/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.vertica.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.edit.GenericPrimaryKeyManager;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericUniqueKey;
import org.jkiss.dbeaver.ext.vertica.model.VerticaConstraint;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class VerticaConstraintManager
extends GenericPrimaryKeyManager {
    protected void addObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        VerticaConstraint constraint = (VerticaConstraint)command.getObject();
        if (((GenericUniqueKey)command.getObject()).getConstraintType() == DBSEntityConstraintType.CHECK) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create check constraint", "ALTER TABLE " + ((GenericTableBase)constraint.getParentObject()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " ADD CONSTRAINT " + DBUtils.getQuotedIdentifier((DBSObject)constraint) + " CHECK (" + constraint.getCheckConstraintDefinition() + ")"));
        } else {
            super.addObjectCreateActions(monitor, executionContext, actions, command, options);
        }
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        VerticaConstraint constraint = (VerticaConstraint)command.getObject();
        if (command.getProperties().containsKey("enabled")) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Alter constraint", "ALTER TABLE " + ((GenericTableBase)constraint.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " ALTER CONSTRAINT " + DBUtils.getQuotedIdentifier((DBPDataSource)constraint.getDataSource(), (String)constraint.getName()) + " " + (constraint.isEnabled() ? "ENABLED" : "DISABLED")));
        }
        super.addObjectModifyActions(monitor, executionContext, actionList, command, options);
    }

    protected void appendConstraintDefinition(StringBuilder decl, DBECommandAbstract<GenericUniqueKey> command) {
        if (((GenericUniqueKey)command.getObject()).getConstraintType() == DBSEntityConstraintType.CHECK) {
            decl.append("(").append(((VerticaConstraint)command.getObject()).getCheckConstraintDefinition()).append(")");
        } else {
            super.appendConstraintDefinition(decl, command);
        }
    }
}

