/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3.ui.actions;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.gef3.commands.Command;
import org.eclipse.gef3.internal.GEFMessages;
import org.eclipse.gef3.ui.actions.StackAction;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class UndoAction
extends StackAction {
    public UndoAction(IEditorPart editor) {
        super((IWorkbenchPart)editor);
    }

    public UndoAction(IWorkbenchPart part) {
        super(part);
    }

    @Override
    protected boolean calculateEnabled() {
        return this.getCommandStack().canUndo();
    }

    @Override
    protected void init() {
        super.init();
        this.setToolTipText(MessageFormat.format((String)GEFMessages.UndoAction_Tooltip, (Object[])new Object[]{""}).trim());
        this.setText(MessageFormat.format((String)GEFMessages.UndoAction_Label, (Object[])new Object[]{""}).trim());
        this.setId(ActionFactory.UNDO.getId());
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO_DISABLED"));
    }

    @Override
    protected void refresh() {
        Command undoCmd = this.getCommandStack().getUndoCommand();
        this.setToolTipText(MessageFormat.format((String)GEFMessages.UndoAction_Tooltip, (Object[])new Object[]{this.getLabelForCommand(undoCmd)}).trim());
        this.setText(MessageFormat.format((String)GEFMessages.UndoAction_Label, (Object[])new Object[]{this.getLabelForCommand(undoCmd)}).trim());
        super.refresh();
    }

    public void run() {
        this.getCommandStack().undo();
    }
}

