/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.preferences;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.sql.format.SQLFormatter;
import org.jkiss.dbeaver.model.sql.format.external.SQLFormatterExternal;
import org.jkiss.dbeaver.model.sql.format.tokenized.SQLFormatterTokenized;
import org.jkiss.dbeaver.model.sql.registry.SQLFormatterConfigurationRegistry;
import org.jkiss.dbeaver.model.sql.registry.SQLFormatterDescriptor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.StringEditorInput;
import org.jkiss.dbeaver.ui.editors.SubEditorSite;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;
import org.jkiss.dbeaver.ui.editors.sql.preferences.format.SQLExternalFormatterConfigurationPage;
import org.jkiss.dbeaver.ui.editors.sql.preferences.format.SQLFormatterConfigurator;
import org.jkiss.dbeaver.ui.editors.sql.preferences.format.tokenized.SQLTokenizedFormatterConfigurationPage;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.utils.CommonUtils;

public class PrefPageSQLFormat
extends TargetPrefPage {
    private static final Log log = Log.getLog(PrefPageSQLFormat.class);
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.sql.format";
    private static final String FORMAT_FILE_NAME = "format_preview.sql";
    private Button styleBoldKeywords;
    private Combo formatterSelector;
    private Button formatCurrentQueryCheck;
    private SQLEditorBase sqlViewer;
    private Composite formatterConfigPlaceholder;
    private List<SQLFormatterDescriptor> formatters;
    private SQLFormatterConfigurator curConfigurator;

    protected boolean hasDataSourceSpecificOptions(DBPDataSourceContainer dataSourceDescriptor) {
        DBPPreferenceStore store = dataSourceDescriptor.getPreferenceStore();
        return store.contains("SQLEditor.format.boldKeywords") || store.contains("sql.format.formatter");
    }

    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)3, (int)5);
        this.formatterSelector = UIUtils.createLabelCombo((Composite)composite, (String)SQLEditorMessages.pref_page_sql_format_label_formatter, (int)12);
        this.formatterSelector.setLayoutData((Object)new GridData(32));
        this.formatters = SQLFormatterConfigurationRegistry.getInstance().getFormatters();
        this.formatters.sort(Comparator.comparing(SQLFormatterDescriptor::getLabel));
        for (SQLFormatterDescriptor formatterDesc : this.formatters) {
            this.formatterSelector.add(DBPIdentifierCase.capitalizeCaseName((String)formatterDesc.getLabel()));
        }
        this.formatterSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageSQLFormat.this.showFormatterSettings();
                PrefPageSQLFormat.this.performApply();
            }
        });
        this.formatterSelector.setLayoutData((Object)new GridData(32));
        this.formatCurrentQueryCheck = UIUtils.createCheckbox((Composite)composite, (String)"Format active query only", (String)"Formats only active query or selected text. Otherwise formats entire SQL script", (boolean)true, (int)1);
        Composite formatterGroup = UIUtils.createPlaceholder((Composite)composite, (int)1, (int)5);
        formatterGroup.setLayoutData((Object)new GridData(768));
        ((GridData)formatterGroup.getLayoutData()).horizontalSpan = 3;
        this.formatterConfigPlaceholder = UIUtils.createPlaceholder((Composite)formatterGroup, (int)2, (int)5);
        this.formatterConfigPlaceholder.setLayoutData((Object)new GridData(800));
        this.formatterConfigPlaceholder.setLayout((Layout)new FillLayout());
        Composite previewGroup = new Composite(composite, 2048);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        previewGroup.setLayoutData((Object)gd);
        previewGroup.setLayout((Layout)new FillLayout());
        this.sqlViewer = new SQLEditorBase(){

            public DBCExecutionContext getExecutionContext() {
                DBPDataSource dataSource;
                DBPDataSourceContainer container = PrefPageSQLFormat.this.getDataSourceContainer();
                if (container != null && (dataSource = container.getDataSource()) != null) {
                    return DBUtils.getDefaultContext((DBSObject)dataSource.getDefaultInstance(), (boolean)false);
                }
                return null;
            }
        };
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (InputStream sqlStream = ((Object)((Object)this)).getClass().getResourceAsStream(FORMAT_FILE_NAME);){
                String sqlText = ContentUtils.readToString((InputStream)sqlStream, (Charset)StandardCharsets.UTF_8);
                SubEditorSite subSite = new SubEditorSite(UIUtils.getActiveWorkbenchWindow().getActivePage().getActivePart().getSite());
                StringEditorInput sqlInput = new StringEditorInput("SQL preview", (CharSequence)sqlText, true, GeneralUtils.getDefaultFileEncoding());
                this.sqlViewer.init((IEditorSite)subSite, (IEditorInput)sqlInput);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e2) {
            log.error((Object)e2);
        }
        this.sqlViewer.createPartControl(previewGroup);
        Control text = this.sqlViewer.getAdapter(Control.class);
        if (text instanceof StyledText) {
            ((StyledText)text).setWordWrap(true);
        }
        this.sqlViewer.reloadSyntaxRules();
        previewGroup.addDisposeListener(e -> this.sqlViewer.dispose());
        this.styleBoldKeywords = UIUtils.createCheckbox((Composite)composite, (String)SQLEditorMessages.pref_page_sql_format_label_bold_keywords, (String)SQLEditorMessages.pref_page_sql_format_label_bold_keywords_tip, (boolean)false, (int)2);
        this.styleBoldKeywords.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageSQLFormat.this.performApply();
            }
        });
        return composite;
    }

    protected void loadPreferences(DBPPreferenceStore store) {
        this.styleBoldKeywords.setSelection(store.getBoolean("SQLEditor.format.boldKeywords"));
        this.formatCurrentQueryCheck.setSelection(store.getBoolean("SQLEditor.format.activeQuery"));
        String formatterId = store.getString("sql.format.formatter");
        int i = 0;
        while (i < this.formatters.size()) {
            if (this.formatters.get(i).getId().equalsIgnoreCase(formatterId)) {
                this.formatterSelector.select(i);
                break;
            }
            ++i;
        }
        if (this.formatterSelector.getSelectionIndex() < 0) {
            this.formatterSelector.select(0);
        }
        this.formatSQL();
        this.showFormatterSettings();
    }

    protected void savePreferences(DBPPreferenceStore store) {
        if (this.curConfigurator != null) {
            this.curConfigurator.saveSettings(this.getTargetPreferenceStore());
        }
        store.setValue("SQLEditor.format.boldKeywords", this.styleBoldKeywords.getSelection());
        store.setValue("SQLEditor.format.activeQuery", this.formatCurrentQueryCheck.getSelection());
        store.setValue("sql.format.formatter", this.formatters.get(this.formatterSelector.getSelectionIndex()).getId().toUpperCase(Locale.ENGLISH));
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
    }

    protected void clearPreferences(DBPPreferenceStore store) {
        store.setToDefault("SQLEditor.format.boldKeywords");
        store.setToDefault("sql.format.formatter");
        if (this.curConfigurator != null) {
            this.curConfigurator.resetSettings(store);
        }
    }

    protected void performApply() {
        super.performApply();
        this.formatSQL();
    }

    protected String getPropertyPageID() {
        return PAGE_ID;
    }

    private void showFormatterSettings() {
        if (this.curConfigurator != null) {
            this.curConfigurator.saveSettings(this.getTargetPreferenceStore());
        }
        UIUtils.disposeChildControls((Composite)this.formatterConfigPlaceholder);
        SQLFormatterDescriptor selFormatter = this.formatters.get(this.formatterSelector.getSelectionIndex());
        try {
            SQLFormatter sqlFormatter = selFormatter.createFormatter();
            this.curConfigurator = sqlFormatter instanceof SQLFormatterTokenized ? new SQLTokenizedFormatterConfigurationPage() : (sqlFormatter instanceof SQLFormatterExternal ? new SQLExternalFormatterConfigurationPage() : (SQLFormatterConfigurator)GeneralUtils.adapt((Object)sqlFormatter, SQLFormatterConfigurator.class));
            if (this.curConfigurator instanceof IDialogPage) {
                this.curConfigurator.configure(selFormatter, () -> {
                    this.curConfigurator.saveSettings(this.getTargetPreferenceStore());
                    this.formatSQL();
                });
                ((IDialogPage)this.curConfigurator).createControl(this.formatterConfigPlaceholder);
                this.curConfigurator.loadSettings(this.getTargetPreferenceStore());
            }
        }
        catch (DBException e) {
            log.error((Object)"Error creating formatter configurator", (Throwable)e);
            this.setMessage(CommonUtils.toString((Object)e.getMessage()), 1);
            return;
        }
        ((Composite)this.getControl()).layout(true, true);
        if (this.isDataSourcePreferencePage()) {
            this.enablePreferenceContent(this.useDataSourceSettings());
        }
    }

    private void formatSQL() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream sqlStream = ((Object)((Object)this)).getClass().getResourceAsStream(FORMAT_FILE_NAME);){
                String sqlText = ContentUtils.readToString((InputStream)sqlStream, (Charset)StandardCharsets.UTF_8);
                this.sqlViewer.setInput((IEditorInput)new StringEditorInput("SQL preview", (CharSequence)sqlText, true, GeneralUtils.getDefaultFileEncoding()));
                this.sqlViewer.getTextViewer().setSelection((ISelection)new TextSelection(0, sqlText.length()));
                this.sqlViewer.getTextViewer().doOperation(15);
                this.sqlViewer.getTextViewer().setSelection((ISelection)new TextSelection(0, 0));
                this.sqlViewer.reloadSyntaxRules();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }
}

