/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app;

import java.awt.Container;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.ApplicationModel;
import org.jhotdraw.app.Project;
import org.jhotdraw.beans.AbstractBean;
import org.jhotdraw.util.ResourceBundleUtil;

public abstract class AbstractApplication
extends AbstractBean
implements Application {
    private LinkedList projects = new LinkedList();
    private Collection unmodifiableDocuments;
    private boolean isEnabled = true;
    protected ResourceBundleUtil labels;
    private ApplicationModel model;
    private LinkedList<File> recentFiles = new LinkedList();
    private static final int maxRecentFilesCount = 10;
    private Preferences prefs;

    @Override
    public void init() {
        this.prefs = Preferences.userNodeForPackage(this.getModel() == null ? this.getClass() : this.getModel().getClass());
        int count = this.prefs.getInt("recentFileCount", 0);
        int i = 0;
        while (i < count) {
            String path = this.prefs.get("recentFile." + i, null);
            if (path != null) {
                this.recentFiles.add(new File(path));
            }
            ++i;
        }
        if (this.model != null) {
            this.model.initApplication(this);
        }
    }

    @Override
    public void start() {
        Project p = this.createProject();
        this.add(p);
        p.clear();
        this.show(p);
    }

    @Override
    public final Project createProject() {
        Project p = this.basicCreateProject();
        p.init();
        if (this.getModel() != null) {
            this.getModel().initProject(this, p);
        }
        this.initProjectActions(p);
        return p;
    }

    @Override
    public void setModel(ApplicationModel newValue) {
        ApplicationModel oldValue = this.model;
        this.model = newValue;
        this.firePropertyChange("model", oldValue, newValue);
    }

    @Override
    public ApplicationModel getModel() {
        return this.model;
    }

    protected Project basicCreateProject() {
        return this.model.createProject();
    }

    @Override
    public String getName() {
        return this.model.getName();
    }

    @Override
    public String getVersion() {
        return this.model.getVersion();
    }

    @Override
    public String getCopyright() {
        return this.model.getCopyright();
    }

    protected abstract void initProjectActions(Project var1);

    @Override
    public void stop() {
        for (Project p : new LinkedList<Project>(this.projects())) {
            this.dispose(p);
        }
        System.exit(0);
    }

    @Override
    public void remove(Project p) {
        this.hide(p);
        int oldCount = this.projects.size();
        this.projects.remove(p);
        p.setApplication(null);
        this.firePropertyChange("projectCount", oldCount, this.projects.size());
    }

    @Override
    public void add(Project p) {
        if (p.getApplication() != this) {
            int oldCount = this.projects.size();
            this.projects.add(p);
            p.setApplication(this);
            this.firePropertyChange("projectCount", oldCount, this.projects.size());
        }
    }

    @Override
    public void dispose(Project p) {
        this.remove(p);
        p.dispose();
    }

    @Override
    public Collection<Project> projects() {
        if (this.unmodifiableDocuments == null) {
            this.unmodifiableDocuments = Collections.unmodifiableCollection(this.projects);
        }
        return this.unmodifiableDocuments;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setEnabled(boolean newValue) {
        boolean oldValue = this.isEnabled;
        this.isEnabled = newValue;
        this.firePropertyChange("enabled", oldValue, newValue);
    }

    public Container createContainer() {
        return new JFrame();
    }

    @Override
    public void launch(String[] args) {
        this.configure(args);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractApplication.this.init();
                AbstractApplication.this.start();
            }
        });
    }

    protected void initLabels() {
        this.labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.app.Labels");
    }

    @Override
    public void configure(String[] args) {
    }

    @Override
    public List<File> recentFiles() {
        return Collections.unmodifiableList(this.recentFiles);
    }

    @Override
    public void clearRecentFiles() {
        List oldValue = (List)this.recentFiles.clone();
        this.recentFiles.clear();
        this.prefs.putInt("recentFileCount", this.recentFiles.size());
        this.firePropertyChange("recentFiles", Collections.unmodifiableList(oldValue), Collections.unmodifiableList(this.recentFiles));
    }

    @Override
    public void addRecentFile(File file) {
        List oldValue = (List)this.recentFiles.clone();
        if (this.recentFiles.contains(file)) {
            this.recentFiles.remove(file);
        }
        this.recentFiles.addFirst(file);
        if (this.recentFiles.size() > 10) {
            this.recentFiles.removeLast();
        }
        this.prefs.putInt("recentFileCount", this.recentFiles.size());
        int i = 0;
        for (File f : this.recentFiles) {
            this.prefs.put("recentFile." + i, f.getPath());
            ++i;
        }
        this.firePropertyChange("recentFiles", oldValue, (Object)0);
        this.firePropertyChange("recentFiles", Collections.unmodifiableList(oldValue), Collections.unmodifiableList(this.recentFiles));
    }
}

