/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.Project;
import org.jhotdraw.app.action.AbstractApplicationAction;
import org.jhotdraw.gui.JSheet;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.gui.event.SheetEvent;
import org.jhotdraw.gui.event.SheetListener;
import org.jhotdraw.util.ResourceBundleUtil;

public class OpenAction
extends AbstractApplicationAction {
    public static final String ID = "open";

    public OpenAction(Application app) {
        super(app);
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.app.Labels");
        labels.configureAction(this, ID);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Application app = this.getApplication();
        if (app.isEnabled()) {
            boolean removeMe;
            Project p;
            app.setEnabled(false);
            Project emptyProject = app.getCurrentProject();
            if (emptyProject == null || emptyProject.getFile() != null || emptyProject.hasUnsavedChanges()) {
                emptyProject = null;
            }
            if (emptyProject == null) {
                p = app.createProject();
                app.add(p);
                removeMe = true;
            } else {
                p = emptyProject;
                removeMe = false;
            }
            JFileChooser fileChooser = p.getOpenChooser();
            if (fileChooser.showOpenDialog(app.getComponent()) == 0) {
                app.show(p);
                this.openFile(fileChooser, p);
            } else {
                if (removeMe) {
                    app.remove(p);
                }
                app.setEnabled(true);
            }
        }
    }

    protected void openFile(JFileChooser fileChooser, final Project project) {
        Application app = this.getApplication();
        final File file = fileChooser.getSelectedFile();
        app.setEnabled(true);
        project.setEnabled(false);
        int multipleOpenId = 1;
        for (Project aProject : app.projects()) {
            if (aProject == project || aProject.getFile() == null || !aProject.getFile().equals(file)) continue;
            multipleOpenId = Math.max(multipleOpenId, aProject.getMultipleOpenId() + 1);
        }
        project.setMultipleOpenId(multipleOpenId);
        project.setEnabled(false);
        project.execute(new Worker(){

            @Override
            public Object construct() {
                try {
                    project.read(file);
                    return null;
                }
                catch (Throwable e) {
                    return e;
                }
            }

            @Override
            public void finished(Object value) {
                OpenAction.this.fileOpened(project, file, value);
            }
        });
    }

    protected void fileOpened(Project project, File file, Object value) {
        Application app = this.getApplication();
        if (value == null) {
            project.setFile(file);
            project.setEnabled(true);
            Frame w = (Frame)SwingUtilities.getWindowAncestor(project.getComponent());
            if (w != null) {
                w.setExtendedState(w.getExtendedState() & 0xFFFFFFFE);
                w.toFront();
            }
            project.getComponent().requestFocus();
            app.addRecentFile(file);
            app.setEnabled(true);
        } else {
            if (value instanceof Throwable) {
                ((Throwable)value).printStackTrace();
            }
            JSheet.showMessageSheet(project.getComponent(), "<html>" + UIManager.getString("OptionPane.css") + "<b>Couldn't open the file \"" + file + "\".</b><br>" + value, 0, new SheetListener(){

                @Override
                public void optionSelected(SheetEvent evt) {
                }
            });
        }
    }
}

