/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.Project;
import org.jhotdraw.app.action.AbstractApplicationAction;
import org.jhotdraw.gui.JSheet;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.gui.event.SheetEvent;
import org.jhotdraw.gui.event.SheetListener;

public class OpenRecentAction
extends AbstractApplicationAction {
    public static final String ID = "openRecent";
    private File file;

    public OpenRecentAction(Application app, File file) {
        super(app);
        this.file = file;
        this.putValue("Name", file.getName());
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Application app = this.getApplication();
        if (app.isEnabled()) {
            Project p;
            app.setEnabled(false);
            Project emptyProject = app.getCurrentProject();
            if (emptyProject == null || emptyProject.getFile() != null || emptyProject.hasUnsavedChanges()) {
                emptyProject = null;
            }
            if (emptyProject == null) {
                p = app.createProject();
                app.add(p);
                app.show(p);
            } else {
                p = emptyProject;
            }
            this.openFile(p);
        }
    }

    protected void openFile(final Project project) {
        Application app = this.getApplication();
        app.setEnabled(true);
        int multipleOpenId = 1;
        for (Project aProject : app.projects()) {
            if (aProject == project || aProject.getFile() == null || !aProject.getFile().equals(this.file)) continue;
            multipleOpenId = Math.max(multipleOpenId, aProject.getMultipleOpenId() + 1);
        }
        project.setMultipleOpenId(multipleOpenId);
        project.setEnabled(false);
        project.execute(new Worker(){

            @Override
            public Object construct() {
                try {
                    project.read(OpenRecentAction.this.file);
                    return null;
                }
                catch (Throwable e) {
                    return e;
                }
            }

            @Override
            public void finished(Object value) {
                OpenRecentAction.this.fileOpened(project, OpenRecentAction.this.file, value);
            }
        });
    }

    protected void fileOpened(Project project, File file, Object value) {
        Application app = this.getApplication();
        if (value == null) {
            project.setFile(file);
            project.setEnabled(true);
            Frame w = (Frame)SwingUtilities.getWindowAncestor(project.getComponent());
            if (w != null) {
                w.setExtendedState(w.getExtendedState() & 0xFFFFFFFE);
                w.toFront();
            }
            project.getComponent().requestFocus();
            if (app != null) {
                app.setEnabled(true);
            }
        } else {
            if (value instanceof Throwable) {
                ((Throwable)value).printStackTrace();
            }
            JSheet.showMessageSheet(project.getComponent(), "<html>" + UIManager.getString("OptionPane.css") + "<b>Couldn't open the file \"" + file + "\".</b><br>" + value, 0, new SheetListener(){

                @Override
                public void optionSelected(SheetEvent evt) {
                }
            });
        }
    }
}

