/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.Project;
import org.jhotdraw.app.action.AbstractProjectAction;
import org.jhotdraw.gui.JSheet;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.gui.event.SheetEvent;
import org.jhotdraw.gui.event.SheetListener;
import org.jhotdraw.io.ExtensionFileFilter;
import org.jhotdraw.util.ResourceBundleUtil;

public class SaveAction
extends AbstractProjectAction {
    public static final String ID = "save";
    private boolean saveAs;
    private Component oldFocusOwner;

    public SaveAction(Application app) {
        this(app, false);
    }

    public SaveAction(Application app, boolean saveAs) {
        super(app);
        this.saveAs = saveAs;
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.app.Labels");
        labels.configureAction(this, ID);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        final Project project = this.getCurrentProject();
        if (project.isEnabled()) {
            this.oldFocusOwner = SwingUtilities.getWindowAncestor(project.getComponent()).getFocusOwner();
            project.setEnabled(false);
            if (!this.saveAs && project.getFile() != null) {
                this.saveToFile(project, project.getFile());
            } else {
                JFileChooser fileChooser = project.getSaveChooser();
                JSheet.showSaveSheet(fileChooser, project.getComponent(), new SheetListener(){

                    @Override
                    public void optionSelected(SheetEvent evt) {
                        if (evt.getOption() == 0) {
                            File file = evt.getFileChooser().getFileFilter() instanceof ExtensionFileFilter ? ((ExtensionFileFilter)evt.getFileChooser().getFileFilter()).makeAcceptable(evt.getFileChooser().getSelectedFile()) : evt.getFileChooser().getSelectedFile();
                            SaveAction.this.saveToFile(project, file);
                        } else {
                            project.setEnabled(true);
                            if (SaveAction.this.oldFocusOwner != null) {
                                SaveAction.this.oldFocusOwner.requestFocus();
                            }
                        }
                    }
                });
            }
        }
    }

    protected void saveToFile(final Project project, final File file) {
        project.execute(new Worker(){

            @Override
            public Object construct() {
                try {
                    project.write(file);
                    return null;
                }
                catch (IOException e) {
                    return e;
                }
            }

            @Override
            public void finished(Object value) {
                SaveAction.this.fileSaved(project, file, value);
            }
        });
    }

    protected void fileSaved(Project project, File file, Object value) {
        if (value == null) {
            project.setFile(file);
            project.markChangesAsSaved();
            int multiOpenId = 1;
            for (Project p : project.getApplication().projects()) {
                if (p == project || p.getFile() == null || !p.getFile().equals(file)) continue;
                multiOpenId = Math.max(multiOpenId, p.getMultipleOpenId() + 1);
            }
            this.getApplication().addRecentFile(file);
            project.setMultipleOpenId(multiOpenId);
        } else {
            ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.app.Labels");
            JSheet.showMessageSheet((Component)project.getComponent(), (Object)("<html>" + UIManager.getString("OptionPane.css") + labels.getFormatted("couldntSave", file, value)), 0);
        }
        project.setEnabled(true);
        SwingUtilities.getWindowAncestor(project.getComponent()).toFront();
        if (this.oldFocusOwner != null) {
            this.oldFocusOwner.requestFocus();
        }
    }
}

