/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.Collections;
import javax.swing.event.EventListenerList;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.FigureListener;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.HandleEvent;
import org.jhotdraw.draw.HandleListener;

public abstract class AbstractHandle
implements Handle,
FigureListener {
    private Figure owner;
    protected DrawingView view;
    protected EventListenerList listenerList = new EventListenerList();
    private Rectangle bounds;

    public AbstractHandle(Figure owner) {
        if (owner == null) {
            throw new IllegalArgumentException("owner must not be null");
        }
        this.owner = owner;
        owner.addFigureListener(this);
    }

    protected int getHandlesize() {
        return 7;
    }

    @Override
    public void addHandleListener(HandleListener l) {
        this.listenerList.add(HandleListener.class, l);
    }

    @Override
    public void removeHandleListener(HandleListener l) {
        this.listenerList.remove(HandleListener.class, l);
    }

    @Override
    public Figure getOwner() {
        return this.owner;
    }

    @Override
    public void setView(DrawingView view) {
        this.view = view;
    }

    public DrawingView getView() {
        return this.view;
    }

    protected void fireAreaInvalidated(Rectangle invalidatedArea) {
        HandleEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == HandleListener.class) {
                if (event == null) {
                    event = new HandleEvent(this, invalidatedArea);
                }
                ((HandleListener)listeners[i + 1]).areaInvalidated(event);
            }
            i -= 2;
        }
    }

    protected void fireUndoableEditHappened(UndoableEdit edit) {
        this.view.getDrawing().fireUndoableEditHappened(edit);
    }

    protected void fireHandleRequestRemove(Rectangle invalidatedArea) {
        HandleEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == HandleListener.class) {
                if (event == null) {
                    event = new HandleEvent(this, invalidatedArea);
                }
                ((HandleListener)listeners[i + 1]).handleRequestRemove(event);
            }
            i -= 2;
        }
    }

    protected void fireHandleRequestSecondaryHandles() {
        HandleEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == HandleListener.class) {
                if (event == null) {
                    event = new HandleEvent(this, null);
                }
                ((HandleListener)listeners[i + 1]).handleRequestSecondaryHandles(event);
            }
            i -= 2;
        }
    }

    @Override
    public void draw(Graphics2D g) {
        this.drawCircle(g, Color.white, Color.black);
    }

    protected void drawCircle(Graphics2D g, Color fill, Color stroke) {
        Rectangle r = this.getBounds();
        if (fill != null) {
            g.setColor(fill);
            g.fillOval(r.x, r.y, r.width, r.height);
        }
        if (stroke != null) {
            g.setStroke(new BasicStroke());
            g.setColor(stroke);
            g.drawOval(r.x, r.y, r.width, r.height);
        }
    }

    protected void drawRectangle(Graphics2D g, Color fill, Color stroke) {
        Rectangle r = this.getBounds();
        if (fill != null) {
            g.setColor(fill);
            g.fill(r);
        }
        if (stroke != null) {
            g.setStroke(new BasicStroke());
            g.setColor(stroke);
            g.draw(r);
        }
    }

    protected void drawDiamond(Graphics2D g, Color fill, Color stroke) {
        Rectangle r = this.getBounds();
        r.grow(1, 1);
        Polygon p = new Polygon();
        p.addPoint(r.x + r.width / 2, r.y);
        p.addPoint(r.x + r.width, r.y + r.height / 2);
        p.addPoint(r.x + r.width / 2, r.y + r.height);
        p.addPoint(r.x, r.y + r.height / 2);
        p.addPoint(r.x + r.width / 2, r.y);
        if (fill != null) {
            g.setColor(fill);
            g.fill(p);
        }
        if (stroke != null) {
            g.setStroke(new BasicStroke());
            g.setColor(stroke);
            g.draw(p);
        }
    }

    @Override
    public boolean contains(Point p) {
        return this.getBounds().contains(p);
    }

    @Override
    public void invalidate() {
        this.bounds = null;
    }

    @Override
    public void dispose() {
        this.owner.removeFigureListener(this);
        this.owner = null;
    }

    @Override
    public void figureAreaInvalidated(FigureEvent evt) {
        this.updateBounds();
    }

    @Override
    public void figureAdded(FigureEvent e) {
    }

    @Override
    public void figureRemoved(FigureEvent e) {
    }

    @Override
    public void figureRequestRemove(FigureEvent e) {
    }

    @Override
    public void figureChanged(FigureEvent evt) {
        this.updateBounds();
    }

    @Override
    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(13);
    }

    @Override
    public boolean isCombinableWith(Handle handle) {
        return this.getClass().isAssignableFrom(handle.getClass());
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }

    @Override
    public void keyPressed(KeyEvent evt) {
    }

    @Override
    public final Rectangle getBounds() {
        if (this.bounds == null) {
            this.bounds = this.basicGetBounds();
        }
        return (Rectangle)this.bounds.clone();
    }

    @Override
    public Rectangle getDrawingArea() {
        Rectangle r = this.getBounds();
        r.grow(2, 2);
        return r;
    }

    protected abstract Rectangle basicGetBounds();

    protected void updateBounds() {
        Rectangle newBounds = this.basicGetBounds();
        if (this.bounds == null || !newBounds.equals(this.bounds)) {
            if (this.bounds != null) {
                this.fireAreaInvalidated(this.getDrawingArea());
            }
            this.bounds = newBounds;
            this.fireAreaInvalidated(this.getDrawingArea());
        }
    }

    @Override
    public void trackDoubleClick(Point p, int modifiersEx) {
    }

    @Override
    public void figureAttributeChanged(FigureEvent e) {
    }

    @Override
    public void viewTransformChanged() {
        this.invalidate();
    }

    @Override
    public Collection<Handle> createSecondaryHandles() {
        return Collections.emptyList();
    }

    @Override
    public String getToolTipText(Point p) {
        return null;
    }

    @Override
    public void figureHandlesChanged(FigureEvent e) {
    }
}

