/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.Collection;
import org.jhotdraw.draw.AbstractCompositeFigure;
import org.jhotdraw.draw.EllipseFigure;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureAdapter;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.GroupFigure;
import org.jhotdraw.draw.TerraResizeEventFunctions;
import org.jhotdraw.draw.TextFigure;
import org.jhotdraw.enums.AttributeTypeEnum;
import org.jhotdraw.interfaces.AttributeTypeElement;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

public class AtributoChaveParcialFigure
extends GroupFigure
implements AttributeTypeElement {
    private TextFigure tf;
    private EllipseFigure ef;
    private static int counter = 0;
    private TerraResizeEventFunctions EventFunctions;
    private AttributeTypeEnum attributeType = AttributeTypeEnum.INTEGER;
    private boolean nullable;

    public AtributoChaveParcialFigure init() {
        this.ef = new EllipseFigure();
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        this.tf = new TextFigure(String.valueOf(labels.getString("createAtributoChaveParcial")) + Integer.toString(counter++));
        this.tf.setAttribute(this.tf.getAttributeKey("strokeDashes"), new double[]{3.0});
        this.tf.setAttribute(this.tf.getAttributeKey("fontBold"), Boolean.TRUE);
        this.add(this.ef);
        this.add(this.tf);
        this.EventFunctions = new TerraResizeEventFunctions(this, this.ef, this.tf);
        this.tf.addFigureListener(new FigureAdapter(){

            @Override
            public void figureAttributeChanged(FigureEvent e) {
                AtributoChaveParcialFigure.this.EventFunctions.figureTextChanged(e);
            }

            @Override
            public void figureChanged(FigureEvent e) {
                AtributoChaveParcialFigure.this.EventFunctions.figureSizeChanged();
            }
        });
        return this;
    }

    @Override
    public String getToolTipText(Point2D.Double p) {
        return this.toString();
    }

    @Override
    public AbstractCompositeFigure clone() {
        AtributoChaveParcialFigure f = new AtributoChaveParcialFigure().init();
        f.willChange();
        f.ef.setBounds(this.ef.getBounds());
        f.tf.setBounds(this.tf.getBounds());
        f.changed();
        return f;
    }

    @Override
    public String toString() {
        return this.tf.getText().replaceAll("\\s+", "_");
    }

    @Override
    public void read(DOMInput in) throws IOException {
        super.read(in);
        this.nullable = in.getAttribute("nullable", false);
        this.attributeType = AttributeTypeEnum.getAttributeTypeByString(in.getAttribute("attributeType", null));
        Collection<Figure> lst = this.getDecomposition();
        for (Figure f : lst) {
            if (f instanceof TextFigure) {
                this.tf = (TextFigure)f;
                continue;
            }
            if (!(f instanceof EllipseFigure)) continue;
            this.ef = (EllipseFigure)f;
        }
        this.EventFunctions = new TerraResizeEventFunctions(this, this.ef, this.tf);
        this.tf.addFigureListener(new FigureAdapter(){

            @Override
            public void figureAttributeChanged(FigureEvent e) {
                AtributoChaveParcialFigure.this.EventFunctions.figureTextChanged(e);
            }

            @Override
            public void figureChanged(FigureEvent e) {
                AtributoChaveParcialFigure.this.EventFunctions.figureSizeChanged();
            }
        });
    }

    @Override
    public void write(DOMOutput out) throws IOException {
        super.write(out);
        out.addAttribute("nullable", this.nullable);
        out.addAttribute("attributeType", this.attributeType.getSqlType());
    }

    @Override
    public AttributeTypeEnum getAttributeType() {
        return this.attributeType;
    }

    @Override
    public void setAttributeType(AttributeTypeEnum attributeType) {
        this.attributeType = attributeType;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }
}

