/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AbstractHandle;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.undo.CompositeEdit;
import org.jhotdraw.util.ResourceBundleUtil;

public class BezierControlPointHandle
extends AbstractHandle {
    private static final Color HANDLE_FILL_COLOR = new Color(2105596);
    private static final Color HANDLE_STROKE_COLOR = Color.WHITE;
    protected int index;
    protected int controlPointIndex;
    private CompositeEdit edit;
    private Figure transformOwner;

    public BezierControlPointHandle(BezierFigure owner, int index, int coord) {
        this(owner, index, coord, owner);
    }

    public BezierControlPointHandle(BezierFigure owner, int index, int coord, Figure transformOwner) {
        super(owner);
        this.index = index;
        this.controlPointIndex = coord;
        this.transformOwner = transformOwner;
        transformOwner.addFigureListener(this);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.transformOwner.removeFigureListener(this);
        this.transformOwner = null;
    }

    protected BezierFigure getBezierFigure() {
        return (BezierFigure)this.getOwner();
    }

    protected Figure getTransformOwner() {
        return this.transformOwner;
    }

    protected Point getLocation() {
        if (this.getBezierFigure().getNodeCount() > this.index) {
            Point2D.Double p = this.getBezierFigure().getPoint(this.index, this.controlPointIndex);
            if (AttributeKeys.TRANSFORM.get(this.getTransformOwner()) != null) {
                AttributeKeys.TRANSFORM.get(this.getTransformOwner()).transform(p, p);
            }
            return this.view.drawingToView(p);
        }
        return new Point(10, 10);
    }

    protected BezierPath.Node getBezierNode() {
        return this.getBezierFigure().getNodeCount() > this.index ? this.getBezierFigure().getNode(this.index) : null;
    }

    @Override
    public void draw(Graphics2D g) {
        BezierFigure f = this.getBezierFigure();
        if (f.getNodeCount() > this.index) {
            BezierPath.Node v = f.getNode(this.index);
            if (v.keepColinear && v.mask == 3 && (this.index > 0 && this.index < f.getNodeCount() - 1 || f.isClosed())) {
                this.drawCircle(g, HANDLE_STROKE_COLOR, HANDLE_FILL_COLOR);
            } else {
                this.drawCircle(g, HANDLE_FILL_COLOR, HANDLE_STROKE_COLOR);
            }
            g.setColor(HANDLE_FILL_COLOR);
            Point2D.Double p0 = new Point2D.Double(v.x[0], v.y[0]);
            Point2D.Double pc = new Point2D.Double(v.x[this.controlPointIndex], v.y[this.controlPointIndex]);
            if (AttributeKeys.TRANSFORM.get(this.getTransformOwner()) != null) {
                AttributeKeys.TRANSFORM.get(this.getTransformOwner()).transform(p0, p0);
                AttributeKeys.TRANSFORM.get(this.getTransformOwner()).transform(pc, pc);
            }
            g.draw(new Line2D.Double(this.view.drawingToView(p0), this.view.drawingToView(pc)));
        }
    }

    @Override
    protected Rectangle basicGetBounds() {
        Rectangle r = new Rectangle(this.getLocation());
        r.grow(this.getHandlesize() / 2, this.getHandlesize() / 2);
        return r;
    }

    @Override
    public void trackStart(Point anchor, int modifiersEx) {
        this.edit = new CompositeEdit("Punkt verschieben");
        this.view.getDrawing().fireUndoableEditHappened(this.edit);
        Point2D.Double location = this.view.getConstrainer().constrainPoint(this.view.viewToDrawing(this.getLocation()));
        Point2D.Double p = this.view.getConstrainer().constrainPoint(this.view.viewToDrawing(anchor));
    }

    @Override
    public void trackStep(Point anchor, Point lead, int modifiersEx) {
        BezierFigure figure = this.getBezierFigure();
        Point2D.Double p = this.view.getConstrainer().constrainPoint(this.view.viewToDrawing(lead));
        BezierPath.Node v = figure.getNode(this.index);
        this.fireAreaInvalidated(v);
        figure.willChange();
        if (AttributeKeys.TRANSFORM.get(this.getTransformOwner()) != null) {
            try {
                AttributeKeys.TRANSFORM.get(this.getTransformOwner()).inverseTransform(p, p);
            }
            catch (NoninvertibleTransformException ex) {
                ex.printStackTrace();
            }
        }
        if (!v.keepColinear) {
            figure.setPoint(this.index, this.controlPointIndex, p);
        } else {
            double a = Math.PI + Math.atan2(p.y - v.y[0], p.x - v.x[0]);
            int c2 = this.controlPointIndex == 1 ? 2 : 1;
            double r = Math.sqrt((v.x[c2] - v.x[0]) * (v.x[c2] - v.x[0]) + (v.y[c2] - v.y[0]) * (v.y[c2] - v.y[0]));
            double sina = Math.sin(a);
            double cosa = Math.cos(a);
            Point2D.Double p2 = new Point2D.Double(r * cosa + v.x[0], r * sina + v.y[0]);
            figure.setPoint(this.index, this.controlPointIndex, p);
            figure.setPoint(this.index, c2, p2);
        }
        figure.changed();
        this.fireAreaInvalidated(figure.getNode(this.index));
    }

    private void fireAreaInvalidated(BezierPath.Node v) {
        Rectangle2D.Double dr = new Rectangle2D.Double(v.x[0], v.y[0], 0.0, 0.0);
        int i = 1;
        while (i < 3) {
            dr.add(v.x[i], v.y[i]);
            ++i;
        }
        Rectangle vr = this.view.drawingToView(dr);
        vr.grow(this.getHandlesize(), this.getHandlesize());
        this.fireAreaInvalidated(vr);
    }

    @Override
    public void trackEnd(Point anchor, Point lead, int modifiersEx) {
        BezierFigure figure = this.getBezierFigure();
        if ((modifiersEx & 0x3C0) != 0) {
            figure.willChange();
            BezierPath.Node v = figure.getNode(this.index);
            boolean bl = v.keepColinear = !v.keepColinear;
            if (v.keepColinear) {
                Point2D.Double p = figure.getPoint(this.index, this.controlPointIndex);
                double a = Math.PI + Math.atan2(p.y - v.y[0], p.x - v.x[0]);
                int c2 = this.controlPointIndex == 1 ? 2 : 1;
                double r = Math.sqrt((v.x[c2] - v.x[0]) * (v.x[c2] - v.x[0]) + (v.y[c2] - v.y[0]) * (v.y[c2] - v.y[0]));
                double sina = Math.sin(a);
                double cosa = Math.cos(a);
                Point2D.Double p2 = new Point2D.Double(r * cosa + v.x[0], r * sina + v.y[0]);
                v.x[c2] = p2.x;
                v.y[c2] = p2.y;
            }
            figure.setNode(this.index, v);
            figure.changed();
        }
        this.view.getDrawing().fireUndoableEditHappened(this.edit);
    }

    @Override
    public boolean isCombinableWith(Handle h) {
        if (super.isCombinableWith(h)) {
            BezierControlPointHandle that = (BezierControlPointHandle)h;
            return that.index == this.index && that.controlPointIndex == this.controlPointIndex && that.getBezierFigure().getNodeCount() == this.getBezierFigure().getNodeCount();
        }
        return false;
    }

    @Override
    public String getToolTipText(Point p) {
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        BezierPath.Node node = this.getBezierNode();
        if (node == null) {
            return null;
        }
        if (node.mask == 3) {
            return labels.getFormatted("bezierCubicControlHandle.tip", labels.getFormatted(node.keepColinear ? "bezierCubicControl.colinearControl" : "bezierCubicControl.unconstrainedControl", new Object[0]));
        }
        return labels.getString("bezierQuadraticControlHandle.tip");
    }
}

