/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import org.jhotdraw.draw.AbstractHandle;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.BezierFigure;

public class BezierOutlineHandle
extends AbstractHandle {
    private static final Color HANDLE_FILL_COLOR = new Color(43263);
    private static final Color HANDLE_STROKE_COLOR = Color.WHITE;

    public BezierOutlineHandle(BezierFigure owner) {
        super(owner);
    }

    @Override
    public BezierFigure getOwner() {
        return (BezierFigure)super.getOwner();
    }

    @Override
    protected Rectangle basicGetBounds() {
        return this.view.drawingToView(this.getOwner().getDrawingArea());
    }

    @Override
    public boolean contains(Point p) {
        return false;
    }

    @Override
    public void trackStart(Point anchor, int modifiersEx) {
    }

    @Override
    public void trackStep(Point anchor, Point lead, int modifiersEx) {
    }

    @Override
    public void trackEnd(Point anchor, Point lead, int modifiersEx) {
    }

    @Override
    public void draw(Graphics2D g) {
        Shape bounds = this.getOwner().getBezierPath();
        if (AttributeKeys.TRANSFORM.get(this.getOwner()) != null) {
            bounds = AttributeKeys.TRANSFORM.get(this.getOwner()).createTransformedShape(bounds);
        }
        bounds = this.view.getDrawingToViewTransform().createTransformedShape(bounds);
        g.setColor(HANDLE_FILL_COLOR);
        g.draw(bounds);
    }
}

