/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import org.jhotdraw.draw.AbstractDrawing;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureAdapter;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.FigureLayerComparator;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.util.ReversedList;

public class DefaultDrawing
extends AbstractDrawing {
    private ArrayList<Figure> figures = new ArrayList();
    private boolean needsSorting = false;
    private FigureHandler figureHandler = this.createFigureHandler();
    private Dimension2DDouble canvasSize;

    protected FigureHandler createFigureHandler() {
        return new FigureHandler();
    }

    @Override
    public int indexOf(Figure figure) {
        return this.figures.indexOf(figure);
    }

    @Override
    public void basicAdd(int index, Figure figure) {
        this.figures.add(index, figure);
        figure.addFigureListener(this.figureHandler);
        this.invalidateSortOrder();
    }

    @Override
    public void basicRemove(Figure figure) {
        this.figures.remove(figure);
        figure.removeFigureListener(this.figureHandler);
        this.invalidateSortOrder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Graphics2D g) {
        Object object = this.getLock();
        synchronized (object) {
            this.ensureSorted();
            ArrayList<Figure> toDraw = new ArrayList<Figure>(this.figures.size());
            Rectangle clipRect = g.getClipBounds();
            for (Figure f : this.figures) {
                if (!f.getDrawingArea().intersects(clipRect)) continue;
                toDraw.add(f);
            }
            this.draw(g, toDraw);
        }
    }

    public void draw(Graphics2D g, Collection<Figure> figures) {
        Rectangle clipBounds = g.getClipBounds();
        if (clipBounds != null) {
            for (Figure f : figures) {
                if (!f.isVisible() || !f.getDrawingArea().intersects(clipBounds)) continue;
                f.draw(g);
            }
        } else {
            for (Figure f : figures) {
                if (!f.isVisible()) continue;
                f.draw(g);
            }
        }
    }

    @Override
    public List<Figure> sort(Collection<Figure> c) {
        HashSet<Figure> unsorted = new HashSet<Figure>();
        unsorted.addAll(c);
        ArrayList<Figure> sorted = new ArrayList<Figure>(c.size());
        for (Figure f : this.figures) {
            if (!unsorted.contains(f)) continue;
            sorted.add(f);
            unsorted.remove(f);
        }
        for (Figure f : c) {
            if (!unsorted.contains(f)) continue;
            sorted.add(f);
            unsorted.remove(f);
        }
        return sorted;
    }

    @Override
    public Figure findFigure(Point2D.Double p) {
        for (Figure f : this.getFiguresFrontToBack()) {
            if (!f.isVisible() || !f.contains(p)) continue;
            return f;
        }
        return null;
    }

    @Override
    public Figure findFigureExcept(Point2D.Double p, Figure ignore) {
        for (Figure f : this.getFiguresFrontToBack()) {
            if (f == ignore || !f.isVisible() || !f.contains(p)) continue;
            return f;
        }
        return null;
    }

    @Override
    public Figure findFigureBehind(Point2D.Double p, Figure figure) {
        boolean isBehind = false;
        for (Figure f : this.getFiguresFrontToBack()) {
            if (isBehind) {
                if (!f.isVisible() || !f.contains(p)) continue;
                return f;
            }
            boolean bl = isBehind = figure == f;
        }
        return null;
    }

    @Override
    public Figure findFigureBehind(Point2D.Double p, Collection<Figure> figures) {
        int inFrontOf = figures.size();
        for (Figure f : this.getFiguresFrontToBack()) {
            if (inFrontOf == 0) {
                if (!f.isVisible() || !f.contains(p)) continue;
                return f;
            }
            if (!figures.contains(f)) continue;
            --inFrontOf;
        }
        return null;
    }

    @Override
    public Figure findFigureExcept(Point2D.Double p, Collection<Figure> ignore) {
        for (Figure f : this.getFiguresFrontToBack()) {
            if (ignore.contains(f) || !f.isVisible() || !f.contains(p)) continue;
            return f;
        }
        return null;
    }

    @Override
    public List<Figure> findFigures(Rectangle2D.Double bounds) {
        LinkedList<Figure> intersection = new LinkedList<Figure>();
        for (Figure f : this.figures) {
            if (!f.isVisible() || !f.getBounds().intersects(bounds)) continue;
            intersection.add(f);
        }
        return intersection;
    }

    @Override
    public List<Figure> findFiguresWithin(Rectangle2D.Double bounds) {
        LinkedList<Figure> contained = new LinkedList<Figure>();
        for (Figure f : this.figures) {
            Rectangle2D r = f.getBounds();
            if (AttributeKeys.TRANSFORM.get(f) != null) {
                r = AttributeKeys.TRANSFORM.get(f).createTransformedShape(r).getBounds2D();
            }
            if (!f.isVisible() || !bounds.contains(r)) continue;
            contained.add(f);
        }
        return contained;
    }

    @Override
    public List<Figure> getFigures() {
        return Collections.unmodifiableList(this.figures);
    }

    @Override
    public Figure findFigureInside(Point2D.Double p) {
        Figure f = this.findFigure(p);
        return f == null ? null : f.findFigureInside(p);
    }

    @Override
    public List<Figure> getFiguresFrontToBack() {
        this.ensureSorted();
        return new ReversedList<Figure>(this.figures);
    }

    @Override
    public void bringToFront(Figure figure) {
        if (this.figures.remove(figure)) {
            this.figures.add(figure);
            this.invalidateSortOrder();
            this.fireAreaInvalidated(figure.getDrawingArea());
        }
    }

    @Override
    public void sendToBack(Figure figure) {
        if (this.figures.remove(figure)) {
            this.figures.add(0, figure);
            this.invalidateSortOrder();
            this.fireAreaInvalidated(figure.getDrawingArea());
        }
    }

    @Override
    public boolean contains(Figure f) {
        return this.figures.contains(f);
    }

    private void invalidateSortOrder() {
        this.needsSorting = true;
    }

    private void ensureSorted() {
        if (this.needsSorting) {
            Collections.sort(this.figures, FigureLayerComparator.INSTANCE);
            this.needsSorting = false;
        }
    }

    @Override
    public void setCanvasSize(Dimension2DDouble newValue) {
        Dimension2DDouble oldValue = this.canvasSize;
        this.canvasSize = newValue;
        this.firePropertyChange("canvasSize", oldValue, newValue);
    }

    @Override
    public Dimension2DDouble getCanvasSize() {
        return this.canvasSize;
    }

    protected class FigureHandler
    extends FigureAdapter
    implements UndoableEditListener {
        protected FigureHandler() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            DefaultDrawing.this.fireUndoableEditHappened(e.getEdit());
        }

        @Override
        public void figureAreaInvalidated(FigureEvent e) {
            DefaultDrawing.this.fireAreaInvalidated(e.getInvalidatedArea());
        }

        @Override
        public void figureChanged(FigureEvent e) {
            DefaultDrawing.this.invalidateSortOrder();
            DefaultDrawing.this.fireAreaInvalidated(e.getInvalidatedArea());
        }

        @Override
        public void figureRequestRemove(FigureEvent e) {
            DefaultDrawing.this.remove(e.getFigure());
        }
    }
}

