/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AbstractAttributedFigure;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.ChopEllipseConnector;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.geom.Geom;

public class EllipseFigure
extends AbstractAttributedFigure {
    protected Ellipse2D.Double ellipse;
    protected static Color fillcolor = new Color(175, 175, 255);

    public EllipseFigure() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public EllipseFigure(double x, double y, double width, double height) {
        this.ellipse = new Ellipse2D.Double(x, y, width, height);
        this.setAttributeEnabled(AttributeKeys.TEXT_COLOR, false);
    }

    @Override
    public Connector findConnector(Point2D.Double p, ConnectionFigure prototype) {
        return new ChopEllipseConnector(this);
    }

    @Override
    public Connector findCompatibleConnector(Connector c, boolean isStartConnector) {
        return new ChopEllipseConnector(this);
    }

    @Override
    public Rectangle2D.Double getBounds() {
        return (Rectangle2D.Double)this.ellipse.getBounds2D();
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        Rectangle2D.Double r = (Rectangle2D.Double)this.ellipse.getBounds2D();
        double grow = AttributeKeys.getPerpendicularHitGrowth(this);
        Geom.grow(r, grow, grow);
        return r;
    }

    @Override
    protected void drawFill(Graphics2D g) {
        Ellipse2D.Double r = (Ellipse2D.Double)this.ellipse.clone();
        g.setPaint(fillcolor);
        double grow = AttributeKeys.getPerpendicularFillGrowth(this);
        r.x -= grow;
        r.y -= grow;
        r.width += grow * 2.0;
        r.height += grow * 2.0;
        if (r.width > 0.0 && r.height > 0.0) {
            g.fill(r);
        }
    }

    @Override
    protected void drawStroke(Graphics2D g) {
        Ellipse2D.Double r = (Ellipse2D.Double)this.ellipse.clone();
        double grow = AttributeKeys.getPerpendicularDrawGrowth(this);
        r.x -= grow;
        r.y -= grow;
        r.width += grow * 2.0;
        r.height += grow * 2.0;
        if (r.width > 0.0 && r.height > 0.0) {
            g.draw(r);
        }
    }

    @Override
    public boolean contains(Point2D.Double p) {
        Ellipse2D.Double r = (Ellipse2D.Double)this.ellipse.clone();
        double grow = AttributeKeys.getPerpendicularHitGrowth(this);
        r.x -= grow;
        r.y -= grow;
        r.width += grow * 2.0;
        r.height += grow * 2.0;
        return r.contains(p);
    }

    @Override
    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        this.ellipse.x = Math.min(anchor.x, lead.x);
        this.ellipse.y = Math.min(anchor.y, lead.y);
        this.ellipse.width = Math.max(0.1, Math.abs(lead.x - anchor.x));
        this.ellipse.height = Math.max(0.1, Math.abs(lead.y - anchor.y));
    }

    @Override
    public void transform(AffineTransform tx) {
        Point2D.Double anchor = this.getStartPoint();
        Point2D.Double lead = this.getEndPoint();
        this.setBounds((Point2D.Double)tx.transform(anchor, anchor), (Point2D.Double)tx.transform(lead, lead));
    }

    @Override
    public EllipseFigure clone() {
        EllipseFigure that = (EllipseFigure)super.clone();
        that.ellipse = (Ellipse2D.Double)this.ellipse.clone();
        return that;
    }

    @Override
    public void restoreTransformTo(Object geometry) {
        Ellipse2D.Double r = (Ellipse2D.Double)geometry;
        this.ellipse.x = r.x;
        this.ellipse.y = r.y;
        this.ellipse.width = r.width;
        this.ellipse.height = r.height;
    }

    @Override
    public Object getTransformRestoreData() {
        return this.ellipse.clone();
    }
}

