/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.CompositeFigure;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureAdapter;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.Layouter;
import org.jhotdraw.draw.LineConnectionFigure;
import org.jhotdraw.util.ReversedList;

public class LabeledLineConnectionFigure
extends LineConnectionFigure
implements CompositeFigure {
    private Layouter layouter;
    private ArrayList<Figure> children = new ArrayList();
    private Rectangle2D.Double drawBounds;
    private ChildHandler childHandler = new ChildHandler(this);

    @Override
    public void draw(Graphics2D g) {
        super.draw(g);
        for (Figure child : this.children) {
            if (!child.isVisible()) continue;
            child.draw(g);
        }
    }

    @Override
    public void transform(AffineTransform tx) {
        super.transform(tx);
        for (Figure f : this.children) {
            f.transform(tx);
        }
        this.invalidateBounds();
    }

    @Override
    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        super.setBounds(anchor, lead);
        this.invalidate();
    }

    @Override
    public Rectangle2D.Double getBounds() {
        return super.getBounds();
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        if (this.drawBounds == null) {
            this.drawBounds = super.getDrawingArea();
            for (Figure child : this.getChildrenFrontToBack()) {
                Rectangle2D.Double childBounds;
                if (!child.isVisible() || (childBounds = child.getDrawingArea()).isEmpty()) continue;
                this.drawBounds.add(childBounds);
            }
        }
        return (Rectangle2D.Double)this.drawBounds.clone();
    }

    @Override
    public boolean contains(Point2D.Double p) {
        if (this.getDrawingArea().contains(p)) {
            for (Figure child : this.getChildrenFrontToBack()) {
                if (!child.isVisible() || !child.contains(p)) continue;
                return true;
            }
            return super.contains(p);
        }
        return false;
    }

    protected void invalidateBounds() {
        this.drawBounds = null;
    }

    @Override
    public void setAttribute(AttributeKey key, Object newValue) {
        super.setAttribute(key, newValue);
        if (this.isAttributeEnabled(key) && this.children != null) {
            for (Figure child : this.children) {
                child.setAttribute(key, newValue);
            }
        }
    }

    @Override
    public Figure findFigureInside(Point2D.Double p) {
        if (this.getDrawingArea().contains(p)) {
            Figure found = null;
            for (Figure child : this.getChildrenFrontToBack()) {
                if (!child.isVisible() || (found = child.findFigureInside(p)) == null) continue;
                return found;
            }
        }
        return null;
    }

    @Override
    public void updateConnection() {
        AttributeKeys.TEXT_COLOR.set(this, this.validation.validateLineConnection(this));
        AttributeKeys.STROKE_COLOR.set(this, this.validation.validateLineConnection(this));
        super.updateConnection();
        this.layout();
    }

    @Override
    public List<Figure> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public Figure getChild(int index) {
        return this.children.get(index);
    }

    public void set(int index, Figure child) {
        this.children.set(index, child);
    }

    public List<Figure> getChildrenFrontToBack() {
        return this.children == null ? new LinkedList() : new ReversedList<Figure>(this.children);
    }

    @Override
    public void add(Figure figure) {
        this.basicAdd(figure);
        if (this.getDrawing() != null) {
            figure.addNotify(this.getDrawing());
        }
    }

    @Override
    public void add(int index, Figure figure) {
        this.basicAdd(index, figure);
        if (this.getDrawing() != null) {
            figure.addNotify(this.getDrawing());
        }
    }

    @Override
    public void basicAdd(Figure figure) {
        this.basicAdd(this.children.size(), figure);
    }

    @Override
    public void basicAdd(int index, Figure figure) {
        this.children.add(index, figure);
        figure.addFigureListener(this.childHandler);
        this.invalidate();
    }

    @Override
    public boolean remove(Figure figure) {
        int index = this.children.indexOf(figure);
        if (index == -1) {
            return false;
        }
        this.willChange();
        this.basicRemoveChild(index);
        if (this.getDrawing() != null) {
            figure.removeNotify(this.getDrawing());
        }
        this.changed();
        return true;
    }

    @Override
    public Figure removeChild(int index) {
        this.willChange();
        Figure figure = this.basicRemoveChild(index);
        if (this.getDrawing() != null) {
            figure.removeNotify(this.getDrawing());
        }
        this.changed();
        return figure;
    }

    @Override
    public boolean basicRemove(Figure figure) {
        int index = this.children.indexOf(figure);
        if (index == -1) {
            return false;
        }
        this.basicRemoveChild(index);
        return true;
    }

    @Override
    public Figure basicRemoveChild(int index) {
        Figure figure = this.children.remove(index);
        figure.removeFigureListener(this.childHandler);
        return figure;
    }

    @Override
    public void removeAllChildren() {
        this.willChange();
        while (this.children.size() > 0) {
            Figure figure = this.basicRemoveChild(this.children.size() - 1);
            if (this.getDrawing() == null) continue;
            figure.removeNotify(this.getDrawing());
        }
        this.changed();
    }

    @Override
    public void basicRemoveAllChildren() {
        while (this.children.size() > 0) {
            this.basicRemoveChild(this.children.size() - 1);
        }
    }

    @Override
    public Layouter getLayouter() {
        return this.layouter;
    }

    @Override
    public void setLayouter(Layouter newLayouter) {
        this.layouter = newLayouter;
    }

    @Override
    public void layout() {
        if (this.getLayouter() != null) {
            Rectangle2D.Double bounds = this.getBounds();
            Point2D.Double p = new Point2D.Double(bounds.x, bounds.y);
            Rectangle2D.Double r = this.getLayouter().layout(this, p, p);
            this.invalidateBounds();
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.invalidateBounds();
    }

    @Override
    public void validate() {
        super.validate();
        this.layout();
    }

    @Override
    public void addNotify(Drawing drawing) {
        for (Figure child : new LinkedList<Figure>(this.children)) {
            child.addNotify(drawing);
        }
        super.addNotify(drawing);
    }

    @Override
    public void removeNotify(Drawing drawing) {
        for (Figure child : new LinkedList<Figure>(this.children)) {
            child.removeNotify(drawing);
        }
        super.removeNotify(drawing);
    }

    @Override
    public LabeledLineConnectionFigure clone() {
        LabeledLineConnectionFigure that = (LabeledLineConnectionFigure)super.clone();
        that.childHandler = new ChildHandler(that);
        that.children = new ArrayList();
        for (Figure thisChild : this.children) {
            Figure thatChild = (Figure)thisChild.clone();
            that.children.add(thatChild);
            thatChild.addFigureListener(that.childHandler);
        }
        return that;
    }

    @Override
    public void remap(HashMap<Figure, Figure> oldToNew) {
        super.remap(oldToNew);
        for (Figure child : this.children) {
            child.remap(oldToNew);
        }
    }

    private static class ChildHandler
    extends FigureAdapter
    implements UndoableEditListener {
        private LabeledLineConnectionFigure owner;

        private ChildHandler(LabeledLineConnectionFigure owner) {
            this.owner = owner;
        }

        @Override
        public void figureRequestRemove(FigureEvent e) {
            this.owner.remove(e.getFigure());
        }

        @Override
        public void figureChanged(FigureEvent e) {
            if (!this.owner.isChanging()) {
                this.owner.willChange();
                this.owner.fireFigureChanged(e);
                this.owner.changed();
            }
        }

        @Override
        public void figureAreaInvalidated(FigureEvent e) {
            if (!this.owner.isChanging()) {
                this.owner.fireAreaInvalidated(e.getInvalidatedArea());
            }
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            this.owner.fireUndoableEditHappened(e.getEdit());
        }
    }
}

