/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.draw.BezierNodeHandle;
import org.jhotdraw.draw.BezierOutlineHandle;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.geom.BezierPath;

public class LineFigure
extends BezierFigure {
    public LineFigure() {
        this.addNode(new BezierPath.Node(new Point2D.Double(0.0, 0.0)));
        this.addNode(new BezierPath.Node(new Point2D.Double(0.0, 0.0)));
    }

    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        switch (detailLevel) {
            case 0: {
                handles.add(new BezierOutlineHandle(this));
                int i = 0;
                int n = this.path.size();
                while (i < n) {
                    handles.add(new BezierNodeHandle(this, i));
                    ++i;
                }
                break;
            }
        }
        return handles;
    }

    @Override
    public boolean canConnect() {
        return false;
    }

    @Override
    public boolean handleMouseClick(Point2D.Double p, MouseEvent evt, DrawingView view) {
        if (evt.getClickCount() == 2 && view.getHandleDetailLevel() == 0) {
            this.willChange();
            final int index = this.splitSegment(p, (float)(5.0 / view.getScaleFactor()));
            if (index != -1) {
                final BezierPath.Node newNode = this.getNode(index);
                this.fireUndoableEditHappened(new AbstractUndoableEdit(){

                    @Override
                    public void redo() throws CannotRedoException {
                        super.redo();
                        LineFigure.this.willChange();
                        LineFigure.this.addNode(index, newNode);
                        LineFigure.this.changed();
                    }

                    @Override
                    public void undo() throws CannotUndoException {
                        super.undo();
                        LineFigure.this.willChange();
                        LineFigure.this.removeNode(index);
                        LineFigure.this.changed();
                    }
                });
                this.changed();
                return true;
            }
        }
        return false;
    }
}

