/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Collection;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.Locator;
import org.jhotdraw.draw.LocatorHandle;
import org.jhotdraw.draw.RelativeLocator;
import org.jhotdraw.draw.TransformEdit;

public class MoveHandle
extends LocatorHandle {
    private Point2D.Double oldPoint;
    private Object geometry;

    public MoveHandle(Figure owner, Locator locator) {
        super(owner, locator);
    }

    public static void addMoveHandles(Figure f, Collection<Handle> handles) {
        handles.add(MoveHandle.southEast(f));
        handles.add(MoveHandle.southWest(f));
        handles.add(MoveHandle.northEast(f));
        handles.add(MoveHandle.northWest(f));
    }

    @Override
    public void draw(Graphics2D g) {
        this.drawRectangle(g, Color.white, Color.black);
    }

    @Override
    public void trackStart(Point anchor, int modifiersEx) {
        this.oldPoint = this.view.getConstrainer().constrainPoint(this.view.viewToDrawing(anchor));
    }

    @Override
    public void trackStep(Point anchor, Point lead, int modifiersEx) {
        Figure f = this.getOwner();
        Point2D.Double newPoint = this.view.getConstrainer().constrainPoint(this.view.viewToDrawing(lead));
        AffineTransform tx = new AffineTransform();
        tx.translate(newPoint.x - this.oldPoint.x, newPoint.y - this.oldPoint.y);
        f.willChange();
        f.transform(tx);
        f.changed();
        this.oldPoint = newPoint;
    }

    @Override
    public void trackEnd(Point anchor, Point lead, int modifiersEx) {
        AffineTransform tx = new AffineTransform();
        tx.translate(lead.x - anchor.x, lead.y - anchor.y);
        this.fireUndoableEditHappened(new TransformEdit(this.getOwner(), tx));
    }

    public static Handle south(Figure owner) {
        return new MoveHandle(owner, RelativeLocator.south());
    }

    public static Handle southEast(Figure owner) {
        return new MoveHandle(owner, RelativeLocator.southEast());
    }

    public static Handle southWest(Figure owner) {
        return new MoveHandle(owner, RelativeLocator.southWest());
    }

    public static Handle north(Figure owner) {
        return new MoveHandle(owner, RelativeLocator.north());
    }

    public static Handle northEast(Figure owner) {
        return new MoveHandle(owner, RelativeLocator.northEast());
    }

    public static Handle northWest(Figure owner) {
        return new MoveHandle(owner, RelativeLocator.northWest());
    }

    public static Handle east(Figure owner) {
        return new MoveHandle(owner, RelativeLocator.east());
    }

    public static Handle west(Figure owner) {
        return new MoveHandle(owner, RelativeLocator.west());
    }
}

