/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.BoundsOutlineHandle;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.GeometryEdit;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.Locator;
import org.jhotdraw.draw.LocatorHandle;
import org.jhotdraw.draw.RelativeLocator;
import org.jhotdraw.util.ResourceBundleUtil;

public class ResizeHandleKit {
    private static final boolean DEBUG = false;
    private static final Color HANDLE_FILL_COLOR = Color.WHITE;
    private static final Color HANDLE_STROKE_COLOR = Color.BLACK;

    public static void addCornerResizeHandles(Figure f, Collection<Handle> handles) {
        handles.add(ResizeHandleKit.southEast(f));
        handles.add(ResizeHandleKit.southWest(f));
        handles.add(ResizeHandleKit.northEast(f));
        handles.add(ResizeHandleKit.northWest(f));
    }

    public static void addEdgeResizeHandles(Figure f, Collection<Handle> handles) {
        handles.add(ResizeHandleKit.south(f));
        handles.add(ResizeHandleKit.north(f));
        handles.add(ResizeHandleKit.east(f));
        handles.add(ResizeHandleKit.west(f));
    }

    public static void addResizeHandles(Figure f, Collection<Handle> handles) {
        handles.add(new BoundsOutlineHandle(f));
        ResizeHandleKit.addCornerResizeHandles(f, handles);
        ResizeHandleKit.addEdgeResizeHandles(f, handles);
    }

    public static Handle south(Figure owner) {
        return new SouthHandle(owner);
    }

    public static Handle southEast(Figure owner) {
        return new SouthEastHandle(owner);
    }

    public static Handle southWest(Figure owner) {
        return new SouthWestHandle(owner);
    }

    public static Handle north(Figure owner) {
        return new NorthHandle(owner);
    }

    public static Handle northEast(Figure owner) {
        return new NorthEastHandle(owner);
    }

    public static Handle northWest(Figure owner) {
        return new NorthWestHandle(owner);
    }

    public static Handle east(Figure owner) {
        return new EastHandle(owner);
    }

    public static Handle west(Figure owner) {
        return new WestHandle(owner);
    }

    private static class EastHandle
    extends ResizeHandle {
        EastHandle(Figure owner) {
            super(owner, RelativeLocator.east(true));
        }

        @Override
        protected void trackStepNormalized(Point2D.Double p) {
            Rectangle2D.Double r = this.getOwner().getBounds();
            this.setBounds(new Point2D.Double(r.x, r.y), new Point2D.Double(Math.max(r.x + 1.0, p.x), r.y + r.height));
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(11);
        }
    }

    private static class NorthEastHandle
    extends ResizeHandle {
        NorthEastHandle(Figure owner) {
            super(owner, RelativeLocator.northEast(true));
        }

        @Override
        protected void trackStepNormalized(Point2D.Double p) {
            Rectangle2D.Double r = this.getOwner().getBounds();
            this.setBounds(new Point2D.Double(r.x, Math.min(r.y + r.height - 1.0, p.y)), new Point2D.Double(Math.max(r.x, p.x), r.y + r.height));
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(7);
        }
    }

    private static class NorthHandle
    extends ResizeHandle {
        NorthHandle(Figure owner) {
            super(owner, RelativeLocator.north(true));
        }

        @Override
        protected void trackStepNormalized(Point2D.Double p) {
            Rectangle2D.Double r = this.getOwner().getBounds();
            this.setBounds(new Point2D.Double(r.x, Math.min(r.y + r.height - 1.0, p.y)), new Point2D.Double(r.x + r.width, r.y + r.height));
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(8);
        }
    }

    private static class NorthWestHandle
    extends ResizeHandle {
        NorthWestHandle(Figure owner) {
            super(owner, RelativeLocator.northWest(true));
        }

        @Override
        protected void trackStepNormalized(Point2D.Double p) {
            Rectangle2D.Double r = this.getOwner().getBounds();
            this.setBounds(new Point2D.Double(Math.min(r.x + r.width - 1.0, p.x), Math.min(r.y + r.height - 1.0, p.y)), new Point2D.Double(r.x + r.width, r.y + r.height));
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(6);
        }
    }

    private static class ResizeHandle
    extends LocatorHandle {
        private int dx;
        private int dy;
        Object geometry;

        ResizeHandle(Figure owner, Locator loc) {
            super(owner, loc);
        }

        @Override
        public String getToolTipText(Point p) {
            ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
            return labels.getString("resizeHandle.tip");
        }

        @Override
        public void draw(Graphics2D g) {
            this.drawRectangle(g, HANDLE_FILL_COLOR, HANDLE_STROKE_COLOR);
        }

        @Override
        public void trackStart(Point anchor, int modifiersEx) {
            this.geometry = this.getOwner().getTransformRestoreData();
            Point location = this.getLocation();
            this.dx = -anchor.x + location.x;
            this.dy = -anchor.y + location.y;
        }

        @Override
        public void trackStep(Point anchor, Point lead, int modifiersEx) {
            Point2D.Double p = this.view.viewToDrawing(new Point(lead.x + this.dx, lead.y + this.dy));
            this.view.getConstrainer().constrainPoint(p);
            if (AttributeKeys.TRANSFORM.get(this.getOwner()) != null) {
                try {
                    AttributeKeys.TRANSFORM.get(this.getOwner()).inverseTransform(p, p);
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    // empty catch block
                }
            }
            this.trackStepNormalized(p);
        }

        @Override
        public void trackEnd(Point anchor, Point lead, int modifiersEx) {
            this.fireUndoableEditHappened(new GeometryEdit(this.getOwner(), this.geometry, this.getOwner().getTransformRestoreData()));
        }

        protected void trackStepNormalized(Point2D.Double p) {
        }

        protected void setBounds(Point2D.Double anchor, Point2D.Double lead) {
            Figure f = this.getOwner();
            f.willChange();
            f.setBounds(anchor, lead);
            f.changed();
        }
    }

    private static class SouthEastHandle
    extends ResizeHandle {
        SouthEastHandle(Figure owner) {
            super(owner, RelativeLocator.southEast(true));
        }

        @Override
        protected void trackStepNormalized(Point2D.Double p) {
            Rectangle2D.Double r = this.getOwner().getBounds();
            this.setBounds(new Point2D.Double(r.x, r.y), new Point2D.Double(Math.max(r.x + 1.0, p.x), Math.max(r.y + 1.0, p.y)));
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(5);
        }
    }

    private static class SouthHandle
    extends ResizeHandle {
        SouthHandle(Figure owner) {
            super(owner, RelativeLocator.south(true));
        }

        @Override
        protected void trackStepNormalized(Point2D.Double p) {
            Rectangle2D.Double r = this.getOwner().getBounds();
            this.setBounds(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width, Math.max(r.y + 1.0, p.y)));
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(9);
        }
    }

    private static class SouthWestHandle
    extends ResizeHandle {
        SouthWestHandle(Figure owner) {
            super(owner, RelativeLocator.southWest(true));
        }

        @Override
        protected void trackStepNormalized(Point2D.Double p) {
            Rectangle2D.Double r = this.getOwner().getBounds();
            this.setBounds(new Point2D.Double(Math.min(r.x + r.width - 1.0, p.x), r.y), new Point2D.Double(r.x + r.width, Math.max(r.y + 1.0, p.y)));
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(4);
        }
    }

    private static class WestHandle
    extends ResizeHandle {
        WestHandle(Figure owner) {
            super(owner, RelativeLocator.west(true));
        }

        @Override
        protected void trackStepNormalized(Point2D.Double p) {
            Rectangle2D.Double r = this.getOwner().getBounds();
            this.setBounds(new Point2D.Double(Math.min(r.x + r.width - 1.0, p.x), r.y), new Point2D.Double(r.x + r.width, r.y + r.height));
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(10);
        }
    }
}

