/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.util.Locale;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.util.ResourceBundleUtil;

public class RestoreDataEdit
extends AbstractUndoableEdit {
    private Figure figure;
    private Object oldRestoreData;
    private Object newRestoreData;

    public RestoreDataEdit(Figure figure, Object oldRestoreData) {
        this.figure = figure;
        this.oldRestoreData = oldRestoreData;
        this.newRestoreData = figure.getTransformRestoreData();
    }

    @Override
    public String getPresentationName() {
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels", Locale.getDefault());
        return labels.getString("transformFigure");
    }

    @Override
    public boolean addEdit(UndoableEdit anEdit) {
        return false;
    }

    @Override
    public boolean replaceEdit(UndoableEdit anEdit) {
        return false;
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.figure.willChange();
        this.figure.restoreTransformTo(this.newRestoreData);
        this.figure.changed();
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.figure.willChange();
        this.figure.restoreTransformTo(this.oldRestoreData);
        this.figure.changed();
    }
}

