/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import org.jhotdraw.draw.AbstractTool;

public class SelectAreaTracker
extends AbstractTool {
    private Rectangle rubberband = new Rectangle();
    private Color rubberbandColor = Color.BLACK;
    private Stroke rubberbandStroke = new BasicStroke();

    @Override
    public void mousePressed(MouseEvent evt) {
        super.mousePressed(evt);
        this.clearRubberBand();
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        this.selectGroup(evt.isShiftDown());
        this.clearRubberBand();
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        Rectangle invalidatedArea = (Rectangle)this.rubberband.clone();
        this.rubberband.setBounds(Math.min(this.anchor.x, evt.getX()), Math.min(this.anchor.y, evt.getY()), Math.abs(this.anchor.x - evt.getX()), Math.abs(this.anchor.y - evt.getY()));
        invalidatedArea = invalidatedArea.isEmpty() ? (Rectangle)this.rubberband.clone() : invalidatedArea.union(this.rubberband);
        this.fireAreaInvalidated(invalidatedArea);
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        this.clearRubberBand();
        this.updateCursor(this.editor.findView((Container)evt.getSource()), new Point(evt.getX(), evt.getY()));
    }

    private void clearRubberBand() {
        if (!this.rubberband.isEmpty()) {
            this.fireAreaInvalidated(this.rubberband);
            this.rubberband.width = -1;
        }
    }

    @Override
    public void draw(Graphics2D g) {
        g.setStroke(this.rubberbandStroke);
        g.setColor(this.rubberbandColor);
        g.drawRect(this.rubberband.x, this.rubberband.y, this.rubberband.width - 1, this.rubberband.height - 1);
    }

    private void selectGroup(boolean toggle) {
        this.getView().addToSelection(this.getView().findFiguresWithin(this.rubberband));
    }
}

