/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AbstractAttributedFigure;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.GroupFigure;
import org.jhotdraw.draw.TerraFigureTree;
import org.jhotdraw.draw.TextFigure;

public class TerraResizeEventFunctions {
    protected GroupFigure Owner;
    protected AbstractAttributedFigure Geo;
    protected AbstractAttributedFigure Geo2;
    protected TextFigure Txf;

    public TerraResizeEventFunctions(GroupFigure Owner, AbstractAttributedFigure Geo, TextFigure Txf) {
        this(Owner, Geo, null, Txf);
    }

    public TerraResizeEventFunctions(GroupFigure Owner, AbstractAttributedFigure Geo, AbstractAttributedFigure Geo2, TextFigure Txf) {
        this.Owner = Owner;
        this.Geo = Geo;
        this.Txf = Txf;
        this.Geo2 = Geo2;
    }

    public void figureSizeChanged() {
        Rectangle2D.Double GeoBounds = this.Geo.getBounds();
        Rectangle2D.Double TxfBounds = this.Txf.getBounds();
        if (GeoBounds.getWidth() > TxfBounds.getWidth()) {
            TxfBounds.x = GeoBounds.x + (GeoBounds.width - TxfBounds.width) / 2.0;
            this.Txf.setBounds(TxfBounds);
        } else {
            GeoBounds.width = TxfBounds.width;
            this.Geo.setBounds(GeoBounds);
            if (this.Geo2 != null) {
                this.Geo2.setBounds(GeoBounds);
            }
        }
        if (GeoBounds.getHeight() > TxfBounds.getHeight()) {
            TxfBounds.y = GeoBounds.y + (GeoBounds.height - TxfBounds.height) / 2.0;
            this.Txf.setBounds(TxfBounds);
        } else {
            GeoBounds.height = TxfBounds.height;
            this.Geo.setBounds(GeoBounds);
            if (this.Geo2 != null) {
                this.Geo2.setBounds(GeoBounds);
            }
        }
    }

    public void figureCenterText() {
        Rectangle2D.Double GeoBounds = this.Geo.getBounds();
        Rectangle2D.Double TxfBounds = this.Txf.getBounds();
        if (GeoBounds.getWidth() > TxfBounds.getWidth()) {
            TxfBounds.x = GeoBounds.x + (GeoBounds.width - TxfBounds.width) / 2.0;
        }
        if (GeoBounds.getHeight() > TxfBounds.getHeight()) {
            TxfBounds.y = GeoBounds.y + (GeoBounds.height - TxfBounds.height) / 2.0;
        }
        this.Txf.setBounds(TxfBounds);
    }

    public void figureTextChanged(FigureEvent e) {
        Object e1 = e.getNewValue();
        Object e2 = e.getOldValue();
        if (e1 != null && e2 != null && !e1.toString().equals(e2.toString())) {
            TerraFigureTree.getInstance().refresh(this.Owner);
            Rectangle2D.Double GeoBounds = this.Geo.getBounds();
            Rectangle2D.Double TxfBounds = this.Txf.getBounds();
            if (GeoBounds.getWidth() < TxfBounds.getWidth()) {
                GeoBounds.width = TxfBounds.width + 20.0;
                this.Geo.setBounds(GeoBounds);
                if (this.Geo2 != null) {
                    this.Geo2.setBounds(GeoBounds);
                }
            }
        }
    }
}

