/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.GeometryEdit;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.Locator;
import org.jhotdraw.draw.LocatorHandle;
import org.jhotdraw.draw.RelativeLocator;
import org.jhotdraw.draw.RotateHandle;
import org.jhotdraw.util.ResourceBundleUtil;

public class TransformHandleKit {
    public static void addCornerTransformHandles(Figure f, Collection<Handle> handles) {
        handles.add(TransformHandleKit.southEast(f));
        handles.add(TransformHandleKit.southWest(f));
        handles.add(TransformHandleKit.northEast(f));
        handles.add(TransformHandleKit.northWest(f));
    }

    public static void addEdgeTransformHandles(Figure f, Collection<Handle> handles) {
        handles.add(TransformHandleKit.south(f));
        handles.add(TransformHandleKit.north(f));
        handles.add(TransformHandleKit.east(f));
        handles.add(TransformHandleKit.west(f));
    }

    public static void addScaleMoveTransformHandles(Figure f, Collection<Handle> handles) {
        TransformHandleKit.addCornerTransformHandles(f, handles);
        TransformHandleKit.addEdgeTransformHandles(f, handles);
    }

    public static void addTransformHandles(Figure f, Collection<Handle> handles) {
        TransformHandleKit.addCornerTransformHandles(f, handles);
        TransformHandleKit.addEdgeTransformHandles(f, handles);
        handles.add(new RotateHandle(f));
    }

    public static Handle south(Figure owner) {
        return new SouthHandle(owner);
    }

    public static Handle southEast(Figure owner) {
        return new SouthEastHandle(owner);
    }

    public static Handle southWest(Figure owner) {
        return new SouthWestHandle(owner);
    }

    public static Handle north(Figure owner) {
        return new NorthHandle(owner);
    }

    public static Handle northEast(Figure owner) {
        return new NorthEastHandle(owner);
    }

    public static Handle northWest(Figure owner) {
        return new NorthWestHandle(owner);
    }

    public static Handle east(Figure owner) {
        return new EastHandle(owner);
    }

    public static Handle west(Figure owner) {
        return new WestHandle(owner);
    }

    private static class EastHandle
    extends TransformHandle {
        EastHandle(Figure owner) {
            super(owner, RelativeLocator.east());
        }

        @Override
        protected void trackStepNormalized(Point2D.Double p) {
            Rectangle2D.Double r = this.getTransformedBounds();
            this.transform(new Point2D.Double(r.x, r.y), new Point2D.Double(Math.max(r.x + 1.0, p.x), r.y + r.height));
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(11);
        }
    }

    private static class NorthEastHandle
    extends TransformHandle {
        NorthEastHandle(Figure owner) {
            super(owner, RelativeLocator.northEast());
        }

        @Override
        protected void trackStepNormalized(Point2D.Double p) {
            Rectangle2D.Double r = this.getTransformedBounds();
            this.transform(new Point2D.Double(r.x, Math.min(r.y + r.height - 1.0, p.y)), new Point2D.Double(Math.max(r.x, p.x), r.y + r.height));
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(7);
        }
    }

    private static class NorthHandle
    extends TransformHandle {
        NorthHandle(Figure owner) {
            super(owner, RelativeLocator.north());
        }

        @Override
        protected void trackStepNormalized(Point2D.Double p) {
            Rectangle2D.Double r = this.getTransformedBounds();
            this.transform(new Point2D.Double(r.x, Math.min(r.y + r.height - 1.0, p.y)), new Point2D.Double(r.x + r.width, r.y + r.height));
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(8);
        }
    }

    private static class NorthWestHandle
    extends TransformHandle {
        NorthWestHandle(Figure owner) {
            super(owner, RelativeLocator.northWest());
        }

        @Override
        protected void trackStepNormalized(Point2D.Double p) {
            Rectangle2D.Double r = this.getTransformedBounds();
            this.transform(new Point2D.Double(Math.min(r.x + r.width - 1.0, p.x), Math.min(r.y + r.height - 1.0, p.y)), new Point2D.Double(r.x + r.width, r.y + r.height));
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(6);
        }
    }

    private static class SouthEastHandle
    extends TransformHandle {
        SouthEastHandle(Figure owner) {
            super(owner, RelativeLocator.southEast());
        }

        @Override
        protected void trackStepNormalized(Point2D.Double p) {
            Rectangle2D.Double r = this.getTransformedBounds();
            this.transform(new Point2D.Double(r.x, r.y), new Point2D.Double(Math.max(r.x + 1.0, p.x), Math.max(r.y + 1.0, p.y)));
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(5);
        }
    }

    private static class SouthHandle
    extends TransformHandle {
        SouthHandle(Figure owner) {
            super(owner, RelativeLocator.south());
        }

        @Override
        protected void trackStepNormalized(Point2D.Double p) {
            Rectangle2D.Double r = this.getTransformedBounds();
            this.transform(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width, Math.max(r.y + 1.0, p.y)));
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(9);
        }
    }

    private static class SouthWestHandle
    extends TransformHandle {
        SouthWestHandle(Figure owner) {
            super(owner, RelativeLocator.southWest());
        }

        @Override
        protected void trackStepNormalized(Point2D.Double p) {
            Rectangle2D.Double r = this.getTransformedBounds();
            this.transform(new Point2D.Double(Math.min(r.x + r.width - 1.0, p.x), r.y), new Point2D.Double(r.x + r.width, Math.max(r.y + 1.0, p.y)));
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(4);
        }
    }

    private static class TransformHandle
    extends LocatorHandle {
        private int dx;
        private int dy;
        Object geometry;

        TransformHandle(Figure owner, Locator loc) {
            super(owner, loc);
        }

        @Override
        public String getToolTipText(Point p) {
            ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
            return labels.getString("transformHandle.tip");
        }

        protected Rectangle2D.Double getTransformedBounds() {
            Figure owner = this.getOwner();
            Rectangle2D.Double bounds = owner.getBounds();
            if (AttributeKeys.TRANSFORM.get(owner) != null) {
                Rectangle2D r = AttributeKeys.TRANSFORM.get(owner).createTransformedShape(bounds).getBounds2D();
                bounds.x = r.getX();
                bounds.y = r.getY();
                bounds.width = r.getWidth();
                bounds.height = r.getHeight();
            }
            return bounds;
        }

        @Override
        public void trackStart(Point anchor, int modifiersEx) {
            this.geometry = this.getOwner().getTransformRestoreData();
            Point location = this.getLocation();
            this.dx = -anchor.x + location.x;
            this.dy = -anchor.y + location.y;
        }

        @Override
        public void trackStep(Point anchor, Point lead, int modifiersEx) {
            Point2D.Double p = this.view.viewToDrawing(new Point(lead.x + this.dx, lead.y + this.dy));
            this.view.getConstrainer().constrainPoint(p);
            this.trackStepNormalized(p);
        }

        @Override
        public void trackEnd(Point anchor, Point lead, int modifiersEx) {
            this.fireUndoableEditHappened(new GeometryEdit(this.getOwner(), this.geometry, this.getOwner().getTransformRestoreData()));
        }

        protected void trackStepNormalized(Point2D.Double p) {
        }

        protected void transform(Point2D.Double anchor, Point2D.Double lead) {
            Figure f = this.getOwner();
            f.willChange();
            Rectangle2D.Double oldBounds = this.getTransformedBounds();
            Rectangle2D.Double newBounds = new Rectangle2D.Double(Math.min(anchor.x, lead.x), Math.min(anchor.y, lead.y), Math.abs(anchor.x - lead.x), Math.abs(anchor.y - lead.y));
            double sx = newBounds.width / oldBounds.width;
            double sy = newBounds.height / oldBounds.height;
            AffineTransform tx = new AffineTransform();
            tx.translate(-oldBounds.x, -oldBounds.y);
            if (!(Double.isNaN(sx) || Double.isNaN(sy) || sx == 1.0 && sy == 1.0 || sx < 1.0E-4 || sy < 1.0E-4)) {
                f.transform(tx);
                tx.setToIdentity();
                tx.scale(sx, sy);
                f.transform(tx);
                tx.setToIdentity();
            }
            tx.translate(newBounds.x, newBounds.y);
            f.transform(tx);
            f.changed();
        }
    }

    private static class WestHandle
    extends TransformHandle {
        WestHandle(Figure owner) {
            super(owner, RelativeLocator.west());
        }

        @Override
        protected void trackStepNormalized(Point2D.Double p) {
            Rectangle2D.Double r = this.getTransformedBounds();
            this.transform(new Point2D.Double(Math.min(r.x + r.width - 1.0, p.x), r.y), new Point2D.Double(r.x + r.width, r.y + r.height));
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(10);
        }
    }
}

