/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Direction;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.TransformEdit;
import org.jhotdraw.draw.action.AbstractSelectedAction;

public abstract class MoveConstrainedAction
extends AbstractSelectedAction {
    private Direction dir;

    public MoveConstrainedAction(DrawingEditor editor, Direction dir) {
        super(editor);
        this.dir = dir;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Point2D p1 = null;
        switch (this.dir) {
            case EAST: {
                Point2D.Double fp;
                Rectangle2D.Double b;
                for (Figure f : this.getView().getSelectedFigures()) {
                    b = f.getBounds();
                    fp = new Point2D.Double(b.x + b.width, b.y + b.height / 2.0);
                    if (AttributeKeys.TRANSFORM.get(f) != null) {
                        AttributeKeys.TRANSFORM.get(f).transform(fp, fp);
                    }
                    if (p1 == null) {
                        p1 = fp;
                        continue;
                    }
                    ((Point2D.Double)p1).x = Math.max(fp.x, ((Point2D.Double)p1).x);
                }
                break;
            }
            case WEST: {
                Point2D.Double fp;
                Rectangle2D.Double b;
                for (Figure f : this.getView().getSelectedFigures()) {
                    b = f.getBounds();
                    fp = new Point2D.Double(b.x, b.y + b.height / 2.0);
                    if (AttributeKeys.TRANSFORM.get(f) != null) {
                        AttributeKeys.TRANSFORM.get(f).transform(fp, fp);
                    }
                    if (p1 == null) {
                        p1 = fp;
                        continue;
                    }
                    ((Point2D.Double)p1).x = Math.min(fp.x, ((Point2D.Double)p1).x);
                }
                break;
            }
            case NORTH: {
                Point2D.Double fp;
                Rectangle2D.Double b;
                for (Figure f : this.getView().getSelectedFigures()) {
                    b = f.getBounds();
                    fp = new Point2D.Double(b.x + b.width / 2.0, b.y);
                    if (AttributeKeys.TRANSFORM.get(f) != null) {
                        AttributeKeys.TRANSFORM.get(f).transform(fp, fp);
                    }
                    if (p1 == null) {
                        p1 = fp;
                        continue;
                    }
                    ((Point2D.Double)p1).x = Math.min(fp.x, ((Point2D.Double)p1).x);
                }
                break;
            }
            case SOUTH: {
                Point2D.Double fp;
                Rectangle2D.Double b;
                for (Figure f : this.getView().getSelectedFigures()) {
                    b = f.getBounds();
                    fp = new Point2D.Double(b.x + b.width / 2.0, b.y + b.height);
                    if (AttributeKeys.TRANSFORM.get(f) != null) {
                        AttributeKeys.TRANSFORM.get(f).transform(fp, fp);
                    }
                    if (p1 == null) {
                        p1 = fp;
                        continue;
                    }
                    ((Point2D.Double)p1).x = Math.min(fp.x, ((Point2D.Double)p1).x);
                }
                break;
            }
        }
        if (p1 != null) {
            Point2D.Double p2 = (Point2D.Double)p1.clone();
            if (this.getView().getConstrainer() != null) {
                this.getView().getConstrainer().constrainPoint(p2, this.dir);
            }
            AffineTransform tx = new AffineTransform();
            tx.translate(p2.x - ((Point2D.Double)p1).x, p2.y - ((Point2D.Double)p1).y);
            for (Figure f : this.getView().getSelectedFigures()) {
                f.willChange();
                f.transform(tx);
                f.changed();
            }
            this.fireUndoableEditHappened(new TransformEdit(this.getView().getSelectedFigures(), tx));
        }
    }

    public static class East
    extends MoveConstrainedAction {
        public static final String ID = "moveConstrainedEast";

        public East(DrawingEditor editor) {
            super(editor, Direction.EAST);
            this.labels.configureAction(this, ID);
        }
    }

    public static class North
    extends MoveConstrainedAction {
        public static final String ID = "moveConstrainedNorth";

        public North(DrawingEditor editor) {
            super(editor, Direction.NORTH);
            this.labels.configureAction(this, ID);
        }
    }

    public static class South
    extends MoveConstrainedAction {
        public static final String ID = "moveConstrainedSouth";

        public South(DrawingEditor editor) {
            super(editor, Direction.SOUTH);
            this.labels.configureAction(this, ID);
        }
    }

    public static class West
    extends MoveConstrainedAction {
        public static final String ID = "moveConstrainedWest";

        public West(DrawingEditor editor) {
            super(editor, Direction.WEST);
            this.labels.configureAction(this, ID);
        }
    }
}

