/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.enums.AttributeTypeEnum;
import org.jhotdraw.interfaces.AttributeTypeElement;

public class SelectAttributeTypeAction
extends AbstractSelectedAction {
    public SelectAttributeTypeAction(DrawingEditor editor) {
        super(editor);
        this.putValue("Name", this.labels.getString("editSelectAttributeType"));
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.selectAttributeType();
    }

    public void selectAttributeType() {
        DrawingView v = this.getView();
        if (v.getSelectedFigures() != null && v.getSelectedFigures().size() == 1 && v.getSelectedFigures().toArray()[0] instanceof AttributeTypeElement) {
            AttributeTypeElement att = (AttributeTypeElement)((Object)v.getSelectedFigures().iterator().next());
            AttributeTypeEnum[] list = new AttributeTypeEnum[]{AttributeTypeEnum.CHAR, AttributeTypeEnum.DATE, AttributeTypeEnum.INTEGER, AttributeTypeEnum.NUMBER, AttributeTypeEnum.TEXT};
            JCheckBox chkNull = new JCheckBox(this.labels.getString("type.notnull"));
            chkNull.setSelected(!att.isNullable());
            JComboBox<AttributeTypeEnum> jcbType = new JComboBox<AttributeTypeEnum>(list);
            jcbType.setEditable(false);
            if (att.getAttributeType() != null) {
                jcbType.setSelectedItem((Object)att.getAttributeType());
            }
            if (JOptionPane.showConfirmDialog(null, new Object[]{jcbType, chkNull}, "Select the attribute type", 2) == 0) {
                att.setAttributeType((AttributeTypeEnum)((Object)jcbType.getSelectedItem()));
                att.setNullable(!chkNull.isSelected());
            }
        }
    }
}

