/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.geom;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.geom.Geom;

public class DoubleStroke
implements Stroke {
    private BasicStroke outlineStroke;
    private float innerWidth;
    private float outlineWidth;
    private double miterLimit;
    private float[] dashes;
    private float dashPhase;

    public DoubleStroke(float innerWidth, float outlineWidth) {
        this(innerWidth, outlineWidth, 2, 2, 10.0f, null, 0.0f);
    }

    public DoubleStroke(float innerWidth, float outlineWidth, int cap, int join, float miterLimit, float[] dashes, float dashPhase) {
        this.innerWidth = innerWidth;
        this.outlineWidth = outlineWidth;
        this.miterLimit = miterLimit;
        this.outlineStroke = new BasicStroke(outlineWidth, cap, 2, miterLimit, dashes, dashPhase);
    }

    @Override
    public Shape createStrokedShape(Shape s) {
        BezierPath bp = new BezierPath();
        GeneralPath left = new GeneralPath();
        GeneralPath right = new GeneralPath();
        double[] coords = new double[6];
        PathIterator i = s.getPathIterator(null, 0.1);
        while (!i.isDone()) {
            int type = i.currentSegment(coords);
            switch (type) {
                case 0: {
                    if (bp.size() != 0) {
                        this.traceStroke(bp, left, right);
                    }
                    bp.clear();
                    bp.setClosed(false);
                    bp.moveTo(coords[0], coords[1]);
                    break;
                }
                case 1: {
                    if (coords[0] == ((BezierPath.Node)bp.get((int)(bp.size() - 1))).x[0] && coords[1] == ((BezierPath.Node)bp.get((int)(bp.size() - 1))).y[0]) break;
                    bp.lineTo(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    bp.quadTo(coords[0], coords[1], coords[2], coords[3]);
                    break;
                }
                case 3: {
                    bp.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 4: {
                    bp.setClosed(true);
                }
            }
            i.next();
        }
        if (bp.size() != 0) {
            this.traceStroke(bp, left, right);
        }
        right.append(left, false);
        return this.outlineStroke.createStrokedShape(right);
    }

    protected void traceStroke(BezierPath bp, GeneralPath left, GeneralPath right) {
        Point2D.Double intersect;
        BezierPath.Node node;
        int i;
        BezierPath.Node prev;
        double[] currentCorners = new double[8];
        double[] prevCorners = new double[8];
        if (bp.isClosed()) {
            prev = (BezierPath.Node)bp.get(bp.size() - 1);
            i = 0;
            while (i < bp.size()) {
                node = (BezierPath.Node)bp.get(i);
                if (prev.x[0] == node.x[0] && prev.y[0] == node.y[0]) {
                    bp.remove(i--);
                } else {
                    prev = node;
                }
                ++i;
            }
        } else {
            prev = (BezierPath.Node)bp.get(0);
            i = 1;
            while (i < bp.size()) {
                node = (BezierPath.Node)bp.get(i);
                if (prev.x[0] == node.x[0] && prev.y[0] == node.y[0]) {
                    bp.remove(i--);
                } else {
                    prev = node;
                }
                ++i;
            }
        }
        if (bp.isClosed() && bp.size() > 1) {
            intersect = Geom.intersect((prevCorners = this.computeThickLine(((BezierPath.Node)bp.get((int)(bp.size() - 1))).x[0], ((BezierPath.Node)bp.get((int)(bp.size() - 1))).y[0], ((BezierPath.Node)bp.get((int)0)).x[0], ((BezierPath.Node)bp.get((int)0)).y[0], this.innerWidth, prevCorners))[0], prevCorners[1], prevCorners[4], prevCorners[5], (currentCorners = this.computeThickLine(((BezierPath.Node)bp.get((int)0)).x[0], ((BezierPath.Node)bp.get((int)0)).y[0], ((BezierPath.Node)bp.get((int)1)).x[0], ((BezierPath.Node)bp.get((int)1)).y[0], this.innerWidth, currentCorners))[0], currentCorners[1], currentCorners[4], currentCorners[5], this.miterLimit);
            if (intersect != null) {
                right.moveTo((float)intersect.x, (float)intersect.y);
            } else {
                right.moveTo((float)prevCorners[4], (float)prevCorners[5]);
                right.lineTo((float)currentCorners[0], (float)currentCorners[1]);
            }
            intersect = Geom.intersect(prevCorners[2], prevCorners[3], prevCorners[6], prevCorners[7], currentCorners[2], currentCorners[3], currentCorners[6], currentCorners[7], this.miterLimit);
            if (intersect != null) {
                left.moveTo((float)intersect.x, (float)intersect.y);
            } else {
                left.moveTo((float)prevCorners[6], (float)prevCorners[7]);
                left.lineTo((float)currentCorners[2], (float)currentCorners[3]);
            }
        } else if (bp.size() > 1) {
            currentCorners = this.computeThickLine(((BezierPath.Node)bp.get((int)0)).x[0], ((BezierPath.Node)bp.get((int)0)).y[0], ((BezierPath.Node)bp.get((int)1)).x[0], ((BezierPath.Node)bp.get((int)1)).y[0], this.innerWidth, currentCorners);
            right.moveTo((float)currentCorners[0], (float)currentCorners[1]);
            left.moveTo((float)currentCorners[2], (float)currentCorners[3]);
        }
        int i2 = 1;
        int n = bp.size() - 1;
        while (i2 < n) {
            prevCorners = currentCorners;
            double[] tmp = prevCorners;
            intersect = Geom.intersect(prevCorners[0], prevCorners[1], prevCorners[4], prevCorners[5], (currentCorners = this.computeThickLine(((BezierPath.Node)bp.get((int)i2)).x[0], ((BezierPath.Node)bp.get((int)i2)).y[0], ((BezierPath.Node)bp.get((int)(i2 + 1))).x[0], ((BezierPath.Node)bp.get((int)(i2 + 1))).y[0], this.innerWidth, tmp))[0], currentCorners[1], currentCorners[4], currentCorners[5], this.miterLimit);
            if (intersect != null) {
                right.lineTo((float)intersect.x, (float)intersect.y);
            } else {
                right.lineTo((float)prevCorners[4], (float)prevCorners[5]);
                right.lineTo((float)currentCorners[0], (float)currentCorners[1]);
            }
            intersect = Geom.intersect(prevCorners[2], prevCorners[3], prevCorners[6], prevCorners[7], currentCorners[2], currentCorners[3], currentCorners[6], currentCorners[7], this.miterLimit);
            if (intersect != null) {
                left.lineTo((float)intersect.x, (float)intersect.y);
            } else {
                left.lineTo((float)prevCorners[6], (float)prevCorners[7]);
                left.lineTo((float)currentCorners[2], (float)currentCorners[3]);
            }
            ++i2;
        }
        if (bp.isClosed() && bp.size() > 0) {
            prevCorners = currentCorners;
            double[] tmp = prevCorners;
            intersect = Geom.intersect(prevCorners[0], prevCorners[1], prevCorners[4], prevCorners[5], (currentCorners = this.computeThickLine(((BezierPath.Node)bp.get((int)(bp.size() - 1))).x[0], ((BezierPath.Node)bp.get((int)(bp.size() - 1))).y[0], ((BezierPath.Node)bp.get((int)0)).x[0], ((BezierPath.Node)bp.get((int)0)).y[0], this.innerWidth, tmp))[0], currentCorners[1], currentCorners[4], currentCorners[5], this.miterLimit);
            if (intersect != null) {
                right.lineTo((float)intersect.x, (float)intersect.y);
            } else {
                right.lineTo((float)prevCorners[4], (float)prevCorners[5]);
                right.lineTo((float)currentCorners[0], (float)currentCorners[1]);
            }
            intersect = Geom.intersect(prevCorners[2], prevCorners[3], prevCorners[6], prevCorners[7], currentCorners[2], currentCorners[3], currentCorners[6], currentCorners[7], this.miterLimit);
            if (intersect != null) {
                left.lineTo((float)intersect.x, (float)intersect.y);
            } else {
                left.lineTo((float)prevCorners[6], (float)prevCorners[7]);
                left.lineTo((float)currentCorners[2], (float)currentCorners[3]);
            }
            right.closePath();
            left.closePath();
        } else if (bp.size() > 1) {
            right.lineTo((float)currentCorners[4], (float)currentCorners[5]);
            left.lineTo((float)currentCorners[6], (float)currentCorners[7]);
        }
    }

    private double[] computeThickLine(double[] seg, int offset, double[] corners) {
        return this.computeThickLine(seg[0 + offset], seg[1 + offset], seg[2 + offset], seg[3 + offset], this.innerWidth, corners);
    }

    private double[] computeThickLine(double x1, double y1, double x2, double y2, double thickness, double[] corners) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double lineLength = Math.sqrt(dx * dx + dy * dy);
        double scale = thickness / (2.0 * lineLength);
        double ddx = -scale * dy;
        double ddy = scale * dx;
        corners[0] = x1 + ddx;
        corners[1] = y1 + ddy;
        corners[2] = x1 - ddx;
        corners[3] = y1 - ddy;
        corners[4] = x2 + ddx;
        corners[5] = y2 + ddy;
        corners[6] = x2 - ddx;
        corners[7] = y2 - ddy;
        return corners;
    }
}

