/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.datatransfer;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;

public class CompositeTransferable
implements Transferable,
ClipboardOwner {
    private HashMap transferables = new HashMap();
    private LinkedList flavors = new LinkedList();

    public void add(Transferable t) {
        DataFlavor[] f = t.getTransferDataFlavors();
        int i = 0;
        while (i < f.length) {
            if (!this.transferables.containsKey(f[i])) {
                this.flavors.add(f[i]);
            }
            this.transferables.put(f[i], t);
            ++i;
        }
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        Transferable t = (Transferable)this.transferables.get(flavor);
        if (t == null) {
            throw new UnsupportedFlavorException(flavor);
        }
        return t.getTransferData(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors.toArray(new DataFlavor[this.transferables.size()]);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.transferables.containsKey(flavor);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

