/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class InputStreamTransferable
implements Transferable {
    private DataFlavor[] flavors;
    private byte[] data;

    public InputStreamTransferable(DataFlavor flavor, byte[] data) {
        this(new DataFlavor[]{flavor}, data);
    }

    public InputStreamTransferable(DataFlavor[] flavors, byte[] data) {
        this.flavors = flavors;
        this.data = data;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])this.flavors.clone();
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        DataFlavor[] dataFlavorArray = this.flavors;
        int n = this.flavors.length;
        int n2 = 0;
        while (n2 < n) {
            DataFlavor f = dataFlavorArray[n2];
            if (f.equals(flavor)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        return new ByteArrayInputStream(this.data);
    }
}

