/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.draw;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JToolBar;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.DefaultApplicationModel;
import org.jhotdraw.app.Project;
import org.jhotdraw.draw.AtributoChaveFigure;
import org.jhotdraw.draw.AtributoChaveParcialFigure;
import org.jhotdraw.draw.AtributoDerivadoFigure;
import org.jhotdraw.draw.AtributoFigure;
import org.jhotdraw.draw.AtributoMultivaloradoFigure;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.ConnectionTool;
import org.jhotdraw.draw.CreationTool;
import org.jhotdraw.draw.DefaultDrawingEditor;
import org.jhotdraw.draw.DisjuncaoFigure;
import org.jhotdraw.draw.DoubleLineConnectionGeneralizacaoFigure;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.EntidadeFigure;
import org.jhotdraw.draw.EntidadeFracaFigure;
import org.jhotdraw.draw.EntidadeRelacionamentoFigure;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.GeneralizacaoLineConnectionFigure;
import org.jhotdraw.draw.LabeledDoubleLineConnectionMuitosFigure;
import org.jhotdraw.draw.LabeledDoubleLineConnectionUmFigure;
import org.jhotdraw.draw.LabeledLineConnectionMuitosFigure;
import org.jhotdraw.draw.LabeledLineConnectionUmFigure;
import org.jhotdraw.draw.LineConnectionFigure;
import org.jhotdraw.draw.LineConnectionGeneralizacaoFigure;
import org.jhotdraw.draw.RelacionamentoFigure;
import org.jhotdraw.draw.RelacionamentoFracoFigure;
import org.jhotdraw.draw.SobreposicaoFigure;
import org.jhotdraw.draw.TextAreaFigure;
import org.jhotdraw.draw.TextAreaTool;
import org.jhotdraw.draw.TextFigure;
import org.jhotdraw.draw.TextItalicoFigure;
import org.jhotdraw.draw.TextTool;
import org.jhotdraw.draw.UniaoFigure;
import org.jhotdraw.draw.action.ButtonFactory;
import org.jhotdraw.samples.draw.DrawProject;
import org.jhotdraw.util.ResourceBundleUtil;

public class DrawApplicationModel
extends DefaultApplicationModel {
    private DefaultDrawingEditor sharedEditor;

    public DefaultDrawingEditor getSharedEditor() {
        if (this.sharedEditor == null) {
            this.sharedEditor = new DefaultDrawingEditor();
        }
        return this.sharedEditor;
    }

    @Override
    public void initProject(Application a, Project p) {
        if (a.isSharingToolsAmongProjects()) {
            ((DrawProject)p).setEditor(this.getSharedEditor());
        }
    }

    @Override
    public List<JToolBar> createToolBars(Application a, Project pr) {
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        DrawProject p = (DrawProject)pr;
        DrawingEditor editor = p == null ? this.getSharedEditor() : p.getEditor();
        LinkedList<JToolBar> list = new LinkedList<JToolBar>();
        JToolBar tb = new JToolBar();
        this.addCreationButtonsTo(tb, editor);
        tb.setName(labels.getString("drawToolBarTitle"));
        list.add(tb);
        tb = new JToolBar();
        ButtonFactory.addAlignmentButtonsTo(tb, editor);
        tb.setName(labels.getString("alignmentToolBarTitle"));
        list.add(tb);
        return list;
    }

    private void addCreationButtonsTo(JToolBar tb, DrawingEditor editor) {
        this.addDefaultCreationButtonsTo(tb, editor, ButtonFactory.createDrawingActions(editor), ButtonFactory.createSelectionActions(editor));
    }

    public void addDefaultCreationButtonsTo(JToolBar tb, DrawingEditor editor, Collection<Action> drawingActions, Collection<Action> selectionActions) {
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        ButtonFactory.addSelectionToolTo(tb, editor, drawingActions, selectionActions);
        tb.addSeparator();
        ButtonFactory.addToolTo(tb, editor, new CreationTool((Figure)new EntidadeFigure().init(), "createEntidade"), "createEntidade", labels);
        ButtonFactory.addToolTo(tb, editor, new CreationTool((Figure)new EntidadeFracaFigure().init(), "createEntidadeFraca"), "createEntidadeFraca", labels);
        tb.addSeparator();
        ButtonFactory.addToolTo(tb, editor, new CreationTool((Figure)new RelacionamentoFigure().init(), "createRelacionamento"), "createRelacionamento", labels);
        ButtonFactory.addToolTo(tb, editor, new CreationTool((Figure)new RelacionamentoFracoFigure().init(), "createRelacionamentoFraco"), "createRelacionamentoFraco", labels);
        ButtonFactory.addToolTo(tb, editor, new CreationTool((Figure)new EntidadeRelacionamentoFigure().init(), "createEntidadeRelacionamento"), "createEntidadeRelacionamento", labels);
        ButtonFactory.addToolTo(tb, editor, new CreationTool(new TextItalicoFigure(labels.getString("createPapel"))), "createPapel", labels);
        tb.addSeparator();
        ConnectionTool cnt = new ConnectionTool((ConnectionFigure)new LineConnectionFigure(), "createElbowConnectionAtributo");
        ButtonFactory.addToolTo(tb, editor, cnt, "createElbowConnectionAtributo", labels);
        ButtonFactory.addToolTo(tb, editor, new CreationTool((Figure)new AtributoFigure().init(), "createAtributo"), "createAtributo", labels);
        ButtonFactory.addToolTo(tb, editor, new CreationTool((Figure)new AtributoChaveFigure().init(), "createAtributoChave"), "createAtributoChave", labels);
        ButtonFactory.addToolTo(tb, editor, new CreationTool((Figure)new AtributoChaveParcialFigure().init(), "createAtributoChaveParcial"), "createAtributoChaveParcial", labels);
        ButtonFactory.addToolTo(tb, editor, new CreationTool((Figure)new AtributoDerivadoFigure().init(), "createAtributoDerivado"), "createAtributoDerivado", labels);
        ButtonFactory.addToolTo(tb, editor, new CreationTool((Figure)new AtributoMultivaloradoFigure().init(), "createAtributoMultivalorado"), "createAtributoMultivalorado", labels);
        tb.addSeparator();
        cnt = new ConnectionTool((ConnectionFigure)new LabeledLineConnectionUmFigure(), "createElbowUmConnection");
        ButtonFactory.addToolTo(tb, editor, cnt, "createElbowUmConnection", labels);
        cnt = new ConnectionTool((ConnectionFigure)new LabeledLineConnectionMuitosFigure(), "createElbowMuitosConnection");
        ButtonFactory.addToolTo(tb, editor, cnt, "createElbowMuitosConnection", labels);
        cnt = new ConnectionTool((ConnectionFigure)new LabeledDoubleLineConnectionUmFigure(), "createElbowDoubleUmConnection");
        ButtonFactory.addToolTo(tb, editor, cnt, "createElbowDoubleUmConnection", labels);
        cnt = new ConnectionTool((ConnectionFigure)new LabeledDoubleLineConnectionMuitosFigure(), "createElbowDoubleMuitosConnection");
        ButtonFactory.addToolTo(tb, editor, cnt, "createElbowDoubleMuitosConnection", labels);
        tb.addSeparator();
        ButtonFactory.addToolTo(tb, editor, new CreationTool((Figure)new DisjuncaoFigure().init(), "createDisjuncao"), "createDisjuncao", labels);
        ButtonFactory.addToolTo(tb, editor, new CreationTool((Figure)new SobreposicaoFigure().init(), "createSobreposicao"), "createSobreposicao", labels);
        ButtonFactory.addToolTo(tb, editor, new CreationTool((Figure)new UniaoFigure().init(), "createUniao"), "createUniao", labels);
        cnt = new ConnectionTool((ConnectionFigure)new GeneralizacaoLineConnectionFigure(), "createGeneralizacaoConnection");
        ButtonFactory.addToolTo(tb, editor, cnt, "createGeneralizacaoConnection", labels);
        cnt = new ConnectionTool((ConnectionFigure)new LineConnectionGeneralizacaoFigure(), "createElbowConnection");
        ButtonFactory.addToolTo(tb, editor, cnt, "createElbowConnection", labels);
        cnt = new ConnectionTool((ConnectionFigure)new DoubleLineConnectionGeneralizacaoFigure(), "createElbowDoubleConnection");
        ButtonFactory.addToolTo(tb, editor, cnt, "createElbowDoubleConnection", labels);
        tb.addSeparator();
        ButtonFactory.addToolTo(tb, editor, new TextTool(new TextFigure()), "createText", labels);
        ButtonFactory.addToolTo(tb, editor, new TextAreaTool(new TextAreaFigure()), "createTextArea", labels);
    }
}

