/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.ApplicationModel;
import org.jhotdraw.app.Project;
import org.jhotdraw.app.action.CopyAllToClipboard;
import org.jhotdraw.beans.AbstractBean;
import org.jhotdraw.util.ResourceBundleUtil;

public class DefaultApplicationModel
extends AbstractBean
implements ApplicationModel {
    private HashMap<String, Action> actions;
    private String name;
    private String version;
    private String copyright;
    private Class projectClass;
    private String projectClassName;

    public void setName(String newValue) {
        String oldValue = this.name;
        this.name = newValue;
        this.firePropertyChange("name", oldValue, newValue);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setVersion(String newValue) {
        String oldValue = this.version;
        this.version = newValue;
        this.firePropertyChange("version", oldValue, newValue);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setCopyright(String newValue) {
        String oldValue = this.copyright;
        this.copyright = newValue;
        this.firePropertyChange("copyright", oldValue, newValue);
    }

    @Override
    public String getCopyright() {
        return this.copyright;
    }

    public void setProjectClassName(String newValue) {
        String oldValue = this.projectClassName;
        this.projectClassName = newValue;
        this.firePropertyChange("projectClassName", oldValue, newValue);
    }

    public void setProjectClass(Class newValue) {
        Class oldValue = this.projectClass;
        this.projectClass = newValue;
        this.firePropertyChange("projectClass", oldValue, newValue);
    }

    public Class getProjectClass() {
        if (this.projectClass == null && this.projectClassName != null) {
            try {
                this.projectClass = Class.forName(this.projectClassName);
            }
            catch (Exception e) {
                InternalError error = new InternalError("unable to get project class");
                error.initCause(e);
                throw error;
            }
        }
        return this.projectClass;
    }

    @Override
    public Project createProject() {
        try {
            return (Project)this.getProjectClass().newInstance();
        }
        catch (Exception e) {
            InternalError error = new InternalError("unable to create project");
            error.initCause(e);
            throw error;
        }
    }

    @Override
    public List<JToolBar> createToolBars(Application app, Project p) {
        JButton b;
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.app.Labels");
        JToolBar tb = new JToolBar();
        tb.setName(labels.getString("standardToolBarTitle"));
        Action a = this.getAction("new");
        if (a != null) {
            b = tb.add(a);
            b.setFocusable(false);
        }
        if ((a = this.getAction("open")) != null) {
            b = tb.add(a);
            b.setFocusable(false);
        }
        if ((a = this.getAction("load")) != null) {
            b = tb.add(a);
            b.setFocusable(false);
        }
        b = tb.add(this.getAction("save"));
        tb.addSeparator();
        b = tb.add(this.getAction("undo"));
        b.setFocusable(false);
        b = tb.add(this.getAction("redo"));
        b.setFocusable(false);
        tb.addSeparator();
        b = tb.add(this.getAction("cut"));
        b.setFocusable(false);
        b = tb.add(this.getAction("copy"));
        b.setFocusable(false);
        b = tb.add(this.getAction("paste"));
        b.setFocusable(false);
        LinkedList<JToolBar> list = new LinkedList<JToolBar>();
        list.add(tb);
        return list;
    }

    @Override
    public List<JMenu> createMenus(Application a, Project p) {
        LinkedList<JMenu> list = new LinkedList<JMenu>();
        list.add(this.createEditMenu(a, p));
        return list;
    }

    protected JMenu createEditMenu(Application a, Project p) {
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.app.Labels");
        JMenu m = new JMenu();
        labels.configureMenu(m, "edit");
        JMenuItem mi = m.add(this.getAction("undo"));
        mi.setIcon(null);
        mi = m.add(this.getAction("redo"));
        mi.setIcon(null);
        m.addSeparator();
        mi = m.add(this.getAction("cut"));
        mi.setIcon(null);
        mi = m.add(this.getAction("copy"));
        mi.setIcon(null);
        mi = m.add(this.getAction("paste"));
        mi.setIcon(null);
        mi = m.add(this.getAction("duplicate"));
        mi.setIcon(null);
        mi = m.add(this.getAction("delete"));
        mi.setIcon(null);
        m.addSeparator();
        JCheckBoxMenuItem cb = new JCheckBoxMenuItem(this.getAction("validateModel"));
        mi = m.add(cb);
        mi.setIcon(null);
        m.addSeparator();
        mi = m.add(this.getAction("selectAll"));
        mi.setIcon(null);
        if (this.getAction("find") != null) {
            m.addSeparator();
            m.add(this.getAction("find"));
        }
        m.addSeparator();
        mi = m.add(new CopyAllToClipboard());
        mi.setIcon(null);
        return m;
    }

    @Override
    public void initProject(Application a, Project p) {
    }

    @Override
    public void initApplication(Application a) {
    }

    @Override
    public Action getAction(String id) {
        return this.actions == null ? null : this.actions.get(id);
    }

    @Override
    public void putAction(String id, Action action) {
        if (this.actions == null) {
            this.actions = new HashMap();
        }
        if (action == null) {
            this.actions.remove(id);
        } else {
            this.actions.put(id, action);
        }
    }
}

