/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Timer;
import org.jhotdraw.app.DefaultOSXApplication;
import org.jhotdraw.app.Project;

public class OSXPaletteHandler {
    private HashSet<Window> palettes = new HashSet();
    private HashMap<Window, Project> windows = new HashMap();
    private static OSXPaletteHandler instance;
    private Timer timer;
    private DefaultOSXApplication app;
    private WindowFocusListener focusHandler = new WindowFocusListener(){

        @Override
        public void windowGainedFocus(WindowEvent e) {
            OSXPaletteHandler.this.timer.stop();
            if (OSXPaletteHandler.this.windows.containsKey(e.getWindow())) {
                OSXPaletteHandler.this.app.setCurrentProject((Project)OSXPaletteHandler.this.windows.get(e.getWindow()));
                OSXPaletteHandler.this.showPalettes();
            }
        }

        @Override
        public void windowLostFocus(WindowEvent e) {
            OSXPaletteHandler.this.timer.restart();
        }
    };

    public OSXPaletteHandler(DefaultOSXApplication app) {
        this.app = app;
        this.timer = new Timer(60, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OSXPaletteHandler.this.maybeHidePalettes();
            }
        });
        this.timer.setRepeats(false);
    }

    public void add(Window window, Project project) {
        window.addWindowFocusListener(this.focusHandler);
        this.windows.put(window, project);
    }

    public void remove(Window window, Project project) {
        this.windows.remove(window);
        window.removeWindowFocusListener(this.focusHandler);
    }

    public void addPalette(Window palette) {
        palette.addWindowFocusListener(this.focusHandler);
        this.palettes.add(palette);
    }

    public void removePalette(Window palette) {
        this.palettes.remove(palette);
        palette.removeWindowFocusListener(this.focusHandler);
    }

    public Set<Window> getPalettes() {
        return Collections.unmodifiableSet(this.palettes);
    }

    private void showPalettes() {
        for (Window palette : this.palettes) {
            if (palette.isVisible()) continue;
            palette.setVisible(true);
        }
    }

    private boolean isFocused(Window w) {
        if (w.isFocused()) {
            return true;
        }
        Window[] ownedWindows = w.getOwnedWindows();
        int i = 0;
        while (i < ownedWindows.length) {
            if (this.isFocused(ownedWindows[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void maybeHidePalettes() {
        boolean hasFocus = false;
        for (Window window : this.windows.keySet()) {
            if (!this.isFocused(window)) continue;
            hasFocus = true;
            break;
        }
        if (!hasFocus && this.windows.size() > 0) {
            for (Window palette : this.palettes) {
                if (!this.isFocused(palette)) continue;
                hasFocus = true;
                break;
            }
        }
        if (!hasFocus) {
            for (Window palette : this.palettes) {
                palette.setVisible(false);
            }
        }
    }
}

