/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.action.AbstractProjectAction;
import org.jhotdraw.gui.JSheet;
import org.jhotdraw.gui.event.SheetEvent;
import org.jhotdraw.gui.event.SheetListener;
import org.jhotdraw.io.ExtensionFileFilter;
import org.jhotdraw.samples.draw.DrawProject;
import org.jhotdraw.util.ResourceBundleUtil;

public class ExportImageAction
extends AbstractProjectAction {
    public static final String ID = "exportImage";
    private Component oldFocusOwner;

    public ExportImageAction(Application app) {
        super(app);
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.app.Labels");
        labels.configureAction(this, ID);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final DrawProject project = (DrawProject)this.getCurrentProject();
        if (project.isEnabled()) {
            this.oldFocusOwner = SwingUtilities.getWindowAncestor(project.getComponent()).getFocusOwner();
            project.setEnabled(false);
            JFileChooser fileChooser = project.createSaveImageChooser();
            JSheet.showSaveSheet(fileChooser, project.getComponent(), new SheetListener(){

                @Override
                public void optionSelected(SheetEvent evt) {
                    if (evt.getOption() == 0) {
                        File file = evt.getFileChooser().getFileFilter() instanceof ExtensionFileFilter ? ((ExtensionFileFilter)evt.getFileChooser().getFileFilter()).makeAcceptable(evt.getFileChooser().getSelectedFile()) : evt.getFileChooser().getSelectedFile();
                        try {
                            project.writeImage(file);
                        }
                        catch (IOException iOException) {}
                    } else {
                        project.setEnabled(true);
                        if (ExportImageAction.this.oldFocusOwner != null) {
                            ExportImageAction.this.oldFocusOwner.requestFocus();
                        }
                    }
                }
            });
            project.setEnabled(true);
        }
    }
}

