/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import org.jhotdraw.app.Project;
import org.jhotdraw.util.ResourceBundleUtil;

public class FocusAction
extends AbstractAction {
    public static final String ID = "focus";
    private Project project;

    public FocusAction(Project project) {
        this.project = project;
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.app.Labels");
        labels.configureAction(this, ID);
        this.setEnabled(project != null);
        project.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.app.Labels");
                String name = evt.getPropertyName();
                if (name.equals("file")) {
                    FocusAction.this.putValue("Name", evt.getNewValue() == null ? labels.getString("unnamedFile") : ((File)evt.getNewValue()).getName());
                }
            }
        });
    }

    @Override
    public Object getValue(String key) {
        if (key == "Name" && this.project != null) {
            return this.getTitle();
        }
        return super.getValue(key);
    }

    private String getTitle() {
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.app.Labels");
        String title = labels.getString("unnamedFile");
        if (this.project != null) {
            File file = this.project.getFile();
            title = file == null ? labels.getString("unnamedFile") : file.getName();
            if (this.project.hasUnsavedChanges()) {
                title = String.valueOf(title) + "*";
            }
            title = labels.getFormatted("internalFrameTitle", title, this.project.getApplication().getName(), this.project.getMultipleOpenId());
        }
        return title;
    }

    private JFrame getFrame() {
        return (JFrame)SwingUtilities.getWindowAncestor(this.project.getComponent());
    }

    private Component getRootPaneContainer() {
        return SwingUtilities.getRootPane(this.project.getComponent()).getParent();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Component rpContainer = this.getRootPaneContainer();
        if (rpContainer instanceof Frame) {
            Frame frame = (Frame)rpContainer;
            frame.setExtendedState(frame.getExtendedState() & 0xFFFFFFFE);
            frame.toFront();
        } else if (rpContainer instanceof JInternalFrame) {
            JInternalFrame frame = (JInternalFrame)rpContainer;
            frame.toFront();
            try {
                frame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        this.project.getComponent().requestFocusInWindow();
    }
}

