/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.action.AbstractProjectAction;
import org.jhotdraw.app.action.CopyButtonHandler;
import org.jhotdraw.draw.AtributoChaveFigure;
import org.jhotdraw.draw.AtributoChaveParcialFigure;
import org.jhotdraw.draw.AtributoDerivadoFigure;
import org.jhotdraw.draw.AtributoFigure;
import org.jhotdraw.draw.AtributoMultivaloradoFigure;
import org.jhotdraw.draw.ConnectionAttribute;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.DisjuncaoFigure;
import org.jhotdraw.draw.DoubleLineConnectionGeneralizacaoFigure;
import org.jhotdraw.draw.EntidadeFigure;
import org.jhotdraw.draw.EntidadeFracaFigure;
import org.jhotdraw.draw.EntidadeRelacionamentoFigure;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.GeneralizacaoLineConnectionFigure;
import org.jhotdraw.draw.LabeledDoubleLineConnectionMuitosFigure;
import org.jhotdraw.draw.LabeledDoubleLineConnectionUmFigure;
import org.jhotdraw.draw.LabeledLineConnectionMuitosFigure;
import org.jhotdraw.draw.LabeledLineConnectionUmFigure;
import org.jhotdraw.draw.LineConnectionGeneralizacaoFigure;
import org.jhotdraw.draw.RelacionamentoFigure;
import org.jhotdraw.draw.RelacionamentoFracoFigure;
import org.jhotdraw.draw.SobreposicaoFigure;
import org.jhotdraw.samples.draw.DrawProject;
import org.jhotdraw.util.ResourceBundleUtil;

public class GenerateDDLAction
extends AbstractProjectAction {
    public static final String ID = "generateDDL";
    public static final String ID2 = "generatedDDL";
    public static final String ID3 = "copyAllToClipboard";
    private String ddlBuffer = "";

    public GenerateDDLAction(Application app) {
        super(app);
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.app.Labels");
        labels.configureAction(this, ID);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.app.Labels");
        ArrayList<Figure> strongEntity = new ArrayList<Figure>();
        ArrayList<Figure> weakEntity = new ArrayList<Figure>();
        ArrayList<Figure> connection = new ArrayList<Figure>();
        ArrayList<Figure> attribute = new ArrayList<Figure>();
        ArrayList<Figure> keyAttribute = new ArrayList<Figure>();
        ArrayList<Figure> partialKeyAttribute = new ArrayList<Figure>();
        ArrayList<Figure> derivedAttribute = new ArrayList<Figure>();
        ArrayList<Figure> multivaluedAttribute = new ArrayList<Figure>();
        ArrayList<Figure> relationship = new ArrayList<Figure>();
        ArrayList<Figure> weakRelationship = new ArrayList<Figure>();
        ArrayList<Figure> entityRelationship = new ArrayList<Figure>();
        ArrayList<Figure> genspecDisjoint = new ArrayList<Figure>();
        ArrayList<Figure> genspecOverlap = new ArrayList<Figure>();
        ArrayList<Figure> singleLineConnectionUm = new ArrayList<Figure>();
        ArrayList<Figure> singleLineConnectionN = new ArrayList<Figure>();
        ArrayList<Figure> doubleLineConnectionUm = new ArrayList<Figure>();
        ArrayList<Figure> doubleLineConnectionN = new ArrayList<Figure>();
        ArrayList<Figure> singleLineGenSpecConn = new ArrayList<Figure>();
        ArrayList<Figure> doubleLineGenSpecConn = new ArrayList<Figure>();
        ArrayList<Figure> genSpecLineConn = new ArrayList<Figure>();
        DrawProject project = (DrawProject)this.getCurrentProject();
        for (Figure f : project.getEditor().getActiveView().getDrawing().getFigures()) {
            if (f.getClass().equals(EntidadeFigure.class)) {
                strongEntity.add(f);
                continue;
            }
            if (f.getClass().equals(EntidadeFracaFigure.class)) {
                weakEntity.add(f);
                continue;
            }
            if (f.getClass().equals(ConnectionAttribute.class)) {
                connection.add(f);
                continue;
            }
            if (f.getClass().equals(LabeledLineConnectionUmFigure.class)) {
                singleLineConnectionUm.add(f);
                continue;
            }
            if (f.getClass().equals(LabeledLineConnectionMuitosFigure.class)) {
                singleLineConnectionN.add(f);
                continue;
            }
            if (f.getClass().equals(LabeledDoubleLineConnectionUmFigure.class)) {
                doubleLineConnectionUm.add(f);
                continue;
            }
            if (f.getClass().equals(LabeledDoubleLineConnectionMuitosFigure.class)) {
                doubleLineConnectionN.add(f);
                continue;
            }
            if (f.getClass().equals(AtributoFigure.class)) {
                attribute.add(f);
                continue;
            }
            if (f.getClass().equals(AtributoChaveFigure.class)) {
                keyAttribute.add(f);
                continue;
            }
            if (f.getClass().equals(AtributoChaveParcialFigure.class)) {
                partialKeyAttribute.add(f);
                continue;
            }
            if (f.getClass().equals(AtributoDerivadoFigure.class)) {
                derivedAttribute.add(f);
                continue;
            }
            if (f.getClass().equals(AtributoMultivaloradoFigure.class)) {
                multivaluedAttribute.add(f);
                continue;
            }
            if (f.getClass().equals(RelacionamentoFracoFigure.class)) {
                weakRelationship.add(f);
                continue;
            }
            if (f.getClass().equals(RelacionamentoFigure.class)) {
                relationship.add(f);
                continue;
            }
            if (f.getClass().equals(EntidadeRelacionamentoFigure.class)) {
                entityRelationship.add(f);
                continue;
            }
            if (f.getClass().equals(DisjuncaoFigure.class)) {
                genspecDisjoint.add(f);
                continue;
            }
            if (f.getClass().equals(SobreposicaoFigure.class)) {
                genspecOverlap.add(f);
                continue;
            }
            if (f.getClass().equals(LineConnectionGeneralizacaoFigure.class)) {
                singleLineGenSpecConn.add(f);
                continue;
            }
            if (f.getClass().equals(DoubleLineConnectionGeneralizacaoFigure.class)) {
                doubleLineGenSpecConn.add(f);
                continue;
            }
            if (!f.getClass().equals(GeneralizacaoLineConnectionFigure.class)) continue;
            genSpecLineConn.add(f);
        }
        this.ddlBuffer = "";
        this.generateTables(strongEntity, weakEntity, connection, attribute, keyAttribute, partialKeyAttribute);
        this.generatePrimaryKey(strongEntity, connection, keyAttribute);
        this.generatePartialKey(strongEntity, weakEntity, connection, singleLineConnectionUm, singleLineConnectionN, doubleLineConnectionUm, doubleLineConnectionN, keyAttribute, partialKeyAttribute, weakRelationship, genspecDisjoint, genspecOverlap, singleLineGenSpecConn, doubleLineGenSpecConn, genSpecLineConn);
        this.generateEntityRelationship(entityRelationship, connection, attribute, keyAttribute, derivedAttribute);
        this.generateGenSpec(strongEntity, connection, keyAttribute, genspecDisjoint, genspecOverlap, singleLineGenSpecConn, doubleLineGenSpecConn, genSpecLineConn);
        this.generateRelationships(strongEntity, connection, keyAttribute, singleLineConnectionUm, singleLineConnectionN, doubleLineConnectionUm, doubleLineConnectionN, relationship, entityRelationship);
        this.generateMultivaluedAttribute(strongEntity, weakEntity, weakRelationship, entityRelationship, connection, keyAttribute, partialKeyAttribute, multivaluedAttribute, singleLineConnectionUm, singleLineConnectionN, doubleLineConnectionUm, doubleLineConnectionN);
        this.generateDerivedAttribute(strongEntity, weakEntity, entityRelationship, connection, derivedAttribute);
        this.ddlBuffer = this.ddlBuffer.replaceAll(",\n\\);", "\n\\);\n");
        this.ddlBuffer = this.ddlBuffer.replaceAll("\\+ <", "<");
        this.ddlBuffer = this.ddlBuffer.replaceAll("\\+ !=", "!=");
        this.ddlBuffer = this.ddlBuffer.replaceAll("\\+  !=", "!=");
        JFrame frame = new JFrame(labels.getString(ID2));
        JPanel panel = new JPanel();
        JButton btn = new JButton(labels.getString(ID3));
        JTextArea ta = new JTextArea(this.ddlBuffer, 23, 43);
        ta.setEditable(false);
        frame.getContentPane().add((Component)panel, "Center");
        frame.getContentPane().add((Component)btn, "South");
        frame.setSize(600, 480);
        panel.add(new JScrollPane(ta));
        CopyButtonHandler handler = new CopyButtonHandler(btn, ta);
        btn.addActionListener(handler);
        frame.setVisible(true);
    }

    public void generateTables(ArrayList<Figure> strongEntity, ArrayList<Figure> weakEntity, ArrayList<Figure> connection, ArrayList<Figure> attribute, ArrayList<Figure> keyAttribute, ArrayList<Figure> partialKeyAttribute) {
        String mycontent = new String();
        for (Figure i : strongEntity) {
            mycontent = "CREATE TABLE " + i.toString().toUpperCase().replaceAll("\\s+", "_") + "(\n";
            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
            for (Figure j : connection) {
                if (((ConnectionFigure)j).getStartFigure().equals((EntidadeFigure)i)) {
                    for (Figure k : attribute) {
                        if (!((ConnectionFigure)j).getEndFigure().equals((AtributoFigure)k)) continue;
                        mycontent = String.valueOf(k.toString()) + " " + (!((AtributoFigure)k).isNullable() ? "NOT NULL" : "") + ",\n";
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                    }
                    for (Figure l : keyAttribute) {
                        if (!((ConnectionFigure)j).getEndFigure().equals((AtributoChaveFigure)l)) continue;
                        mycontent = String.valueOf(l.toString()) + " " + (Object)((Object)((AtributoChaveFigure)l).getAttributeType()) + " " + (!((AtributoChaveFigure)l).isNullable() ? "NOT NULL" : "") + ",\n";
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                    }
                    continue;
                }
                if (!((ConnectionFigure)j).getEndFigure().equals((EntidadeFigure)i)) continue;
                for (Figure k : attribute) {
                    if (!((ConnectionFigure)j).getStartFigure().equals((AtributoFigure)k)) continue;
                    mycontent = String.valueOf(k.toString()) + " " + (!((AtributoFigure)k).isNullable() ? "NOT NULL" : "") + ",\n";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                }
                for (Figure l : keyAttribute) {
                    if (!((ConnectionFigure)j).getStartFigure().equals((AtributoChaveFigure)l)) continue;
                    mycontent = String.valueOf(l.toString()) + " " + (Object)((Object)((AtributoChaveFigure)l).getAttributeType()) + " " + (!((AtributoChaveFigure)l).isNullable() ? "NOT NULL" : "") + ",\n";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                }
            }
            mycontent = ");\n";
            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
        }
        for (Figure a : weakEntity) {
            mycontent = "CREATE TABLE " + a.toString().toUpperCase().replaceAll("\\s+", "_") + "(\n";
            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
            for (Figure b : connection) {
                if (((ConnectionFigure)b).getStartFigure().equals((EntidadeFracaFigure)a)) {
                    for (Figure c : attribute) {
                        if (!((ConnectionFigure)b).getEndFigure().equals((AtributoFigure)c)) continue;
                        mycontent = String.valueOf(c.toString()) + " " + (!((AtributoFigure)c).isNullable() ? "NOT NULL" : "") + ",\n";
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                    }
                    for (Figure d : partialKeyAttribute) {
                        if (!((ConnectionFigure)b).getEndFigure().equals((AtributoChaveParcialFigure)d)) continue;
                        mycontent = String.valueOf(d.toString()) + " " + (Object)((Object)((AtributoChaveParcialFigure)d).getAttributeType()) + " " + (!((AtributoChaveParcialFigure)d).isNullable() ? "NOT NULL" : "") + ",\n";
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                    }
                    continue;
                }
                if (!((ConnectionFigure)b).getEndFigure().equals((EntidadeFracaFigure)a)) continue;
                for (Figure c : attribute) {
                    if (!((ConnectionFigure)b).getStartFigure().equals((AtributoFigure)c)) continue;
                    mycontent = String.valueOf(c.toString()) + " " + (!((AtributoFigure)c).isNullable() ? "NOT NULL" : "") + ",\n";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                }
                for (Figure d : partialKeyAttribute) {
                    if (!((ConnectionFigure)b).getStartFigure().equals((AtributoChaveParcialFigure)d)) continue;
                    mycontent = String.valueOf(d.toString()) + " " + (Object)((Object)((AtributoChaveParcialFigure)d).getAttributeType()) + " " + (!((AtributoChaveParcialFigure)d).isNullable() ? "NOT NULL" : "") + ",\n";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                }
            }
            mycontent = ");\n";
            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
        }
    }

    public void generatePrimaryKey(ArrayList<Figure> strongEntity, ArrayList<Figure> connection, ArrayList<Figure> keyAttribute) {
        String mycontent = new String();
        ArrayList<String> multipleKeyAtt = new ArrayList<String>();
        for (Figure i : strongEntity) {
            for (Figure j : connection) {
                if (((ConnectionFigure)j).getStartFigure().equals((EntidadeFigure)i)) {
                    for (Figure k : keyAttribute) {
                        if (!((ConnectionFigure)j).getEndFigure().equals((AtributoChaveFigure)k)) continue;
                        mycontent = "\nALTER TABLE " + i.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT PK_" + i.toString().toUpperCase().replaceAll("\\s+", "_") + " PRIMARY KEY (" + k.toString() + ");\n";
                        multipleKeyAtt.add(mycontent);
                    }
                    continue;
                }
                if (!((ConnectionFigure)j).getEndFigure().equals((EntidadeFigure)i)) continue;
                for (Figure k : keyAttribute) {
                    if (!((ConnectionFigure)j).getStartFigure().equals((AtributoChaveFigure)k)) continue;
                    mycontent = "\nALTER TABLE " + i.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT PK_" + i.toString().toUpperCase().replaceAll("\\s+", "_") + " PRIMARY KEY (" + k.toString() + ");\n";
                    multipleKeyAtt.add(mycontent);
                }
            }
            if (multipleKeyAtt.size() >= 2) {
                int num = 1;
                int l = 0;
                while (l < multipleKeyAtt.size()) {
                    String aux = String.format("%02d", num);
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + ((String)multipleKeyAtt.get(l)).replaceAll(" PRIMARY KEY", "_<" + aux + "> PRIMARY KEY");
                    ++num;
                    ++l;
                }
            } else if (!multipleKeyAtt.isEmpty() && multipleKeyAtt.size() < 2) {
                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                multipleKeyAtt.clear();
            }
            multipleKeyAtt.clear();
        }
    }

    public void generatePartialKey(ArrayList<Figure> strongEntity, ArrayList<Figure> weakEntity, ArrayList<Figure> connection, ArrayList<Figure> singleLineConnectionUm, ArrayList<Figure> singleLineConnectionN, ArrayList<Figure> doubleLineConnectionUm, ArrayList<Figure> doubleLineConnectionN, ArrayList<Figure> keyAttribute, ArrayList<Figure> partialKeyAttribute, ArrayList<Figure> weakRelationship, ArrayList<Figure> genspecDisjoint, ArrayList<Figure> genspecOverlap, ArrayList<Figure> singleLineGenSpecConn, ArrayList<Figure> doubleLineGenSpecConn, ArrayList<Figure> genSpecLineConn) {
        ArrayList<Figure> lineconnectors = new ArrayList<Figure>();
        lineconnectors.addAll(singleLineConnectionUm);
        lineconnectors.addAll(singleLineConnectionN);
        lineconnectors.addAll(doubleLineConnectionUm);
        lineconnectors.addAll(doubleLineConnectionN);
        ArrayList<Figure> genspecFigures = new ArrayList<Figure>();
        genspecFigures.addAll(genspecDisjoint);
        genspecFigures.addAll(genspecOverlap);
        ArrayList<Figure> genspecConnectors = new ArrayList<Figure>();
        genspecConnectors.addAll(singleLineGenSpecConn);
        genspecConnectors.addAll(doubleLineGenSpecConn);
        String mycontent = new String();
        String mycontent2 = new String();
        String mycontent3 = new String();
        String ownerEntity = new String();
        String keyAtt = new String();
        String keyAttType = new String();
        String keyAttNullable = new String();
        if (genspecFigures.isEmpty()) {
            this.partialKeyGenerator(strongEntity, weakEntity, connection, singleLineConnectionUm, singleLineConnectionN, doubleLineConnectionUm, doubleLineConnectionN, keyAttribute, partialKeyAttribute, weakRelationship);
        } else if (!genspecFigures.isEmpty()) {
            for (Figure f : weakRelationship) {
                for (Figure g : lineconnectors) {
                    if (((ConnectionFigure)g).getEndFigure().equals((RelacionamentoFracoFigure)f)) {
                        for (Figure h : strongEntity) {
                            if (((ConnectionFigure)g).getStartFigure().equals((EntidadeFigure)h)) {
                                for (Figure i : genSpecLineConn) {
                                    if (!((ConnectionFigure)i).getEndFigure().equals((EntidadeFigure)h)) continue;
                                    for (Figure j : genspecFigures) {
                                        if (!((ConnectionFigure)i).getStartFigure().equals(j)) continue;
                                        for (Figure k : genspecConnectors) {
                                            if (((ConnectionFigure)k).getStartFigure().equals(j)) {
                                                for (Figure l : strongEntity) {
                                                    if (!((ConnectionFigure)k).getEndFigure().equals(l)) continue;
                                                    for (Figure m : connection) {
                                                        if (((ConnectionFigure)m).getStartFigure().equals((EntidadeFigure)l)) {
                                                            for (Figure n : keyAttribute) {
                                                                if (!((ConnectionFigure)m).getEndFigure().equals((AtributoChaveFigure)n)) continue;
                                                                ownerEntity = l.toString().toUpperCase().replaceAll("\\s+", "_");
                                                                keyAtt = n.toString();
                                                                keyAttType = ((AtributoChaveFigure)n).getAttributeType().toString();
                                                                String string = keyAttNullable = !((AtributoChaveFigure)n).isNullable() ? "NOT NULL" : "";
                                                            }
                                                            continue;
                                                        }
                                                        if (!((ConnectionFigure)m).getEndFigure().equals((EntidadeFigure)l)) continue;
                                                        for (Figure n : keyAttribute) {
                                                            if (!((ConnectionFigure)m).getStartFigure().equals((AtributoChaveFigure)n)) continue;
                                                            ownerEntity = l.toString().toUpperCase().replaceAll("\\s+", "_");
                                                            keyAtt = n.toString();
                                                            keyAttType = ((AtributoChaveFigure)n).getAttributeType().toString();
                                                            String string = keyAttNullable = !((AtributoChaveFigure)n).isNullable() ? "NOT NULL" : "";
                                                        }
                                                    }
                                                }
                                                continue;
                                            }
                                            if (!((ConnectionFigure)k).getEndFigure().equals(j)) continue;
                                            for (Figure l : strongEntity) {
                                                if (!((ConnectionFigure)k).getStartFigure().equals(l)) continue;
                                                for (Figure m : connection) {
                                                    if (((ConnectionFigure)m).getStartFigure().equals((EntidadeFigure)l)) {
                                                        for (Figure n : keyAttribute) {
                                                            if (!((ConnectionFigure)m).getEndFigure().equals((AtributoChaveFigure)n)) continue;
                                                            ownerEntity = l.toString().toUpperCase().replaceAll("\\s+", "_");
                                                            keyAtt = n.toString();
                                                            keyAttType = ((AtributoChaveFigure)n).getAttributeType().toString();
                                                            String string = keyAttNullable = !((AtributoChaveFigure)n).isNullable() ? "NOT NULL" : "";
                                                        }
                                                        continue;
                                                    }
                                                    if (!((ConnectionFigure)m).getEndFigure().equals((EntidadeFigure)l)) continue;
                                                    for (Figure n : keyAttribute) {
                                                        if (!((ConnectionFigure)m).getStartFigure().equals((AtributoChaveFigure)n)) continue;
                                                        ownerEntity = l.toString().toUpperCase().replaceAll("\\s+", "_");
                                                        keyAtt = n.toString();
                                                        keyAttType = ((AtributoChaveFigure)n).getAttributeType().toString();
                                                        String string = keyAttNullable = !((AtributoChaveFigure)n).isNullable() ? "NOT NULL" : "";
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                for (Figure i : connection) {
                                    if (((ConnectionFigure)i).getStartFigure().equals((EntidadeFigure)h)) {
                                        for (Figure j : keyAttribute) {
                                            if (!((ConnectionFigure)i).getEndFigure().equals((AtributoChaveFigure)j)) continue;
                                            ownerEntity = h.toString().toUpperCase().replaceAll("\\s+", "_");
                                            keyAtt = j.toString();
                                            keyAttType = ((AtributoChaveFigure)j).getAttributeType().toString();
                                            String string = keyAttNullable = !((AtributoChaveFigure)j).isNullable() ? "NOT NULL" : "";
                                        }
                                        continue;
                                    }
                                    if (!((ConnectionFigure)i).getEndFigure().equals((EntidadeFigure)h)) continue;
                                    for (Figure j : keyAttribute) {
                                        if (!((ConnectionFigure)i).getStartFigure().equals((AtributoChaveFigure)j)) continue;
                                        ownerEntity = h.toString().toUpperCase().replaceAll("\\s+", "_");
                                        keyAtt = j.toString();
                                        keyAttType = ((AtributoChaveFigure)j).getAttributeType().toString();
                                        String string = keyAttNullable = !((AtributoChaveFigure)j).isNullable() ? "NOT NULL" : "";
                                    }
                                }
                                continue;
                            }
                            if (!((ConnectionFigure)g).getEndFigure().equals((EntidadeFigure)h)) continue;
                            for (Figure i : genSpecLineConn) {
                                if (!((ConnectionFigure)i).getEndFigure().equals((EntidadeFigure)h)) continue;
                                for (Figure j : genspecFigures) {
                                    if (!((ConnectionFigure)i).getStartFigure().equals(j)) continue;
                                    for (Figure k : genspecConnectors) {
                                        if (((ConnectionFigure)k).getStartFigure().equals(j)) {
                                            for (Figure l : strongEntity) {
                                                if (!((ConnectionFigure)k).getEndFigure().equals(l)) continue;
                                                for (Figure m : connection) {
                                                    if (((ConnectionFigure)m).getStartFigure().equals((EntidadeFigure)l)) {
                                                        for (Figure n : keyAttribute) {
                                                            if (!((ConnectionFigure)m).getEndFigure().equals((AtributoChaveFigure)n)) continue;
                                                            ownerEntity = l.toString().toUpperCase().replaceAll("\\s+", "_");
                                                            keyAtt = n.toString();
                                                            keyAttType = ((AtributoChaveFigure)n).getAttributeType().toString();
                                                            String string = keyAttNullable = !((AtributoChaveFigure)n).isNullable() ? "NOT NULL" : "";
                                                        }
                                                        continue;
                                                    }
                                                    if (!((ConnectionFigure)m).getEndFigure().equals((EntidadeFigure)l)) continue;
                                                    for (Figure n : keyAttribute) {
                                                        if (!((ConnectionFigure)m).getStartFigure().equals((AtributoChaveFigure)n)) continue;
                                                        ownerEntity = l.toString().toUpperCase().replaceAll("\\s+", "_");
                                                        keyAtt = n.toString();
                                                        keyAttType = ((AtributoChaveFigure)n).getAttributeType().toString();
                                                        String string = keyAttNullable = !((AtributoChaveFigure)n).isNullable() ? "NOT NULL" : "";
                                                    }
                                                }
                                            }
                                            continue;
                                        }
                                        if (!((ConnectionFigure)k).getEndFigure().equals(j)) continue;
                                        for (Figure l : strongEntity) {
                                            if (!((ConnectionFigure)k).getStartFigure().equals(l)) continue;
                                            for (Figure m : connection) {
                                                if (((ConnectionFigure)m).getStartFigure().equals((EntidadeFigure)l)) {
                                                    for (Figure n : keyAttribute) {
                                                        if (!((ConnectionFigure)m).getEndFigure().equals((AtributoChaveFigure)n)) continue;
                                                        ownerEntity = l.toString().toUpperCase().replaceAll("\\s+", "_");
                                                        keyAtt = n.toString();
                                                        keyAttType = ((AtributoChaveFigure)n).getAttributeType().toString();
                                                        String string = keyAttNullable = !((AtributoChaveFigure)n).isNullable() ? "NOT NULL" : "";
                                                    }
                                                    continue;
                                                }
                                                if (!((ConnectionFigure)m).getEndFigure().equals((EntidadeFigure)l)) continue;
                                                for (Figure n : keyAttribute) {
                                                    if (!((ConnectionFigure)m).getStartFigure().equals((AtributoChaveFigure)n)) continue;
                                                    ownerEntity = l.toString().toUpperCase().replaceAll("\\s+", "_");
                                                    keyAtt = n.toString();
                                                    keyAttType = ((AtributoChaveFigure)n).getAttributeType().toString();
                                                    String string = keyAttNullable = !((AtributoChaveFigure)n).isNullable() ? "NOT NULL" : "";
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            for (Figure i : connection) {
                                if (((ConnectionFigure)i).getStartFigure().equals((EntidadeFigure)h)) {
                                    for (Figure j : keyAttribute) {
                                        if (!((ConnectionFigure)i).getEndFigure().equals((AtributoChaveFigure)j)) continue;
                                        ownerEntity = h.toString().toUpperCase().replaceAll("\\s+", "_");
                                        keyAtt = j.toString();
                                        keyAttType = ((AtributoChaveFigure)j).getAttributeType().toString();
                                        String string = keyAttNullable = !((AtributoChaveFigure)j).isNullable() ? "NOT NULL" : "";
                                    }
                                    continue;
                                }
                                if (!((ConnectionFigure)i).getEndFigure().equals((EntidadeFigure)h)) continue;
                                for (Figure j : keyAttribute) {
                                    if (!((ConnectionFigure)i).getStartFigure().equals((AtributoChaveFigure)j)) continue;
                                    ownerEntity = h.toString().toUpperCase().replaceAll("\\s+", "_");
                                    keyAtt = j.toString();
                                    keyAttType = ((AtributoChaveFigure)j).getAttributeType().toString();
                                    String string = keyAttNullable = !((AtributoChaveFigure)j).isNullable() ? "NOT NULL" : "";
                                }
                            }
                        }
                        for (Figure h : weakEntity) {
                            if (((ConnectionFigure)g).getStartFigure().equals((EntidadeFracaFigure)h)) {
                                for (Figure i : connection) {
                                    if (((ConnectionFigure)i).getStartFigure().equals((EntidadeFracaFigure)h)) {
                                        for (Figure j : partialKeyAttribute) {
                                            if (!((ConnectionFigure)i).getEndFigure().equals((AtributoChaveParcialFigure)j)) continue;
                                            mycontent = "\nALTER TABLE " + h.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD " + keyAtt + "_" + ownerEntity.toLowerCase() + " " + keyAttType + " " + keyAttNullable + ";\n";
                                            mycontent2 = "ALTER TABLE " + h.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + h.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + keyAtt + "_" + ownerEntity.toLowerCase() + ") REFERENCES " + ownerEntity + " (" + keyAtt + ");\n";
                                            mycontent3 = "ALTER TABLE " + h.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT PK_" + h.toString().toUpperCase().replaceAll("\\s+", "_") + " PRIMARY KEY (" + j.toString() + ", " + keyAtt + "_" + ownerEntity.toLowerCase() + ");\n";
                                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                                        }
                                        continue;
                                    }
                                    if (!((ConnectionFigure)i).getEndFigure().equals((EntidadeFracaFigure)h)) continue;
                                    for (Figure j : partialKeyAttribute) {
                                        if (!((ConnectionFigure)i).getStartFigure().equals((AtributoChaveParcialFigure)j)) continue;
                                        mycontent = "\nALTER TABLE " + h.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD " + keyAtt + "_" + ownerEntity.toLowerCase() + " " + keyAttType + " " + keyAttNullable + ";\n";
                                        mycontent2 = "ALTER TABLE " + h.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + h.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + keyAtt + "_" + ownerEntity.toLowerCase() + ") REFERENCES " + ownerEntity + " (" + keyAtt + ");\n";
                                        mycontent3 = "ALTER TABLE " + h.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT PK_" + h.toString().toUpperCase().replaceAll("\\s+", "_") + " PRIMARY KEY (" + j.toString() + ", " + keyAtt + "_" + ownerEntity.toLowerCase() + ");\n";
                                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                                    }
                                }
                                continue;
                            }
                            if (!((ConnectionFigure)g).getEndFigure().equals((EntidadeFracaFigure)h)) continue;
                            for (Figure i : connection) {
                                if (((ConnectionFigure)i).getStartFigure().equals((EntidadeFracaFigure)h)) {
                                    for (Figure j : partialKeyAttribute) {
                                        if (!((ConnectionFigure)i).getEndFigure().equals((AtributoChaveParcialFigure)j)) continue;
                                        mycontent = "\nALTER TABLE " + h.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD " + keyAtt + "_" + ownerEntity.toLowerCase() + " " + keyAttType + " " + keyAttNullable + ";\n";
                                        mycontent2 = "ALTER TABLE " + h.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + h.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + keyAtt + "_" + ownerEntity.toLowerCase() + ") REFERENCES " + ownerEntity + " (" + keyAtt + ");\n";
                                        mycontent3 = "ALTER TABLE " + h.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT PK_" + h.toString().toUpperCase().replaceAll("\\s+", "_") + " PRIMARY KEY (" + j.toString() + ", " + keyAtt + "_" + ownerEntity.toLowerCase() + ");\n";
                                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                                    }
                                    continue;
                                }
                                if (!((ConnectionFigure)i).getEndFigure().equals((EntidadeFracaFigure)h)) continue;
                                for (Figure j : partialKeyAttribute) {
                                    if (!((ConnectionFigure)i).getStartFigure().equals((AtributoChaveParcialFigure)j)) continue;
                                    mycontent = "\nALTER TABLE " + h.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD " + keyAtt + "_" + ownerEntity.toLowerCase() + " " + keyAttType + " " + keyAttNullable + ";\n";
                                    mycontent2 = "ALTER TABLE " + h.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + h.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + keyAtt + "_" + ownerEntity.toLowerCase() + ") REFERENCES " + ownerEntity + " (" + keyAtt + ");\n";
                                    mycontent3 = "ALTER TABLE " + h.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT PK_" + h.toString().toUpperCase().replaceAll("\\s+", "_") + " PRIMARY KEY (" + j.toString() + ", " + keyAtt + "_" + ownerEntity.toLowerCase() + ");\n";
                                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                                }
                            }
                        }
                        continue;
                    }
                    if (!((ConnectionFigure)g).getStartFigure().equals((RelacionamentoFracoFigure)f)) continue;
                    for (Figure h : strongEntity) {
                        if (((ConnectionFigure)g).getStartFigure().equals((EntidadeFigure)h)) {
                            for (Figure i : genSpecLineConn) {
                                if (!((ConnectionFigure)i).getEndFigure().equals((EntidadeFigure)h)) continue;
                                for (Figure j : genspecFigures) {
                                    if (!((ConnectionFigure)i).getStartFigure().equals(j)) continue;
                                    for (Figure k : genspecConnectors) {
                                        if (((ConnectionFigure)k).getStartFigure().equals(j)) {
                                            for (Figure l : strongEntity) {
                                                if (!((ConnectionFigure)k).getEndFigure().equals(l)) continue;
                                                for (Figure m : connection) {
                                                    if (((ConnectionFigure)m).getStartFigure().equals((EntidadeFigure)l)) {
                                                        for (Figure n : keyAttribute) {
                                                            if (!((ConnectionFigure)m).getEndFigure().equals((AtributoChaveFigure)n)) continue;
                                                            ownerEntity = l.toString().toUpperCase().replaceAll("\\s+", "_");
                                                            keyAtt = n.toString();
                                                            keyAttType = ((AtributoChaveFigure)n).getAttributeType().toString();
                                                            String string = keyAttNullable = !((AtributoChaveFigure)n).isNullable() ? "NOT NULL" : "";
                                                        }
                                                        continue;
                                                    }
                                                    if (!((ConnectionFigure)m).getEndFigure().equals((EntidadeFigure)l)) continue;
                                                    for (Figure n : keyAttribute) {
                                                        if (!((ConnectionFigure)m).getStartFigure().equals((AtributoChaveFigure)n)) continue;
                                                        ownerEntity = l.toString().toUpperCase().replaceAll("\\s+", "_");
                                                        keyAtt = n.toString();
                                                        keyAttType = ((AtributoChaveFigure)n).getAttributeType().toString();
                                                        String string = keyAttNullable = !((AtributoChaveFigure)n).isNullable() ? "NOT NULL" : "";
                                                    }
                                                }
                                            }
                                            continue;
                                        }
                                        if (!((ConnectionFigure)k).getEndFigure().equals(j)) continue;
                                        for (Figure l : strongEntity) {
                                            if (!((ConnectionFigure)k).getStartFigure().equals(l)) continue;
                                            for (Figure m : connection) {
                                                if (((ConnectionFigure)m).getStartFigure().equals((EntidadeFigure)l)) {
                                                    for (Figure n : keyAttribute) {
                                                        if (!((ConnectionFigure)m).getEndFigure().equals((AtributoChaveFigure)n)) continue;
                                                        ownerEntity = l.toString().toUpperCase().replaceAll("\\s+", "_");
                                                        keyAtt = n.toString();
                                                        keyAttType = ((AtributoChaveFigure)n).getAttributeType().toString();
                                                        String string = keyAttNullable = !((AtributoChaveFigure)n).isNullable() ? "NOT NULL" : "";
                                                    }
                                                    continue;
                                                }
                                                if (!((ConnectionFigure)m).getEndFigure().equals((EntidadeFigure)l)) continue;
                                                for (Figure n : keyAttribute) {
                                                    if (!((ConnectionFigure)m).getStartFigure().equals((AtributoChaveFigure)n)) continue;
                                                    ownerEntity = l.toString().toUpperCase().replaceAll("\\s+", "_");
                                                    keyAtt = n.toString();
                                                    keyAttType = ((AtributoChaveFigure)n).getAttributeType().toString();
                                                    String string = keyAttNullable = !((AtributoChaveFigure)n).isNullable() ? "NOT NULL" : "";
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            for (Figure i : connection) {
                                if (((ConnectionFigure)i).getStartFigure().equals((EntidadeFigure)h)) {
                                    for (Figure j : keyAttribute) {
                                        if (!((ConnectionFigure)i).getEndFigure().equals((AtributoChaveFigure)j)) continue;
                                        ownerEntity = h.toString().toUpperCase().replaceAll("\\s+", "_");
                                        keyAtt = j.toString();
                                        keyAttType = ((AtributoChaveFigure)j).getAttributeType().toString();
                                        String string = keyAttNullable = !((AtributoChaveFigure)j).isNullable() ? "NOT NULL" : "";
                                    }
                                    continue;
                                }
                                if (!((ConnectionFigure)i).getEndFigure().equals((EntidadeFigure)h)) continue;
                                for (Figure j : keyAttribute) {
                                    if (!((ConnectionFigure)i).getStartFigure().equals((AtributoChaveFigure)j)) continue;
                                    ownerEntity = h.toString().toUpperCase().replaceAll("\\s+", "_");
                                    keyAtt = j.toString();
                                    keyAttType = ((AtributoChaveFigure)j).getAttributeType().toString();
                                    String string = keyAttNullable = !((AtributoChaveFigure)j).isNullable() ? "NOT NULL" : "";
                                }
                            }
                            continue;
                        }
                        if (!((ConnectionFigure)g).getEndFigure().equals((EntidadeFigure)h)) continue;
                        for (Figure i : genSpecLineConn) {
                            if (!((ConnectionFigure)i).getEndFigure().equals((EntidadeFigure)h)) continue;
                            for (Figure j : genspecFigures) {
                                if (!((ConnectionFigure)i).getStartFigure().equals(j)) continue;
                                for (Figure k : genspecConnectors) {
                                    if (((ConnectionFigure)k).getStartFigure().equals(j)) {
                                        for (Figure l : strongEntity) {
                                            if (!((ConnectionFigure)k).getEndFigure().equals(l)) continue;
                                            for (Figure m : connection) {
                                                if (((ConnectionFigure)m).getStartFigure().equals((EntidadeFigure)l)) {
                                                    for (Figure n : keyAttribute) {
                                                        if (!((ConnectionFigure)m).getEndFigure().equals((AtributoChaveFigure)n)) continue;
                                                        ownerEntity = l.toString().toUpperCase().replaceAll("\\s+", "_");
                                                        keyAtt = n.toString();
                                                        keyAttType = ((AtributoChaveFigure)n).getAttributeType().toString();
                                                        String string = keyAttNullable = !((AtributoChaveFigure)n).isNullable() ? "NOT NULL" : "";
                                                    }
                                                    continue;
                                                }
                                                if (!((ConnectionFigure)m).getEndFigure().equals((EntidadeFigure)l)) continue;
                                                for (Figure n : keyAttribute) {
                                                    if (!((ConnectionFigure)m).getStartFigure().equals((AtributoChaveFigure)n)) continue;
                                                    ownerEntity = l.toString().toUpperCase().replaceAll("\\s+", "_");
                                                    keyAtt = n.toString();
                                                    keyAttType = ((AtributoChaveFigure)n).getAttributeType().toString();
                                                    String string = keyAttNullable = !((AtributoChaveFigure)n).isNullable() ? "NOT NULL" : "";
                                                }
                                            }
                                        }
                                        continue;
                                    }
                                    if (!((ConnectionFigure)k).getEndFigure().equals(j)) continue;
                                    for (Figure l : strongEntity) {
                                        if (!((ConnectionFigure)k).getStartFigure().equals(l)) continue;
                                        for (Figure m : connection) {
                                            if (((ConnectionFigure)m).getStartFigure().equals((EntidadeFigure)l)) {
                                                for (Figure n : keyAttribute) {
                                                    if (!((ConnectionFigure)m).getEndFigure().equals((AtributoChaveFigure)n)) continue;
                                                    ownerEntity = l.toString().toUpperCase().replaceAll("\\s+", "_");
                                                    keyAtt = n.toString();
                                                    keyAttType = ((AtributoChaveFigure)n).getAttributeType().toString();
                                                    String string = keyAttNullable = !((AtributoChaveFigure)n).isNullable() ? "NOT NULL" : "";
                                                }
                                                continue;
                                            }
                                            if (!((ConnectionFigure)m).getEndFigure().equals((EntidadeFigure)l)) continue;
                                            for (Figure n : keyAttribute) {
                                                if (!((ConnectionFigure)m).getStartFigure().equals((AtributoChaveFigure)n)) continue;
                                                ownerEntity = l.toString().toUpperCase().replaceAll("\\s+", "_");
                                                keyAtt = n.toString();
                                                keyAttType = ((AtributoChaveFigure)n).getAttributeType().toString();
                                                String string = keyAttNullable = !((AtributoChaveFigure)n).isNullable() ? "NOT NULL" : "";
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        for (Figure i : connection) {
                            if (((ConnectionFigure)i).getStartFigure().equals((EntidadeFigure)h)) {
                                for (Figure j : keyAttribute) {
                                    if (!((ConnectionFigure)i).getEndFigure().equals((AtributoChaveFigure)j)) continue;
                                    ownerEntity = h.toString().toUpperCase().replaceAll("\\s+", "_");
                                    keyAtt = j.toString();
                                    keyAttType = ((AtributoChaveFigure)j).getAttributeType().toString();
                                    String string = keyAttNullable = !((AtributoChaveFigure)j).isNullable() ? "NOT NULL" : "";
                                }
                                continue;
                            }
                            if (!((ConnectionFigure)i).getEndFigure().equals((EntidadeFigure)h)) continue;
                            for (Figure j : keyAttribute) {
                                if (!((ConnectionFigure)i).getStartFigure().equals((AtributoChaveFigure)j)) continue;
                                ownerEntity = h.toString().toUpperCase().replaceAll("\\s+", "_");
                                keyAtt = j.toString();
                                keyAttType = ((AtributoChaveFigure)j).getAttributeType().toString();
                                String string = keyAttNullable = !((AtributoChaveFigure)j).isNullable() ? "NOT NULL" : "";
                            }
                        }
                    }
                    for (Figure h : weakEntity) {
                        if (((ConnectionFigure)g).getStartFigure().equals((EntidadeFracaFigure)h)) {
                            for (Figure i : connection) {
                                if (((ConnectionFigure)i).getStartFigure().equals((EntidadeFracaFigure)h)) {
                                    for (Figure j : partialKeyAttribute) {
                                        if (!((ConnectionFigure)i).getEndFigure().equals((AtributoChaveParcialFigure)j)) continue;
                                        mycontent = "\nALTER TABLE " + h.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD " + keyAtt + "_" + ownerEntity.toLowerCase() + " " + keyAttType + " " + keyAttNullable + ";\n";
                                        mycontent2 = "ALTER TABLE " + h.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + h.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + keyAtt + "_" + ownerEntity.toLowerCase() + ") REFERENCES " + ownerEntity + " (" + keyAtt + ");\n";
                                        mycontent3 = "ALTER TABLE " + h.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT PK_" + h.toString().toUpperCase().replaceAll("\\s+", "_") + " PRIMARY KEY (" + j.toString() + ", " + keyAtt + "_" + ownerEntity.toLowerCase() + ");\n";
                                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                                    }
                                    continue;
                                }
                                if (!((ConnectionFigure)i).getEndFigure().equals((EntidadeFracaFigure)h)) continue;
                                for (Figure j : partialKeyAttribute) {
                                    if (!((ConnectionFigure)i).getStartFigure().equals((AtributoChaveParcialFigure)j)) continue;
                                    mycontent = "\nALTER TABLE " + h.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD " + keyAtt + "_" + ownerEntity.toLowerCase() + " " + keyAttType + " " + keyAttNullable + ";\n";
                                    mycontent2 = "ALTER TABLE " + h.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + h.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + keyAtt + "_" + ownerEntity.toLowerCase() + ") REFERENCES " + ownerEntity + " (" + keyAtt + ");\n";
                                    mycontent3 = "ALTER TABLE " + h.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT PK_" + h.toString().toUpperCase().replaceAll("\\s+", "_") + " PRIMARY KEY (" + j.toString() + ", " + keyAtt + "_" + ownerEntity.toLowerCase() + ");\n";
                                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                                }
                            }
                            continue;
                        }
                        if (!((ConnectionFigure)g).getEndFigure().equals((EntidadeFracaFigure)h)) continue;
                        for (Figure i : connection) {
                            if (((ConnectionFigure)i).getStartFigure().equals((EntidadeFracaFigure)h)) {
                                for (Figure j : partialKeyAttribute) {
                                    if (!((ConnectionFigure)i).getEndFigure().equals((AtributoChaveParcialFigure)j)) continue;
                                    mycontent = "\nALTER TABLE " + h.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD " + keyAtt + "_" + ownerEntity.toLowerCase() + " " + keyAttType + " " + keyAttNullable + ";\n";
                                    mycontent2 = "ALTER TABLE " + h.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + h.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + keyAtt + "_" + ownerEntity.toLowerCase() + ") REFERENCES " + ownerEntity + " (" + keyAtt + ");\n";
                                    mycontent3 = "ALTER TABLE " + h.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT PK_" + h.toString().toUpperCase().replaceAll("\\s+", "_") + " PRIMARY KEY (" + j.toString() + ", " + keyAtt + "_" + ownerEntity.toLowerCase() + ");\n";
                                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                                }
                                continue;
                            }
                            if (!((ConnectionFigure)i).getEndFigure().equals((EntidadeFracaFigure)h)) continue;
                            for (Figure j : partialKeyAttribute) {
                                if (!((ConnectionFigure)i).getStartFigure().equals((AtributoChaveParcialFigure)j)) continue;
                                mycontent = "\nALTER TABLE " + h.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD " + keyAtt + "_" + ownerEntity.toLowerCase() + " " + keyAttType + " " + keyAttNullable + ";\n";
                                mycontent2 = "ALTER TABLE " + h.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + h.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + keyAtt + "_" + ownerEntity.toLowerCase() + ") REFERENCES " + ownerEntity + " (" + keyAtt + ");\n";
                                mycontent3 = "ALTER TABLE " + h.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT PK_" + h.toString().toUpperCase().replaceAll("\\s+", "_") + " PRIMARY KEY (" + j.toString() + ", " + keyAtt + "_" + ownerEntity.toLowerCase() + ");\n";
                                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                            }
                        }
                    }
                }
            }
        }
    }

    public void partialKeyGenerator(ArrayList<Figure> strongEntity, ArrayList<Figure> weakEntity, ArrayList<Figure> connection, ArrayList<Figure> singleLineConnectionUm, ArrayList<Figure> singleLineConnectionN, ArrayList<Figure> doubleLineConnectionUm, ArrayList<Figure> doubleLineConnectionN, ArrayList<Figure> keyAttribute, ArrayList<Figure> partialKeyAttribute, ArrayList<Figure> weakRelationship) {
        ArrayList<Figure> lineconnectors = new ArrayList<Figure>();
        lineconnectors.addAll(singleLineConnectionUm);
        lineconnectors.addAll(singleLineConnectionN);
        lineconnectors.addAll(doubleLineConnectionUm);
        lineconnectors.addAll(doubleLineConnectionN);
        String mycontent = new String();
        String mycontent2 = new String();
        String mycontent3 = new String();
        String ownerEntity = new String();
        String keyAtt = new String();
        String keyAttType = new String();
        String keyAttNullable = new String();
        for (Figure a : weakRelationship) {
            for (Figure b : lineconnectors) {
                if (((ConnectionFigure)b).getEndFigure().equals((RelacionamentoFracoFigure)a)) {
                    for (Figure c : strongEntity) {
                        if (((ConnectionFigure)b).getStartFigure().equals((EntidadeFigure)c)) {
                            for (Figure d : connection) {
                                if (((ConnectionFigure)d).getStartFigure().equals((EntidadeFigure)c)) {
                                    for (Figure e : keyAttribute) {
                                        if (!((ConnectionFigure)d).getEndFigure().equals((AtributoChaveFigure)e)) continue;
                                        ownerEntity = c.toString().toUpperCase().replaceAll("\\s+", "_");
                                        keyAtt = e.toString();
                                        keyAttType = ((AtributoChaveFigure)e).getAttributeType().toString();
                                        String string = keyAttNullable = !((AtributoChaveFigure)e).isNullable() ? "NOT NULL" : "";
                                    }
                                    continue;
                                }
                                if (!((ConnectionFigure)d).getEndFigure().equals((EntidadeFigure)c)) continue;
                                for (Figure e : keyAttribute) {
                                    if (!((ConnectionFigure)d).getStartFigure().equals((AtributoChaveFigure)e)) continue;
                                    ownerEntity = c.toString().toUpperCase().replaceAll("\\s+", "_");
                                    keyAtt = e.toString();
                                    keyAttType = ((AtributoChaveFigure)e).getAttributeType().toString();
                                    String string = keyAttNullable = !((AtributoChaveFigure)e).isNullable() ? "NOT NULL" : "";
                                }
                            }
                            continue;
                        }
                        if (!((ConnectionFigure)b).getEndFigure().equals((EntidadeFigure)c)) continue;
                        for (Figure d : connection) {
                            if (((ConnectionFigure)d).getStartFigure().equals((EntidadeFigure)c)) {
                                for (Figure e : keyAttribute) {
                                    if (!((ConnectionFigure)d).getEndFigure().equals((AtributoChaveFigure)e)) continue;
                                    ownerEntity = c.toString().toUpperCase().replaceAll("\\s+", "_");
                                    keyAtt = e.toString();
                                    keyAttType = ((AtributoChaveFigure)e).getAttributeType().toString();
                                    String string = keyAttNullable = !((AtributoChaveFigure)e).isNullable() ? "NOT NULL" : "";
                                }
                                continue;
                            }
                            if (!((ConnectionFigure)d).getEndFigure().equals((EntidadeFigure)c)) continue;
                            for (Figure e : keyAttribute) {
                                if (!((ConnectionFigure)d).getStartFigure().equals((AtributoChaveFigure)e)) continue;
                                ownerEntity = c.toString().toUpperCase().replaceAll("\\s+", "_");
                                keyAtt = e.toString();
                                keyAttType = ((AtributoChaveFigure)e).getAttributeType().toString();
                                String string = keyAttNullable = !((AtributoChaveFigure)e).isNullable() ? "NOT NULL" : "";
                            }
                        }
                    }
                    for (Figure f : weakEntity) {
                        if (((ConnectionFigure)b).getStartFigure().equals((EntidadeFracaFigure)f)) {
                            for (Figure g : connection) {
                                if (((ConnectionFigure)g).getStartFigure().equals((EntidadeFracaFigure)f)) {
                                    for (Figure h : partialKeyAttribute) {
                                        if (!((ConnectionFigure)g).getEndFigure().equals((AtributoChaveParcialFigure)h)) continue;
                                        mycontent = "\nALTER TABLE " + f.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD " + keyAtt + "_" + ownerEntity.toLowerCase() + " " + keyAttType + " " + keyAttNullable + ";\n";
                                        mycontent2 = "ALTER TABLE " + f.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + f.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + keyAtt + "_" + ownerEntity.toLowerCase() + ") REFERENCES " + ownerEntity + " (" + keyAtt + ");\n";
                                        mycontent3 = "ALTER TABLE " + f.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT PK_" + f.toString().toUpperCase().replaceAll("\\s+", "_") + " PRIMARY KEY (" + h.toString() + ", " + keyAtt + "_" + ownerEntity.toLowerCase() + ");\n";
                                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                                    }
                                    continue;
                                }
                                if (!((ConnectionFigure)g).getEndFigure().equals((EntidadeFracaFigure)f)) continue;
                                for (Figure h : partialKeyAttribute) {
                                    if (!((ConnectionFigure)g).getStartFigure().equals((AtributoChaveParcialFigure)h)) continue;
                                    mycontent = "\nALTER TABLE " + f.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD " + keyAtt + "_" + ownerEntity.toLowerCase() + " " + keyAttType + " " + keyAttNullable + ";\n";
                                    mycontent2 = "ALTER TABLE " + f.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + f.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + keyAtt + "_" + ownerEntity.toLowerCase() + ") REFERENCES " + ownerEntity + " (" + keyAtt + ");\n";
                                    mycontent3 = "ALTER TABLE " + f.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT PK_" + f.toString().toUpperCase().replaceAll("\\s+", "_") + " PRIMARY KEY (" + h.toString() + ", " + keyAtt + "_" + ownerEntity.toLowerCase() + ");\n";
                                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                                }
                            }
                            continue;
                        }
                        if (!((ConnectionFigure)b).getEndFigure().equals((EntidadeFracaFigure)f)) continue;
                        for (Figure g : connection) {
                            if (((ConnectionFigure)g).getStartFigure().equals((EntidadeFracaFigure)f)) {
                                for (Figure h : partialKeyAttribute) {
                                    if (!((ConnectionFigure)g).getEndFigure().equals((AtributoChaveParcialFigure)h)) continue;
                                    mycontent = "\nALTER TABLE " + f.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD " + keyAtt + "_" + ownerEntity.toLowerCase() + " " + keyAttType + " " + keyAttNullable + ";\n";
                                    mycontent2 = "ALTER TABLE " + f.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + f.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + keyAtt + "_" + ownerEntity.toLowerCase() + ") REFERENCES " + ownerEntity + " (" + keyAtt + ");\n";
                                    mycontent3 = "ALTER TABLE " + f.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT PK_" + f.toString().toUpperCase().replaceAll("\\s+", "_") + " PRIMARY KEY (" + h.toString() + ", " + keyAtt + "_" + ownerEntity.toLowerCase() + ");\n";
                                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                                }
                                continue;
                            }
                            if (!((ConnectionFigure)g).getEndFigure().equals((EntidadeFracaFigure)f)) continue;
                            for (Figure h : partialKeyAttribute) {
                                if (!((ConnectionFigure)g).getStartFigure().equals((AtributoChaveParcialFigure)h)) continue;
                                mycontent = "\nALTER TABLE " + f.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD " + keyAtt + "_" + ownerEntity.toLowerCase() + " " + keyAttType + " " + keyAttNullable + ";\n";
                                mycontent2 = "ALTER TABLE " + f.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + f.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + keyAtt + "_" + ownerEntity.toLowerCase() + ") REFERENCES " + ownerEntity + " (" + keyAtt + ");\n";
                                mycontent3 = "ALTER TABLE " + f.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT PK_" + f.toString().toUpperCase().replaceAll("\\s+", "_") + " PRIMARY KEY (" + h.toString() + ", " + keyAtt + "_" + ownerEntity.toLowerCase() + ");\n";
                                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                            }
                        }
                    }
                    continue;
                }
                if (!((ConnectionFigure)b).getStartFigure().equals((RelacionamentoFracoFigure)a)) continue;
                for (Figure c : strongEntity) {
                    if (((ConnectionFigure)b).getStartFigure().equals((EntidadeFigure)c)) {
                        for (Figure d : connection) {
                            if (((ConnectionFigure)d).getStartFigure().equals((EntidadeFigure)c)) {
                                for (Figure e : keyAttribute) {
                                    if (!((ConnectionFigure)d).getEndFigure().equals((AtributoChaveFigure)e)) continue;
                                    ownerEntity = c.toString().toUpperCase().replaceAll("\\s+", "_");
                                    keyAtt = e.toString();
                                    keyAttType = ((AtributoChaveFigure)e).getAttributeType().toString();
                                    String string = keyAttNullable = !((AtributoChaveFigure)e).isNullable() ? "NOT NULL" : "";
                                }
                                continue;
                            }
                            if (!((ConnectionFigure)d).getEndFigure().equals((EntidadeFigure)c)) continue;
                            for (Figure e : keyAttribute) {
                                if (!((ConnectionFigure)d).getStartFigure().equals((AtributoChaveFigure)e)) continue;
                                ownerEntity = c.toString().toUpperCase().replaceAll("\\s+", "_");
                                keyAtt = e.toString();
                                keyAttType = ((AtributoChaveFigure)e).getAttributeType().toString();
                                String string = keyAttNullable = !((AtributoChaveFigure)e).isNullable() ? "NOT NULL" : "";
                            }
                        }
                        continue;
                    }
                    if (!((ConnectionFigure)b).getEndFigure().equals((EntidadeFigure)c)) continue;
                    for (Figure d : connection) {
                        if (((ConnectionFigure)d).getStartFigure().equals((EntidadeFigure)c)) {
                            for (Figure e : keyAttribute) {
                                if (!((ConnectionFigure)d).getEndFigure().equals((AtributoChaveFigure)e)) continue;
                                ownerEntity = c.toString().toUpperCase().replaceAll("\\s+", "_");
                                keyAtt = e.toString();
                                keyAttType = ((AtributoChaveFigure)e).getAttributeType().toString();
                                String string = keyAttNullable = !((AtributoChaveFigure)e).isNullable() ? "NOT NULL" : "";
                            }
                            continue;
                        }
                        if (!((ConnectionFigure)d).getEndFigure().equals((EntidadeFigure)c)) continue;
                        for (Figure e : keyAttribute) {
                            if (!((ConnectionFigure)d).getStartFigure().equals((AtributoChaveFigure)e)) continue;
                            ownerEntity = c.toString().toUpperCase().replaceAll("\\s+", "_");
                            keyAtt = e.toString();
                            keyAttType = ((AtributoChaveFigure)e).getAttributeType().toString();
                            String string = keyAttNullable = !((AtributoChaveFigure)e).isNullable() ? "NOT NULL" : "";
                        }
                    }
                }
                for (Figure f : weakEntity) {
                    if (((ConnectionFigure)b).getStartFigure().equals((EntidadeFracaFigure)f)) {
                        for (Figure g : connection) {
                            if (((ConnectionFigure)g).getStartFigure().equals((EntidadeFracaFigure)f)) {
                                for (Figure h : partialKeyAttribute) {
                                    if (!((ConnectionFigure)g).getEndFigure().equals((AtributoChaveParcialFigure)h)) continue;
                                    mycontent = "\nALTER TABLE " + f.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD " + keyAtt + "_" + ownerEntity.toLowerCase() + " " + keyAttType + " " + keyAttNullable + ";\n";
                                    mycontent2 = "ALTER TABLE " + f.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + f.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + keyAtt + "_" + ownerEntity.toLowerCase() + ") REFERENCES " + ownerEntity + " (" + keyAtt + ");\n";
                                    mycontent3 = "ALTER TABLE " + f.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT PK_" + f.toString().toUpperCase().replaceAll("\\s+", "_") + " PRIMARY KEY (" + h.toString() + ", " + keyAtt + "_" + ownerEntity.toLowerCase() + ");\n";
                                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                                }
                                continue;
                            }
                            if (!((ConnectionFigure)g).getEndFigure().equals((EntidadeFracaFigure)f)) continue;
                            for (Figure h : partialKeyAttribute) {
                                if (!((ConnectionFigure)g).getStartFigure().equals((AtributoChaveParcialFigure)h)) continue;
                                mycontent = "\nALTER TABLE " + f.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD " + keyAtt + "_" + ownerEntity.toLowerCase() + " " + keyAttType + " " + keyAttNullable + ";\n";
                                mycontent2 = "ALTER TABLE " + f.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + f.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + keyAtt + "_" + ownerEntity.toLowerCase() + ") REFERENCES " + ownerEntity + " (" + keyAtt + ");\n";
                                mycontent3 = "ALTER TABLE " + f.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT PK_" + f.toString().toUpperCase().replaceAll("\\s+", "_") + " PRIMARY KEY (" + h.toString() + ", " + keyAtt + "_" + ownerEntity.toLowerCase() + ");\n";
                                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                            }
                        }
                        continue;
                    }
                    if (!((ConnectionFigure)b).getEndFigure().equals((EntidadeFracaFigure)f)) continue;
                    for (Figure g : connection) {
                        if (((ConnectionFigure)g).getStartFigure().equals((EntidadeFracaFigure)f)) {
                            for (Figure h : partialKeyAttribute) {
                                if (!((ConnectionFigure)g).getEndFigure().equals((AtributoChaveParcialFigure)h)) continue;
                                mycontent = "\nALTER TABLE " + f.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD " + keyAtt + "_" + ownerEntity.toLowerCase() + " " + keyAttType + " " + keyAttNullable + ";\n";
                                mycontent2 = "ALTER TABLE " + f.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + f.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + keyAtt + "_" + ownerEntity.toLowerCase() + ") REFERENCES " + ownerEntity + " (" + keyAtt + ");\n";
                                mycontent3 = "ALTER TABLE " + f.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT PK_" + f.toString().toUpperCase().replaceAll("\\s+", "_") + " PRIMARY KEY (" + h.toString() + ", " + keyAtt + "_" + ownerEntity.toLowerCase() + ");\n";
                                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                            }
                            continue;
                        }
                        if (!((ConnectionFigure)g).getEndFigure().equals((EntidadeFracaFigure)f)) continue;
                        for (Figure h : partialKeyAttribute) {
                            if (!((ConnectionFigure)g).getStartFigure().equals((AtributoChaveParcialFigure)h)) continue;
                            mycontent = "\nALTER TABLE " + f.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD " + keyAtt + "_" + ownerEntity.toLowerCase() + " " + keyAttType + " " + keyAttNullable + ";\n";
                            mycontent2 = "ALTER TABLE " + f.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + f.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + keyAtt + "_" + ownerEntity.toLowerCase() + ") REFERENCES " + ownerEntity + " (" + keyAtt + ");\n";
                            mycontent3 = "ALTER TABLE " + f.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT PK_" + f.toString().toUpperCase().replaceAll("\\s+", "_") + " PRIMARY KEY (" + h.toString() + ", " + keyAtt + "_" + ownerEntity.toLowerCase() + ");\n";
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                        }
                    }
                }
            }
        }
    }

    public void generateEntityRelationship(ArrayList<Figure> entityRelationship, ArrayList<Figure> connection, ArrayList<Figure> attribute, ArrayList<Figure> keyAttribute, ArrayList<Figure> derivedAttribute) {
        String mycontent = new String();
        for (Figure i : entityRelationship) {
            mycontent = "\nCREATE TABLE " + i.toString().toUpperCase() + "(\n";
            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
            for (Figure j : connection) {
                if (((ConnectionFigure)j).getStartFigure().equals((EntidadeRelacionamentoFigure)i)) {
                    for (Figure k : attribute) {
                        if (!((ConnectionFigure)j).getEndFigure().equals((AtributoFigure)k)) continue;
                        mycontent = String.valueOf(k.toString()) + " " + (!((AtributoFigure)k).isNullable() ? "NOT NULL" : "") + ",\n";
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                    }
                    for (Figure l : keyAttribute) {
                        if (!((ConnectionFigure)j).getEndFigure().equals((AtributoChaveFigure)l)) continue;
                        mycontent = String.valueOf(l.toString()) + " " + (Object)((Object)((AtributoChaveFigure)l).getAttributeType()) + " " + (!((AtributoChaveFigure)l).isNullable() ? "NOT NULL" : "") + ",\n";
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                    }
                    continue;
                }
                if (!((ConnectionFigure)j).getEndFigure().equals((EntidadeRelacionamentoFigure)i)) continue;
                for (Figure k : attribute) {
                    if (!((ConnectionFigure)j).getStartFigure().equals((AtributoFigure)k)) continue;
                    mycontent = String.valueOf(k.toString()) + " " + (!((AtributoFigure)k).isNullable() ? "NOT NULL" : "") + ",\n";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                }
                for (Figure l : keyAttribute) {
                    if (!((ConnectionFigure)j).getStartFigure().equals((AtributoChaveFigure)l)) continue;
                    mycontent = String.valueOf(l.toString()) + " " + (Object)((Object)((AtributoChaveFigure)l).getAttributeType()) + " " + (!((AtributoChaveFigure)l).isNullable() ? "NOT NULL" : "") + ",\n";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                }
            }
            mycontent = ");\n";
            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
        }
    }

    public void generateGenSpec(ArrayList<Figure> strongEntity, ArrayList<Figure> connection, ArrayList<Figure> keyAttribute, ArrayList<Figure> genspecDisjoint, ArrayList<Figure> genspecOverlap, ArrayList<Figure> singleLineGenSpecConn, ArrayList<Figure> doubleLineGenSpecConn, ArrayList<Figure> genSpecLineConn) {
        String mycontent = new String();
        String mycontent2 = new String();
        String mycontent3 = new String();
        String ownerEntity = new String();
        String ownerKey = new String();
        String ownerKeyType = new String();
        String specKey = new String();
        ArrayList<String> specName = new ArrayList<String>();
        if (genspecOverlap.size() > 0) {
            for (Figure a : genspecOverlap) {
                if (singleLineGenSpecConn.size() > 0) {
                    for (Figure b : singleLineGenSpecConn) {
                        if (((ConnectionFigure)b).getEndFigure().equals(a)) {
                            for (Figure c : strongEntity) {
                                if (!((ConnectionFigure)b).getStartFigure().equals(c)) continue;
                                for (Figure d : connection) {
                                    if (((ConnectionFigure)d).getStartFigure().equals((EntidadeFigure)c)) {
                                        for (Figure e : keyAttribute) {
                                            if (!((ConnectionFigure)d).getEndFigure().equals((AtributoChaveFigure)e)) continue;
                                            ownerEntity = c.toString().toUpperCase().replaceAll("\\s+", "_");
                                            ownerKey = e.toString();
                                            ownerKeyType = ((AtributoChaveFigure)e).getAttributeType().toString();
                                        }
                                        continue;
                                    }
                                    if (!((ConnectionFigure)d).getEndFigure().equals((EntidadeFigure)c)) continue;
                                    for (Figure e : keyAttribute) {
                                        if (!((ConnectionFigure)d).getStartFigure().equals((AtributoChaveFigure)e)) continue;
                                        ownerEntity = c.toString().toUpperCase().replaceAll("\\s+", "_");
                                        ownerKey = e.toString();
                                        ownerKeyType = ((AtributoChaveFigure)e).getAttributeType().toString();
                                    }
                                }
                            }
                            continue;
                        }
                        if (!((ConnectionFigure)b).getStartFigure().equals(a)) continue;
                        for (Figure c : strongEntity) {
                            if (!((ConnectionFigure)b).getEndFigure().equals(c)) continue;
                            for (Figure d : connection) {
                                if (((ConnectionFigure)d).getStartFigure().equals((EntidadeFigure)c)) {
                                    for (Figure e : keyAttribute) {
                                        if (!((ConnectionFigure)d).getEndFigure().equals((AtributoChaveFigure)e)) continue;
                                        ownerEntity = c.toString().toUpperCase().replaceAll("\\s+", "_");
                                        ownerKey = e.toString();
                                        ownerKeyType = ((AtributoChaveFigure)e).getAttributeType().toString();
                                    }
                                    continue;
                                }
                                if (!((ConnectionFigure)d).getEndFigure().equals((EntidadeFigure)c)) continue;
                                for (Figure e : keyAttribute) {
                                    if (!((ConnectionFigure)d).getStartFigure().equals((AtributoChaveFigure)e)) continue;
                                    ownerEntity = c.toString().toUpperCase().replaceAll("\\s+", "_");
                                    ownerKey = e.toString();
                                    ownerKeyType = ((AtributoChaveFigure)e).getAttributeType().toString();
                                }
                            }
                        }
                    }
                    for (Figure f : genSpecLineConn) {
                        if (!((ConnectionFigure)f).getStartFigure().equals(a)) continue;
                        for (Figure g : strongEntity) {
                            if (!((ConnectionFigure)f).getEndFigure().equals(g)) continue;
                            for (Figure h : connection) {
                                if (((ConnectionFigure)h).getStartFigure().equals((EntidadeFigure)g)) {
                                    specKey = String.valueOf(ownerKey) + "_" + ownerEntity.toLowerCase();
                                    mycontent = "ALTER TABLE " + g.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD " + specKey + " " + ownerKeyType + " NOT NULL;\n";
                                    mycontent2 = "ALTER TABLE " + g.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + g.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + specKey + ") REFERENCES " + ownerEntity + " (" + ownerKey + ") ON DELETE CASCADE;\n";
                                    mycontent3 = "ALTER TABLE " + g.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT PK_" + g.toString().toUpperCase().replaceAll("\\s+", "_") + " PRIMARY KEY (" + specKey + ") REFERENCES " + ownerEntity + " (" + ownerKey + ");\n";
                                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                                    continue;
                                }
                                if (!((ConnectionFigure)h).getEndFigure().equals((EntidadeFigure)g)) continue;
                                specKey = String.valueOf(ownerKey) + "_" + ownerEntity.toLowerCase();
                                mycontent = "ALTER TABLE " + g.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD " + specKey + " " + ownerKeyType + " NOT NULL;\n";
                                mycontent2 = "ALTER TABLE " + g.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + g.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + specKey + ") REFERENCES " + ownerEntity + " (" + ownerKey + ") ON DELETE CASCADE;\n";
                                mycontent3 = "ALTER TABLE " + g.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT PK_" + g.toString().toUpperCase().replaceAll("\\s+", "_") + " PRIMARY KEY (" + specKey + ") REFERENCES " + ownerEntity + " (" + ownerKey + ");\n";
                                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                            }
                        }
                    }
                    continue;
                }
                for (Figure b : doubleLineGenSpecConn) {
                    if (((ConnectionFigure)b).getEndFigure().equals(a)) {
                        for (Figure c : strongEntity) {
                            if (!((ConnectionFigure)b).getStartFigure().equals(c)) continue;
                            for (Figure d : connection) {
                                if (((ConnectionFigure)d).getStartFigure().equals((EntidadeFigure)c)) {
                                    for (Figure e : keyAttribute) {
                                        if (!((ConnectionFigure)d).getEndFigure().equals((AtributoChaveFigure)e)) continue;
                                        ownerEntity = c.toString().toUpperCase().replaceAll("\\s+", "_");
                                        ownerKey = e.toString();
                                        ownerKeyType = ((AtributoChaveFigure)e).getAttributeType().toString();
                                    }
                                    continue;
                                }
                                if (!((ConnectionFigure)d).getEndFigure().equals((EntidadeFigure)c)) continue;
                                for (Figure e : keyAttribute) {
                                    if (!((ConnectionFigure)d).getStartFigure().equals((AtributoChaveFigure)e)) continue;
                                    ownerEntity = c.toString().toUpperCase().replaceAll("\\s+", "_");
                                    ownerKey = e.toString();
                                    ownerKeyType = ((AtributoChaveFigure)e).getAttributeType().toString();
                                }
                            }
                        }
                        continue;
                    }
                    if (!((ConnectionFigure)b).getStartFigure().equals(a)) continue;
                    for (Figure c : strongEntity) {
                        if (!((ConnectionFigure)b).getEndFigure().equals(c)) continue;
                        for (Figure d : connection) {
                            if (((ConnectionFigure)d).getStartFigure().equals((EntidadeFigure)c)) {
                                for (Figure e : keyAttribute) {
                                    if (!((ConnectionFigure)d).getEndFigure().equals((AtributoChaveFigure)e)) continue;
                                    ownerEntity = c.toString().toUpperCase().replaceAll("\\s+", "_");
                                    ownerKey = e.toString();
                                    ownerKeyType = ((AtributoChaveFigure)e).getAttributeType().toString();
                                }
                                continue;
                            }
                            if (!((ConnectionFigure)d).getEndFigure().equals((EntidadeFigure)c)) continue;
                            for (Figure e : keyAttribute) {
                                if (!((ConnectionFigure)d).getStartFigure().equals((AtributoChaveFigure)e)) continue;
                                ownerEntity = c.toString().toUpperCase().replaceAll("\\s+", "_");
                                ownerKey = e.toString();
                                ownerKeyType = ((AtributoChaveFigure)e).getAttributeType().toString();
                            }
                        }
                    }
                }
                for (Figure f : genSpecLineConn) {
                    if (!((ConnectionFigure)f).getStartFigure().equals(a)) continue;
                    for (Figure g : strongEntity) {
                        if (!((ConnectionFigure)f).getEndFigure().equals(g)) continue;
                        for (Figure h : connection) {
                            if (((ConnectionFigure)h).getStartFigure().equals((EntidadeFigure)g)) {
                                specName.add(g.toString().toUpperCase().replaceAll("\\s+", "_"));
                                specKey = String.valueOf(ownerKey) + "_" + ownerEntity.toLowerCase();
                                mycontent = "ALTER TABLE " + g.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD " + specKey + " " + ownerKeyType + " NOT NULL;\n";
                                mycontent2 = "ALTER TABLE " + g.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + g.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + specKey + ") REFERENCES " + ownerEntity + " (" + ownerKey + ") ON DELETE CASCADE;\n";
                                mycontent3 = "ALTER TABLE " + g.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT PK_" + g.toString().toUpperCase().replaceAll("\\s+", "_") + " PRIMARY KEY (" + specKey + ") REFERENCES " + ownerEntity + " (" + ownerKey + ");\n";
                                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                                continue;
                            }
                            if (!((ConnectionFigure)h).getEndFigure().equals((EntidadeFigure)g)) continue;
                            specName.add(g.toString().toUpperCase().replaceAll("\\s+", "_"));
                            specKey = String.valueOf(ownerKey) + "_" + ownerEntity.toLowerCase();
                            mycontent = "ALTER TABLE " + g.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD " + specKey + " " + ownerKeyType + " NOT NULL;\n";
                            mycontent2 = "ALTER TABLE " + g.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + g.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + specKey + ") REFERENCES " + ownerEntity + " (" + ownerKey + ") ON DELETE CASCADE;\n";
                            mycontent3 = "ALTER TABLE " + g.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT PK_" + g.toString().toUpperCase().replaceAll("\\s+", "_") + " PRIMARY KEY (" + specKey + ") REFERENCES " + ownerEntity + " (" + ownerKey + ");\n";
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                        }
                    }
                }
                mycontent = "\nCREATE OR REPLACE TRIGGER genspecTrigger_" + ownerEntity + " AFTER INSERT OR DELETE OR UPDATE ON " + ownerEntity + "\nREFERENCING NEW AS n OLD as o FOR EACH ROW\nDECLARE ";
                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                int i = 0;
                while (i < specName.size()) {
                    mycontent2 = "X" + i + " number; ";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                    ++i;
                }
                mycontent = "\nBEGIN\n\tIF INSTERTING THEN\n";
                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                i = 0;
                while (i < specName.size()) {
                    mycontent2 = "\t\tSELECT COUNT(*) INTO X" + i + " FROM " + (String)specName.get(i) + " c WHERE c." + specKey + " = :n." + ownerKey + ";\n";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                    ++i;
                }
                mycontent = "\t\tIF(";
                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                i = 0;
                while (i < specName.size()) {
                    mycontent2 = "X" + i + " + ";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                    ++i;
                }
                mycontent = "< 1) THEN RAISE_APPLICATION_ERROR(-20000, 'Viola\u00e7\u00e3o detectada!'); END IF;\n\tEND IF;\nEND;\n";
                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                int errcount = 20001;
                int i2 = 0;
                while (i2 < specName.size()) {
                    mycontent = "\nCREATE OR REPLACE TRIGGER genspecTrigger_" + (String)specName.get(i2) + " AFTER INSERT OR DELETE OR UPDATE ON " + (String)specName.get(i2) + "\nREFERENCING NEW AS n OLD as o FOR EACH ROW\nDECLARE ";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                    int j = 0;
                    while (j < specName.size() - 1) {
                        mycontent2 = "X" + j + " number; ";
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                        ++j;
                    }
                    mycontent = "\nBEGIN\n\tIF DELETING THEN\n";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                    int aux = 0;
                    int l = 0;
                    while (l < specName.size()) {
                        if (i2 != l) {
                            mycontent2 = "\t\tSELECT COUNT(*) INTO X" + aux + " FROM " + (String)specName.get(l) + " c WHERE c." + specKey + " = :n." + specKey + ";\n";
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                            ++aux;
                        }
                        ++l;
                    }
                    mycontent = "\t\tIF(";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                    l = 0;
                    while (l < specName.size() - 1) {
                        mycontent2 = "X" + l + " + ";
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                        ++l;
                    }
                    mycontent = "< 1) THEN RAISE_APPLICATION_ERROR(-" + errcount + ", 'Viola\u00e7\u00e3o detectada!'); END IF;\n\tEND IF;\nEND;\n";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                    ++errcount;
                    ++i2;
                }
            }
        }
        if (genspecDisjoint.size() > 0) {
            for (Figure a : genspecDisjoint) {
                if (singleLineGenSpecConn.size() > 0) {
                    for (Figure b : singleLineGenSpecConn) {
                        if (((ConnectionFigure)b).getEndFigure().equals(a)) {
                            for (Figure c : strongEntity) {
                                if (!((ConnectionFigure)b).getStartFigure().equals(c)) continue;
                                for (Figure d : connection) {
                                    if (((ConnectionFigure)d).getStartFigure().equals((EntidadeFigure)c)) {
                                        for (Figure e : keyAttribute) {
                                            if (!((ConnectionFigure)d).getEndFigure().equals((AtributoChaveFigure)e)) continue;
                                            ownerEntity = c.toString().toUpperCase().replaceAll("\\s+", "_");
                                            ownerKey = e.toString();
                                            ownerKeyType = ((AtributoChaveFigure)e).getAttributeType().toString();
                                        }
                                        continue;
                                    }
                                    if (!((ConnectionFigure)d).getEndFigure().equals((EntidadeFigure)c)) continue;
                                    for (Figure e : keyAttribute) {
                                        if (!((ConnectionFigure)d).getStartFigure().equals((AtributoChaveFigure)e)) continue;
                                        ownerEntity = c.toString().toUpperCase().replaceAll("\\s+", "_");
                                        ownerKey = e.toString();
                                        ownerKeyType = ((AtributoChaveFigure)e).getAttributeType().toString();
                                    }
                                }
                            }
                            continue;
                        }
                        if (!((ConnectionFigure)b).getStartFigure().equals(a)) continue;
                        for (Figure c : strongEntity) {
                            if (!((ConnectionFigure)b).getEndFigure().equals(c)) continue;
                            for (Figure d : connection) {
                                if (((ConnectionFigure)d).getStartFigure().equals((EntidadeFigure)c)) {
                                    for (Figure e : keyAttribute) {
                                        if (!((ConnectionFigure)d).getEndFigure().equals((AtributoChaveFigure)e)) continue;
                                        ownerEntity = c.toString().toUpperCase().replaceAll("\\s+", "_");
                                        ownerKey = e.toString();
                                        ownerKeyType = ((AtributoChaveFigure)e).getAttributeType().toString();
                                    }
                                    continue;
                                }
                                if (!((ConnectionFigure)d).getEndFigure().equals((EntidadeFigure)c)) continue;
                                for (Figure e : keyAttribute) {
                                    if (!((ConnectionFigure)d).getStartFigure().equals((AtributoChaveFigure)e)) continue;
                                    ownerEntity = c.toString().toUpperCase().replaceAll("\\s+", "_");
                                    ownerKey = e.toString();
                                    ownerKeyType = ((AtributoChaveFigure)e).getAttributeType().toString();
                                }
                            }
                        }
                    }
                    for (Figure f : genSpecLineConn) {
                        if (!((ConnectionFigure)f).getStartFigure().equals(a)) continue;
                        for (Figure g : strongEntity) {
                            if (!((ConnectionFigure)f).getEndFigure().equals(g)) continue;
                            for (Figure h : connection) {
                                if (((ConnectionFigure)h).getStartFigure().equals((EntidadeFigure)g)) {
                                    specName.add(g.toString().toUpperCase().replaceAll("\\s+", "_"));
                                    specKey = String.valueOf(ownerKey) + "_" + ownerEntity.toLowerCase();
                                    mycontent = "ALTER TABLE " + g.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD " + specKey + " " + ownerKeyType + " NOT NULL;\n";
                                    mycontent2 = "ALTER TABLE " + g.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + g.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + specKey + ") REFERENCES " + ownerEntity + " (" + ownerKey + ") ON DELETE CASCADE;\n";
                                    mycontent3 = "ALTER TABLE " + g.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT PK_" + g.toString().toUpperCase().replaceAll("\\s+", "_") + " PRIMARY KEY (" + specKey + ") REFERENCES " + ownerEntity + " (" + ownerKey + ");\n";
                                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                                    continue;
                                }
                                if (!((ConnectionFigure)h).getEndFigure().equals((EntidadeFigure)g)) continue;
                                specName.add(g.toString().toUpperCase().replaceAll("\\s+", "_"));
                                specKey = String.valueOf(ownerKey) + "_" + ownerEntity.toLowerCase();
                                mycontent = "ALTER TABLE " + g.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD " + specKey + " " + ownerKeyType + " NOT NULL;\n";
                                mycontent2 = "ALTER TABLE " + g.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + g.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + specKey + ") REFERENCES " + ownerEntity + " (" + ownerKey + ") ON DELETE CASCADE;\n";
                                mycontent3 = "ALTER TABLE " + g.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT PK_" + g.toString().toUpperCase().replaceAll("\\s+", "_") + " PRIMARY KEY (" + specKey + ") REFERENCES " + ownerEntity + " (" + ownerKey + ");\n";
                                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                            }
                        }
                    }
                    int errcount = 20000;
                    int i = 0;
                    while (i < specName.size()) {
                        mycontent = "\nCREATE OR REPLACE TRIGGER genspecTrigger_" + (String)specName.get(i) + " AFTER INSERT OR DELETE OR UPDATE ON " + (String)specName.get(i) + "\nREFERENCING NEW AS n OLD as o FOR EACH ROW\nDECLARE ";
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                        int j = 0;
                        while (j < specName.size() - 1) {
                            mycontent2 = "X" + j + " number; ";
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                            ++j;
                        }
                        mycontent = "\nBEGIN\n\tIF INSERTING THEN\n";
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                        int aux = 0;
                        int l = 0;
                        while (l < specName.size()) {
                            if (i != l) {
                                mycontent2 = "\t\tSELECT COUNT(*) INTO X" + aux + " FROM " + (String)specName.get(l) + " c WHERE c." + specKey + " = :n." + specKey + ";\n";
                                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                                ++aux;
                            }
                            ++l;
                        }
                        mycontent = "\t\tIF(";
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                        l = 0;
                        while (l < specName.size() - 1) {
                            mycontent2 = "X" + l + " + ";
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                            ++l;
                        }
                        mycontent = "!= 0) THEN RAISE_APPLICATION_ERROR(-" + errcount + ", 'Viola\u00e7\u00e3o detectada!'); END IF;\n\tEND IF;\nEND;\n";
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                        ++errcount;
                        ++i;
                    }
                    continue;
                }
                for (Figure b : doubleLineGenSpecConn) {
                    if (((ConnectionFigure)b).getEndFigure().equals(a)) {
                        for (Figure c : strongEntity) {
                            if (!((ConnectionFigure)b).getStartFigure().equals(c)) continue;
                            for (Figure d : connection) {
                                if (((ConnectionFigure)d).getStartFigure().equals((EntidadeFigure)c)) {
                                    for (Figure e : keyAttribute) {
                                        if (!((ConnectionFigure)d).getEndFigure().equals((AtributoChaveFigure)e)) continue;
                                        ownerEntity = c.toString().toUpperCase().replaceAll("\\s+", "_");
                                        ownerKey = e.toString();
                                        ownerKeyType = ((AtributoChaveFigure)e).getAttributeType().toString();
                                    }
                                    continue;
                                }
                                if (!((ConnectionFigure)d).getEndFigure().equals((EntidadeFigure)c)) continue;
                                for (Figure e : keyAttribute) {
                                    if (!((ConnectionFigure)d).getStartFigure().equals((AtributoChaveFigure)e)) continue;
                                    ownerEntity = c.toString().toUpperCase().replaceAll("\\s+", "_");
                                    ownerKey = e.toString();
                                    ownerKeyType = ((AtributoChaveFigure)e).getAttributeType().toString();
                                }
                            }
                        }
                        continue;
                    }
                    if (!((ConnectionFigure)b).getStartFigure().equals(a)) continue;
                    for (Figure c : strongEntity) {
                        if (!((ConnectionFigure)b).getEndFigure().equals(c)) continue;
                        for (Figure d : connection) {
                            if (((ConnectionFigure)d).getStartFigure().equals((EntidadeFigure)c)) {
                                for (Figure e : keyAttribute) {
                                    if (!((ConnectionFigure)d).getEndFigure().equals((AtributoChaveFigure)e)) continue;
                                    ownerEntity = c.toString().toUpperCase().replaceAll("\\s+", "_");
                                    ownerKey = e.toString();
                                    ownerKeyType = ((AtributoChaveFigure)e).getAttributeType().toString();
                                }
                                continue;
                            }
                            if (!((ConnectionFigure)d).getEndFigure().equals((EntidadeFigure)c)) continue;
                            for (Figure e : keyAttribute) {
                                if (!((ConnectionFigure)d).getStartFigure().equals((AtributoChaveFigure)e)) continue;
                                ownerEntity = c.toString().toUpperCase().replaceAll("\\s+", "_");
                                ownerKey = e.toString();
                                ownerKeyType = ((AtributoChaveFigure)e).getAttributeType().toString();
                            }
                        }
                    }
                }
                for (Figure f : genSpecLineConn) {
                    if (!((ConnectionFigure)f).getStartFigure().equals(a)) continue;
                    for (Figure g : strongEntity) {
                        if (!((ConnectionFigure)f).getEndFigure().equals(g)) continue;
                        for (Figure h : connection) {
                            if (((ConnectionFigure)h).getStartFigure().equals((EntidadeFigure)g)) {
                                specName.add(g.toString().toUpperCase().replaceAll("\\s+", "_"));
                                specKey = String.valueOf(ownerKey) + "_" + ownerEntity.toLowerCase();
                                mycontent = "ALTER TABLE " + g.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD " + specKey + " " + ownerKeyType + " NOT NULL;\n";
                                mycontent2 = "ALTER TABLE " + g.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + g.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + specKey + ") REFERENCES " + ownerEntity + " (" + ownerKey + ") ON DELETE CASCADE;\n";
                                mycontent3 = "ALTER TABLE " + g.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT PK_" + g.toString().toUpperCase().replaceAll("\\s+", "_") + " PRIMARY KEY (" + specKey + ") REFERENCES " + ownerEntity + " (" + ownerKey + ");\n";
                                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                                continue;
                            }
                            if (!((ConnectionFigure)h).getEndFigure().equals((EntidadeFigure)g)) continue;
                            specName.add(g.toString().toUpperCase().replaceAll("\\s+", "_"));
                            specKey = String.valueOf(ownerKey) + "_" + ownerEntity.toLowerCase();
                            mycontent = "ALTER TABLE " + g.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD " + specKey + " " + ownerKeyType + " NOT NULL;\n";
                            mycontent2 = "ALTER TABLE " + g.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + g.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + specKey + ") REFERENCES " + ownerEntity + " (" + ownerKey + ") ON DELETE CASCADE;\n";
                            mycontent3 = "ALTER TABLE " + g.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT PK_" + g.toString().toUpperCase().replaceAll("\\s+", "_") + " PRIMARY KEY (" + specKey + ") REFERENCES " + ownerEntity + " (" + ownerKey + ");\n";
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                        }
                    }
                }
                mycontent = "\nCREATE OR REPLACE TRIGGER genspecTrigger_" + ownerEntity + " AFTER INSERT OR DELETE OR UPDATE ON " + ownerEntity + "\nREFERENCING NEW AS n OLD as o FOR EACH ROW\nDECLARE ";
                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                int i = 0;
                while (i < specName.size()) {
                    mycontent2 = "X" + i + " number; ";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                    ++i;
                }
                mycontent = "\nBEGIN\n\tIF INSTERTING THEN\n";
                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                i = 0;
                while (i < specName.size()) {
                    mycontent2 = "\t\tSELECT COUNT(*) INTO X" + i + " FROM " + (String)specName.get(i) + " c WHERE c." + specKey + " = :n." + ownerKey + ";\n";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                    ++i;
                }
                mycontent = "\t\tIF(";
                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                i = 0;
                while (i < specName.size()) {
                    mycontent2 = "X" + i + " + ";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                    ++i;
                }
                mycontent = "< 1) THEN RAISE_APPLICATION_ERROR(-20000, 'Viola\u00e7\u00e3o detectada!'); END IF;\n\tEND IF;\nEND;\n";
                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                int errcount = 20000;
                int i3 = 0;
                while (i3 < specName.size()) {
                    mycontent = "\nCREATE OR REPLACE TRIGGER genspecTrigger_" + (String)specName.get(i3) + " AFTER INSERT OR DELETE OR UPDATE ON " + (String)specName.get(i3) + "\nREFERENCING NEW AS n OLD as o FOR EACH ROW\nDECLARE ";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                    int j = 0;
                    while (j < specName.size()) {
                        mycontent2 = "X" + j + " number; ";
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                        ++j;
                    }
                    mycontent = "\nBEGIN\n\tIF INSERTING THEN\n";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                    int aux = 1;
                    int l = 0;
                    while (l < specName.size()) {
                        if (i3 != l) {
                            mycontent2 = "\t\tSELECT COUNT(*) INTO X" + aux + " FROM " + (String)specName.get(l) + " c WHERE c." + specKey + " = :n." + specKey + ";\n";
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                            ++aux;
                        }
                        ++l;
                    }
                    mycontent = "\t\tIF(";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                    l = 1;
                    while (l < specName.size()) {
                        mycontent2 = "X" + l + " + ";
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                        ++l;
                    }
                    mycontent = " != 0) THEN RAISE_APPLICATION_ERROR(-" + errcount + ", 'Viola\u00e7\u00e3o detectada!'); END IF;\n\tEND IF;\n";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                    mycontent = "\tIF DELETING THEN\n\t\tSELECT COUNT(*) INTO X0 FROM " + ownerEntity + " c WHERE c." + ownerKey + " = :o." + specKey + ";\n";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                    mycontent2 = "\t\tIF(X0 != 0) THEN RAISE_APPLICATION_ERROR(-" + ++errcount + ", 'Viola\u00e7\u00e3o detectada!'); END IF;\n\tEND IF;\n";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                    mycontent = "\tIF UPDATING THEN\n\t\tIF(:n." + specKey + " != :o." + specKey + ") THEN\n";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                    mycontent = "\t\t\tSELECT COUNT(*) INTO X0 FROM " + ownerEntity + " c WHERE c." + ownerKey + " = :o." + specKey + ";\n";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                    mycontent2 = "\t\t\tIF(X0 != 0) THEN RAISE_APPLICATION_ERROR(-" + ++errcount + ", 'Viola\u00e7\u00e3o detectada!'); END IF;\n";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                    ++errcount;
                    int aux2 = 1;
                    int l2 = 0;
                    while (l2 < specName.size()) {
                        if (i3 != l2) {
                            mycontent2 = "\t\t\tSELECT COUNT(*) INTO X" + aux2 + " FROM " + (String)specName.get(l2) + " c WHERE c." + specKey + " = :n." + specKey + ";\n";
                            mycontent3 = "\t\t\tIF(X" + aux2 + " != 0) THEN RAISE_APPLICATION_ERROR(-" + errcount + ", 'Viola\u00e7\u00e3o detectada!'); END IF;\n";
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                            ++aux2;
                            ++errcount;
                        }
                        ++l2;
                    }
                    mycontent = "\t\tEND IF;\n\tEND IF\nEND;\n";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                    ++i3;
                }
            }
        }
    }

    public void generateRelationships(ArrayList<Figure> strongEntity, ArrayList<Figure> connection, ArrayList<Figure> keyAttribute, ArrayList<Figure> singleLineConnectionUm, ArrayList<Figure> singleLineConnectionN, ArrayList<Figure> doubleLineConnectionUm, ArrayList<Figure> doubleLineConnectionN, ArrayList<Figure> relationship, ArrayList<Figure> entityRelationship) {
        ArrayList<Figure> slcN = new ArrayList<Figure>();
        ArrayList<Figure> dlcN = new ArrayList<Figure>();
        String entRel = new String();
        String ownerEntity = new String();
        String ownerKey = new String();
        String ownerKeyType = new String();
        String ownerEntity2 = new String();
        String ownerKey2 = new String();
        String ownerKeyType2 = new String();
        String mycontent = new String();
        String mycontent2 = new String();
        String mycontent3 = new String();
        if (entityRelationship.isEmpty()) {
            this.relationshipGenerator(strongEntity, connection, keyAttribute, singleLineConnectionUm, singleLineConnectionN, doubleLineConnectionUm, doubleLineConnectionN, relationship);
        } else if (!entityRelationship.isEmpty()) {
            this.relationshipGenerator(strongEntity, connection, keyAttribute, singleLineConnectionUm, singleLineConnectionN, doubleLineConnectionUm, doubleLineConnectionN, relationship);
            for (Figure a : entityRelationship) {
                for (Figure b : singleLineConnectionN) {
                    if (!((ConnectionFigure)b).getEndFigure().equals(a)) continue;
                    slcN.add(b);
                }
                for (Figure c : doubleLineConnectionN) {
                    if (!((ConnectionFigure)c).getEndFigure().equals(a)) continue;
                    dlcN.add(c);
                }
                entRel = a.toString().toUpperCase().replaceAll("\\s+", "_");
                if (slcN.size() == 2) {
                    int i = 0;
                    while (i < slcN.size() - 1) {
                        for (Figure f : strongEntity) {
                            if (((ConnectionFigure)slcN.get(i)).getStartFigure().equals(f)) {
                                for (Figure g : connection) {
                                    if (((ConnectionFigure)g).getStartFigure().equals(f)) {
                                        for (Figure h : keyAttribute) {
                                            if (!((ConnectionFigure)g).getEndFigure().equals((AtributoChaveFigure)h)) continue;
                                            ownerEntity = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                            ownerKey = h.toString();
                                            ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                                        }
                                        continue;
                                    }
                                    if (!((ConnectionFigure)g).getEndFigure().equals(f)) continue;
                                    for (Figure h : keyAttribute) {
                                        if (!((ConnectionFigure)g).getStartFigure().equals((AtributoChaveFigure)h)) continue;
                                        ownerEntity = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                        ownerKey = h.toString();
                                        ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                                    }
                                }
                                continue;
                            }
                            if (!((ConnectionFigure)slcN.get(i)).getEndFigure().equals(f)) continue;
                            for (Figure g : connection) {
                                if (((ConnectionFigure)g).getStartFigure().equals(f)) {
                                    for (Figure h : keyAttribute) {
                                        if (!((ConnectionFigure)g).getEndFigure().equals((AtributoChaveFigure)h)) continue;
                                        ownerEntity = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                        ownerKey = h.toString();
                                        ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                                    }
                                    continue;
                                }
                                if (!((ConnectionFigure)g).getEndFigure().equals(f)) continue;
                                for (Figure h : keyAttribute) {
                                    if (!((ConnectionFigure)g).getStartFigure().equals((AtributoChaveFigure)h)) continue;
                                    ownerEntity = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                    ownerKey = h.toString();
                                    ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                                }
                            }
                        }
                        ++i;
                    }
                    i = 1;
                    while (i < slcN.size()) {
                        for (Figure f : strongEntity) {
                            if (((ConnectionFigure)slcN.get(i)).getStartFigure().equals(f)) {
                                for (Figure g : connection) {
                                    if (((ConnectionFigure)g).getStartFigure().equals(f)) {
                                        for (Figure h : keyAttribute) {
                                            if (!((ConnectionFigure)g).getEndFigure().equals((AtributoChaveFigure)h)) continue;
                                            ownerEntity2 = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                            ownerKey2 = h.toString();
                                            ownerKeyType2 = ((AtributoChaveFigure)h).getAttributeType().toString();
                                        }
                                        continue;
                                    }
                                    if (!((ConnectionFigure)g).getEndFigure().equals(f)) continue;
                                    for (Figure h : keyAttribute) {
                                        if (!((ConnectionFigure)g).getStartFigure().equals((AtributoChaveFigure)h)) continue;
                                        ownerEntity2 = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                        ownerKey2 = h.toString();
                                        ownerKeyType2 = ((AtributoChaveFigure)h).getAttributeType().toString();
                                    }
                                }
                                continue;
                            }
                            if (!((ConnectionFigure)slcN.get(i)).getEndFigure().equals(f)) continue;
                            for (Figure g : connection) {
                                if (((ConnectionFigure)g).getStartFigure().equals(f)) {
                                    for (Figure h : keyAttribute) {
                                        if (!((ConnectionFigure)g).getEndFigure().equals((AtributoChaveFigure)h)) continue;
                                        ownerEntity2 = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                        ownerKey2 = h.toString();
                                        ownerKeyType2 = ((AtributoChaveFigure)h).getAttributeType().toString();
                                    }
                                    continue;
                                }
                                if (!((ConnectionFigure)g).getEndFigure().equals(f)) continue;
                                for (Figure h : keyAttribute) {
                                    if (!((ConnectionFigure)g).getStartFigure().equals((AtributoChaveFigure)h)) continue;
                                    ownerEntity2 = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                    ownerKey2 = h.toString();
                                    ownerKeyType2 = ((AtributoChaveFigure)h).getAttributeType().toString();
                                }
                            }
                        }
                        ++i;
                    }
                    mycontent = "\nALTER TABLE " + entRel + " ADD " + ownerKey + "_" + ownerEntity.toLowerCase() + " " + ownerKeyType + " NOT NULL";
                    mycontent2 = "\nALTER TABLE " + entRel + " ADD " + ownerKey2 + "_" + ownerEntity2.toLowerCase() + " " + ownerKeyType2 + " NOT NULL";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                    mycontent = "\nALTER TABLE " + entRel + " ADD CONSTRAINT FK_" + entRel + " FOREING KEY (" + ownerKey + "_" + ownerEntity.toLowerCase() + ") REFERENCES " + ownerEntity + " (" + ownerKey + ");\n";
                    mycontent2 = "\nALTER TABLE " + entRel + " ADD CONSTRAINT FK2_" + entRel + " FOREING KEY (" + ownerKey2 + "_" + ownerEntity2.toLowerCase() + ") REFERENCES " + ownerEntity2 + " (" + ownerKey2 + ");\n";
                    mycontent3 = "\nALTER TABLE " + entRel + " ADD CONSTRAINT PK_" + entRel + " PRIMARY KEY (" + ownerKey + "_" + ownerEntity.toLowerCase() + ", " + ownerKey2 + "_" + ownerEntity2.toLowerCase() + ");\n";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                } else if (slcN.size() == 1 && dlcN.size() == 1) {
                    int i = 0;
                    while (i < slcN.size()) {
                        for (Figure f : strongEntity) {
                            if (((ConnectionFigure)slcN.get(i)).getStartFigure().equals(f)) {
                                for (Figure g : connection) {
                                    if (((ConnectionFigure)g).getStartFigure().equals(f)) {
                                        for (Figure h : keyAttribute) {
                                            if (!((ConnectionFigure)g).getEndFigure().equals((AtributoChaveFigure)h)) continue;
                                            ownerEntity = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                            ownerKey = h.toString();
                                            ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                                        }
                                        continue;
                                    }
                                    if (!((ConnectionFigure)g).getEndFigure().equals(f)) continue;
                                    for (Figure h : keyAttribute) {
                                        if (!((ConnectionFigure)g).getStartFigure().equals((AtributoChaveFigure)h)) continue;
                                        ownerEntity = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                        ownerKey = h.toString();
                                        ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                                    }
                                }
                                continue;
                            }
                            if (!((ConnectionFigure)slcN.get(i)).getEndFigure().equals(f)) continue;
                            for (Figure g : connection) {
                                if (((ConnectionFigure)g).getStartFigure().equals(f)) {
                                    for (Figure h : keyAttribute) {
                                        if (!((ConnectionFigure)g).getEndFigure().equals((AtributoChaveFigure)h)) continue;
                                        ownerEntity = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                        ownerKey = h.toString();
                                        ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                                    }
                                    continue;
                                }
                                if (!((ConnectionFigure)g).getEndFigure().equals(f)) continue;
                                for (Figure h : keyAttribute) {
                                    if (!((ConnectionFigure)g).getStartFigure().equals((AtributoChaveFigure)h)) continue;
                                    ownerEntity = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                    ownerKey = h.toString();
                                    ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                                }
                            }
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < dlcN.size()) {
                        for (Figure f : strongEntity) {
                            if (((ConnectionFigure)dlcN.get(i)).getStartFigure().equals(f)) {
                                for (Figure g : connection) {
                                    if (((ConnectionFigure)g).getStartFigure().equals(f)) {
                                        for (Figure h : keyAttribute) {
                                            if (!((ConnectionFigure)g).getEndFigure().equals((AtributoChaveFigure)h)) continue;
                                            ownerEntity2 = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                            ownerKey2 = h.toString();
                                            ownerKeyType2 = ((AtributoChaveFigure)h).getAttributeType().toString();
                                        }
                                        continue;
                                    }
                                    if (!((ConnectionFigure)g).getEndFigure().equals(f)) continue;
                                    for (Figure h : keyAttribute) {
                                        if (!((ConnectionFigure)g).getStartFigure().equals((AtributoChaveFigure)h)) continue;
                                        ownerEntity2 = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                        ownerKey2 = h.toString();
                                        ownerKeyType2 = ((AtributoChaveFigure)h).getAttributeType().toString();
                                    }
                                }
                                continue;
                            }
                            if (!((ConnectionFigure)dlcN.get(i)).getEndFigure().equals(f)) continue;
                            for (Figure g : connection) {
                                if (((ConnectionFigure)g).getStartFigure().equals(f)) {
                                    for (Figure h : keyAttribute) {
                                        if (!((ConnectionFigure)g).getEndFigure().equals((AtributoChaveFigure)h)) continue;
                                        ownerEntity2 = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                        ownerKey2 = h.toString();
                                        ownerKeyType2 = ((AtributoChaveFigure)h).getAttributeType().toString();
                                    }
                                    continue;
                                }
                                if (!((ConnectionFigure)g).getEndFigure().equals(f)) continue;
                                for (Figure h : keyAttribute) {
                                    if (!((ConnectionFigure)g).getStartFigure().equals((AtributoChaveFigure)h)) continue;
                                    ownerEntity2 = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                    ownerKey2 = h.toString();
                                    ownerKeyType2 = ((AtributoChaveFigure)h).getAttributeType().toString();
                                }
                            }
                        }
                        ++i;
                    }
                    mycontent = "\nALTER TABLE " + entRel + " ADD " + ownerKey + "_" + ownerEntity.toLowerCase() + " " + ownerKeyType + " NOT NULL";
                    mycontent2 = "\nALTER TABLE " + entRel + " ADD " + ownerKey2 + "_" + ownerEntity2.toLowerCase() + " " + ownerKeyType2 + " NOT NULL";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                    mycontent = "\nALTER TABLE " + entRel + " ADD CONSTRAINT FK_" + entRel + " FOREING KEY (" + ownerKey + "_" + ownerEntity.toLowerCase() + ") REFERENCES " + ownerEntity + " (" + ownerKey + ");\n";
                    mycontent2 = "\nALTER TABLE " + entRel + " ADD CONSTRAINT FK2_" + entRel + " FOREING KEY (" + ownerKey2 + "_" + ownerEntity2.toLowerCase() + ") REFERENCES " + ownerEntity2 + " (" + ownerKey2 + ");\n";
                    mycontent3 = "\nALTER TABLE " + entRel + " ADD CONSTRAINT PK_" + entRel + " PRIMARY KEY (" + ownerKey + "_" + ownerEntity.toLowerCase() + ", " + ownerKey2 + "_" + ownerEntity2.toLowerCase() + ");\n";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                } else if (dlcN.size() == 2) {
                    int i = 0;
                    while (i < dlcN.size() - 1) {
                        for (Figure f : strongEntity) {
                            if (((ConnectionFigure)dlcN.get(i)).getStartFigure().equals(f)) {
                                for (Figure g : connection) {
                                    if (((ConnectionFigure)g).getStartFigure().equals(f)) {
                                        for (Figure h : keyAttribute) {
                                            if (!((ConnectionFigure)g).getEndFigure().equals((AtributoChaveFigure)h)) continue;
                                            ownerEntity = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                            ownerKey = h.toString();
                                            ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                                        }
                                        continue;
                                    }
                                    if (!((ConnectionFigure)g).getEndFigure().equals(f)) continue;
                                    for (Figure h : keyAttribute) {
                                        if (!((ConnectionFigure)g).getStartFigure().equals((AtributoChaveFigure)h)) continue;
                                        ownerEntity = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                        ownerKey = h.toString();
                                        ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                                    }
                                }
                                continue;
                            }
                            if (!((ConnectionFigure)dlcN.get(i)).getEndFigure().equals(f)) continue;
                            for (Figure g : connection) {
                                if (((ConnectionFigure)g).getStartFigure().equals(f)) {
                                    for (Figure h : keyAttribute) {
                                        if (!((ConnectionFigure)g).getEndFigure().equals((AtributoChaveFigure)h)) continue;
                                        ownerEntity = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                        ownerKey = h.toString();
                                        ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                                    }
                                    continue;
                                }
                                if (!((ConnectionFigure)g).getEndFigure().equals(f)) continue;
                                for (Figure h : keyAttribute) {
                                    if (!((ConnectionFigure)g).getStartFigure().equals((AtributoChaveFigure)h)) continue;
                                    ownerEntity = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                    ownerKey = h.toString();
                                    ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                                }
                            }
                        }
                        ++i;
                    }
                    i = 1;
                    while (i < dlcN.size()) {
                        for (Figure f : strongEntity) {
                            if (((ConnectionFigure)dlcN.get(i)).getStartFigure().equals(f)) {
                                for (Figure g : connection) {
                                    if (((ConnectionFigure)g).getStartFigure().equals(f)) {
                                        for (Figure h : keyAttribute) {
                                            if (!((ConnectionFigure)g).getEndFigure().equals((AtributoChaveFigure)h)) continue;
                                            ownerEntity2 = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                            ownerKey2 = h.toString();
                                            ownerKeyType2 = ((AtributoChaveFigure)h).getAttributeType().toString();
                                        }
                                        continue;
                                    }
                                    if (!((ConnectionFigure)g).getEndFigure().equals(f)) continue;
                                    for (Figure h : keyAttribute) {
                                        if (!((ConnectionFigure)g).getStartFigure().equals((AtributoChaveFigure)h)) continue;
                                        ownerEntity2 = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                        ownerKey2 = h.toString();
                                        ownerKeyType2 = ((AtributoChaveFigure)h).getAttributeType().toString();
                                    }
                                }
                                continue;
                            }
                            if (!((ConnectionFigure)dlcN.get(i)).getEndFigure().equals(f)) continue;
                            for (Figure g : connection) {
                                if (((ConnectionFigure)g).getStartFigure().equals(f)) {
                                    for (Figure h : keyAttribute) {
                                        if (!((ConnectionFigure)g).getEndFigure().equals((AtributoChaveFigure)h)) continue;
                                        ownerEntity2 = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                        ownerKey2 = h.toString();
                                        ownerKeyType2 = ((AtributoChaveFigure)h).getAttributeType().toString();
                                    }
                                    continue;
                                }
                                if (!((ConnectionFigure)g).getEndFigure().equals(f)) continue;
                                for (Figure h : keyAttribute) {
                                    if (!((ConnectionFigure)g).getStartFigure().equals((AtributoChaveFigure)h)) continue;
                                    ownerEntity2 = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                    ownerKey2 = h.toString();
                                    ownerKeyType2 = ((AtributoChaveFigure)h).getAttributeType().toString();
                                }
                            }
                        }
                        ++i;
                    }
                    mycontent = "\nALTER TABLE " + entRel + " ADD " + ownerKey + "_" + ownerEntity.toLowerCase() + " " + ownerKeyType + " NOT NULL";
                    mycontent2 = "\nALTER TABLE " + entRel + " ADD " + ownerKey2 + "_" + ownerEntity2.toLowerCase() + " " + ownerKeyType2 + " NOT NULL";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                    mycontent = "\nALTER TABLE " + entRel + " ADD CONSTRAINT FK_" + entRel + " FOREING KEY (" + ownerKey + "_" + ownerEntity.toLowerCase() + ") REFERENCES " + ownerEntity + " (" + ownerKey + ");\n";
                    mycontent2 = "\nALTER TABLE " + entRel + " ADD CONSTRAINT FK2_" + entRel + " FOREING KEY (" + ownerKey2 + "_" + ownerEntity2.toLowerCase() + ") REFERENCES " + ownerEntity2 + " (" + ownerKey2 + ");\n";
                    mycontent3 = "\nALTER TABLE " + entRel + " ADD CONSTRAINT PK_" + entRel + " PRIMARY KEY (" + ownerKey + "_" + ownerEntity.toLowerCase() + ", " + ownerKey2 + "_" + ownerEntity2.toLowerCase() + ");\n";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                }
                slcN.clear();
                dlcN.clear();
            }
        }
    }

    public void relationshipGenerator(ArrayList<Figure> strongEntity, ArrayList<Figure> connection, ArrayList<Figure> keyAttribute, ArrayList<Figure> singleLineConnectionUm, ArrayList<Figure> singleLineConnectionN, ArrayList<Figure> doubleLineConnectionUm, ArrayList<Figure> doubleLineConnectionN, ArrayList<Figure> relationship) {
        ArrayList<Figure> slcUm = new ArrayList<Figure>();
        ArrayList<Figure> slcN = new ArrayList<Figure>();
        ArrayList<Figure> dlcUm = new ArrayList<Figure>();
        ArrayList<Figure> dlcN = new ArrayList<Figure>();
        String ownerEntity = new String();
        String ownerKey = new String();
        String ownerKeyType = new String();
        String ownerEntity2 = new String();
        String ownerKey2 = new String();
        String ownerKeyType2 = new String();
        String mycontent = new String();
        String mycontent2 = new String();
        String mycontent3 = new String();
        String mycontent4 = new String();
        for (Figure a : relationship) {
            for (Figure b : singleLineConnectionUm) {
                if (((ConnectionFigure)b).getEndFigure().equals(a)) {
                    slcUm.add(b);
                }
                if (!((ConnectionFigure)b).getStartFigure().equals(a)) continue;
                slcUm.add(b);
            }
            for (Figure c : singleLineConnectionN) {
                if (((ConnectionFigure)c).getEndFigure().equals(a)) {
                    slcN.add(c);
                }
                if (!((ConnectionFigure)c).getStartFigure().equals(a)) continue;
                slcN.add(c);
            }
            for (Figure d : doubleLineConnectionUm) {
                if (((ConnectionFigure)d).getEndFigure().equals(a)) {
                    dlcUm.add(d);
                }
                if (!((ConnectionFigure)d).getStartFigure().equals(a)) continue;
                dlcUm.add(d);
            }
            for (Figure e : doubleLineConnectionN) {
                if (((ConnectionFigure)e).getEndFigure().equals(a)) {
                    dlcN.add(e);
                }
                if (!((ConnectionFigure)e).getStartFigure().equals(a)) continue;
                dlcN.add(e);
            }
            if (slcUm.size() == 2) {
                int i = 0;
                while (i < slcUm.size() - 1) {
                    for (Figure f : strongEntity) {
                        if (((ConnectionFigure)slcUm.get(i)).getStartFigure().equals(f)) {
                            for (Figure g : connection) {
                                if (((ConnectionFigure)g).getStartFigure().equals(f)) {
                                    for (Figure h : keyAttribute) {
                                        if (!((ConnectionFigure)g).getEndFigure().equals((AtributoChaveFigure)h)) continue;
                                        ownerEntity = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                        ownerKey = h.toString();
                                        ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                                    }
                                    continue;
                                }
                                if (!((ConnectionFigure)g).getEndFigure().equals(f)) continue;
                                for (Figure h : keyAttribute) {
                                    if (!((ConnectionFigure)g).getStartFigure().equals((AtributoChaveFigure)h)) continue;
                                    ownerEntity = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                    ownerKey = h.toString();
                                    ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                                }
                            }
                            continue;
                        }
                        if (!((ConnectionFigure)slcUm.get(i)).getEndFigure().equals(f)) continue;
                        for (Figure g : connection) {
                            if (((ConnectionFigure)g).getStartFigure().equals(f)) {
                                for (Figure h : keyAttribute) {
                                    if (!((ConnectionFigure)g).getEndFigure().equals((AtributoChaveFigure)h)) continue;
                                    ownerEntity = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                    ownerKey = h.toString();
                                    ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                                }
                                continue;
                            }
                            if (!((ConnectionFigure)g).getEndFigure().equals(f)) continue;
                            for (Figure h : keyAttribute) {
                                if (!((ConnectionFigure)g).getStartFigure().equals((AtributoChaveFigure)h)) continue;
                                ownerEntity = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                ownerKey = h.toString();
                                ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                            }
                        }
                    }
                    ++i;
                }
                i = 1;
                while (i < slcUm.size()) {
                    for (Figure f : strongEntity) {
                        if (((ConnectionFigure)slcUm.get(i)).getStartFigure().equals(f)) {
                            mycontent = "\nALTER TABLE " + f.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD " + ownerKey + "_" + ownerEntity.toLowerCase() + " " + ownerKeyType + ";\n";
                            mycontent2 = "ALTER TABLE " + f.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + f.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + ownerKey + "_" + ownerEntity.toLowerCase() + ") REFERENCES " + ownerEntity + " (" + ownerKey + ");\n";
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                            continue;
                        }
                        if (!((ConnectionFigure)slcUm.get(i)).getEndFigure().equals(f)) continue;
                        mycontent = "\nALTER TABLE " + f.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD " + ownerKey + "_" + ownerEntity.toLowerCase() + " " + ownerKeyType + ";\n";
                        mycontent2 = "ALTER TABLE " + f.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + f.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + ownerKey + "_" + ownerEntity.toLowerCase() + ") REFERENCES " + ownerEntity + " (" + ownerKey + ");\n";
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                    }
                    ++i;
                }
            } else if (slcUm.size() == 1) {
                int i = 0;
                while (i < slcUm.size()) {
                    for (Figure f : strongEntity) {
                        if (((ConnectionFigure)slcUm.get(i)).getStartFigure().equals(f)) {
                            for (Figure g : connection) {
                                if (((ConnectionFigure)g).getStartFigure().equals(f)) {
                                    for (Figure h : keyAttribute) {
                                        if (!((ConnectionFigure)g).getEndFigure().equals((AtributoChaveFigure)h)) continue;
                                        ownerEntity = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                        ownerKey = h.toString();
                                        ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                                    }
                                    continue;
                                }
                                if (!((ConnectionFigure)g).getEndFigure().equals(f)) continue;
                                for (Figure h : keyAttribute) {
                                    if (!((ConnectionFigure)g).getStartFigure().equals((AtributoChaveFigure)h)) continue;
                                    ownerEntity = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                    ownerKey = h.toString();
                                    ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                                }
                            }
                            continue;
                        }
                        if (!((ConnectionFigure)slcUm.get(i)).getEndFigure().equals(f)) continue;
                        for (Figure g : connection) {
                            if (((ConnectionFigure)g).getStartFigure().equals(f)) {
                                for (Figure h : keyAttribute) {
                                    if (!((ConnectionFigure)g).getEndFigure().equals((AtributoChaveFigure)h)) continue;
                                    ownerEntity = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                    ownerKey = h.toString();
                                    ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                                }
                                continue;
                            }
                            if (!((ConnectionFigure)g).getEndFigure().equals(f)) continue;
                            for (Figure h : keyAttribute) {
                                if (!((ConnectionFigure)g).getStartFigure().equals((AtributoChaveFigure)h)) continue;
                                ownerEntity = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                ownerKey = h.toString();
                                ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                            }
                        }
                    }
                    ++i;
                }
                if (dlcUm.size() > 0) {
                    i = 0;
                    while (i < dlcUm.size()) {
                        for (Figure f : strongEntity) {
                            if (((ConnectionFigure)dlcUm.get(i)).getStartFigure().equals(f)) {
                                mycontent = "\nALTER TABLE " + f.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD " + ownerKey + "_" + ownerEntity.toLowerCase() + " " + ownerKeyType + " NOT NULL;\n";
                                mycontent2 = "ALTER TABLE " + f.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + f.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + ownerKey + "_" + ownerEntity.toLowerCase() + ") REFERENCES " + ownerEntity + " (" + ownerKey + ");\n";
                                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                                continue;
                            }
                            if (!((ConnectionFigure)dlcUm.get(i)).getEndFigure().equals(f)) continue;
                            mycontent = "\nALTER TABLE " + f.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD " + ownerKey + "_" + ownerEntity.toLowerCase() + " " + ownerKeyType + " NOT NULL;\n";
                            mycontent2 = "ALTER TABLE " + f.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + f.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + ownerKey + "_" + ownerEntity.toLowerCase() + ") REFERENCES " + ownerEntity + " (" + ownerKey + ");\n";
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                        }
                        ++i;
                    }
                } else if (slcN.size() > 0) {
                    i = 0;
                    while (i < slcN.size()) {
                        for (Figure f : strongEntity) {
                            if (((ConnectionFigure)slcN.get(i)).getStartFigure().equals(f)) {
                                mycontent = "\nALTER TABLE " + f.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD " + ownerKey + "_" + ownerEntity.toLowerCase() + " " + ownerKeyType + ";\n";
                                mycontent2 = "ALTER TABLE " + f.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + f.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + ownerKey + "_" + ownerEntity.toLowerCase() + ") REFERENCES " + ownerEntity + " (" + ownerKey + ");\n";
                                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                                continue;
                            }
                            if (!((ConnectionFigure)slcN.get(i)).getEndFigure().equals(f)) continue;
                            mycontent = "\nALTER TABLE " + f.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD " + ownerKey + "_" + ownerEntity.toLowerCase() + " " + ownerKeyType + ";\n";
                            mycontent2 = "ALTER TABLE " + f.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + f.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + ownerKey + "_" + ownerEntity.toLowerCase() + ") REFERENCES " + ownerEntity + " (" + ownerKey + ");\n";
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                        }
                        ++i;
                    }
                } else if (dlcN.size() > 0) {
                    i = 0;
                    while (i < dlcN.size()) {
                        for (Figure f : strongEntity) {
                            if (((ConnectionFigure)dlcN.get(i)).getStartFigure().equals(f)) {
                                mycontent = "\nALTER TABLE " + f.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD " + ownerKey + "_" + ownerEntity.toLowerCase() + " " + ownerKeyType + " NOT NULL;\n";
                                mycontent2 = "ALTER TABLE " + f.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + f.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + ownerKey + "_" + ownerEntity.toLowerCase() + ") REFERENCES " + ownerEntity + " (" + ownerKey + ");\n";
                                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                                continue;
                            }
                            if (!((ConnectionFigure)dlcN.get(i)).getEndFigure().equals(f)) continue;
                            mycontent = "\nALTER TABLE " + f.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD " + ownerKey + "_" + ownerEntity.toLowerCase() + " " + ownerKeyType + " NOT NULL;\n";
                            mycontent2 = "ALTER TABLE " + f.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + f.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + ownerKey + "_" + ownerEntity.toLowerCase() + ") REFERENCES " + ownerEntity + " (" + ownerKey + ");\n";
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                        }
                        ++i;
                    }
                }
            } else if (dlcUm.size() > 0) {
                if (dlcUm.size() == 2) {
                    int i = 0;
                    while (i < dlcUm.size() - 1) {
                        for (Figure f : strongEntity) {
                            if (((ConnectionFigure)dlcUm.get(i)).getStartFigure().equals(f)) {
                                for (Figure g : connection) {
                                    if (((ConnectionFigure)g).getStartFigure().equals(f)) {
                                        for (Figure h : keyAttribute) {
                                            if (!((ConnectionFigure)g).getEndFigure().equals((AtributoChaveFigure)h)) continue;
                                            ownerEntity = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                            ownerKey = h.toString();
                                            ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                                        }
                                        continue;
                                    }
                                    if (!((ConnectionFigure)g).getEndFigure().equals(f)) continue;
                                    for (Figure h : keyAttribute) {
                                        if (!((ConnectionFigure)g).getStartFigure().equals((AtributoChaveFigure)h)) continue;
                                        ownerEntity = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                        ownerKey = h.toString();
                                        ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                                    }
                                }
                                continue;
                            }
                            if (!((ConnectionFigure)dlcUm.get(i)).getEndFigure().equals(f)) continue;
                            for (Figure g : connection) {
                                if (((ConnectionFigure)g).getStartFigure().equals(f)) {
                                    for (Figure h : keyAttribute) {
                                        if (!((ConnectionFigure)g).getEndFigure().equals((AtributoChaveFigure)h)) continue;
                                        ownerEntity = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                        ownerKey = h.toString();
                                        ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                                    }
                                    continue;
                                }
                                if (!((ConnectionFigure)g).getEndFigure().equals(f)) continue;
                                for (Figure h : keyAttribute) {
                                    if (!((ConnectionFigure)g).getStartFigure().equals((AtributoChaveFigure)h)) continue;
                                    ownerEntity = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                    ownerKey = h.toString();
                                    ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                                }
                            }
                        }
                        ++i;
                    }
                    i = 1;
                    while (i < dlcUm.size()) {
                        for (Figure f : strongEntity) {
                            if (((ConnectionFigure)dlcUm.get(i)).getStartFigure().equals(f)) {
                                for (Figure g : connection) {
                                    if (((ConnectionFigure)g).getStartFigure().equals(f)) {
                                        for (Figure h : keyAttribute) {
                                            if (!((ConnectionFigure)g).getEndFigure().equals((AtributoChaveFigure)h)) continue;
                                            ownerEntity2 = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                            ownerKey2 = h.toString();
                                            ownerKeyType2 = ((AtributoChaveFigure)h).getAttributeType().toString();
                                        }
                                        continue;
                                    }
                                    if (!((ConnectionFigure)g).getEndFigure().equals(f)) continue;
                                    for (Figure h : keyAttribute) {
                                        if (!((ConnectionFigure)g).getStartFigure().equals((AtributoChaveFigure)h)) continue;
                                        ownerEntity2 = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                        ownerKey2 = h.toString();
                                        ownerKeyType2 = ((AtributoChaveFigure)h).getAttributeType().toString();
                                    }
                                }
                                continue;
                            }
                            if (!((ConnectionFigure)dlcUm.get(i)).getEndFigure().equals(f)) continue;
                            for (Figure g : connection) {
                                if (((ConnectionFigure)g).getStartFigure().equals(f)) {
                                    for (Figure h : keyAttribute) {
                                        if (!((ConnectionFigure)g).getEndFigure().equals((AtributoChaveFigure)h)) continue;
                                        ownerEntity2 = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                        ownerKey2 = h.toString();
                                        ownerKeyType2 = ((AtributoChaveFigure)h).getAttributeType().toString();
                                    }
                                    continue;
                                }
                                if (!((ConnectionFigure)g).getEndFigure().equals(f)) continue;
                                for (Figure h : keyAttribute) {
                                    if (!((ConnectionFigure)g).getStartFigure().equals((AtributoChaveFigure)h)) continue;
                                    ownerEntity2 = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                    ownerKey2 = h.toString();
                                    ownerKeyType2 = ((AtributoChaveFigure)h).getAttributeType().toString();
                                }
                            }
                        }
                        ++i;
                    }
                    mycontent = "\nCREATE TABLE " + ownerEntity + "_" + ownerEntity2 + "(\n\t" + ownerKey + "_" + ownerEntity.toLowerCase() + " " + ownerKeyType + " NOT NULL,\n\t" + ownerKey2 + "_" + ownerEntity2.toLowerCase() + " " + ownerKeyType2 + " NOT NULL\n);\n";
                    mycontent2 = "\nALTER TABLE " + ownerEntity + "_" + ownerEntity2 + " ADD CONSTRAINT FK_" + ownerEntity + "_" + ownerEntity2 + " FOREING KEY (" + ownerKey + "_" + ownerEntity.toLowerCase() + ") REFERENCES " + ownerEntity + " (" + ownerKey + ");\n";
                    mycontent3 = "\nALTER TABLE " + ownerEntity + "_" + ownerEntity2 + " ADD CONSTRAINT FK2_" + ownerEntity + "_" + ownerEntity2 + " FOREING KEY (" + ownerKey2 + "_" + ownerEntity2.toLowerCase() + ") REFERENCES " + ownerEntity2 + " (" + ownerKey2 + ");\n";
                    mycontent4 = "\nALTER TABLE " + ownerEntity + "_" + ownerEntity2 + " ADD CONSTRAINT PK_" + ownerEntity + "_" + ownerEntity2 + " PRIMARY KEY (" + ownerKey + "_" + ownerEntity.toLowerCase() + ", " + ownerKey2 + "_" + ownerEntity2.toLowerCase() + ");\n";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent4;
                } else if (dlcUm.size() == 1) {
                    int i = 0;
                    while (i < dlcUm.size()) {
                        for (Figure f : strongEntity) {
                            if (((ConnectionFigure)dlcUm.get(i)).getStartFigure().equals(f)) {
                                for (Figure g : connection) {
                                    if (((ConnectionFigure)g).getStartFigure().equals(f)) {
                                        for (Figure h : keyAttribute) {
                                            if (!((ConnectionFigure)g).getEndFigure().equals((AtributoChaveFigure)h)) continue;
                                            ownerEntity = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                            ownerKey = h.toString();
                                            ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                                        }
                                        continue;
                                    }
                                    if (!((ConnectionFigure)g).getEndFigure().equals(f)) continue;
                                    for (Figure h : keyAttribute) {
                                        if (!((ConnectionFigure)g).getStartFigure().equals((AtributoChaveFigure)h)) continue;
                                        ownerEntity = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                        ownerKey = h.toString();
                                        ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                                    }
                                }
                                continue;
                            }
                            if (!((ConnectionFigure)dlcUm.get(i)).getEndFigure().equals(f)) continue;
                            for (Figure g : connection) {
                                if (((ConnectionFigure)g).getStartFigure().equals(f)) {
                                    for (Figure h : keyAttribute) {
                                        if (!((ConnectionFigure)g).getEndFigure().equals((AtributoChaveFigure)h)) continue;
                                        ownerEntity = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                        ownerKey = h.toString();
                                        ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                                    }
                                    continue;
                                }
                                if (!((ConnectionFigure)g).getEndFigure().equals(f)) continue;
                                for (Figure h : keyAttribute) {
                                    if (!((ConnectionFigure)g).getStartFigure().equals((AtributoChaveFigure)h)) continue;
                                    ownerEntity = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                    ownerKey = h.toString();
                                    ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                                }
                            }
                        }
                        ++i;
                    }
                    if (dlcN.size() > 0) {
                        int j = 0;
                        while (j < dlcN.size()) {
                            for (Figure k : strongEntity) {
                                if (((ConnectionFigure)dlcN.get(j)).getStartFigure().equals(k)) {
                                    ownerEntity2 = k.toString().toUpperCase().replaceAll("\\s+", "_");
                                    continue;
                                }
                                if (!((ConnectionFigure)dlcN.get(j)).getEndFigure().equals(k)) continue;
                                ownerEntity2 = k.toString().toUpperCase().replaceAll("\\s+", "_");
                            }
                            ++j;
                        }
                    }
                    mycontent = "\nALTER TABLE " + ownerEntity2 + " ADD " + ownerKey + "_" + ownerEntity.toLowerCase() + " " + ownerKeyType + " NOT NULL;\n";
                    mycontent2 = "\nALTER TABLE " + ownerEntity2 + " ADD CONSTRAINT FK_" + ownerEntity2 + " FOREING KEY (" + ownerKey + "_" + ownerEntity.toLowerCase() + ") REFERENCES " + ownerEntity + " (" + ownerKey + ") INITIALLY DEFERRED DEFERREABLE;\n";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                    mycontent = "\nCREATE OR REPLACE TRIGGER relTrigger_" + ownerEntity + " AFTER INSERT OR DELETE OR UPDATE ON " + ownerEntity + "\nREFERENCING NEW AS n OLD AS o FOR EACH ROW\nDECLARE X number;\nBEGIN\n\tIF INSERTING THEN";
                    mycontent2 = "\n\t\tSELECT COUNT (*) INTO X FROM " + ownerEntity2 + " c WHERE c." + ownerKey + "_" + ownerEntity.toLowerCase() + " = :n." + ownerKey + "_" + ownerEntity.toLowerCase() + ";\n\t\tIF (X = 0) THEN RAISE_APPLICATION_ERROR(-20000, 'Violacao detectada!'); END IF;\n\tELSEIF UPDATING THEN\n\t\tIF(:n." + ownerKey + "_" + ownerEntity.toLowerCase() + " != :o." + ownerKey + "_" + ownerEntity.toLowerCase() + ") THEN";
                    mycontent3 = "\n\t\t\tSELECT COUNT (*) INTO X FROM " + ownerEntity2 + " c WHERE c." + ownerKey + "_" + ownerEntity.toLowerCase() + " = :o." + ownerKey + "_" + ownerEntity.toLowerCase() + ";\n\t\t\tIF (X != 0) THEN RAISE_APPLICATION_ERROR(-20001, 'Violacao detectada!'); END IF;";
                    mycontent4 = "\n\t\t\tSELECT COUNT (*) INTO X FROM " + ownerEntity2 + " c WHERE c." + ownerKey + "_" + ownerEntity.toLowerCase() + " = :n." + ownerKey + "_" + ownerEntity.toLowerCase() + ";\n\t\t\tIF (X = 0) THEN RAISE_APPLICATION_ERROR(-20002, 'Violacao detectada!'); END IF;\n\t\tEND IF;\n\tELSEIF DELETING THEN";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent4;
                    mycontent = "\n\t\t\tSELECT COUNT (*) INTO X FROM " + ownerEntity2 + " c WHERE c." + ownerKey + "_" + ownerEntity.toLowerCase() + " = :o." + ownerKey + "_" + ownerEntity.toLowerCase() + ";\n\t\tIF (X != 0) THEN RAISE_APPLICATION_ERROR(-20003, 'Violacao detectada!'); END IF;\n\tEND IF\nEND;\n";
                    mycontent2 = "\nCREATE OR REPLACE TRIGGER relTrigger_" + ownerEntity2 + " AFTER INSERT OR DELETE OR UPDATE ON " + ownerEntity2 + "\nREFERENCING NEW AS n OLD AS o FOR EACH ROW\nDECLARE Y number; PRAGMA AUTONOMOUS_TRANSACTION;\nBEGIN\n\tIF DELETING THEN";
                    mycontent3 = "\n\t\tSELECT COUNT (*) INTO Y FROM " + ownerEntity2 + " c WHERE c." + ownerKey + "_" + ownerEntity.toLowerCase() + " = :o." + ownerKey + "_" + ownerEntity.toLowerCase() + ";\n\t\tIF (Y != 0) THEN RAISE_APPLICATION_ERROR(-20004, 'Violacao detectada!'); END IF;\n\tELSEIF UPDATING THEN\n\t\tIF(:o." + ownerKey + "_" + ownerEntity.toLowerCase() + " != :n." + ownerKey + "_" + ownerEntity.toLowerCase() + ") THEN";
                    mycontent4 = "\n\t\t\tSELECT COUNT (*) INTO Y FROM " + ownerEntity2 + " c WHERE c." + ownerKey + "_" + ownerEntity.toLowerCase() + " = :o." + ownerKey + "_" + ownerEntity.toLowerCase() + ";\n\t\t\tIF (Y != 0) THEN RAISE_APPLICATION_ERROR(-20005, 'Violacao detectada!'); END IF;\n\t\tEND IF;\n\tEND IF;\nEND;";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent4;
                }
            } else if (slcN.size() == 2) {
                int i = 0;
                while (i < slcN.size() - 1) {
                    for (Figure f : strongEntity) {
                        if (((ConnectionFigure)slcN.get(i)).getStartFigure().equals(f)) {
                            for (Figure g : connection) {
                                if (((ConnectionFigure)g).getStartFigure().equals(f)) {
                                    for (Figure h : keyAttribute) {
                                        if (!((ConnectionFigure)g).getEndFigure().equals((AtributoChaveFigure)h)) continue;
                                        ownerEntity = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                        ownerKey = h.toString();
                                        ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                                    }
                                    continue;
                                }
                                if (!((ConnectionFigure)g).getEndFigure().equals(f)) continue;
                                for (Figure h : keyAttribute) {
                                    if (!((ConnectionFigure)g).getStartFigure().equals((AtributoChaveFigure)h)) continue;
                                    ownerEntity = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                    ownerKey = h.toString();
                                    ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                                }
                            }
                            continue;
                        }
                        if (!((ConnectionFigure)slcN.get(i)).getEndFigure().equals(f)) continue;
                        for (Figure g : connection) {
                            if (((ConnectionFigure)g).getStartFigure().equals(f)) {
                                for (Figure h : keyAttribute) {
                                    if (!((ConnectionFigure)g).getEndFigure().equals((AtributoChaveFigure)h)) continue;
                                    ownerEntity = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                    ownerKey = h.toString();
                                    ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                                }
                                continue;
                            }
                            if (!((ConnectionFigure)g).getEndFigure().equals(f)) continue;
                            for (Figure h : keyAttribute) {
                                if (!((ConnectionFigure)g).getStartFigure().equals((AtributoChaveFigure)h)) continue;
                                ownerEntity = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                ownerKey = h.toString();
                                ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                            }
                        }
                    }
                    ++i;
                }
                i = 1;
                while (i < slcN.size()) {
                    for (Figure f : strongEntity) {
                        if (((ConnectionFigure)slcN.get(i)).getStartFigure().equals(f)) {
                            for (Figure g : connection) {
                                if (((ConnectionFigure)g).getStartFigure().equals(f)) {
                                    for (Figure h : keyAttribute) {
                                        if (!((ConnectionFigure)g).getEndFigure().equals((AtributoChaveFigure)h)) continue;
                                        ownerEntity2 = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                        ownerKey2 = h.toString();
                                        ownerKeyType2 = ((AtributoChaveFigure)h).getAttributeType().toString();
                                    }
                                    continue;
                                }
                                if (!((ConnectionFigure)g).getEndFigure().equals(f)) continue;
                                for (Figure h : keyAttribute) {
                                    if (!((ConnectionFigure)g).getStartFigure().equals((AtributoChaveFigure)h)) continue;
                                    ownerEntity2 = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                    ownerKey2 = h.toString();
                                    ownerKeyType2 = ((AtributoChaveFigure)h).getAttributeType().toString();
                                }
                            }
                            continue;
                        }
                        if (!((ConnectionFigure)slcN.get(i)).getEndFigure().equals(f)) continue;
                        for (Figure g : connection) {
                            if (((ConnectionFigure)g).getStartFigure().equals(f)) {
                                for (Figure h : keyAttribute) {
                                    if (!((ConnectionFigure)g).getEndFigure().equals((AtributoChaveFigure)h)) continue;
                                    ownerEntity2 = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                    ownerKey2 = h.toString();
                                    ownerKeyType2 = ((AtributoChaveFigure)h).getAttributeType().toString();
                                }
                                continue;
                            }
                            if (!((ConnectionFigure)g).getEndFigure().equals(f)) continue;
                            for (Figure h : keyAttribute) {
                                if (!((ConnectionFigure)g).getStartFigure().equals((AtributoChaveFigure)h)) continue;
                                ownerEntity2 = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                ownerKey2 = h.toString();
                                ownerKeyType2 = ((AtributoChaveFigure)h).getAttributeType().toString();
                            }
                        }
                    }
                    ++i;
                }
                mycontent = "\nCREATE TABLE " + ownerEntity + "_" + ownerEntity2 + "(\n\t" + ownerKey + "_" + ownerEntity.toLowerCase() + " " + ownerKeyType + " NOT NULL,\n\t" + ownerKey2 + "_" + ownerEntity2.toLowerCase() + " " + ownerKeyType2 + " NOT NULL\n);\n";
                mycontent2 = "\nALTER TABLE " + ownerEntity + "_" + ownerEntity2 + " ADD CONSTRAINT FK_" + ownerEntity + "_" + ownerEntity2 + " FOREING KEY (" + ownerKey + "_" + ownerEntity.toLowerCase() + ") REFERENCES " + ownerEntity + " (" + ownerKey + ");\n";
                mycontent3 = "\nALTER TABLE " + ownerEntity + "_" + ownerEntity2 + " ADD CONSTRAINT FK2_" + ownerEntity + "_" + ownerEntity2 + " FOREING KEY (" + ownerKey2 + "_" + ownerEntity2.toLowerCase() + ") REFERENCES " + ownerEntity2 + " (" + ownerKey2 + ");\n";
                mycontent4 = "\nALTER TABLE " + ownerEntity + "_" + ownerEntity2 + " ADD CONSTRAINT PK_" + ownerEntity + "_" + ownerEntity2 + " PRIMARY KEY (" + ownerKey + "_" + ownerEntity.toLowerCase() + ", " + ownerKey2 + "_" + ownerEntity2.toLowerCase() + ");\n";
                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent4;
            } else if (slcN.size() == 1 && dlcN.size() == 1) {
                int i = 0;
                while (i < slcN.size()) {
                    for (Figure f : strongEntity) {
                        if (((ConnectionFigure)slcN.get(i)).getStartFigure().equals(f)) {
                            for (Figure g : connection) {
                                if (((ConnectionFigure)g).getStartFigure().equals(f)) {
                                    for (Figure h : keyAttribute) {
                                        if (!((ConnectionFigure)g).getEndFigure().equals((AtributoChaveFigure)h)) continue;
                                        ownerEntity = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                        ownerKey = h.toString();
                                        ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                                    }
                                    continue;
                                }
                                if (!((ConnectionFigure)g).getEndFigure().equals(f)) continue;
                                for (Figure h : keyAttribute) {
                                    if (!((ConnectionFigure)g).getStartFigure().equals((AtributoChaveFigure)h)) continue;
                                    ownerEntity = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                    ownerKey = h.toString();
                                    ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                                }
                            }
                            continue;
                        }
                        if (!((ConnectionFigure)slcN.get(i)).getEndFigure().equals(f)) continue;
                        for (Figure g : connection) {
                            if (((ConnectionFigure)g).getStartFigure().equals(f)) {
                                for (Figure h : keyAttribute) {
                                    if (!((ConnectionFigure)g).getEndFigure().equals((AtributoChaveFigure)h)) continue;
                                    ownerEntity = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                    ownerKey = h.toString();
                                    ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                                }
                                continue;
                            }
                            if (!((ConnectionFigure)g).getEndFigure().equals(f)) continue;
                            for (Figure h : keyAttribute) {
                                if (!((ConnectionFigure)g).getStartFigure().equals((AtributoChaveFigure)h)) continue;
                                ownerEntity = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                ownerKey = h.toString();
                                ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                            }
                        }
                    }
                    ++i;
                }
                i = 0;
                while (i < dlcN.size()) {
                    for (Figure f : strongEntity) {
                        if (((ConnectionFigure)dlcN.get(i)).getStartFigure().equals(f)) {
                            for (Figure g : connection) {
                                if (((ConnectionFigure)g).getStartFigure().equals(f)) {
                                    for (Figure h : keyAttribute) {
                                        if (!((ConnectionFigure)g).getEndFigure().equals((AtributoChaveFigure)h)) continue;
                                        ownerEntity2 = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                        ownerKey2 = h.toString();
                                        ownerKeyType2 = ((AtributoChaveFigure)h).getAttributeType().toString();
                                    }
                                    continue;
                                }
                                if (!((ConnectionFigure)g).getEndFigure().equals(f)) continue;
                                for (Figure h : keyAttribute) {
                                    if (!((ConnectionFigure)g).getStartFigure().equals((AtributoChaveFigure)h)) continue;
                                    ownerEntity2 = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                    ownerKey2 = h.toString();
                                    ownerKeyType2 = ((AtributoChaveFigure)h).getAttributeType().toString();
                                }
                            }
                            continue;
                        }
                        if (!((ConnectionFigure)dlcN.get(i)).getEndFigure().equals(f)) continue;
                        for (Figure g : connection) {
                            if (((ConnectionFigure)g).getStartFigure().equals(f)) {
                                for (Figure h : keyAttribute) {
                                    if (!((ConnectionFigure)g).getEndFigure().equals((AtributoChaveFigure)h)) continue;
                                    ownerEntity2 = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                    ownerKey2 = h.toString();
                                    ownerKeyType2 = ((AtributoChaveFigure)h).getAttributeType().toString();
                                }
                                continue;
                            }
                            if (!((ConnectionFigure)g).getEndFigure().equals(f)) continue;
                            for (Figure h : keyAttribute) {
                                if (!((ConnectionFigure)g).getStartFigure().equals((AtributoChaveFigure)h)) continue;
                                ownerEntity2 = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                ownerKey2 = h.toString();
                                ownerKeyType2 = ((AtributoChaveFigure)h).getAttributeType().toString();
                            }
                        }
                    }
                    ++i;
                }
                mycontent = "\nCREATE TABLE " + ownerEntity + "_" + ownerEntity2 + "(\n\t" + ownerKey + "_" + ownerEntity.toLowerCase() + " " + ownerKeyType + " NOT NULL,\n\t" + ownerKey2 + "_" + ownerEntity2.toLowerCase() + " " + ownerKeyType2 + " NOT NULL\n);\n";
                mycontent2 = "\nALTER TABLE " + ownerEntity + "_" + ownerEntity2 + " ADD CONSTRAINT FK_" + ownerEntity + "_" + ownerEntity2 + " FOREING KEY (" + ownerKey + "_" + ownerEntity.toLowerCase() + ") REFERENCES " + ownerEntity + " (" + ownerKey + ");\n";
                mycontent3 = "\nALTER TABLE " + ownerEntity + "_" + ownerEntity2 + " ADD CONSTRAINT FK2_" + ownerEntity + "_" + ownerEntity2 + " FOREING KEY (" + ownerKey2 + "_" + ownerEntity2.toLowerCase() + ") REFERENCES " + ownerEntity2 + " (" + ownerKey2 + ");\n";
                mycontent4 = "\nALTER TABLE " + ownerEntity + "_" + ownerEntity2 + " ADD CONSTRAINT PK_" + ownerEntity + "_" + ownerEntity2 + " PRIMARY KEY (" + ownerKey + "_" + ownerEntity.toLowerCase() + ", " + ownerKey2 + "_" + ownerEntity2.toLowerCase() + ");\n";
                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent4;
            } else if (dlcN.size() == 2) {
                int i = 0;
                while (i < dlcN.size() - 1) {
                    for (Figure f : strongEntity) {
                        if (((ConnectionFigure)dlcN.get(i)).getStartFigure().equals(f)) {
                            for (Figure g : connection) {
                                if (((ConnectionFigure)g).getStartFigure().equals(f)) {
                                    for (Figure h : keyAttribute) {
                                        if (!((ConnectionFigure)g).getEndFigure().equals((AtributoChaveFigure)h)) continue;
                                        ownerEntity = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                        ownerKey = h.toString();
                                        ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                                    }
                                    continue;
                                }
                                if (!((ConnectionFigure)g).getEndFigure().equals(f)) continue;
                                for (Figure h : keyAttribute) {
                                    if (!((ConnectionFigure)g).getStartFigure().equals((AtributoChaveFigure)h)) continue;
                                    ownerEntity = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                    ownerKey = h.toString();
                                    ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                                }
                            }
                            continue;
                        }
                        if (!((ConnectionFigure)dlcN.get(i)).getEndFigure().equals(f)) continue;
                        for (Figure g : connection) {
                            if (((ConnectionFigure)g).getStartFigure().equals(f)) {
                                for (Figure h : keyAttribute) {
                                    if (!((ConnectionFigure)g).getEndFigure().equals((AtributoChaveFigure)h)) continue;
                                    ownerEntity = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                    ownerKey = h.toString();
                                    ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                                }
                                continue;
                            }
                            if (!((ConnectionFigure)g).getEndFigure().equals(f)) continue;
                            for (Figure h : keyAttribute) {
                                if (!((ConnectionFigure)g).getStartFigure().equals((AtributoChaveFigure)h)) continue;
                                ownerEntity = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                ownerKey = h.toString();
                                ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                            }
                        }
                    }
                    ++i;
                }
                i = 1;
                while (i < dlcN.size()) {
                    for (Figure f : strongEntity) {
                        if (((ConnectionFigure)dlcN.get(i)).getStartFigure().equals(f)) {
                            for (Figure g : connection) {
                                if (((ConnectionFigure)g).getStartFigure().equals(f)) {
                                    for (Figure h : keyAttribute) {
                                        if (!((ConnectionFigure)g).getEndFigure().equals((AtributoChaveFigure)h)) continue;
                                        ownerEntity2 = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                        ownerKey2 = h.toString();
                                        ownerKeyType2 = ((AtributoChaveFigure)h).getAttributeType().toString();
                                    }
                                    continue;
                                }
                                if (!((ConnectionFigure)g).getEndFigure().equals(f)) continue;
                                for (Figure h : keyAttribute) {
                                    if (!((ConnectionFigure)g).getStartFigure().equals((AtributoChaveFigure)h)) continue;
                                    ownerEntity2 = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                    ownerKey2 = h.toString();
                                    ownerKeyType2 = ((AtributoChaveFigure)h).getAttributeType().toString();
                                }
                            }
                            continue;
                        }
                        if (!((ConnectionFigure)dlcN.get(i)).getEndFigure().equals(f)) continue;
                        for (Figure g : connection) {
                            if (((ConnectionFigure)g).getStartFigure().equals(f)) {
                                for (Figure h : keyAttribute) {
                                    if (!((ConnectionFigure)g).getEndFigure().equals((AtributoChaveFigure)h)) continue;
                                    ownerEntity2 = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                    ownerKey2 = h.toString();
                                    ownerKeyType2 = ((AtributoChaveFigure)h).getAttributeType().toString();
                                }
                                continue;
                            }
                            if (!((ConnectionFigure)g).getEndFigure().equals(f)) continue;
                            for (Figure h : keyAttribute) {
                                if (!((ConnectionFigure)g).getStartFigure().equals((AtributoChaveFigure)h)) continue;
                                ownerEntity2 = f.toString().toUpperCase().replaceAll("\\s+", "_");
                                ownerKey2 = h.toString();
                                ownerKeyType2 = ((AtributoChaveFigure)h).getAttributeType().toString();
                            }
                        }
                    }
                    ++i;
                }
                mycontent = "\nCREATE TABLE " + ownerEntity + "_" + ownerEntity2 + "(\n\t" + ownerKey + "_" + ownerEntity.toLowerCase() + " " + ownerKeyType + " NOT NULL,\n\t" + ownerKey2 + "_" + ownerEntity2.toLowerCase() + " " + ownerKeyType2 + " NOT NULL\n);\n";
                mycontent2 = "\nALTER TABLE " + ownerEntity + "_" + ownerEntity2 + " ADD CONSTRAINT FK_" + ownerEntity + "_" + ownerEntity2 + " FOREING KEY (" + ownerKey + "_" + ownerEntity.toLowerCase() + ") REFERENCES " + ownerEntity + " (" + ownerKey + ");\n";
                mycontent3 = "\nALTER TABLE " + ownerEntity + "_" + ownerEntity2 + " ADD CONSTRAINT FK2_" + ownerEntity + "_" + ownerEntity2 + " FOREING KEY (" + ownerKey2 + "_" + ownerEntity2.toLowerCase() + ") REFERENCES " + ownerEntity2 + " (" + ownerKey2 + ");\n";
                mycontent4 = "\nALTER TABLE " + ownerEntity + "_" + ownerEntity2 + " ADD CONSTRAINT PK_" + ownerEntity + "_" + ownerEntity2 + " PRIMARY KEY (" + ownerKey + "_" + ownerEntity.toLowerCase() + ", " + ownerKey2 + "_" + ownerEntity2.toLowerCase() + ");\n";
                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent4;
            }
            slcUm.clear();
            slcN.clear();
            dlcUm.clear();
            dlcN.clear();
        }
    }

    private void generateMultivaluedAttribute(ArrayList<Figure> strongEntity, ArrayList<Figure> weakEntity, ArrayList<Figure> weakRelationship, ArrayList<Figure> entityRelationship, ArrayList<Figure> connection, ArrayList<Figure> keyAttribute, ArrayList<Figure> partialKeyAttribute, ArrayList<Figure> multivaluedAttribute, ArrayList<Figure> singleLineConnectionUm, ArrayList<Figure> singleLineConnectionN, ArrayList<Figure> doubleLineConnectionUm, ArrayList<Figure> doubleLineConnectionN) {
        ArrayList<Figure> lineconnectors = new ArrayList<Figure>();
        lineconnectors.addAll(singleLineConnectionUm);
        lineconnectors.addAll(singleLineConnectionN);
        lineconnectors.addAll(doubleLineConnectionUm);
        lineconnectors.addAll(doubleLineConnectionN);
        ArrayList<Figure> slcN = new ArrayList<Figure>();
        ArrayList<Figure> dlcN = new ArrayList<Figure>();
        String entRel = new String();
        String partialKey = new String();
        String partialKeyType = new String();
        String ownerEntity = new String();
        String ownerKey = new String();
        String ownerKeyType = new String();
        String ownerEntity2 = new String();
        String ownerKey2 = new String();
        String ownerKeyType2 = new String();
        String mycontent = new String();
        String mycontent2 = new String();
        String mycontent3 = new String();
        boolean done = false;
        for (Figure a : strongEntity) {
            for (Figure b : connection) {
                if (((ConnectionFigure)b).getStartFigure().equals((EntidadeFigure)a)) {
                    for (Figure figure : keyAttribute) {
                        if (!((ConnectionFigure)b).getEndFigure().equals((AtributoChaveFigure)figure)) continue;
                        ownerEntity = a.toString().toUpperCase().replaceAll("\\s+", "_");
                        ownerKey = figure.toString();
                        ownerKeyType = ((AtributoChaveFigure)figure).getAttributeType().toString();
                    }
                    for (Figure figure : multivaluedAttribute) {
                        if (!((ConnectionFigure)b).getEndFigure().equals((AtributoMultivaloradoFigure)figure)) continue;
                        mycontent = "\nCREATE TABLE " + ownerEntity + "_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + "(";
                        mycontent2 = "\n\t" + ownerKey + " " + ownerKeyType + " NOT NULL,\n\tpk-" + figure.toString().toLowerCase().replaceAll("\\s+", "_") + " NUMBER NOT NULL,";
                        mycontent3 = "\n\t" + figure.toString().toLowerCase().replaceAll("\\s+", "_") + " " + (Object)((Object)((AtributoMultivaloradoFigure)figure).getAttributeType()) + " " + (!((AtributoMultivaloradoFigure)figure).isNullable() ? "NOT NULL" : "") + "\n);\n";
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                        mycontent = "\nALTER TABLE " + ownerEntity + "_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT PK_" + ownerEntity + "_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + " PRIMARY KEY (pk-" + figure.toString().toLowerCase().replaceAll("\\s+", "_") + ");\n";
                        mycontent2 = "ALTER TABLE " + ownerEntity + "_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + ownerEntity + "_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + ownerKey + ") REFERENCES " + ownerEntity + " (" + ownerKey + ");\n";
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                    }
                    continue;
                }
                if (!((ConnectionFigure)b).getEndFigure().equals((EntidadeFigure)a)) continue;
                for (Figure figure : keyAttribute) {
                    if (!((ConnectionFigure)b).getStartFigure().equals((AtributoChaveFigure)figure)) continue;
                    ownerEntity = a.toString().toUpperCase().replaceAll("\\s+", "_");
                    ownerKey = figure.toString();
                    ownerKeyType = ((AtributoChaveFigure)figure).getAttributeType().toString();
                }
                for (Figure figure : multivaluedAttribute) {
                    if (!((ConnectionFigure)b).getStartFigure().equals((AtributoMultivaloradoFigure)figure)) continue;
                    mycontent = "\nCREATE TABLE " + ownerEntity + "_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + "(";
                    mycontent2 = "\n\t" + ownerKey + " " + ownerKeyType + " NOT NULL,\n\tpk-" + figure.toString().toLowerCase().replaceAll("\\s+", "_") + " NUMBER NOT NULL,";
                    mycontent3 = "\n\t" + figure.toString().toLowerCase().replaceAll("\\s+", "_") + " " + (Object)((Object)((AtributoMultivaloradoFigure)figure).getAttributeType()) + " " + (!((AtributoMultivaloradoFigure)figure).isNullable() ? "NOT NULL" : "") + "\n);\n";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                    mycontent = "\nALTER TABLE " + ownerEntity + "_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT PK_" + ownerEntity + "_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + " PRIMARY KEY (pk-" + figure.toString().toLowerCase().replaceAll("\\s+", "_") + ");\n";
                    mycontent2 = "ALTER TABLE " + ownerEntity + "_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + ownerEntity + "_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + ownerKey + ") REFERENCES " + ownerEntity + " (" + ownerKey + ");\n";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                }
            }
        }
        for (Figure e : weakRelationship) {
            for (Figure f : lineconnectors) {
                if (!((ConnectionFigure)f).getEndFigure().equals((RelacionamentoFracoFigure)e)) continue;
                for (Figure figure : strongEntity) {
                    if (!((ConnectionFigure)f).getStartFigure().equals((EntidadeFigure)figure)) continue;
                    for (Figure h : connection) {
                        if (((ConnectionFigure)h).getStartFigure().equals((EntidadeFigure)figure)) {
                            for (Figure i : keyAttribute) {
                                if (!((ConnectionFigure)h).getEndFigure().equals((AtributoChaveFigure)i)) continue;
                                ownerKey = i.toString();
                                ownerKeyType = ((AtributoChaveFigure)i).getAttributeType().toString();
                            }
                            continue;
                        }
                        if (!((ConnectionFigure)h).getEndFigure().equals((EntidadeFigure)figure)) continue;
                        for (Figure i : keyAttribute) {
                            if (!((ConnectionFigure)h).getStartFigure().equals((AtributoChaveFigure)i)) continue;
                            ownerKey = i.toString();
                            ownerKeyType = ((AtributoChaveFigure)i).getAttributeType().toString();
                        }
                    }
                }
                for (Figure figure : weakEntity) {
                    for (Figure i : connection) {
                        if (((ConnectionFigure)i).getStartFigure().equals((EntidadeFracaFigure)figure)) {
                            for (Figure j : partialKeyAttribute) {
                                if (!((ConnectionFigure)i).getEndFigure().equals((AtributoChaveParcialFigure)j)) continue;
                                partialKey = j.toString();
                                partialKeyType = ((AtributoChaveParcialFigure)j).getAttributeType().toString();
                            }
                            continue;
                        }
                        if (!((ConnectionFigure)i).getEndFigure().equals((EntidadeFracaFigure)figure)) continue;
                        for (Figure j : partialKeyAttribute) {
                            if (!((ConnectionFigure)i).getStartFigure().equals((AtributoChaveParcialFigure)j)) continue;
                            partialKey = j.toString();
                            partialKeyType = ((AtributoChaveParcialFigure)j).getAttributeType().toString();
                        }
                    }
                }
                for (Figure figure : weakEntity) {
                    for (Figure i : connection) {
                        if (((ConnectionFigure)i).getStartFigure().equals((EntidadeFracaFigure)figure)) {
                            for (Figure k : multivaluedAttribute) {
                                if (!((ConnectionFigure)i).getEndFigure().equals((AtributoMultivaloradoFigure)k) || done) continue;
                                mycontent = "\nCREATE TABLE " + figure.toString().toUpperCase().replaceAll("\\s+", "_") + "_" + k.toString().toUpperCase().replaceAll("\\s+", "_") + "(";
                                mycontent2 = "\n\t" + ownerKey + " " + ownerKeyType + " NOT NULL,\n\t" + partialKey + " " + partialKeyType + " NOT NULL,\n\tpk-" + k.toString().toLowerCase().replaceAll("\\s+", "_") + " NUMBER NOT NULL,";
                                mycontent3 = "\n\t" + k.toString().toLowerCase().replaceAll("\\s+", "_") + " " + (Object)((Object)((AtributoMultivaloradoFigure)k).getAttributeType()) + " " + (!((AtributoMultivaloradoFigure)k).isNullable() ? "NOT NULL" : "") + "\n);\n";
                                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                                mycontent = "ALTER TABLE " + figure.toString().toUpperCase().replaceAll("\\s+", "_") + "_" + k.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT PK_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + "_" + k.toString().toUpperCase().replaceAll("\\s+", "_") + " PRIMARY KEY (pk-" + k.toString().toLowerCase().replaceAll("\\s+", "_") + ");\n";
                                mycontent2 = "ALTER TABLE " + figure.toString().toUpperCase().replaceAll("\\s+", "_") + "_" + k.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + "_" + k.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + partialKey + ", " + ownerKey + ") REFERENCES " + figure.toString().toUpperCase().replaceAll("\\s+", "_") + " (" + partialKey + ", " + ownerKey + ");\n";
                                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                                this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                                done = true;
                            }
                            continue;
                        }
                        if (!((ConnectionFigure)i).getEndFigure().equals((EntidadeFracaFigure)figure)) continue;
                        for (Figure k : multivaluedAttribute) {
                            if (!((ConnectionFigure)i).getStartFigure().equals((AtributoMultivaloradoFigure)k) || done) continue;
                            mycontent = "\nCREATE TABLE " + figure.toString().toUpperCase().replaceAll("\\s+", "_") + "_" + k.toString().toUpperCase().replaceAll("\\s+", "_") + "(";
                            mycontent2 = "\n\t" + ownerKey + " " + ownerKeyType + " NOT NULL,\n\t" + partialKey + " " + partialKeyType + " NOT NULL,\n\tpk-" + k.toString().toLowerCase().replaceAll("\\s+", "_") + " NUMBER NOT NULL,";
                            mycontent3 = "\n\t" + k.toString().toLowerCase().replaceAll("\\s+", "_") + " " + (Object)((Object)((AtributoMultivaloradoFigure)k).getAttributeType()) + " " + (!((AtributoMultivaloradoFigure)k).isNullable() ? "NOT NULL" : "") + "\n);\n";
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                            mycontent = "ALTER TABLE " + figure.toString().toUpperCase().replaceAll("\\s+", "_") + "_" + k.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT PK_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + "_" + k.toString().toUpperCase().replaceAll("\\s+", "_") + " PRIMARY KEY (pk-" + k.toString().toLowerCase().replaceAll("\\s+", "_") + ");\n";
                            mycontent2 = "ALTER TABLE " + figure.toString().toUpperCase().replaceAll("\\s+", "_") + "_" + k.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + "_" + k.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + partialKey + ", " + ownerKey + ") REFERENCES " + figure.toString().toUpperCase().replaceAll("\\s+", "_") + " (" + partialKey + ", " + ownerKey + ");\n";
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                            done = true;
                        }
                    }
                }
            }
            done = false;
        }
        for (Figure a : entityRelationship) {
            for (Figure b : singleLineConnectionN) {
                if (!((ConnectionFigure)b).getEndFigure().equals(a)) continue;
                slcN.add(b);
            }
            for (Figure c : doubleLineConnectionN) {
                if (!((ConnectionFigure)c).getEndFigure().equals(a)) continue;
                dlcN.add(c);
            }
            entRel = a.toString().toUpperCase().replaceAll("\\s+", "_");
            if (slcN.size() == 2) {
                int i = 0;
                while (i < slcN.size() - 1) {
                    for (Figure figure : strongEntity) {
                        if (!((ConnectionFigure)slcN.get(i)).getStartFigure().equals(figure)) continue;
                        for (Figure figure2 : connection) {
                            if (((ConnectionFigure)figure2).getStartFigure().equals(figure)) {
                                for (Figure h : keyAttribute) {
                                    if (!((ConnectionFigure)figure2).getEndFigure().equals((AtributoChaveFigure)h)) continue;
                                    ownerKey = h.toString();
                                    ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                                }
                                continue;
                            }
                            if (!((ConnectionFigure)figure2).getEndFigure().equals(figure)) continue;
                            for (Figure h : keyAttribute) {
                                if (!((ConnectionFigure)figure2).getStartFigure().equals((AtributoChaveFigure)h)) continue;
                                ownerKey = h.toString();
                                ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                            }
                        }
                    }
                    ++i;
                }
                i = 1;
                while (i < slcN.size()) {
                    for (Figure figure : strongEntity) {
                        if (!((ConnectionFigure)slcN.get(i)).getStartFigure().equals(figure)) continue;
                        for (Figure figure3 : connection) {
                            if (((ConnectionFigure)figure3).getStartFigure().equals(figure)) {
                                for (Figure h : keyAttribute) {
                                    if (!((ConnectionFigure)figure3).getEndFigure().equals((AtributoChaveFigure)h)) continue;
                                    ownerKey2 = h.toString();
                                    ownerKeyType2 = ((AtributoChaveFigure)h).getAttributeType().toString();
                                }
                                continue;
                            }
                            if (!((ConnectionFigure)figure3).getEndFigure().equals(figure)) continue;
                            for (Figure h : keyAttribute) {
                                if (!((ConnectionFigure)figure3).getStartFigure().equals((AtributoChaveFigure)h)) continue;
                                ownerKey2 = h.toString();
                                ownerKeyType2 = ((AtributoChaveFigure)h).getAttributeType().toString();
                            }
                        }
                    }
                    ++i;
                }
                for (Figure j : connection) {
                    if (((ConnectionFigure)j).getStartFigure().equals((EntidadeRelacionamentoFigure)a)) {
                        for (Figure figure : multivaluedAttribute) {
                            if (!((ConnectionFigure)j).getEndFigure().equals((AtributoMultivaloradoFigure)figure)) continue;
                            mycontent = "\nCREATE TABLE " + entRel + "_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + "(";
                            mycontent2 = "\n\t" + ownerKey + " " + ownerKeyType + " NOT NULL,\n\t" + ownerKey2 + " " + ownerKeyType2 + " NOT NULL,\n\tpk-" + figure.toString().toLowerCase().replaceAll("\\s+", "_") + " NUMBER NOT NULL,";
                            mycontent3 = "\n\t" + figure.toString().toLowerCase().replaceAll("\\s+", "_") + " " + (Object)((Object)((AtributoMultivaloradoFigure)figure).getAttributeType()) + " " + (!((AtributoMultivaloradoFigure)figure).isNullable() ? "NOT NULL" : "") + "\n);\n";
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                            mycontent = "\nALTER TABLE " + entRel + "_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT PK_" + entRel + "_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + " PRIMARY KEY (pk-" + figure.toString().toLowerCase().replaceAll("\\s+", "_") + ");\n";
                            mycontent2 = "ALTER TABLE " + entRel + "_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + entRel + "_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + ownerKey + ", " + ownerKey2 + ") REFERENCES " + entRel + " (" + ownerKey + ", " + ownerKey2 + ");\n";
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                        }
                        continue;
                    }
                    if (!((ConnectionFigure)j).getEndFigure().equals((EntidadeRelacionamentoFigure)a)) continue;
                    for (Figure figure : multivaluedAttribute) {
                        if (!((ConnectionFigure)j).getStartFigure().equals((AtributoMultivaloradoFigure)figure)) continue;
                        mycontent = "\nCREATE TABLE " + entRel + "_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + "(";
                        mycontent2 = "\n\t" + ownerKey + " " + ownerKeyType + " NOT NULL,\n\t" + ownerKey2 + " " + ownerKeyType2 + " NOT NULL,\n\tpk-" + figure.toString().toLowerCase().replaceAll("\\s+", "_") + " NUMBER NOT NULL,";
                        mycontent3 = "\n\t" + figure.toString().toLowerCase().replaceAll("\\s+", "_") + " " + (Object)((Object)((AtributoMultivaloradoFigure)figure).getAttributeType()) + " " + (!((AtributoMultivaloradoFigure)figure).isNullable() ? "NOT NULL" : "") + "\n);\n";
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                        mycontent = "\nALTER TABLE " + entRel + "_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT PK_" + entRel + "_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + " PRIMARY KEY (pk-" + figure.toString().toLowerCase().replaceAll("\\s+", "_") + ");\n";
                        mycontent2 = "ALTER TABLE " + entRel + "_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + entRel + "_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + ownerKey + ", " + ownerKey2 + ") REFERENCES " + entRel + " (" + ownerKey + ", " + ownerKey2 + ");\n";
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                    }
                }
            } else if (slcN.size() == 1 && dlcN.size() == 1) {
                int i = 0;
                while (i < slcN.size()) {
                    for (Figure figure : strongEntity) {
                        if (!((ConnectionFigure)slcN.get(i)).getStartFigure().equals(figure)) continue;
                        for (Figure figure4 : connection) {
                            if (((ConnectionFigure)figure4).getStartFigure().equals(figure)) {
                                for (Figure h : keyAttribute) {
                                    if (!((ConnectionFigure)figure4).getEndFigure().equals((AtributoChaveFigure)h)) continue;
                                    ownerKey = h.toString();
                                    ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                                }
                                continue;
                            }
                            if (!((ConnectionFigure)figure4).getEndFigure().equals(figure)) continue;
                            for (Figure h : keyAttribute) {
                                if (!((ConnectionFigure)figure4).getStartFigure().equals((AtributoChaveFigure)h)) continue;
                                ownerKey = h.toString();
                                ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                            }
                        }
                    }
                    ++i;
                }
                i = 0;
                while (i < dlcN.size()) {
                    for (Figure figure : strongEntity) {
                        if (!((ConnectionFigure)dlcN.get(i)).getStartFigure().equals(figure)) continue;
                        for (Figure figure5 : connection) {
                            if (((ConnectionFigure)figure5).getStartFigure().equals(figure)) {
                                for (Figure h : keyAttribute) {
                                    if (!((ConnectionFigure)figure5).getEndFigure().equals((AtributoChaveFigure)h)) continue;
                                    ownerKey2 = h.toString();
                                    ownerKeyType2 = ((AtributoChaveFigure)h).getAttributeType().toString();
                                }
                                continue;
                            }
                            if (!((ConnectionFigure)figure5).getEndFigure().equals(figure)) continue;
                            for (Figure h : keyAttribute) {
                                if (!((ConnectionFigure)figure5).getStartFigure().equals((AtributoChaveFigure)h)) continue;
                                ownerKey2 = h.toString();
                                ownerKeyType2 = ((AtributoChaveFigure)h).getAttributeType().toString();
                            }
                        }
                    }
                    ++i;
                }
                for (Figure j : connection) {
                    if (((ConnectionFigure)j).getStartFigure().equals((EntidadeRelacionamentoFigure)a)) {
                        for (Figure figure : multivaluedAttribute) {
                            if (!((ConnectionFigure)j).getEndFigure().equals((AtributoMultivaloradoFigure)figure)) continue;
                            mycontent = "\nCREATE TABLE " + entRel + "_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + "(";
                            mycontent2 = "\n\t" + ownerKey + " " + ownerKeyType + " NOT NULL,\n\t" + ownerKey2 + " " + ownerKeyType2 + " NOT NULL,\n\tpk-" + figure.toString().toLowerCase().replaceAll("\\s+", "_") + " NUMBER NOT NULL,";
                            mycontent3 = "\n\t" + figure.toString().toLowerCase().replaceAll("\\s+", "_") + " " + (Object)((Object)((AtributoMultivaloradoFigure)figure).getAttributeType()) + " " + (!((AtributoMultivaloradoFigure)figure).isNullable() ? "NOT NULL" : "") + "\n);\n";
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                            mycontent = "\nALTER TABLE " + entRel + "_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT PK_" + entRel + "_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + " PRIMARY KEY (pk-" + figure.toString().toLowerCase().replaceAll("\\s+", "_") + ");\n";
                            mycontent2 = "ALTER TABLE " + entRel + "_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + entRel + "_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + ownerKey + ", " + ownerKey2 + ") REFERENCES " + entRel + " (" + ownerKey + ", " + ownerKey2 + ");\n";
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                        }
                        continue;
                    }
                    if (!((ConnectionFigure)j).getEndFigure().equals((EntidadeRelacionamentoFigure)a)) continue;
                    for (Figure figure : multivaluedAttribute) {
                        if (!((ConnectionFigure)j).getStartFigure().equals((AtributoMultivaloradoFigure)figure)) continue;
                        mycontent = "\nCREATE TABLE " + entRel + "_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + "(";
                        mycontent2 = "\n\t" + ownerKey + " " + ownerKeyType + " NOT NULL,\n\t" + ownerKey2 + " " + ownerKeyType2 + " NOT NULL,\n\tpk-" + figure.toString().toLowerCase().replaceAll("\\s+", "_") + " NUMBER NOT NULL,";
                        mycontent3 = "\n\t" + figure.toString().toLowerCase().replaceAll("\\s+", "_") + " " + (Object)((Object)((AtributoMultivaloradoFigure)figure).getAttributeType()) + " " + (!((AtributoMultivaloradoFigure)figure).isNullable() ? "NOT NULL" : "") + "\n);\n";
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                        mycontent = "\nALTER TABLE " + entRel + "_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT PK_" + entRel + "_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + " PRIMARY KEY (pk-" + figure.toString().toLowerCase().replaceAll("\\s+", "_") + ");\n";
                        mycontent2 = "ALTER TABLE " + entRel + "_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + entRel + "_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + ownerKey + ", " + ownerKey2 + ") REFERENCES " + entRel + " (" + ownerKey + ", " + ownerKey2 + ");\n";
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                    }
                }
            } else if (dlcN.size() == 2) {
                int i = 0;
                while (i < dlcN.size() - 1) {
                    for (Figure figure : strongEntity) {
                        if (!((ConnectionFigure)dlcN.get(i)).getStartFigure().equals(figure)) continue;
                        for (Figure figure6 : connection) {
                            if (((ConnectionFigure)figure6).getStartFigure().equals(figure)) {
                                for (Figure h : keyAttribute) {
                                    if (!((ConnectionFigure)figure6).getEndFigure().equals((AtributoChaveFigure)h)) continue;
                                    ownerKey = h.toString();
                                    ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                                }
                                continue;
                            }
                            if (!((ConnectionFigure)figure6).getEndFigure().equals(figure)) continue;
                            for (Figure h : keyAttribute) {
                                if (!((ConnectionFigure)figure6).getStartFigure().equals((AtributoChaveFigure)h)) continue;
                                ownerKey = h.toString();
                                ownerKeyType = ((AtributoChaveFigure)h).getAttributeType().toString();
                            }
                        }
                    }
                    ++i;
                }
                i = 1;
                while (i < dlcN.size()) {
                    for (Figure figure : strongEntity) {
                        if (!((ConnectionFigure)dlcN.get(i)).getStartFigure().equals(figure)) continue;
                        for (Figure figure7 : connection) {
                            if (((ConnectionFigure)figure7).getStartFigure().equals(figure)) {
                                for (Figure h : keyAttribute) {
                                    if (!((ConnectionFigure)figure7).getEndFigure().equals((AtributoChaveFigure)h)) continue;
                                    ownerKey2 = h.toString();
                                    ownerKeyType2 = ((AtributoChaveFigure)h).getAttributeType().toString();
                                }
                                continue;
                            }
                            if (!((ConnectionFigure)figure7).getEndFigure().equals(figure)) continue;
                            for (Figure h : keyAttribute) {
                                if (!((ConnectionFigure)figure7).getStartFigure().equals((AtributoChaveFigure)h)) continue;
                                ownerKey2 = h.toString();
                                ownerKeyType2 = ((AtributoChaveFigure)h).getAttributeType().toString();
                            }
                        }
                    }
                    ++i;
                }
                for (Figure j : connection) {
                    if (((ConnectionFigure)j).getStartFigure().equals((EntidadeRelacionamentoFigure)a)) {
                        for (Figure figure : multivaluedAttribute) {
                            if (!((ConnectionFigure)j).getEndFigure().equals((AtributoMultivaloradoFigure)figure)) continue;
                            mycontent = "\nCREATE TABLE " + entRel + "_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + "(";
                            mycontent2 = "\n\t" + ownerKey + " " + ownerKeyType + " NOT NULL,\n\t" + ownerKey2 + " " + ownerKeyType2 + " NOT NULL,\n\tpk-" + figure.toString().toLowerCase().replaceAll("\\s+", "_") + " NUMBER NOT NULL,";
                            mycontent3 = "\n\t" + figure.toString().toLowerCase().replaceAll("\\s+", "_") + " " + (Object)((Object)((AtributoMultivaloradoFigure)figure).getAttributeType()) + " " + (!((AtributoMultivaloradoFigure)figure).isNullable() ? "NOT NULL" : "") + "\n);\n";
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                            mycontent = "\nALTER TABLE " + entRel + "_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT PK_" + entRel + "_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + " PRIMARY KEY (pk-" + figure.toString().toLowerCase().replaceAll("\\s+", "_") + ");\n";
                            mycontent2 = "ALTER TABLE " + entRel + "_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + entRel + "_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + ownerKey + ", " + ownerKey2 + ") REFERENCES " + entRel + " (" + ownerKey + ", " + ownerKey2 + ");\n";
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                            this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                        }
                        continue;
                    }
                    if (!((ConnectionFigure)j).getEndFigure().equals((EntidadeRelacionamentoFigure)a)) continue;
                    for (Figure figure : multivaluedAttribute) {
                        if (!((ConnectionFigure)j).getStartFigure().equals((AtributoMultivaloradoFigure)figure)) continue;
                        mycontent = "\nCREATE TABLE " + entRel + "_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + "(";
                        mycontent2 = "\n\t" + ownerKey + " " + ownerKeyType + " NOT NULL,\n\t" + ownerKey2 + " " + ownerKeyType2 + " NOT NULL,\n\tpk-" + figure.toString().toLowerCase().replaceAll("\\s+", "_") + " NUMBER NOT NULL,";
                        mycontent3 = "\n\t" + figure.toString().toLowerCase().replaceAll("\\s+", "_") + " " + (Object)((Object)((AtributoMultivaloradoFigure)figure).getAttributeType()) + " " + (!((AtributoMultivaloradoFigure)figure).isNullable() ? "NOT NULL" : "") + "\n);\n";
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent3;
                        mycontent = "\nALTER TABLE " + entRel + "_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT PK_" + entRel + "_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + " PRIMARY KEY (pk-" + figure.toString().toLowerCase().replaceAll("\\s+", "_") + ");\n";
                        mycontent2 = "ALTER TABLE " + entRel + "_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + " ADD CONSTRAINT FK_" + entRel + "_" + figure.toString().toUpperCase().replaceAll("\\s+", "_") + " FOREIGN KEY (" + ownerKey + ", " + ownerKey2 + ") REFERENCES " + entRel + " (" + ownerKey + ", " + ownerKey2 + ");\n";
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                    }
                }
            }
            slcN.clear();
            dlcN.clear();
        }
    }

    private void generateDerivedAttribute(ArrayList<Figure> strongEntity, ArrayList<Figure> weakEntity, ArrayList<Figure> entityRelationship, ArrayList<Figure> connection, ArrayList<Figure> derivedAttribute) {
        String mycontent = new String();
        String mycontent2 = new String();
        for (Figure a : strongEntity) {
            for (Figure b : connection) {
                if (((ConnectionFigure)b).getStartFigure().equals(a)) {
                    for (Figure c : derivedAttribute) {
                        if (!((ConnectionFigure)b).getEndFigure().equals(c)) continue;
                        mycontent = "\nCREATE OR REPLACE VIEW VW_" + a.toString().toUpperCase().replaceAll("\\s+", "_") + " AS (\n";
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                        mycontent2 = String.valueOf(((AtributoDerivadoFigure)c).getSql()) + "\n);";
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                    }
                    continue;
                }
                if (!((ConnectionFigure)b).getEndFigure().equals(a)) continue;
                for (Figure c : derivedAttribute) {
                    if (!((ConnectionFigure)b).getStartFigure().equals(c)) continue;
                    mycontent = "\nCREATE OR REPLACE VIEW VW_" + a.toString().toUpperCase().replaceAll("\\s+", "_") + " AS (\n";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                    mycontent2 = String.valueOf(((AtributoDerivadoFigure)c).getSql()) + "\n);";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                }
            }
        }
        for (Figure a : weakEntity) {
            for (Figure b : connection) {
                if (((ConnectionFigure)b).getStartFigure().equals(a)) {
                    for (Figure c : derivedAttribute) {
                        if (!((ConnectionFigure)b).getEndFigure().equals(c)) continue;
                        mycontent = "\nCREATE OR REPLACE VIEW VW_" + a.toString().toUpperCase().replaceAll("\\s+", "_") + " AS (\n";
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                        mycontent2 = String.valueOf(((AtributoDerivadoFigure)c).getSql()) + "\n);";
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                    }
                    continue;
                }
                if (!((ConnectionFigure)b).getEndFigure().equals(a)) continue;
                for (Figure c : derivedAttribute) {
                    if (!((ConnectionFigure)b).getStartFigure().equals(c)) continue;
                    mycontent = "\nCREATE OR REPLACE VIEW VW_" + a.toString().toUpperCase().replaceAll("\\s+", "_") + " AS (\n";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                    mycontent2 = String.valueOf(((AtributoDerivadoFigure)c).getSql()) + "\n);";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                }
            }
        }
        for (Figure a : entityRelationship) {
            for (Figure b : connection) {
                if (((ConnectionFigure)b).getStartFigure().equals(a)) {
                    for (Figure c : derivedAttribute) {
                        if (!((ConnectionFigure)b).getEndFigure().equals(c)) continue;
                        mycontent = "\nCREATE OR REPLACE VIEW VW_" + a.toString().toUpperCase().replaceAll("\\s+", "_") + " AS (\n";
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                        mycontent2 = String.valueOf(((AtributoDerivadoFigure)c).getSql()) + "\n);";
                        this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                    }
                    continue;
                }
                if (!((ConnectionFigure)b).getEndFigure().equals(a)) continue;
                for (Figure c : derivedAttribute) {
                    if (!((ConnectionFigure)b).getStartFigure().equals(c)) continue;
                    mycontent = "\nCREATE OR REPLACE VIEW VW_" + a.toString().toUpperCase().replaceAll("\\s+", "_") + " AS (\n";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent;
                    mycontent2 = String.valueOf(((AtributoDerivadoFigure)c).getSql()) + "\n);";
                    this.ddlBuffer = String.valueOf(this.ddlBuffer) + mycontent2;
                }
            }
        }
    }
}

