/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.ConnectionAttribute;
import org.jhotdraw.draw.DoubleLineConnectionGeneralizacaoFigure;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.GeneralizacaoLineConnectionFigure;
import org.jhotdraw.draw.LabeledDoubleLineConnectionMuitosFigure;
import org.jhotdraw.draw.LabeledDoubleLineConnectionUmFigure;
import org.jhotdraw.draw.LabeledLineConnectionMuitosFigure;
import org.jhotdraw.draw.LabeledLineConnectionUmFigure;
import org.jhotdraw.draw.LineConnectionFigure;
import org.jhotdraw.draw.LineConnectionGeneralizacaoFigure;

public class InsertNewConnectionAction
implements ActionListener {
    private Class c;
    private LineConnectionFigure lcf;
    private Drawing draw;

    public InsertNewConnectionAction(LineConnectionFigure lcf, Class c, Drawing draw) {
        this.c = c;
        this.lcf = lcf;
        this.draw = draw;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LineConnectionFigure newConection = this.createConnection(this.c);
        newConection.setStartConnector(this.lcf.getStartConnector());
        newConection.setEndConnector(this.lcf.getEndConnector());
        this.draw.remove(this.lcf);
        this.draw.add(newConection);
        final LineConnectionFigure remFigure = this.lcf;
        final LineConnectionFigure addedFigure = newConection;
        final Drawing addedDrawing = this.draw;
        this.draw.fireUndoableEditHappened(new AbstractUndoableEdit(){

            @Override
            public String getPresentationName() {
                return "recomendation";
            }

            @Override
            public void undo() throws CannotUndoException {
                super.undo();
                addedDrawing.remove(addedFigure);
                addedDrawing.add(remFigure);
            }

            @Override
            public void redo() throws CannotRedoException {
                super.redo();
                addedDrawing.remove(remFigure);
                addedDrawing.add(addedFigure);
            }
        });
    }

    public LineConnectionFigure createConnection(Class c) {
        if (c.equals(ConnectionAttribute.class)) {
            return new ConnectionAttribute();
        }
        if (c.equals(LabeledLineConnectionUmFigure.class)) {
            return new LabeledLineConnectionUmFigure();
        }
        if (c.equals(LabeledLineConnectionMuitosFigure.class)) {
            return new LabeledLineConnectionMuitosFigure();
        }
        if (c.equals(LabeledDoubleLineConnectionUmFigure.class)) {
            return new LabeledDoubleLineConnectionUmFigure();
        }
        if (c.equals(LabeledDoubleLineConnectionMuitosFigure.class)) {
            return new LabeledDoubleLineConnectionMuitosFigure();
        }
        if (c.equals(LineConnectionGeneralizacaoFigure.class)) {
            return new LineConnectionGeneralizacaoFigure();
        }
        if (c.equals(DoubleLineConnectionGeneralizacaoFigure.class)) {
            return new DoubleLineConnectionGeneralizacaoFigure();
        }
        if (c.equals(GeneralizacaoLineConnectionFigure.class)) {
            return new GeneralizacaoLineConnectionFigure();
        }
        return null;
    }
}

