/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action;

import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.Project;
import org.jhotdraw.app.action.AbstractSaveBeforeAction;
import org.jhotdraw.gui.JSheet;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.gui.event.SheetEvent;
import org.jhotdraw.gui.event.SheetListener;
import org.jhotdraw.util.ResourceBundleUtil;

public class LoadAction
extends AbstractSaveBeforeAction {
    public static final String ID = "load";

    public LoadAction(Application app) {
        super(app);
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.app.Labels");
        labels.configureAction(this, "open");
    }

    @Override
    public void doIt(Project project) {
        JFileChooser fileChooser = project.getOpenChooser();
        if (fileChooser.showOpenDialog(project.getComponent()) == 0) {
            this.openFile(project, fileChooser);
        } else {
            project.setEnabled(true);
        }
    }

    protected void openFile(final Project project, JFileChooser fileChooser) {
        final File file = fileChooser.getSelectedFile();
        project.setEnabled(false);
        project.execute(new Worker(){

            @Override
            public Object construct() {
                try {
                    project.read(file);
                    return null;
                }
                catch (IOException e) {
                    return e;
                }
            }

            @Override
            public void finished(Object value) {
                LoadAction.this.fileOpened(project, file, value);
            }
        });
    }

    protected void fileOpened(final Project project, File file, Object value) {
        if (value == null) {
            project.setFile(file);
            project.setEnabled(true);
            this.getApplication().addRecentFile(file);
        } else {
            JSheet.showMessageSheet(project.getComponent(), "<html>" + UIManager.getString("OptionPane.css") + "<b>Couldn't open the file \"" + file + "\".</b><br>" + value, 0, new SheetListener(){

                @Override
                public void optionSelected(SheetEvent evt) {
                    project.clear();
                    project.setEnabled(true);
                }
            });
        }
    }
}

