/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action;

import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import net.roydesign.event.ApplicationEvent;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.Project;
import org.jhotdraw.app.action.AbstractApplicationAction;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.util.ResourceBundleUtil;

public class OSXDropOnDockAction
extends AbstractApplicationAction {
    public static final String ID = "osxdrop";
    private JFileChooser fileChooser;
    private int entries;

    public OSXDropOnDockAction(Application app) {
        super(app);
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.app.Labels");
        this.putValue("Name", "OSX Drop On Dock");
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        final Application app = this.getApplication();
        if (evt instanceof ApplicationEvent) {
            final ApplicationEvent ae = (ApplicationEvent)evt;
            final Project p = app.createProject();
            p.setEnabled(false);
            app.add(p);
            p.execute(new Worker(){

                @Override
                public Object construct() {
                    try {
                        p.read(ae.getFile());
                        return null;
                    }
                    catch (IOException e) {
                        return e;
                    }
                }

                @Override
                public void finished(Object value) {
                    if (value == null) {
                        p.setFile(ae.getFile());
                        p.setEnabled(true);
                    } else {
                        app.dispose(p);
                        JOptionPane.showMessageDialog(null, "<html>" + UIManager.getString("OptionPane.css") + "<b>Can't open file " + ae.getFile() + "</b><p>" + value, "", 0);
                    }
                }
            });
        }
    }
}

