/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.LineDecoration;
import org.jhotdraw.draw.Liner;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.geom.DoubleStroke;
import org.jhotdraw.geom.Insets2D;

public class AttributeKeys {
    public static final AttributeKey<Color> FILL_COLOR = new AttributeKey<Color>("fillColor", Color.white);
    public static final AttributeKey<Boolean> CLOSED = new AttributeKey<Boolean>("closed", false);
    public static final AttributeKey<Boolean> FILL_OPEN_PATH = new AttributeKey<Boolean>("fillOpenPath", false);
    public static final AttributeKey<WindingRule> WINDING_RULE = new AttributeKey<WindingRule>("windingRule", WindingRule.EVEN_ODD, false);
    public static final AttributeKey<String> LABEL_TEXT = new AttributeKey<String>("labelText", "caracter\ufffdstica", false);
    public static final AttributeKey<Underfill> FILL_UNDER_STROKE = new AttributeKey<Underfill>("fillUnderStroke", Underfill.CENTER, false);
    public static final AttributeKey<Color> STROKE_COLOR = new AttributeKey<Color>("strokeColor", Color.black);
    public static final AttributeKey<Double> STROKE_WIDTH = new AttributeKey<Double>("strokeWidth", 1.0, false);
    public static final AttributeKey<Double> STROKE_INNER_WIDTH_FACTOR = new AttributeKey<Double>("innerStrokeWidthFactor", 2.0, false);
    public static final AttributeKey<Integer> STROKE_JOIN = new AttributeKey<Integer>("strokeJoin", 0, false);
    public static final AttributeKey<Integer> STROKE_CAP = new AttributeKey<Integer>("strokeCap", 0, false);
    public static final AttributeKey<Double> STROKE_MITER_LIMIT = new AttributeKey<Double>("strokeMiterLimitFactor", 3.0, false);
    public static final AttributeKey<Boolean> IS_STROKE_MITER_LIMIT_FACTOR = new AttributeKey<Boolean>("isStrokeMiterLimitFactor", true);
    public static final AttributeKey<double[]> STROKE_DASHES = new AttributeKey<Object>("strokeDashes", null);
    public static final AttributeKey<Double> STROKE_DASH_PHASE = new AttributeKey<Double>("strokeDashPhase", 0.0, false);
    public static final AttributeKey<Boolean> IS_STROKE_DASH_FACTOR = new AttributeKey<Boolean>("isStrokeDashFactor", true);
    public static final AttributeKey<StrokeType> STROKE_TYPE = new AttributeKey<StrokeType>("strokeType", StrokeType.BASIC, false);
    public static final AttributeKey<StrokePlacement> STROKE_PLACEMENT = new AttributeKey<StrokePlacement>("strokePlacement", StrokePlacement.CENTER, false);
    public static final AttributeKey<String> TEXT = new AttributeKey<Object>("text", null);
    public static final AttributeKey<Color> TEXT_COLOR = new AttributeKey<Color>("textColor", Color.black);
    public static final AttributeKey<Color> TEXT_SHADOW_COLOR = new AttributeKey<Object>("textShadowColor", null);
    public static final AttributeKey<Dimension2DDouble> TEXT_SHADOW_OFFSET = new AttributeKey<Dimension2DDouble>("textShadowOffset", new Dimension2DDouble(1.0, 1.0), false);
    public static final AttributeKey<Font> FONT_FACE = new AttributeKey<Font>("fontFace", new Font("VERDANA", 0, 10), false);
    public static final AttributeKey<Double> FONT_SIZE = new AttributeKey<Double>("fontSize", 12.0, false);
    public static final AttributeKey<Boolean> FONT_BOLD = new AttributeKey<Boolean>("fontBold", false, false);
    public static final AttributeKey<Boolean> FONT_ITALIC = new AttributeKey<Boolean>("fontItalic", false, false);
    public static final AttributeKey<Boolean> FONT_UNDERLINE = new AttributeKey<Boolean>("fontUnderlined", false, false);
    public static final AttributeKey<Liner> BEZIER_PATH_LAYOUTER = new AttributeKey<Object>("bezierPathLayouter", null);
    public static final AttributeKey<LineDecoration> END_DECORATION = new AttributeKey<Object>("endDecoration", null);
    public static final AttributeKey<LineDecoration> START_DECORATION = new AttributeKey<Object>("startDecoration", null);
    public static final AttributeKey<Insets2D.Double> DECORATOR_INSETS = new AttributeKey<Insets2D.Double>("decoratorInsets", new Insets2D.Double(), false);
    public static final AttributeKey<Insets2D.Double> LAYOUT_INSETS = new AttributeKey<Insets2D.Double>("borderInsets", new Insets2D.Double());
    public static final AttributeKey<AffineTransform> TRANSFORM = new AttributeKey<Object>("transform", null, true);
    public static final AttributeKey<Orientation> ORIENTATION = new AttributeKey<Orientation>("orientation", Orientation.NORTH);
    public static final Set<AttributeKey> supportedAttributes;
    public static final Map<String, AttributeKey> supportedAttributeMap;

    static {
        HashSet<AttributeKey> as = new HashSet<AttributeKey>();
        as.addAll(Arrays.asList(FILL_COLOR, FILL_UNDER_STROKE, STROKE_COLOR, STROKE_WIDTH, STROKE_INNER_WIDTH_FACTOR, STROKE_JOIN, STROKE_CAP, STROKE_MITER_LIMIT, STROKE_DASHES, STROKE_DASH_PHASE, STROKE_TYPE, STROKE_PLACEMENT, TEXT, TEXT_COLOR, TEXT_SHADOW_COLOR, TEXT_SHADOW_OFFSET, TRANSFORM, FONT_FACE, FONT_SIZE, FONT_BOLD, FONT_ITALIC, FONT_UNDERLINE, BEZIER_PATH_LAYOUTER, END_DECORATION, START_DECORATION, DECORATOR_INSETS, ORIENTATION, WINDING_RULE, LABEL_TEXT));
        supportedAttributes = Collections.unmodifiableSet(as);
        HashMap<String, AttributeKey> am = new HashMap<String, AttributeKey>();
        for (AttributeKey a : as) {
            am.put(a.getKey(), a);
        }
        supportedAttributeMap = Collections.unmodifiableMap(am);
    }

    public static double getStrokeTotalWidth(Figure f) {
        switch (STROKE_TYPE.get(f)) {
            default: {
                return STROKE_WIDTH.get(f);
            }
            case DOUBLE: 
        }
        return STROKE_WIDTH.get(f) * (1.0 + STROKE_INNER_WIDTH_FACTOR.get(f));
    }

    public static double getStrokeTotalMiterLimit(Figure f) {
        if (IS_STROKE_MITER_LIMIT_FACTOR.get(f).booleanValue()) {
            return STROKE_MITER_LIMIT.get(f) * STROKE_WIDTH.get(f);
        }
        return STROKE_MITER_LIMIT.get(f);
    }

    public static Stroke getStroke(Figure f) {
        double strokeWidth = STROKE_WIDTH.get(f);
        float miterLimit = (float)AttributeKeys.getStrokeTotalMiterLimit(f);
        double dashFactor = IS_STROKE_DASH_FACTOR.get(f) != false ? strokeWidth : 1.0;
        double[] ddashes = STROKE_DASHES.get(f);
        float[] dashes = null;
        if (ddashes != null) {
            dashes = new float[ddashes.length];
            int i = 0;
            while (i < dashes.length) {
                dashes[i] = (float)(ddashes[i] * dashFactor);
                ++i;
            }
        }
        switch (STROKE_TYPE.get(f)) {
            default: {
                return new BasicStroke((float)strokeWidth, STROKE_CAP.get(f), STROKE_JOIN.get(f), miterLimit, dashes, (float)(STROKE_DASH_PHASE.get(f) * dashFactor));
            }
            case DOUBLE: 
        }
        return new DoubleStroke((float)(STROKE_INNER_WIDTH_FACTOR.get(f) * strokeWidth), (float)strokeWidth, STROKE_CAP.get(f), STROKE_JOIN.get(f), miterLimit, dashes, (float)((double)STROKE_DASH_PHASE.get(f).floatValue() * dashFactor));
    }

    public static Font getFont(Figure f) {
        Font prototype = FONT_FACE.get(f);
        if (prototype == null) {
            return null;
        }
        if (AttributeKeys.getFontStyle(f) != 0) {
            return prototype.deriveFont(AttributeKeys.getFontStyle(f), FONT_SIZE.get(f).floatValue());
        }
        return prototype.deriveFont(FONT_SIZE.get(f).floatValue());
    }

    public static int getFontStyle(Figure f) {
        int style = 0;
        if (FONT_BOLD.get(f).booleanValue()) {
            style |= 1;
        }
        if (FONT_ITALIC.get(f).booleanValue()) {
            style |= 2;
        }
        return style;
    }

    public static double getPerpendicularFillGrowth(Figure f) {
        double grow;
        double strokeWidth = AttributeKeys.getStrokeTotalWidth(f);
        StrokePlacement placement = STROKE_PLACEMENT.get(f);
        block0 : switch (FILL_UNDER_STROKE.get(f)) {
            case FULL: {
                switch (placement) {
                    case INSIDE: {
                        grow = 0.0;
                        break block0;
                    }
                    case OUTSIDE: {
                        grow = strokeWidth;
                        break block0;
                    }
                }
                grow = strokeWidth / 2.0;
                break;
            }
            case NONE: {
                switch (placement) {
                    case INSIDE: {
                        grow = -strokeWidth;
                        break block0;
                    }
                    case OUTSIDE: {
                        grow = 0.0;
                        break block0;
                    }
                }
                grow = strokeWidth / -2.0;
                break;
            }
            default: {
                switch (placement) {
                    case INSIDE: {
                        grow = strokeWidth / -2.0;
                        break block0;
                    }
                    case OUTSIDE: {
                        grow = strokeWidth / 2.0;
                        break block0;
                    }
                }
                grow = 0.0;
            }
        }
        return grow;
    }

    public static double getPerpendicularDrawGrowth(Figure f) {
        double grow;
        double strokeWidth = AttributeKeys.getStrokeTotalWidth(f);
        switch (STROKE_PLACEMENT.get(f)) {
            case INSIDE: {
                grow = strokeWidth / -2.0;
                break;
            }
            case OUTSIDE: {
                grow = strokeWidth / 2.0;
                break;
            }
            default: {
                grow = 0.0;
            }
        }
        return grow;
    }

    public static double getPerpendicularHitGrowth(Figure f) {
        double grow;
        if (STROKE_COLOR.get(f) == null) {
            grow = AttributeKeys.getPerpendicularFillGrowth(f);
        } else {
            double strokeWidth = AttributeKeys.getStrokeTotalWidth(f);
            grow = AttributeKeys.getPerpendicularDrawGrowth(f) + strokeWidth / 2.0;
        }
        return grow;
    }

    public static enum Orientation {
        NORTH,
        NORTH_EAST,
        EAST,
        SOUTH_EAST,
        SOUTH,
        SOUTH_WEST,
        WEST,
        NORTH_WEST;

    }

    public static enum StrokePlacement {
        CENTER,
        INSIDE,
        OUTSIDE;

    }

    public static enum StrokeType {
        BASIC,
        DOUBLE;

    }

    public static enum Underfill {
        NONE,
        CENTER,
        FULL;

    }

    public static enum WindingRule {
        EVEN_ODD,
        NON_ZERO;

    }
}

