/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.AbstractTool;
import org.jhotdraw.draw.AtributoChaveFigure;
import org.jhotdraw.draw.AtributoChaveParcialFigure;
import org.jhotdraw.draw.AtributoDerivadoFigure;
import org.jhotdraw.draw.AtributoFigure;
import org.jhotdraw.draw.AtributoMultivaloradoFigure;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.CircleFigure;
import org.jhotdraw.draw.CompositeFigure;
import org.jhotdraw.draw.DiamondFigure;
import org.jhotdraw.draw.DisjuncaoFigure;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.EllipseFigure;
import org.jhotdraw.draw.EntidadeFigure;
import org.jhotdraw.draw.EntidadeFracaFigure;
import org.jhotdraw.draw.EntidadeRelacionamentoFigure;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.GroupFigure;
import org.jhotdraw.draw.RectangleFigure;
import org.jhotdraw.draw.RelacionamentoFigure;
import org.jhotdraw.draw.RelacionamentoFracoFigure;
import org.jhotdraw.draw.SobreposicaoFigure;
import org.jhotdraw.draw.TextAreaFigure;
import org.jhotdraw.draw.TextFigure;
import org.jhotdraw.draw.TextItalicoFigure;
import org.jhotdraw.draw.TextNegritoFigure;
import org.jhotdraw.draw.UniaoFigure;
import org.jhotdraw.util.ResourceBundleUtil;

public class CreationTool
extends AbstractTool {
    private Map<AttributeKey, Object> prototypeAttributes;
    private String presentationName;
    private Dimension minimalSizeTreshold = new Dimension(2, 2);
    private Dimension minimalSize = new Dimension(40, 40);
    private Figure prototype;
    protected Figure createdFigure;

    public CreationTool(String prototypeClassName) {
        this(prototypeClassName, null, null);
    }

    public CreationTool(String prototypeClassName, Map<AttributeKey, Object> attributes) {
        this(prototypeClassName, attributes, null);
    }

    public CreationTool(String prototypeClassName, Map<AttributeKey, Object> attributes, String name) {
        try {
            this.prototype = (Figure)Class.forName(prototypeClassName).newInstance();
        }
        catch (Exception e) {
            InternalError error = new InternalError("Unable to create Figure from " + prototypeClassName);
            error.initCause(e);
            throw error;
        }
        this.prototypeAttributes = attributes;
        if (name == null) {
            ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
            name = labels.getString("createFigure");
        }
        this.presentationName = name;
    }

    public CreationTool(Figure prototype) {
        this(prototype, null, null);
    }

    public CreationTool(Figure prototype, String name) {
        this(prototype, null, name);
    }

    public CreationTool(Figure prototype, Map<AttributeKey, Object> attributes) {
        this(prototype, attributes, null);
    }

    public CreationTool(Figure prototype, Map<AttributeKey, Object> attributes, String name) {
        this.prototype = prototype;
        this.prototypeAttributes = attributes;
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        name = name == null ? labels.getString("createFigure") : labels.getString(String.valueOf(name) + ".desc");
        this.presentationName = name;
    }

    public Figure getPrototype() {
        return this.prototype;
    }

    @Override
    public void activate(DrawingEditor editor) {
        super.activate(editor);
        this.getView().setCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    public void deactivate(DrawingEditor editor) {
        super.deactivate(editor);
        if (this.getView() != null) {
            this.getView().setCursor(Cursor.getDefaultCursor());
        }
        if (this.createdFigure != null) {
            if (this.createdFigure instanceof CompositeFigure) {
                ((CompositeFigure)this.createdFigure).layout();
            }
            this.createdFigure = null;
        }
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        super.mousePressed(evt);
        this.getView().clearSelection();
        this.createdFigure = this.createFigure();
        Point2D.Double p = this.constrainPoint(this.viewToDrawing(this.anchor));
        this.anchor.x = evt.getX();
        this.anchor.y = evt.getY();
        this.createdFigure.setBounds(p, p);
        this.getDrawing().add(this.createdFigure);
        if (!(this.createdFigure instanceof TextFigure) && !(this.createdFigure instanceof TextAreaFigure)) {
            this.mouseReleased(evt);
        }
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
    }

    public void setBoundsEntity(Rectangle2D.Double bounds) {
        GroupFigure gf = (GroupFigure)this.createdFigure;
        gf.setBounds(this.constrainPoint(new Point(this.anchor.x, this.anchor.y)), this.constrainPoint(new Point(this.anchor.x + (int)Math.max(bounds.width, 80.0), this.anchor.y + (int)Math.max(bounds.height, 40.0))));
        for (Figure f : gf.getChildren()) {
            f.setBounds(this.constrainPoint(new Point(this.anchor.x, this.anchor.y)), this.constrainPoint(new Point(this.anchor.x + (int)Math.max(bounds.width, 80.0), this.anchor.y + (int)Math.max(bounds.height, 40.0))));
            if (f.getClass().equals(RectangleFigure.class)) {
                f.setAttribute(AttributeKeys.FILL_COLOR, new Color(235, 255, 232));
                continue;
            }
            if (f.getClass().equals(DiamondFigure.class)) {
                f.setBounds(this.constrainPoint(new Point(this.anchor.x + 2, this.anchor.y + 2)), this.constrainPoint(new Point(this.anchor.x + (int)Math.max(bounds.width, 76.0), this.anchor.y + (int)Math.max(bounds.height, 36.0))));
                f.setAttribute(AttributeKeys.FILL_COLOR, new Color(221, 221, 255));
                continue;
            }
            if (!f.getClass().equals(TextFigure.class)) continue;
            f.setBounds(this.constrainPoint(new Point(this.anchor.x + 10, this.anchor.y + 13)), this.constrainPoint(new Point(this.anchor.x + (int)Math.max(bounds.width, 80.0), this.anchor.y + (int)Math.max(bounds.height, 20.0))));
        }
    }

    public void setBoundsAttribute(Rectangle2D.Double bounds) {
        GroupFigure gf = (GroupFigure)this.createdFigure;
        gf.setBounds(this.constrainPoint(new Point(this.anchor.x, this.anchor.y)), this.constrainPoint(new Point(this.anchor.x + (int)Math.max(bounds.width, 80.0), this.anchor.y + (int)Math.max(bounds.height, 40.0))));
        for (Figure f : gf.getChildren()) {
            f.setBounds(this.constrainPoint(new Point(this.anchor.x, this.anchor.y)), this.constrainPoint(new Point(this.anchor.x + (int)Math.max(bounds.width, 80.0), this.anchor.y + (int)Math.max(bounds.height, 40.0))));
            if (f.getClass().equals(EllipseFigure.class)) {
                f.setAttribute(AttributeKeys.FILL_COLOR, new Color(255, 235, 235));
                if (this.createdFigure.getClass().equals(AtributoChaveParcialFigure.class)) {
                    f.setBounds(this.constrainPoint(new Point(this.anchor.x, this.anchor.y)), this.constrainPoint(new Point(this.anchor.x + (int)Math.max(bounds.width, 125.0), this.anchor.y + (int)Math.max(bounds.height, 27.0))));
                    continue;
                }
                f.setBounds(this.constrainPoint(new Point(this.anchor.x, this.anchor.y)), this.constrainPoint(new Point(this.anchor.x + (int)Math.max(bounds.width, 80.0), this.anchor.y + (int)Math.max(bounds.height, 20.0))));
                continue;
            }
            if (!f.getClass().equals(TextFigure.class)) continue;
            f.setBounds(this.constrainPoint(new Point(this.anchor.x + 10, this.anchor.y + 3)), this.constrainPoint(new Point(this.anchor.x + (int)Math.max(bounds.width, 80.0), this.anchor.y + (int)Math.max(bounds.height, 20.0))));
        }
    }

    public void setBoundsRelationship(Rectangle2D.Double bounds) {
        GroupFigure gf = (GroupFigure)this.createdFigure;
        gf.setBounds(this.constrainPoint(new Point(this.anchor.x, this.anchor.y)), this.constrainPoint(new Point(this.anchor.x + (int)Math.max(bounds.width, 80.0), this.anchor.y + (int)Math.max(bounds.height, 40.0))));
        for (Figure f : gf.getChildren()) {
            if (this.createdFigure.getClass().equals(RelacionamentoFracoFigure.class)) {
                gf.setBounds(this.constrainPoint(new Point(this.anchor.x, this.anchor.y)), this.constrainPoint(new Point(this.anchor.x + (int)Math.max(bounds.width, 97.0), this.anchor.y + (int)Math.max(bounds.height, 50.0))));
            } else {
                f.setBounds(this.constrainPoint(new Point(this.anchor.x, this.anchor.y)), this.constrainPoint(new Point(this.anchor.x + (int)Math.max(bounds.width, 80.0), this.anchor.y + (int)Math.max(bounds.height, 40.0))));
            }
            if (f.getClass().equals(DiamondFigure.class)) {
                f.setAttribute(AttributeKeys.FILL_COLOR, new Color(221, 221, 255));
                continue;
            }
            if (!f.getClass().equals(TextFigure.class)) continue;
            f.setBounds(this.constrainPoint(new Point(this.anchor.x + 15, this.anchor.y + 13)), this.constrainPoint(new Point(this.anchor.x + (int)Math.max(bounds.width, 80.0), this.anchor.y + (int)Math.max(bounds.height, 20.0))));
        }
    }

    public void setBoundsInheritanceMode(Rectangle2D.Double bounds) {
        GroupFigure gf = (GroupFigure)this.createdFigure;
        gf.setBounds(this.constrainPoint(new Point(this.anchor.x, this.anchor.y)), this.constrainPoint(new Point(this.anchor.x + (int)Math.max(bounds.width, 20.0), this.anchor.y + (int)Math.max(bounds.height, 20.0))));
        for (Figure f : gf.getChildren()) {
            if (f.getClass().equals(CircleFigure.class)) {
                f.setAttribute(AttributeKeys.FILL_COLOR, new Color(245, 242, 224));
                f.setBounds(this.constrainPoint(new Point(this.anchor.x, this.anchor.y)), this.constrainPoint(new Point(this.anchor.x + (int)Math.max(bounds.width, 20.0), this.anchor.y + (int)Math.max(bounds.height, 20.0))));
                continue;
            }
            if (!f.getClass().equals(TextNegritoFigure.class)) continue;
            f.setBounds(this.constrainPoint(new Point(this.anchor.x + 4, this.anchor.y + 1)), this.constrainPoint(new Point(this.anchor.x + (int)Math.max(bounds.width, 20.0), this.anchor.y + (int)Math.max(bounds.height, 20.0))));
        }
    }

    public void setBoundsOthes(Rectangle2D.Double bounds) {
        if (this.createdFigure.getClass().equals(RectangleFigure.class) || this.createdFigure.getClass().equals(DiamondFigure.class)) {
            this.createdFigure.setBounds(this.constrainPoint(new Point(this.anchor.x, this.anchor.y)), this.constrainPoint(new Point(this.anchor.x + (int)Math.max(bounds.width, 80.0), this.anchor.y + (int)Math.max(bounds.height, 40.0))));
            if (this.createdFigure.getClass().equals(RectangleFigure.class)) {
                this.createdFigure.setAttribute(AttributeKeys.FILL_COLOR, new Color(235, 255, 232));
            } else if (this.createdFigure.getClass().equals(DiamondFigure.class)) {
                this.createdFigure.setAttribute(AttributeKeys.FILL_COLOR, new Color(221, 221, 255));
            }
        } else if (this.createdFigure.getClass().equals(EllipseFigure.class)) {
            this.createdFigure.setAttribute(AttributeKeys.FILL_COLOR, new Color(255, 235, 235));
            this.createdFigure.setBounds(this.constrainPoint(new Point(this.anchor.x, this.anchor.y)), this.constrainPoint(new Point(this.anchor.x + (int)Math.max(bounds.width, 80.0), this.anchor.y + (int)Math.max(bounds.height, 20.0))));
        } else if (this.createdFigure.getClass().equals(TextNegritoFigure.class)) {
            TextFigure tf = (TextFigure)this.createdFigure;
            tf.setAttribute(tf.getAttributeKey("fontBold"), Boolean.TRUE);
            tf.setFontSize(16.0f);
            tf.setEditable(false);
        } else {
            this.createdFigure.setBounds(this.constrainPoint(new Point(this.anchor.x, this.anchor.y)), this.constrainPoint(new Point(this.anchor.x + (int)Math.max(bounds.width, (double)this.minimalSize.width), this.anchor.y + (int)Math.max(bounds.height, (double)this.minimalSize.height))));
        }
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        if (this.createdFigure != null) {
            Rectangle2D.Double bounds = this.createdFigure.getBounds();
            if (bounds.width == 0.0 && bounds.height == 0.0) {
                this.getDrawing().remove(this.createdFigure);
                this.fireToolDone();
            } else {
                if (Math.abs(this.anchor.x - evt.getX()) < this.minimalSizeTreshold.width && Math.abs(this.anchor.y - evt.getY()) < this.minimalSizeTreshold.height) {
                    this.createdFigure.willChange();
                    if (this.createdFigure.getClass().equals(EntidadeRelacionamentoFigure.class) || this.createdFigure.getClass().equals(EntidadeFigure.class) || this.createdFigure.getClass().equals(EntidadeFracaFigure.class)) {
                        this.setBoundsEntity(bounds);
                    } else if (this.createdFigure.getClass().equals(AtributoFigure.class) || this.createdFigure.getClass().equals(AtributoDerivadoFigure.class) || this.createdFigure.getClass().equals(AtributoMultivaloradoFigure.class) || this.createdFigure.getClass().equals(AtributoChaveFigure.class) || this.createdFigure.getClass().equals(AtributoChaveParcialFigure.class)) {
                        this.setBoundsAttribute(bounds);
                    } else if (this.createdFigure.getClass().equals(RelacionamentoFigure.class) || this.createdFigure.getClass().equals(RelacionamentoFracoFigure.class)) {
                        this.setBoundsRelationship(bounds);
                    } else if (this.createdFigure.getClass().equals(DisjuncaoFigure.class) || this.createdFigure.getClass().equals(UniaoFigure.class) || this.createdFigure.getClass().equals(SobreposicaoFigure.class)) {
                        this.setBoundsInheritanceMode(bounds);
                    } else if (this.createdFigure.getClass().equals(TextItalicoFigure.class)) {
                        ((TextFigure)this.createdFigure).setAttribute(AttributeKeys.FONT_ITALIC, Boolean.TRUE);
                    } else {
                        this.setBoundsOthes(bounds);
                    }
                    this.createdFigure.changed();
                }
                this.getView().addToSelection(this.createdFigure);
                if (this.createdFigure instanceof CompositeFigure) {
                    ((CompositeFigure)this.createdFigure).layout();
                }
                final Figure addedFigure = this.createdFigure;
                final Drawing addedDrawing = this.getDrawing();
                this.getDrawing().fireUndoableEditHappened(new AbstractUndoableEdit(){

                    @Override
                    public String getPresentationName() {
                        return CreationTool.this.presentationName;
                    }

                    @Override
                    public void undo() throws CannotUndoException {
                        super.undo();
                        addedDrawing.remove(addedFigure);
                    }

                    @Override
                    public void redo() throws CannotRedoException {
                        super.redo();
                        addedDrawing.add(addedFigure);
                    }
                });
                this.creationFinished(this.createdFigure);
            }
        } else {
            this.fireToolDone();
        }
    }

    protected Figure createFigure() {
        Figure f = (Figure)this.prototype.clone();
        this.getEditor().applyDefaultAttributesTo(f);
        if (this.prototypeAttributes != null) {
            for (Map.Entry<AttributeKey, Object> entry : this.prototypeAttributes.entrySet()) {
                f.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        return f;
    }

    protected Figure getCreatedFigure() {
        return this.createdFigure;
    }

    protected Figure getAddedFigure() {
        return this.createdFigure;
    }

    protected void creationFinished(Figure createdFigure) {
        this.fireToolDone();
    }
}

