/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JViewport;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.app.EditableComponent;
import org.jhotdraw.draw.Constrainer;
import org.jhotdraw.draw.DefaultDrawingViewTransferHandler;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingEvent;
import org.jhotdraw.draw.DrawingListener;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureAdapter;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.FigureListener;
import org.jhotdraw.draw.FigureSelectionEvent;
import org.jhotdraw.draw.FigureSelectionListener;
import org.jhotdraw.draw.GridConstrainer;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.HandleEvent;
import org.jhotdraw.draw.HandleListener;
import org.jhotdraw.draw.Options;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.util.ReversedList;

public class DefaultDrawingView
extends JComponent
implements DrawingView,
DrawingListener,
HandleListener,
EditableComponent {
    private static final boolean DEBUG = false;
    private Drawing drawing;
    private Set<Figure> dirtyFigures = new HashSet<Figure>();
    private Set<Figure> selectedFigures = new HashSet<Figure>();
    private int rainbow = 0;
    private LinkedList<Handle> selectionHandles = new LinkedList();
    private Handle secondaryHandleOwner;
    private LinkedList<Handle> secondaryHandles = new LinkedList();
    private boolean handlesAreValid = true;
    private Dimension cachedPreferredSize;
    private double scaleFactor = 1.0;
    private Point2D.Double translate = new Point2D.Double(0.0, 0.0);
    private int detailLevel;
    private DrawingEditor editor;
    private Constrainer constrainer = new GridConstrainer(1.0, 1.0);
    private JLabel emptyDrawingLabel;
    private FigureListener handleInvalidator = new FigureAdapter(){

        @Override
        public void figureHandlesChanged(FigureEvent e) {
            DefaultDrawingView.this.invalidateHandles();
        }
    };
    private Rectangle2D.Double cachedDrawingArea;
    private ButtonGroup buttonGroup1;

    public DefaultDrawingView() {
        this.initComponents();
        this.setToolTipText("dummy");
        this.setFocusable(true);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                DefaultDrawingView.this.repaintHandles();
            }

            @Override
            public void focusLost(FocusEvent e) {
                DefaultDrawingView.this.repaintHandles();
            }
        });
        this.setTransferHandler(new DefaultDrawingViewTransferHandler());
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.setLayout(null);
        this.setBackground(new Color(255, 255, 255));
    }

    @Override
    public Drawing getDrawing() {
        return this.drawing;
    }

    @Override
    public String getToolTipText(MouseEvent evt) {
        Handle handle = this.findHandle(evt.getPoint());
        if (handle != null) {
            return handle.getToolTipText(evt.getPoint());
        }
        Figure figure = this.findFigure(evt.getPoint());
        if (figure != null) {
            return figure.getToolTipText(this.viewToDrawing(evt.getPoint()));
        }
        return null;
    }

    public void setEmptyDrawingMessage(String newValue) {
        String oldValue;
        String string = oldValue = this.emptyDrawingLabel == null ? null : this.emptyDrawingLabel.getText();
        if (newValue == null) {
            this.emptyDrawingLabel = null;
        } else {
            this.emptyDrawingLabel = new JLabel(newValue);
            this.emptyDrawingLabel.setHorizontalAlignment(0);
        }
        this.firePropertyChange("emptyDrawingMessage", oldValue, newValue);
        this.repaint();
    }

    public String getEmptyDrawingMessage() {
        return this.emptyDrawingLabel == null ? null : this.emptyDrawingLabel.getText();
    }

    @Override
    public void paintComponent(Graphics gr) {
        Graphics2D g = (Graphics2D)gr;
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, Options.isFractionalMetrics() ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, Options.isTextAntialiased() ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        this.drawBackground(g);
        this.drawGrid(g);
        this.drawDrawing(g);
        this.drawHandles(g);
        this.drawTool(g);
    }

    @Override
    public void printComponent(Graphics gr) {
        Graphics2D g = (Graphics2D)gr;
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, Options.isFractionalMetrics() ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, Options.isTextAntialiased() ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        this.drawDrawing(g);
    }

    protected void drawBackground(Graphics2D g) {
        Dimension2DDouble canvasSize;
        int x = (int)(-this.translate.x * this.scaleFactor);
        int y = (int)(-this.translate.y * this.scaleFactor);
        int w = this.getWidth();
        int h = this.getHeight();
        g.setColor(this.getBackground());
        g.fillRect(x, y, w - x, h - y);
        if (y > 0) {
            g.setColor(new Color(0xF0F0F0));
            g.fillRect(0, 0, w, y);
        }
        if (x > 0) {
            g.setColor(new Color(0xF0F0F0));
            g.fillRect(0, y, x, h - y);
        }
        if (this.getDrawing() != null && (canvasSize = this.getDrawing().getCanvasSize()) != null) {
            Point lowerRight = this.drawingToView(new Point2D.Double(canvasSize.width, canvasSize.height));
            if (lowerRight.x < w) {
                g.setColor(new Color(0xF0F0F0));
                g.fillRect(lowerRight.x, y, w - lowerRight.x, h - y);
            }
            if (lowerRight.y < h) {
                g.setColor(new Color(0xF0F0F0));
                g.fillRect(x, lowerRight.y, w - x, h - lowerRight.y);
            }
        }
    }

    protected void drawGrid(Graphics2D g) {
        this.constrainer.draw(g, this);
    }

    protected void drawDrawing(Graphics2D gr) {
        if (this.drawing != null) {
            if (this.drawing.getFigureCount() == 0 && this.emptyDrawingLabel != null) {
                this.emptyDrawingLabel.setBounds(0, 0, this.getWidth(), this.getHeight());
                this.emptyDrawingLabel.paint(gr);
            } else {
                Graphics2D g = (Graphics2D)gr.create();
                AffineTransform tx = g.getTransform();
                tx.translate(-this.translate.x * this.scaleFactor, -this.translate.y * this.scaleFactor);
                tx.scale(this.scaleFactor, this.scaleFactor);
                g.setTransform(tx);
                this.drawing.setFontRenderContext(g.getFontRenderContext());
                this.drawing.draw(g);
                g.dispose();
            }
        }
    }

    protected void drawHandles(Graphics2D g) {
        if (this.editor != null && this.editor.getActiveView() == this) {
            this.validateHandles();
            for (Handle h : this.getSelectionHandles()) {
                h.draw(g);
            }
            for (Handle h : this.getSecondaryHandles()) {
                h.draw(g);
            }
        }
    }

    protected void drawTool(Graphics2D g) {
        if (this.editor != null && this.editor.getActiveView() == this && this.editor.getTool() != null) {
            this.editor.getTool().draw(g);
        }
    }

    @Override
    public void setDrawing(Drawing d) {
        if (this.drawing != null) {
            this.drawing.removeDrawingListener(this);
            this.clearSelection();
        }
        this.drawing = d;
        if (this.drawing != null) {
            this.drawing.addDrawingListener(this);
        }
        this.invalidateDimension();
        this.invalidate();
        if (this.getParent() != null) {
            this.getParent().validate();
            if (this.getParent() instanceof JViewport) {
                JViewport vp = (JViewport)this.getParent();
                Rectangle2D.Double r = this.getDrawingArea();
                vp.setViewPosition(this.drawingToView(new Point2D.Double(Math.min(0.0, -r.x), Math.min(0.0, -r.y))));
            }
        }
        this.repaint();
    }

    protected void repaint(Rectangle2D.Double r) {
        Rectangle vr = this.drawingToView(r);
        vr.grow(1, 1);
        this.repaint(vr);
    }

    @Override
    public void areaInvalidated(DrawingEvent evt) {
        this.repaint(evt.getInvalidatedArea());
        this.invalidateDimension();
    }

    @Override
    public void areaInvalidated(HandleEvent evt) {
        this.repaint(evt.getInvalidatedArea());
        this.invalidateDimension();
    }

    @Override
    public void figureAdded(DrawingEvent evt) {
        if (evt.getDrawing().getFigureCount() == 1) {
            this.repaint();
        } else {
            this.repaint(evt.getInvalidatedArea());
        }
        this.invalidateDimension();
    }

    @Override
    public void figureRemoved(DrawingEvent evt) {
        if (evt.getDrawing().getFigureCount() == 0) {
            this.repaint();
        } else {
            this.repaint(evt.getInvalidatedArea());
        }
        this.removeFromSelection(evt.getFigure());
        this.invalidateDimension();
    }

    @Override
    public void invalidate() {
        this.invalidateDimension();
        super.invalidate();
    }

    @Override
    public void addToSelection(Figure figure) {
        HashSet<Figure> oldSelection = new HashSet<Figure>(this.selectedFigures);
        if (this.selectedFigures.add(figure)) {
            figure.addFigureListener(this.handleInvalidator);
            HashSet<Figure> newSelection = new HashSet<Figure>(this.selectedFigures);
            this.invalidateHandles();
            this.fireSelectionChanged(oldSelection, newSelection);
            this.repaint();
        }
    }

    @Override
    public void addToSelection(Collection<Figure> figures) {
        HashSet<Figure> oldSelection = new HashSet<Figure>(this.selectedFigures);
        if (this.selectedFigures.addAll(figures)) {
            HashSet<Figure> newSelection = new HashSet<Figure>(this.selectedFigures);
            for (Figure f : figures) {
                f.addFigureListener(this.handleInvalidator);
            }
            this.invalidateHandles();
            this.fireSelectionChanged(oldSelection, newSelection);
            this.repaint();
        }
    }

    @Override
    public void removeFromSelection(Figure figure) {
        HashSet<Figure> oldSelection = new HashSet<Figure>(this.selectedFigures);
        if (this.selectedFigures.remove(figure)) {
            HashSet<Figure> newSelection = new HashSet<Figure>(this.selectedFigures);
            this.invalidateHandles();
            figure.removeFigureListener(this.handleInvalidator);
            this.fireSelectionChanged(oldSelection, newSelection);
            this.repaint();
        }
    }

    @Override
    public void toggleSelection(Figure figure) {
        HashSet<Figure> oldSelection = new HashSet<Figure>(this.selectedFigures);
        if (this.selectedFigures.contains(figure)) {
            this.selectedFigures.remove(figure);
        } else {
            this.selectedFigures.add(figure);
        }
        HashSet<Figure> newSelection = new HashSet<Figure>(this.selectedFigures);
        this.fireSelectionChanged(oldSelection, newSelection);
        this.invalidateHandles();
        this.repaint();
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.setCursor(Cursor.getPredefinedCursor(b ? 0 : 3));
    }

    @Override
    public void selectAll() {
        HashSet<Figure> oldSelection = new HashSet<Figure>(this.selectedFigures);
        this.selectedFigures.clear();
        this.selectedFigures.addAll(this.drawing.getFigures());
        HashSet<Figure> newSelection = new HashSet<Figure>(this.selectedFigures);
        this.invalidateHandles();
        this.fireSelectionChanged(oldSelection, newSelection);
        this.repaint();
    }

    @Override
    public void clearSelection() {
        if (this.getSelectionCount() > 0) {
            HashSet<Figure> oldSelection = new HashSet<Figure>(this.selectedFigures);
            this.selectedFigures.clear();
            HashSet<Figure> newSelection = new HashSet<Figure>(this.selectedFigures);
            this.invalidateHandles();
            this.fireSelectionChanged(oldSelection, newSelection);
        }
        this.repaint();
    }

    @Override
    public boolean isFigureSelected(Figure checkFigure) {
        return this.selectedFigures.contains(checkFigure);
    }

    @Override
    public Set<Figure> getSelectedFigures() {
        return Collections.unmodifiableSet(this.selectedFigures);
    }

    @Override
    public int getSelectionCount() {
        return this.selectedFigures.size();
    }

    private List<Handle> getSelectionHandles() {
        this.validateHandles();
        return Collections.unmodifiableList(this.selectionHandles);
    }

    private List<Handle> getSecondaryHandles() {
        this.validateHandles();
        return Collections.unmodifiableList(this.secondaryHandles);
    }

    private void invalidateHandles() {
        if (this.handlesAreValid) {
            this.handlesAreValid = false;
            Rectangle invalidatedArea = null;
            for (Handle handle : this.selectionHandles) {
                handle.removeHandleListener(this);
                if (invalidatedArea == null) {
                    invalidatedArea = handle.getDrawingArea();
                } else {
                    invalidatedArea.add(handle.getDrawingArea());
                }
                handle.dispose();
            }
            this.selectionHandles.clear();
            this.secondaryHandles.clear();
            switch (this.selectedFigures.size()) {
                case 0: {
                    if (invalidatedArea == null) break;
                    this.repaint(invalidatedArea);
                    break;
                }
                case 1: {
                    if (invalidatedArea == null) break;
                    this.repaint(invalidatedArea);
                    break;
                }
                default: {
                    this.repaint();
                }
            }
        }
    }

    private void validateHandles() {
        if (!this.handlesAreValid) {
            this.handlesAreValid = true;
            Rectangle invalidatedArea = null;
            int level = this.detailLevel;
            do {
                for (Figure figure : this.getSelectedFigures()) {
                    for (Handle handle : figure.createHandles(level)) {
                        handle.setView(this);
                        this.selectionHandles.add(handle);
                        handle.addHandleListener(this);
                        if (invalidatedArea == null) {
                            invalidatedArea = handle.getDrawingArea();
                            continue;
                        }
                        invalidatedArea.add(handle.getDrawingArea());
                    }
                }
            } while (level-- > 0 && this.selectionHandles.size() == 0);
            this.detailLevel = level + 1;
            if (invalidatedArea != null) {
                this.repaint(invalidatedArea);
            }
        }
    }

    @Override
    public Handle findHandle(Point p) {
        this.validateHandles();
        for (Handle handle : new ReversedList<Handle>(this.getSecondaryHandles())) {
            if (!handle.contains(p)) continue;
            return handle;
        }
        for (Handle handle : new ReversedList<Handle>(this.getSelectionHandles())) {
            if (!handle.contains(p)) continue;
            return handle;
        }
        return null;
    }

    @Override
    public Collection<Handle> getCompatibleHandles(Handle master) {
        this.validateHandles();
        HashSet<Figure> owners = new HashSet<Figure>();
        LinkedList<Handle> compatibleHandles = new LinkedList<Handle>();
        owners.add(master.getOwner());
        compatibleHandles.add(master);
        for (Handle handle : this.getSelectionHandles()) {
            if (owners.contains(handle.getOwner()) || !handle.isCombinableWith(master)) continue;
            owners.add(handle.getOwner());
            compatibleHandles.add(handle);
        }
        return compatibleHandles;
    }

    @Override
    public Figure findFigure(Point p) {
        return this.getDrawing().findFigure(this.viewToDrawing(p));
    }

    @Override
    public Collection<Figure> findFigures(Rectangle r) {
        return this.getDrawing().findFigures(this.viewToDrawing(r));
    }

    @Override
    public Collection<Figure> findFiguresWithin(Rectangle r) {
        return this.getDrawing().findFiguresWithin(this.viewToDrawing(r));
    }

    protected void repaintHandles() {
        Rectangle bounds = null;
        for (Handle handle : this.selectionHandles) {
            if (bounds == null) {
                bounds = handle.getDrawingArea();
                continue;
            }
            bounds.add(handle.getDrawingArea());
        }
        if (bounds != null) {
            this.repaint(bounds);
        }
    }

    @Override
    public void addFigureSelectionListener(FigureSelectionListener fsl) {
        this.listenerList.add(FigureSelectionListener.class, fsl);
    }

    @Override
    public void removeFigureSelectionListener(FigureSelectionListener fsl) {
        this.listenerList.remove(FigureSelectionListener.class, fsl);
    }

    protected void fireSelectionChanged(Set<Figure> oldValue, Set<Figure> newValue) {
        if (this.listenerList.getListenerCount() > 0) {
            FigureSelectionEvent event = null;
            Object[] listeners = this.listenerList.getListenerList();
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == FigureSelectionListener.class) {
                    if (event == null) {
                        event = new FigureSelectionEvent(this, oldValue, newValue);
                    }
                    ((FigureSelectionListener)listeners[i + 1]).selectionChanged(event);
                }
                i -= 2;
            }
        }
    }

    @Override
    public void handleRequestRemove(HandleEvent e) {
        this.selectionHandles.remove(e.getHandle());
        e.getHandle().dispose();
        this.invalidateHandles();
        this.repaint(e.getInvalidatedArea());
    }

    protected void invalidateDimension() {
        this.cachedPreferredSize = null;
        this.cachedDrawingArea = null;
    }

    @Override
    public Constrainer getConstrainer() {
        return this.constrainer;
    }

    @Override
    public void setConstrainer(Constrainer newValue) {
        Constrainer oldValue = this.constrainer;
        this.constrainer = newValue;
        this.repaint();
        this.firePropertyChange("constrainer", oldValue, newValue);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.cachedPreferredSize == null) {
            Rectangle2D.Double r = this.getDrawingArea();
            this.translate.x = Math.min(0.0, r.x);
            this.translate.y = Math.min(0.0, r.y);
            this.cachedPreferredSize = new Dimension((int)((r.width + 10.0 - this.translate.x) * this.scaleFactor), (int)((r.height + 10.0 - this.translate.y) * this.scaleFactor));
            this.fireViewTransformChanged();
            this.repaint();
        }
        return this.cachedPreferredSize;
    }

    protected Rectangle2D.Double getDrawingArea() {
        if (this.cachedDrawingArea == null) {
            this.cachedDrawingArea = new Rectangle2D.Double();
            if (this.drawing != null) {
                for (Figure f : this.drawing.getFigures()) {
                    if (this.cachedDrawingArea == null) {
                        this.cachedDrawingArea = f.getDrawingArea();
                        continue;
                    }
                    this.cachedDrawingArea.add(f.getDrawingArea());
                }
            }
            if (this.cachedDrawingArea == null) {
                this.cachedDrawingArea = new Rectangle2D.Double();
            }
        }
        return (Rectangle2D.Double)this.cachedDrawingArea.clone();
    }

    @Override
    public Point drawingToView(Point2D.Double p) {
        return new Point((int)((p.x - this.translate.x) * this.scaleFactor), (int)((p.y - this.translate.y) * this.scaleFactor));
    }

    @Override
    public Point2D.Double viewToDrawing(Point p) {
        return new Point2D.Double((double)p.x / this.scaleFactor + this.translate.x, (double)p.y / this.scaleFactor + this.translate.y);
    }

    @Override
    public Rectangle drawingToView(Rectangle2D.Double r) {
        return new Rectangle((int)((r.x - this.translate.x) * this.scaleFactor), (int)((r.y - this.translate.y) * this.scaleFactor), (int)(r.width * this.scaleFactor), (int)(r.height * this.scaleFactor));
    }

    @Override
    public Rectangle2D.Double viewToDrawing(Rectangle r) {
        return new Rectangle2D.Double((double)r.x / this.scaleFactor + this.translate.x, (double)r.y / this.scaleFactor + this.translate.y, (double)r.width / this.scaleFactor, (double)r.height / this.scaleFactor);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public double getScaleFactor() {
        return this.scaleFactor;
    }

    @Override
    public void setScaleFactor(double newValue) {
        double oldValue = this.scaleFactor;
        this.scaleFactor = newValue;
        this.fireViewTransformChanged();
        this.firePropertyChange("scaleFactor", oldValue, newValue);
        this.invalidateDimension();
        this.invalidate();
        if (this.getParent() != null) {
            this.getParent().validate();
        }
        this.repaint();
    }

    protected void fireViewTransformChanged() {
        for (Handle handle : this.selectionHandles) {
            handle.viewTransformChanged();
        }
        for (Handle handle : this.secondaryHandles) {
            handle.viewTransformChanged();
        }
    }

    @Override
    public void setHandleDetailLevel(int newValue) {
        this.detailLevel = newValue;
        this.invalidateHandles();
        this.repaint();
    }

    @Override
    public int getHandleDetailLevel() {
        return this.detailLevel;
    }

    @Override
    public void handleRequestSecondaryHandles(HandleEvent e) {
        this.secondaryHandleOwner = e.getHandle();
        this.secondaryHandles.clear();
        this.secondaryHandles.addAll(this.secondaryHandleOwner.createSecondaryHandles());
        for (Handle h : this.secondaryHandles) {
            h.setView(this);
            h.addHandleListener(this);
        }
        this.repaint();
    }

    @Override
    public AffineTransform getDrawingToViewTransform() {
        AffineTransform t = new AffineTransform();
        t.scale(this.scaleFactor, this.scaleFactor);
        t.translate(-this.translate.x, -this.translate.y);
        return t;
    }

    @Override
    public void delete() {
        final LinkedList deletionEvents = new LinkedList();
        final LinkedList<Figure> selectedFigures = new LinkedList<Figure>(this.getSelectedFigures());
        this.clearSelection();
        DrawingListener removeListener = new DrawingListener(){

            @Override
            public void areaInvalidated(DrawingEvent e) {
            }

            @Override
            public void figureAdded(DrawingEvent e) {
            }

            @Override
            public void figureRemoved(DrawingEvent evt) {
                deletionEvents.addFirst(evt);
            }
        };
        this.getDrawing().addDrawingListener(removeListener);
        this.getDrawing().removeAll(selectedFigures);
        this.getDrawing().removeDrawingListener(removeListener);
        this.getDrawing().fireUndoableEditHappened(new AbstractUndoableEdit(){

            @Override
            public String getPresentationName() {
                ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
                return labels.getString("delete");
            }

            @Override
            public void undo() throws CannotUndoException {
                super.undo();
                DefaultDrawingView.this.clearSelection();
                Drawing d = DefaultDrawingView.this.getDrawing();
                for (DrawingEvent evt : deletionEvents) {
                    d.add(evt.getIndex(), evt.getFigure());
                }
                DefaultDrawingView.this.addToSelection(selectedFigures);
            }

            @Override
            public void redo() throws CannotRedoException {
                super.redo();
                for (DrawingEvent evt : new ReversedList(deletionEvents)) {
                    DefaultDrawingView.this.getDrawing().remove(evt.getFigure());
                }
            }
        });
    }

    @Override
    public void duplicate() {
        List<Figure> sorted = this.getDrawing().sort(this.getSelectedFigures());
        HashMap<Figure, Figure> originalToDuplicateMap = new HashMap<Figure, Figure>(sorted.size());
        this.clearSelection();
        Drawing drawing = this.getDrawing();
        final ArrayList<Figure> duplicates = new ArrayList<Figure>(sorted.size());
        AffineTransform tx = new AffineTransform();
        tx.translate(5.0, 5.0);
        for (Figure f : sorted) {
            Figure d = (Figure)f.clone();
            d.transform(tx);
            duplicates.add(d);
            originalToDuplicateMap.put(f, d);
            drawing.add(d);
        }
        for (Figure f : duplicates) {
            f.remap(originalToDuplicateMap);
        }
        this.addToSelection(duplicates);
        this.getDrawing().fireUndoableEditHappened(new AbstractUndoableEdit(){

            @Override
            public String getPresentationName() {
                ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
                return labels.getString("duplicate");
            }

            @Override
            public void undo() throws CannotUndoException {
                super.undo();
                DefaultDrawingView.this.getDrawing().removeAll(duplicates);
            }

            @Override
            public void redo() throws CannotRedoException {
                super.redo();
                DefaultDrawingView.this.getDrawing().addAll(duplicates);
            }
        });
    }

    @Override
    public void removeNotify(DrawingEditor editor) {
        this.editor = null;
        this.repaint();
    }

    @Override
    public void addNotify(DrawingEditor editor) {
        this.editor = editor;
        this.repaint();
    }
}

