/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.InputEvent;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEvent;
import org.jhotdraw.draw.DrawingListener;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.InputFormat;
import org.jhotdraw.draw.OutputFormat;
import org.jhotdraw.gui.datatransfer.CompositeTransferable;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.util.ReversedList;

public class DefaultDrawingViewTransferHandler
extends TransferHandler {
    private static final boolean DEBUG = false;

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        boolean retValue;
        if (comp instanceof DrawingView) {
            DrawingView view = (DrawingView)((Object)comp);
            final Drawing drawing = view.getDrawing();
            if (drawing.getInputFormats() == null || drawing.getInputFormats().size() == 0) {
                retValue = false;
            } else {
                retValue = false;
                try {
                    block2: for (InputFormat format : drawing.getInputFormats()) {
                        DataFlavor[] dataFlavorArray = t.getTransferDataFlavors();
                        int n = dataFlavorArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            DataFlavor flavor = dataFlavorArray[n2];
                            if (format.isDataFlavorSupported(flavor)) {
                                final List<Figure> importedFigures = format.readFigures(t);
                                view.clearSelection();
                                drawing.addAll(importedFigures);
                                view.addToSelection(importedFigures);
                                drawing.fireUndoableEditHappened(new AbstractUndoableEdit(){

                                    @Override
                                    public String getPresentationName() {
                                        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
                                        return labels.getString("editPaste");
                                    }

                                    @Override
                                    public void undo() throws CannotUndoException {
                                        super.undo();
                                        drawing.removeAll(importedFigures);
                                    }

                                    @Override
                                    public void redo() throws CannotRedoException {
                                        super.redo();
                                        drawing.addAll(importedFigures);
                                    }
                                });
                                retValue = true;
                                break block2;
                            }
                            ++n2;
                        }
                    }
                    if (!retValue && t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                        List files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                        retValue = true;
                        LinkedList<Figure> storedFigures = new LinkedList<Figure>(drawing.getFigures());
                        for (File file : files) {
                            for (InputFormat format : drawing.getInputFormats()) {
                                if (!file.isFile() || !format.getFileFilter().accept(file)) continue;
                                format.read(file, drawing);
                            }
                        }
                        final LinkedList<Figure> importedFigures = new LinkedList<Figure>(drawing.getFigures());
                        importedFigures.removeAll(storedFigures);
                        if (importedFigures.size() > 0) {
                            view.clearSelection();
                            view.addToSelection(importedFigures);
                            drawing.fireUndoableEditHappened(new AbstractUndoableEdit(){

                                @Override
                                public String getPresentationName() {
                                    ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
                                    return labels.getString("editPaste");
                                }

                                @Override
                                public void undo() throws CannotUndoException {
                                    super.undo();
                                    drawing.removeAll(importedFigures);
                                }

                                @Override
                                public void redo() throws CannotRedoException {
                                    super.redo();
                                    drawing.addAll(importedFigures);
                                }
                            });
                        }
                    }
                }
                catch (Throwable throwable) {}
            }
        } else {
            retValue = super.importData(comp, t);
        }
        return retValue;
    }

    @Override
    public int getSourceActions(JComponent c) {
        DrawingView view;
        int retValue = c instanceof DrawingView ? ((view = (DrawingView)((Object)c)).getDrawing().getOutputFormats().size() > 0 && view.getSelectionCount() > 0 ? 3 : 0) : super.getSourceActions(c);
        return retValue;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        Transferable retValue;
        if (c instanceof DrawingView) {
            DrawingView view = (DrawingView)((Object)c);
            Drawing drawing = view.getDrawing();
            if (drawing.getOutputFormats() == null || drawing.getOutputFormats().size() == 0) {
                retValue = null;
            } else {
                List<Figure> toBeCopied = drawing.sort(view.getSelectedFigures());
                if (toBeCopied.size() > 0) {
                    try {
                        CompositeTransferable transfer = new CompositeTransferable();
                        for (OutputFormat format : drawing.getOutputFormats()) {
                            Transferable t = format.createTransferable(toBeCopied, view.getScaleFactor());
                            if (transfer.isDataFlavorSupported(t.getTransferDataFlavors()[0])) continue;
                            transfer.add(t);
                        }
                        retValue = transfer;
                    }
                    catch (IOException e) {
                        retValue = null;
                    }
                } else {
                    retValue = null;
                }
            }
        } else {
            retValue = super.createTransferable(c);
        }
        return retValue;
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        if (source instanceof DrawingView) {
            final DrawingView view = (DrawingView)((Object)source);
            final Drawing drawing = view.getDrawing();
            if (action == 2) {
                final LinkedList deletionEvents = new LinkedList();
                final LinkedList<Figure> selectedFigures = new LinkedList<Figure>(view.getSelectedFigures());
                view.clearSelection();
                DrawingListener removeListener = new DrawingListener(){

                    @Override
                    public void areaInvalidated(DrawingEvent e) {
                    }

                    @Override
                    public void figureAdded(DrawingEvent e) {
                    }

                    @Override
                    public void figureRemoved(DrawingEvent evt) {
                        deletionEvents.addFirst(evt);
                    }
                };
                drawing.addDrawingListener(removeListener);
                drawing.removeAll(selectedFigures);
                drawing.removeDrawingListener(removeListener);
                drawing.removeAll(selectedFigures);
                drawing.fireUndoableEditHappened(new AbstractUndoableEdit(){

                    @Override
                    public String getPresentationName() {
                        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
                        return labels.getString("delete");
                    }

                    @Override
                    public void undo() throws CannotUndoException {
                        super.undo();
                        view.clearSelection();
                        for (DrawingEvent evt : deletionEvents) {
                            drawing.add(evt.getIndex(), evt.getFigure());
                        }
                        view.addToSelection(selectedFigures);
                    }

                    @Override
                    public void redo() throws CannotRedoException {
                        super.redo();
                        for (DrawingEvent evt : new ReversedList(deletionEvents)) {
                            drawing.remove(evt.getFigure());
                        }
                    }
                });
            }
        } else {
            super.exportDone(source, data, action);
        }
    }

    @Override
    public void exportAsDrag(JComponent comp, InputEvent e, int action) {
        if (comp instanceof DrawingView) {
            DrawingView drawingView = (DrawingView)((Object)comp);
        } else {
            super.exportAsDrag(comp, e, action);
        }
    }

    @Override
    public Icon getVisualRepresentation(Transferable t) {
        Image image = null;
        try {
            image = (Image)t.getTransferData(DataFlavor.imageFlavor);
        }
        catch (IOException iOException) {
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            // empty catch block
        }
        return image == null ? null : new ImageIcon(image);
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        boolean retValue;
        block5: {
            if (comp instanceof DrawingView) {
                DrawingView view = (DrawingView)((Object)comp);
                Drawing drawing = view.getDrawing();
                retValue = false;
                for (InputFormat format : drawing.getInputFormats()) {
                    DataFlavor[] dataFlavorArray = transferFlavors;
                    int n = transferFlavors.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DataFlavor flavor = dataFlavorArray[n2];
                        if (flavor.isFlavorJavaFileListType() || format.isDataFlavorSupported(flavor)) {
                            retValue = true;
                            break block5;
                        }
                        ++n2;
                    }
                }
            } else {
                retValue = super.canImport(comp, transferFlavors);
            }
        }
        return retValue;
    }

    private void getDrawing() {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

