/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;

public class DrawingPageable
implements Pageable {
    private Drawing drawing;
    private PageFormat pageFormat;
    private boolean isAutorotate = false;

    public DrawingPageable(Drawing drawing) {
        this.drawing = drawing;
        Paper paper = new Paper();
        this.pageFormat = new PageFormat();
        this.pageFormat.setPaper(paper);
    }

    @Override
    public int getNumberOfPages() {
        return 1;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        return this.pageFormat;
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        if (pageIndex < 0 || pageIndex >= this.getNumberOfPages()) {
            throw new IndexOutOfBoundsException("Invalid page index:" + pageIndex);
        }
        return new Printable(){

            @Override
            public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
                return DrawingPageable.this.printPage(graphics, pageFormat, pageIndex);
            }
        };
    }

    public int printPage(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex < 0 || pageIndex >= this.getNumberOfPages()) {
            return 1;
        }
        if (this.drawing.getFigureCount() > 0) {
            Graphics2D g = (Graphics2D)graphics;
            this.setRenderingHints(g);
            Rectangle2D.Double drawBounds = null;
            for (Figure f : this.drawing.getFigures()) {
                if (drawBounds == null) {
                    drawBounds = f.getDrawingArea();
                    continue;
                }
                drawBounds.add(f.getDrawingArea());
            }
            AffineTransform tx = new AffineTransform();
            tx.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            if (this.isAutorotate && drawBounds.width > drawBounds.height && pageFormat.getImageableWidth() < pageFormat.getImageableHeight()) {
                double scaleFactor = Math.min(pageFormat.getImageableWidth() / drawBounds.height, pageFormat.getImageableHeight() / drawBounds.width);
                tx.scale(scaleFactor, scaleFactor);
                tx.translate(drawBounds.height, 0.0);
                tx.rotate(1.5707963267948966, 0.0, 0.0);
                tx.translate(-drawBounds.x, -drawBounds.y);
            } else {
                double scaleFactor = Math.min(pageFormat.getImageableWidth() / drawBounds.width, pageFormat.getImageableHeight() / drawBounds.height);
                tx.scale(scaleFactor, scaleFactor);
                tx.translate(-drawBounds.x, -drawBounds.y);
            }
            g.transform(tx);
            this.drawing.draw(g);
        }
        return 0;
    }

    protected void setRenderingHints(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }
}

