/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.Collection;
import org.jhotdraw.draw.AbstractCompositeFigure;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureAdapter;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.GroupFigure;
import org.jhotdraw.draw.RectangleFigure;
import org.jhotdraw.draw.TerraResizeEventFunctions;
import org.jhotdraw.draw.TextFigure;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.xml.DOMInput;

public class EntidadeFigure
extends GroupFigure {
    private TextFigure tf;
    private RectangleFigure rec;
    private static int counter = 0;
    private TerraResizeEventFunctions EventFunctions;

    public EntidadeFigure init() {
        this.rec = new RectangleFigure();
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        this.tf = new TextFigure(String.valueOf(labels.getString("createEntidade").toUpperCase()) + Integer.toString(counter++));
        this.add(this.rec);
        this.add(this.tf);
        this.EventFunctions = new TerraResizeEventFunctions(this, this.rec, this.tf);
        this.tf.addFigureListener(new FigureAdapter(){

            @Override
            public void figureAttributeChanged(FigureEvent e) {
                EntidadeFigure.this.EventFunctions.figureTextChanged(e);
            }

            @Override
            public void figureChanged(FigureEvent e) {
                EntidadeFigure.this.EventFunctions.figureSizeChanged();
            }
        });
        return this;
    }

    public TextFigure getTextFigure() {
        return this.tf;
    }

    @Override
    public String getToolTipText(Point2D.Double p) {
        return this.toString();
    }

    @Override
    public AbstractCompositeFigure clone() {
        EntidadeFigure f = new EntidadeFigure().init();
        f.willChange();
        f.tf.setBounds(this.tf.getBounds());
        f.rec.setBounds(this.rec.getBounds());
        f.changed();
        return f;
    }

    @Override
    public String toString() {
        return this.tf.getText();
    }

    @Override
    public void read(DOMInput in) throws IOException {
        super.read(in);
        Collection<Figure> lst = this.getDecomposition();
        for (Figure f : lst) {
            if (f instanceof TextFigure) {
                this.tf = (TextFigure)f;
                continue;
            }
            if (!(f instanceof RectangleFigure)) continue;
            this.rec = (RectangleFigure)f;
        }
        this.EventFunctions = new TerraResizeEventFunctions(this, this.rec, this.tf);
        this.tf.addFigureListener(new FigureAdapter(){

            @Override
            public void figureAttributeChanged(FigureEvent e) {
                EntidadeFigure.this.EventFunctions.figureTextChanged(e);
            }

            @Override
            public void figureChanged(FigureEvent e) {
                EntidadeFigure.this.EventFunctions.figureSizeChanged();
            }
        });
    }
}

