/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.LabeledLineConnectionFigure;
import org.jhotdraw.util.ResourceBundleUtil;

public class GeneralizacaoLineConnectionFigure
extends LabeledLineConnectionFigure {
    public GeneralizacaoLineConnectionFigure() {
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        this.title = labels.getString("createGeneralizacaoConnection");
    }

    @Override
    public void draw(Graphics2D g) {
        super.draw(g);
        Point2D.Double startPoint = this.getStartPoint();
        Point2D.Double centerPoint = this.getCenter();
        double diffXSemAbs = startPoint.x - centerPoint.x;
        double diffYSemAbs = startPoint.y - centerPoint.y;
        double diffX = Math.abs(startPoint.x - centerPoint.x);
        double diffY = Math.abs(startPoint.y - centerPoint.y);
        double tg = diffY / diffX;
        double arco = Math.toDegrees(Math.atan(tg));
        double anguloInicial = 0.0;
        anguloInicial = diffXSemAbs > 0.0 && diffYSemAbs < 0.0 ? (arco + 90.0) % 360.0 : (diffXSemAbs > 0.0 && diffYSemAbs > 0.0 ? (90.0 - arco) % 360.0 : (diffXSemAbs < 0.0 && diffYSemAbs > 0.0 ? (arco + 270.0) % 360.0 : (270.0 - arco) % 360.0));
        g.setStroke(new BasicStroke(1.0f));
        g.drawArc((int)centerPoint.x - 10, (int)centerPoint.y - 10, 20, 20, (int)anguloInicial - 15, 210);
    }

    @Override
    public boolean handleMouseClick(Point2D.Double p, MouseEvent evt, DrawingView view) {
        return false;
    }
}

