/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.Constrainer;
import org.jhotdraw.draw.Direction;
import org.jhotdraw.draw.DrawingView;

public class GridConstrainer
implements Constrainer {
    private double width;
    private double height;
    private static Color minorColor = new Color(0xEBEBEB);
    private static Color majorColor = new Color(0xCACACA);

    public GridConstrainer(double width, double height) {
        if (width <= 0.0 || height <= 0.0) {
            throw new IllegalArgumentException("Width or height is <= 0");
        }
        this.width = width;
        this.height = height;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    @Override
    public Point2D.Double constrainPoint(Point2D.Double p) {
        p.x = (double)Math.round(p.x / this.width) * this.width;
        p.y = (double)Math.round(p.y / this.height) * this.height;
        return p;
    }

    @Override
    public Point2D.Double constrainPoint(Point2D.Double p, Direction dir) {
        Point2D.Double p0 = this.constrainPoint((Point2D.Double)p.clone());
        switch (dir) {
            case NORTH: {
                p.y = p0.y - this.height;
                break;
            }
            case WEST: {
                p.x = p0.x - this.width;
                break;
            }
            case SOUTH: {
                p.y = p0.y + this.height;
                break;
            }
            case EAST: {
                p.x = p0.x + this.width;
            }
        }
        return p;
    }

    public String toString() {
        return String.valueOf(super.toString()) + "[" + this.width + "," + this.height + "]";
    }

    @Override
    public boolean isVisible() {
        return this.width > 1.0 && this.height > 1.0;
    }

    @Override
    public void draw(Graphics2D g, DrawingView view) {
        if (this.isVisible()) {
            int m;
            int i;
            AffineTransform t = view.getDrawingToViewTransform();
            Rectangle viewBounds = g.getClipBounds();
            Rectangle2D.Double bounds = view.viewToDrawing(viewBounds);
            Point2D.Double origin = this.constrainPoint(new Point2D.Double(bounds.x, bounds.y));
            Point2D.Double point = new Point2D.Double();
            Point2D.Double viewPoint = new Point2D.Double();
            if (this.width * view.getScaleFactor() > 1.0) {
                g.setColor(minorColor);
                i = (int)(origin.x / this.width);
                m = (int)((origin.x + bounds.width) / this.width) + 1;
                while (i <= m) {
                    g.setColor(i % 5 == 0 ? majorColor : minorColor);
                    point.x = this.width * (double)i;
                    t.transform(point, viewPoint);
                    g.drawLine((int)viewPoint.x, viewBounds.y, (int)viewPoint.x, viewBounds.y + viewBounds.height);
                    ++i;
                }
            }
            if (this.height * view.getScaleFactor() > 1.0) {
                g.setColor(minorColor);
                i = (int)(origin.y / this.height);
                m = (int)((origin.y + bounds.height) / this.height) + 1;
                while (i <= m) {
                    g.setColor(i % 5 == 0 ? majorColor : minorColor);
                    point.y = this.height * (double)i;
                    t.transform(point, viewPoint);
                    g.drawLine(viewBounds.x, (int)viewPoint.y, viewBounds.x + viewBounds.width, (int)viewPoint.y);
                    ++i;
                }
            }
        }
    }
}

