/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.filechooser.FileFilter;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.ImageHolderFigure;
import org.jhotdraw.draw.InputFormat;
import org.jhotdraw.io.ExtensionFileFilter;

public class ImageInputFormat
implements InputFormat {
    private ImageHolderFigure prototype;
    private String description;
    private String fileExtension;
    private String formatName;
    private int imageType;

    public ImageInputFormat(ImageHolderFigure prototype) {
        this(prototype, "PNG", "Portable Network Graphics (PNG)", "png", 2);
    }

    public ImageInputFormat(ImageHolderFigure prototype, String formatName, String description, String fileExtension, int bufferedImageType) {
        this.prototype = prototype;
        this.formatName = formatName;
        this.description = description;
        this.fileExtension = fileExtension;
        this.imageType = bufferedImageType;
    }

    @Override
    public FileFilter getFileFilter() {
        return new ExtensionFileFilter(this.description, this.fileExtension);
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    @Override
    public JComponent getInputFormatAccessory() {
        return null;
    }

    @Override
    public void read(File file, Drawing drawing) throws IOException {
        ImageHolderFigure figure = (ImageHolderFigure)this.prototype.clone();
        figure.loadImage(file);
        figure.setBounds(new Point2D.Double(0.0, 0.0), new Point2D.Double(figure.getBufferedImage().getWidth(), figure.getBufferedImage().getHeight()));
        drawing.basicAdd(figure);
    }

    @Override
    public void read(InputStream in, Drawing drawing) throws IOException {
        drawing.basicAdd(this.createImageHolder(in));
    }

    public ImageHolderFigure createImageHolder(InputStream in) throws IOException {
        ImageHolderFigure figure = (ImageHolderFigure)this.prototype.clone();
        figure.loadImage(in);
        figure.setBounds(new Point2D.Double(0.0, 0.0), new Point2D.Double(figure.getBufferedImage().getWidth(), figure.getBufferedImage().getHeight()));
        return figure;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(DataFlavor.imageFlavor);
    }

    @Override
    public List<Figure> readFigures(Transferable t) throws UnsupportedFlavorException, IOException {
        Image img = (Image)t.getTransferData(DataFlavor.imageFlavor);
        if (!(img instanceof BufferedImage)) {
            MediaTracker tracker = new MediaTracker(new JLabel());
            tracker.addImage(img, 0);
            try {
                tracker.waitForAll();
            }
            catch (InterruptedException ex) {
                IOException e = new IOException("MediaTracker interrupted");
                e.initCause(ex);
                throw e;
            }
            BufferedImage buf = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
            Graphics2D g = buf.createGraphics();
            g.drawImage(img, 0, 0, null);
            g.dispose();
            img.flush();
            img = buf;
        }
        ImageHolderFigure figure = (ImageHolderFigure)this.prototype.clone();
        figure.setBufferedImage((BufferedImage)img);
        figure.setBounds(new Point2D.Double(0.0, 0.0), new Point2D.Double(figure.getBufferedImage().getWidth(), figure.getBufferedImage().getHeight()));
        LinkedList<Figure> list = new LinkedList<Figure>();
        list.add(figure);
        return list;
    }
}

