/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.datatransfer.Transferable;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.OutputFormat;
import org.jhotdraw.gui.datatransfer.ImageTransferable;
import org.jhotdraw.io.ExtensionFileFilter;

public class ImageOutputFormat
implements OutputFormat {
    private String description;
    private String fileExtension;
    private String formatName;
    private int imageType;

    public ImageOutputFormat() {
        this("PNG", "Portable Network Graphics (PNG)", "png", 2);
    }

    public ImageOutputFormat(String formatName, String description, String fileExtension, int bufferedImageType) {
        this.formatName = formatName;
        this.description = description;
        this.fileExtension = fileExtension;
        this.imageType = bufferedImageType;
    }

    @Override
    public FileFilter getFileFilter() {
        return new ExtensionFileFilter(this.description, this.fileExtension);
    }

    @Override
    public String getFileExtension() {
        return this.fileExtension;
    }

    @Override
    public JComponent getOutputFormatAccessory() {
        return null;
    }

    @Override
    public void write(File file, Drawing drawing) throws IOException {
        try (FilterOutputStream out = null;){
            out = new BufferedOutputStream(new FileOutputStream(file));
            this.write((OutputStream)out, drawing);
        }
    }

    @Override
    public void write(OutputStream out, Drawing drawing) throws IOException {
        this.write(out, drawing.getFigures(), null, null);
    }

    public void write(OutputStream out, Drawing drawing, AffineTransform drawingTransform, Dimension imageSize) throws IOException {
        this.write(out, drawing.getFigures(), drawingTransform, imageSize);
    }

    @Override
    public Transferable createTransferable(List<Figure> figures, double scaleFactor) throws IOException {
        return new ImageTransferable(this.toImage(figures, scaleFactor));
    }

    public void write(OutputStream out, List<Figure> figures) throws IOException {
        this.write(out, figures, null, null);
    }

    public void write(OutputStream out, List<Figure> figures, AffineTransform drawingTransform, Dimension imageSize) throws IOException {
        BufferedImage img = drawingTransform == null || imageSize == null ? this.toImage(figures, 1.0) : this.toImage(figures, drawingTransform, imageSize);
        ImageIO.write((RenderedImage)img, this.formatName, out);
        img.flush();
    }

    public BufferedImage toImage(List<Figure> figures, double scaleFactor) {
        Rectangle2D.Double drawBounds = null;
        for (Figure f : figures) {
            if (drawBounds == null) {
                drawBounds = f.getDrawingArea();
                continue;
            }
            drawBounds.add(f.getDrawingArea());
        }
        AffineTransform transform = new AffineTransform();
        if (drawBounds.x < 0.0) {
            transform.translate(-drawBounds.x * scaleFactor, 0.0);
        }
        if (drawBounds.y < 0.0) {
            transform.translate(0.0, -drawBounds.y * scaleFactor);
        }
        transform.scale(scaleFactor, scaleFactor);
        return this.toImage(figures, transform, new Dimension((int)((Math.max(0.0, drawBounds.x) + drawBounds.width + 20.0) * scaleFactor), (int)((Math.max(0.0, drawBounds.y) + drawBounds.height + 20.0) * scaleFactor)));
    }

    public BufferedImage toImage(List<Figure> figures, AffineTransform transform, Dimension imageSize) {
        BufferedImage buf = new BufferedImage(imageSize.width, imageSize.height, 2);
        Graphics2D g = buf.createGraphics();
        Composite savedComposite = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(2));
        g.setColor(new Color(0xFFFFFF, true));
        g.fillRect(0, 0, buf.getWidth(), buf.getHeight());
        g.setComposite(savedComposite);
        this.setRenderingHints(g);
        g.transform(transform);
        for (Figure f : figures) {
            f.draw(g);
        }
        g.dispose();
        if (this.imageType != 2) {
            BufferedImage buf2 = new BufferedImage(buf.getWidth(), buf.getHeight(), this.imageType);
            g = buf2.createGraphics();
            g.setComposite(AlphaComposite.getInstance(2));
            g.drawImage((Image)buf, 0, 0, null);
            g.dispose();
            buf.flush();
            buf = buf2;
        }
        return buf;
    }

    protected void setRenderingHints(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }
}

