/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import org.jhotdraw.draw.AbstractDrawing;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureAdapter;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.FigureLayerComparator;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.geom.QuadTree;
import org.jhotdraw.util.ReversedList;

public class QuadTreeDrawing
extends AbstractDrawing {
    private ArrayList<Figure> figures = new ArrayList();
    private QuadTree<Figure> quadTree = new QuadTree();
    private boolean needsSorting = false;
    private FigureHandler figureHandler = this.createFigureHandler();
    private Dimension2DDouble canvasSize;

    protected FigureHandler createFigureHandler() {
        return new FigureHandler();
    }

    @Override
    public int indexOf(Figure figure) {
        return this.figures.indexOf(figure);
    }

    @Override
    public void basicAdd(int index, Figure figure) {
        this.figures.add(index, figure);
        this.quadTree.add(figure, figure.getDrawingArea());
        figure.addFigureListener(this.figureHandler);
        this.needsSorting = true;
    }

    @Override
    public void basicRemove(Figure figure) {
        this.figures.remove(figure);
        this.quadTree.remove(figure);
        figure.removeFigureListener(this.figureHandler);
        this.needsSorting = true;
    }

    @Override
    public void draw(Graphics2D g) {
        Rectangle clipBounds = g.getClipBounds();
        if (clipBounds != null) {
            Collection<Figure> c = this.quadTree.findIntersects(clipBounds);
            List<Figure> toDraw = this.sort(c);
            this.draw(g, toDraw);
        } else {
            this.draw(g, this.figures);
        }
    }

    @Override
    public List<Figure> sort(Collection<Figure> c) {
        this.ensureSorted();
        ArrayList<Figure> sorted = new ArrayList<Figure>(c.size());
        for (Figure f : this.figures) {
            if (!c.contains(f)) continue;
            sorted.add(f);
        }
        return sorted;
    }

    public void draw(Graphics2D g, Collection<Figure> c) {
        for (Figure f : c) {
            f.draw(g);
        }
    }

    public List<Figure> getFigures(Rectangle2D.Double bounds) {
        return new LinkedList<Figure>(this.quadTree.findInside(bounds));
    }

    @Override
    public List<Figure> getFigures() {
        return Collections.unmodifiableList(this.figures);
    }

    @Override
    public Figure findFigureInside(Point2D.Double p) {
        Collection<Figure> c = this.quadTree.findContains(p);
        for (Figure f : this.getFiguresFrontToBack()) {
            if (!c.contains(f) || !f.contains(p)) continue;
            return f.findFigureInside(p);
        }
        return null;
    }

    @Override
    public List<Figure> getFiguresFrontToBack() {
        this.ensureSorted();
        return new ReversedList<Figure>(this.figures);
    }

    @Override
    public Figure findFigure(Point2D.Double p) {
        Collection<Figure> c = this.quadTree.findContains(p);
        switch (c.size()) {
            case 0: {
                return null;
            }
            case 1: {
                Figure f = c.iterator().next();
                return f.contains(p) ? f : null;
            }
        }
        for (Figure f : this.getFiguresFrontToBack()) {
            if (!c.contains(f) || !f.contains(p)) continue;
            return f;
        }
        return null;
    }

    @Override
    public Figure findFigureExcept(Point2D.Double p, Figure ignore) {
        Collection<Figure> c = this.quadTree.findContains(p);
        switch (c.size()) {
            case 0: {
                return null;
            }
            case 1: {
                Figure f = c.iterator().next();
                return f == ignore || !f.contains(p) ? null : f;
            }
        }
        for (Figure f : this.getFiguresFrontToBack()) {
            if (f == ignore || !f.contains(p)) continue;
            return f;
        }
        return null;
    }

    public Figure findFigureExcept(Point2D.Double p, Collection ignore) {
        Collection<Figure> c = this.quadTree.findContains(p);
        switch (c.size()) {
            case 0: {
                return null;
            }
            case 1: {
                Figure f = c.iterator().next();
                return !ignore.contains(f) || !f.contains(p) ? null : f;
            }
        }
        for (Figure f : this.getFiguresFrontToBack()) {
            if (ignore.contains(f) || !f.contains(p)) continue;
            return f;
        }
        return null;
    }

    @Override
    public Figure findFigureBehind(Point2D.Double p, Figure figure) {
        boolean isBehind = false;
        for (Figure f : this.getFiguresFrontToBack()) {
            if (isBehind) {
                if (!f.isVisible() || !f.contains(p)) continue;
                return f;
            }
            boolean bl = isBehind = figure == f;
        }
        return null;
    }

    @Override
    public Figure findFigureBehind(Point2D.Double p, Collection<Figure> figures) {
        int inFrontOf = figures.size();
        for (Figure f : this.getFiguresFrontToBack()) {
            if (inFrontOf == 0) {
                if (!f.isVisible() || !f.contains(p)) continue;
                return f;
            }
            if (!figures.contains(f)) continue;
            --inFrontOf;
        }
        return null;
    }

    @Override
    public List<Figure> findFigures(Rectangle2D.Double r) {
        LinkedList<Figure> c = new LinkedList<Figure>(this.quadTree.findIntersects(r));
        switch (c.size()) {
            case 0: 
            case 1: {
                return c;
            }
        }
        return this.sort(c);
    }

    @Override
    public List<Figure> findFiguresWithin(Rectangle2D.Double bounds) {
        LinkedList<Figure> contained = new LinkedList<Figure>();
        for (Figure f : this.figures) {
            Rectangle2D r = f.getBounds();
            if (AttributeKeys.TRANSFORM.get(f) != null) {
                r = AttributeKeys.TRANSFORM.get(f).createTransformedShape(r).getBounds2D();
            }
            if (!f.isVisible() || !bounds.contains(r)) continue;
            contained.add(f);
        }
        return contained;
    }

    @Override
    public void bringToFront(Figure figure) {
        if (this.figures.remove(figure)) {
            this.figures.add(figure);
            this.needsSorting = true;
            this.fireAreaInvalidated(figure.getDrawingArea());
        }
    }

    @Override
    public void sendToBack(Figure figure) {
        if (this.figures.remove(figure)) {
            this.figures.add(0, figure);
            this.needsSorting = true;
            this.fireAreaInvalidated(figure.getDrawingArea());
        }
    }

    @Override
    public boolean contains(Figure f) {
        return this.figures.contains(f);
    }

    private void ensureSorted() {
        if (this.needsSorting) {
            Collections.sort(this.figures, FigureLayerComparator.INSTANCE);
            this.needsSorting = false;
        }
    }

    @Override
    public void setCanvasSize(Dimension2DDouble newValue) {
        Dimension2DDouble oldValue = this.canvasSize;
        this.canvasSize = newValue;
        this.firePropertyChange("canvasSize", oldValue, newValue);
    }

    @Override
    public Dimension2DDouble getCanvasSize() {
        return this.canvasSize;
    }

    protected class FigureHandler
    extends FigureAdapter
    implements UndoableEditListener {
        protected FigureHandler() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            QuadTreeDrawing.this.fireUndoableEditHappened(e.getEdit());
        }

        @Override
        public void figureAreaInvalidated(FigureEvent e) {
            QuadTreeDrawing.this.fireAreaInvalidated(e.getInvalidatedArea());
        }

        @Override
        public void figureChanged(FigureEvent e) {
            QuadTreeDrawing.this.quadTree.remove(e.getFigure());
            QuadTreeDrawing.this.quadTree.add(e.getFigure(), e.getFigure().getDrawingArea());
            QuadTreeDrawing.this.needsSorting = true;
            QuadTreeDrawing.this.fireAreaInvalidated(e.getInvalidatedArea());
        }

        @Override
        public void figureRequestRemove(FigureEvent e) {
            QuadTreeDrawing.this.remove(e.getFigure());
        }
    }
}

