/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jhotdraw.draw.AtributoChaveFigure;
import org.jhotdraw.draw.AtributoChaveParcialFigure;
import org.jhotdraw.draw.AtributoDerivadoFigure;
import org.jhotdraw.draw.AtributoFigure;
import org.jhotdraw.draw.AtributoMultivaloradoFigure;
import org.jhotdraw.draw.ConnectionAttribute;
import org.jhotdraw.draw.DisjuncaoFigure;
import org.jhotdraw.draw.DoubleLineConnectionGeneralizacaoFigure;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.EntidadeFigure;
import org.jhotdraw.draw.EntidadeFracaFigure;
import org.jhotdraw.draw.EntidadeRelacionamentoFigure;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureSelectionEvent;
import org.jhotdraw.draw.FigureSelectionListener;
import org.jhotdraw.draw.GeneralizacaoLineConnectionFigure;
import org.jhotdraw.draw.LabeledDoubleLineConnectionMuitosFigure;
import org.jhotdraw.draw.LabeledDoubleLineConnectionUmFigure;
import org.jhotdraw.draw.LabeledLineConnectionMuitosFigure;
import org.jhotdraw.draw.LabeledLineConnectionUmFigure;
import org.jhotdraw.draw.LineConnectionGeneralizacaoFigure;
import org.jhotdraw.draw.RelacionamentoFigure;
import org.jhotdraw.draw.RelacionamentoFracoFigure;
import org.jhotdraw.draw.SobreposicaoFigure;
import org.jhotdraw.draw.TextItalicoFigure;
import org.jhotdraw.draw.UniaoFigure;
import org.jhotdraw.util.ResourceBundleUtil;

public class TerraFigureTree
extends JTree {
    private static TerraFigureTree instance = null;
    private DrawingView ActiveView = null;
    private DefaultTreeModel dtmTreeModel = null;
    private DefaultMutableTreeNode nodRoot = null;
    private DefaultMutableTreeNode nodEntidades = null;
    private DefaultMutableTreeNode nodRelacionamentos = null;
    private DefaultMutableTreeNode nodAtributos = null;
    private DefaultMutableTreeNode nodOutros = null;
    private boolean DrawSelectionEventHandle = true;
    private boolean TreeSelectionEventHandle = true;

    protected TerraFigureTree() {
        this.buildTreeNodes();
        this.dtmTreeModel = new DefaultTreeModel(this.nodRoot);
        this.setModel(this.dtmTreeModel);
        this.setRootVisible(false);
        this.getSelectionModel().setSelectionMode(4);
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TerraFigureTree.this.treeSelectionChanged();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    TerraFigureTree.this.removeFromDrawing();
                }
            }
        });
    }

    public static TerraFigureTree getInstance() {
        if (instance == null) {
            instance = new TerraFigureTree();
        }
        return instance;
    }

    protected void buildTreeNodes() {
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.app.Labels");
        this.nodRoot = new DefaultMutableTreeNode("Root");
        this.nodEntidades = new DefaultMutableTreeNode(labels.getString("node.entities"));
        this.nodRelacionamentos = new DefaultMutableTreeNode(labels.getString("node.relationships"));
        this.nodAtributos = new DefaultMutableTreeNode(labels.getString("node.attributes"));
        this.nodOutros = new DefaultMutableTreeNode(labels.getString("node.others"));
        this.nodRoot.add(this.nodEntidades);
        this.nodRoot.add(this.nodRelacionamentos);
        this.nodRoot.add(this.nodAtributos);
        this.nodRoot.add(this.nodOutros);
        Vector<DefaultMutableTreeNode> vctTopNodes = new Vector<DefaultMutableTreeNode>();
        vctTopNodes.add(this.nodEntidades);
        vctTopNodes.add(this.nodRelacionamentos);
        vctTopNodes.add(this.nodAtributos);
        vctTopNodes.add(this.nodOutros);
        this.setCellRenderer(new TerraTreeCellRenderer(vctTopNodes));
    }

    public void setView(DrawingView d) {
        this.ActiveView = d;
        this.ActiveView.addFigureSelectionListener(new FigureSelectionListener(){

            @Override
            public void selectionChanged(FigureSelectionEvent evt) {
                TerraFigureTree.this.setSelectedFigure(evt);
            }
        });
    }

    @Override
    public void removeAll() {
        this.nodEntidades.removeAllChildren();
        this.nodRelacionamentos.removeAllChildren();
        this.nodAtributos.removeAllChildren();
        this.nodOutros.removeAllChildren();
        this.dtmTreeModel.reload(this.nodRoot);
    }

    public void add(Figure f) {
        DefaultMutableTreeNode Node2 = this.chooseApropriateNode(f);
        Node2.add(new DefaultMutableTreeNode(f));
        this.dtmTreeModel.reload(Node2);
    }

    public void remove(Figure f) {
        DefaultMutableTreeNode Node2 = this.chooseApropriateNode(f);
        Enumeration<TreeNode> NodeChildren = Node2.children();
        while (NodeChildren.hasMoreElements()) {
            DefaultMutableTreeNode Child = (DefaultMutableTreeNode)NodeChildren.nextElement();
            if (Child.getUserObject() != f) continue;
            Node2.remove(Child);
            break;
        }
        this.dtmTreeModel.reload(Node2);
    }

    protected DefaultMutableTreeNode find(Figure f) {
        DefaultMutableTreeNode Ret = null;
        DefaultMutableTreeNode Node2 = this.chooseApropriateNode(f);
        Enumeration<TreeNode> NodeChildren = Node2.children();
        while (NodeChildren.hasMoreElements()) {
            DefaultMutableTreeNode Child = (DefaultMutableTreeNode)NodeChildren.nextElement();
            if (Child.getUserObject() != f) continue;
            Ret = Child;
            break;
        }
        return Ret;
    }

    protected DefaultMutableTreeNode chooseApropriateNode(Figure f) {
        DefaultMutableTreeNode ChosenNode = null;
        ChosenNode = f instanceof EntidadeFigure || f instanceof EntidadeFracaFigure ? this.nodEntidades : (f instanceof RelacionamentoFigure || f instanceof RelacionamentoFracoFigure || f instanceof EntidadeRelacionamentoFigure ? this.nodRelacionamentos : (f instanceof AtributoFigure || f instanceof AtributoChaveFigure || f instanceof AtributoChaveParcialFigure || f instanceof AtributoDerivadoFigure || f instanceof AtributoMultivaloradoFigure ? this.nodAtributos : this.nodOutros));
        return ChosenNode;
    }

    protected void setSelectedFigure(FigureSelectionEvent evt) {
        if (this.DrawSelectionEventHandle) {
            this.TreeSelectionEventHandle = false;
            Set<Figure> figsel = evt.getNewSelection();
            TreePath[] SelectedNodesPath = new TreePath[figsel.size()];
            int i = 0;
            for (Figure f : figsel) {
                DefaultMutableTreeNode Node2 = this.find(f);
                SelectedNodesPath[i] = new TreePath(Node2.getPath());
                ++i;
            }
            this.setSelectionPaths(SelectedNodesPath);
            this.TreeSelectionEventHandle = true;
        }
    }

    public void treeSelectionChanged() {
        if (this.TreeSelectionEventHandle) {
            this.DrawSelectionEventHandle = false;
            TreePath[] SelectedNodesPath = this.getSelectionPaths();
            if (SelectedNodesPath != null) {
                this.ActiveView.clearSelection();
                int i = 0;
                while (i < SelectedNodesPath.length) {
                    DefaultMutableTreeNode Node2 = (DefaultMutableTreeNode)SelectedNodesPath[i].getLastPathComponent();
                    Object O = Node2.getUserObject();
                    if (O instanceof Figure) {
                        Figure f = (Figure)O;
                        this.ActiveView.addToSelection(f);
                    }
                    ++i;
                }
            }
            this.DrawSelectionEventHandle = true;
        }
    }

    public void removeFromDrawing() {
        TreePath[] SelectedNodesPath = this.getSelectionPaths();
        if (SelectedNodesPath != null) {
            int i = 0;
            while (i < SelectedNodesPath.length) {
                DefaultMutableTreeNode Node2 = (DefaultMutableTreeNode)SelectedNodesPath[i].getLastPathComponent();
                Object O = Node2.getUserObject();
                if (O instanceof Figure) {
                    Figure f = (Figure)O;
                    this.ActiveView.getDrawing().remove(f);
                }
                ++i;
            }
        }
    }

    public void refresh(Figure f) {
        this.TreeSelectionEventHandle = false;
        this.DrawSelectionEventHandle = false;
        TreePath[] SelectedNodesPath = this.getSelectionPaths();
        this.dtmTreeModel.reload(this.chooseApropriateNode(f));
        this.setSelectionPaths(SelectedNodesPath);
        this.TreeSelectionEventHandle = true;
        this.DrawSelectionEventHandle = true;
    }

    class TerraTreeCellRenderer
    extends DefaultTreeCellRenderer {
        protected Vector<DefaultMutableTreeNode> vctTopNodes;

        public TerraTreeCellRenderer(Vector<DefaultMutableTreeNode> TopNodes) {
            this.vctTopNodes = TopNodes;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            ImageIcon Img = this.findIcon(value);
            if (Img != null) {
                this.setIcon(Img);
            }
            return this;
        }

        protected ImageIcon findIcon(Object value) {
            ImageIcon Ret = null;
            DefaultMutableTreeNode Node2 = (DefaultMutableTreeNode)value;
            if (Node2 != null && !Node2.isRoot() && !this.vctTopNodes.contains(Node2) && Node2.getUserObject() instanceof Figure) {
                Figure f = (Figure)Node2.getUserObject();
                if (f instanceof EntidadeFigure) {
                    Ret = new ImageIcon(this.getClass().getResource("/org/jhotdraw/draw/action/images/createEntidade.png"));
                } else if (f instanceof EntidadeFracaFigure) {
                    Ret = new ImageIcon(this.getClass().getResource("/org/jhotdraw/draw/action/images/createEntidadeFraca.png"));
                } else if (f instanceof RelacionamentoFigure) {
                    Ret = new ImageIcon(this.getClass().getResource("/org/jhotdraw/draw/action/images/createRelacionamento.png"));
                } else if (f instanceof RelacionamentoFracoFigure) {
                    Ret = new ImageIcon(this.getClass().getResource("/org/jhotdraw/draw/action/images/createRelacionamentoFraco.png"));
                } else if (f instanceof EntidadeRelacionamentoFigure) {
                    Ret = new ImageIcon(this.getClass().getResource("/org/jhotdraw/draw/action/images/createEntidadeRelacionamento.png"));
                } else if (f instanceof AtributoFigure) {
                    Ret = new ImageIcon(this.getClass().getResource("/org/jhotdraw/draw/action/images/createAtributo.png"));
                } else if (f instanceof AtributoChaveFigure) {
                    Ret = new ImageIcon(this.getClass().getResource("/org/jhotdraw/draw/action/images/createAtributoChave.png"));
                } else if (f instanceof AtributoChaveParcialFigure) {
                    Ret = new ImageIcon(this.getClass().getResource("/org/jhotdraw/draw/action/images/createAtributoChaveParcial.png"));
                } else if (f instanceof AtributoDerivadoFigure) {
                    Ret = new ImageIcon(this.getClass().getResource("/org/jhotdraw/draw/action/images/createAtributoDerivado.png"));
                } else if (f instanceof AtributoMultivaloradoFigure) {
                    Ret = new ImageIcon(this.getClass().getResource("/org/jhotdraw/draw/action/images/createAtributoMultivalorado.png"));
                } else if (f instanceof LineConnectionGeneralizacaoFigure) {
                    Ret = new ImageIcon(this.getClass().getResource("/org/jhotdraw/draw/action/images/createElbowConnectionSmall.png"));
                } else if (f instanceof DoubleLineConnectionGeneralizacaoFigure) {
                    Ret = new ImageIcon(this.getClass().getResource("/org/jhotdraw/draw/action/images/createElbowDoubleConnectionSmall.png"));
                } else if (f instanceof GeneralizacaoLineConnectionFigure) {
                    Ret = new ImageIcon(this.getClass().getResource("/org/jhotdraw/draw/action/images/createGeneralizacaoConnectionSmall.png"));
                } else if (f instanceof LabeledDoubleLineConnectionMuitosFigure) {
                    Ret = new ImageIcon(this.getClass().getResource("/org/jhotdraw/draw/action/images/createElbowDoubleMuitosConnectionSmall.png"));
                } else if (f instanceof LabeledDoubleLineConnectionUmFigure) {
                    Ret = new ImageIcon(this.getClass().getResource("/org/jhotdraw/draw/action/images/createElbowDoubleUmConnectionSmall.png"));
                } else if (f instanceof LabeledLineConnectionUmFigure) {
                    Ret = new ImageIcon(this.getClass().getResource("/org/jhotdraw/draw/action/images/createElbowUmConnectionSmall.png"));
                } else if (f instanceof LabeledLineConnectionMuitosFigure) {
                    Ret = new ImageIcon(this.getClass().getResource("/org/jhotdraw/draw/action/images/createElbowMuitosConnectionSmall.png"));
                } else if (f instanceof SobreposicaoFigure) {
                    ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
                    Ret = labels.getImageIcon("createSobreposicaoSmall", SobreposicaoFigure.class);
                } else if (f instanceof UniaoFigure) {
                    ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
                    Ret = labels.getImageIcon("createUniaoSmall", UniaoFigure.class);
                } else if (f instanceof DisjuncaoFigure) {
                    Ret = new ImageIcon(this.getClass().getResource("/org/jhotdraw/draw/action/images/createDisjuncaoSmall.png"));
                } else if (f instanceof TextItalicoFigure) {
                    Ret = new ImageIcon(this.getClass().getResource("/org/jhotdraw/draw/action/images/createPapelSmall.png"));
                } else if (f instanceof ConnectionAttribute) {
                    Ret = new ImageIcon(this.getClass().getResource("/org/jhotdraw/draw/action/images/createElbowConnectionAtributoSmall.png"));
                }
            }
            return Ret;
        }
    }
}

