/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.jhotdraw.app.action.ConnectionRecommendationAction;
import org.jhotdraw.app.action.CopyAction;
import org.jhotdraw.app.action.CutAction;
import org.jhotdraw.app.action.DuplicateAction;
import org.jhotdraw.app.action.PasteAction;
import org.jhotdraw.app.action.SelectAllAction;
import org.jhotdraw.draw.Constrainer;
import org.jhotdraw.draw.DelegationSelectionTool;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.GridConstrainer;
import org.jhotdraw.draw.Tool;
import org.jhotdraw.draw.ToolEvent;
import org.jhotdraw.draw.ToolListener;
import org.jhotdraw.draw.action.AlignAction;
import org.jhotdraw.draw.action.GroupAction;
import org.jhotdraw.draw.action.IncludeSqlStatementAction;
import org.jhotdraw.draw.action.MoveAction;
import org.jhotdraw.draw.action.MoveToBackAction;
import org.jhotdraw.draw.action.MoveToFrontAction;
import org.jhotdraw.draw.action.SelectAttributeTypeAction;
import org.jhotdraw.draw.action.SelectSameAction;
import org.jhotdraw.draw.action.UngroupAction;
import org.jhotdraw.draw.action.ZoomAction;
import org.jhotdraw.gui.JPopupButton;
import org.jhotdraw.util.ResourceBundleUtil;

public class ButtonFactory {
    public static final Map<String, Color> DEFAULT_COLORS;

    static {
        LinkedHashMap<String, Color> m = new LinkedHashMap<String, Color>();
        m.put("Cayenne", new Color(128, 0, 0));
        m.put("Asparagus", new Color(128, 128, 0));
        m.put("Clover", new Color(0, 128, 0));
        m.put("Teal", new Color(0, 128, 128));
        m.put("Midnight", new Color(0, 0, 128));
        m.put("Plum", new Color(128, 0, 128));
        m.put("Tin", new Color(127, 127, 127));
        m.put("Nickel", new Color(128, 128, 128));
        m.put("Maraschino", new Color(255, 0, 0));
        m.put("Lemon", new Color(255, 255, 0));
        m.put("Spring", new Color(0, 255, 0));
        m.put("Turquoise", new Color(0, 255, 255));
        m.put("Blueberry", new Color(0, 0, 255));
        m.put("Magenta", new Color(255, 0, 255));
        m.put("Steel", new Color(102, 102, 102));
        m.put("Aluminium", new Color(153, 153, 153));
        m.put("Salmon", new Color(255, 102, 102));
        m.put("Banana", new Color(255, 255, 102));
        m.put("Flora", new Color(102, 255, 102));
        m.put("Ice", new Color(102, 255, 255));
        m.put("Orchid", new Color(102, 102, 255));
        m.put("Bubblegum", new Color(255, 102, 255));
        m.put("Iron", new Color(76, 76, 76));
        m.put("Magnesium", new Color(179, 179, 179));
        m.put("Mocha", new Color(128, 64, 0));
        m.put("Fern", new Color(64, 128, 0));
        m.put("Moss", new Color(0, 128, 64));
        m.put("Ocean", new Color(0, 64, 128));
        m.put("Eggplant", new Color(64, 0, 128));
        m.put("Maroon", new Color(128, 0, 64));
        m.put("Tungsten", new Color(51, 51, 51));
        m.put("Silver", new Color(204, 204, 204));
        m.put("Tangerine", new Color(255, 128, 0));
        m.put("Lime", new Color(128, 255, 0));
        m.put("Sea Foam", new Color(0, 255, 128));
        m.put("Aqua", new Color(0, 128, 255));
        m.put("Grape", new Color(128, 0, 255));
        m.put("Strawberry", new Color(255, 0, 128));
        m.put("Lead", new Color(25, 25, 25));
        m.put("Mercury", new Color(230, 230, 230));
        m.put("Cantaloupe", new Color(255, 204, 102));
        m.put("Honeydew", new Color(204, 255, 102));
        m.put("Spindrift", new Color(102, 255, 204));
        m.put("Sky", new Color(102, 204, 255));
        m.put("Lavender", new Color(204, 102, 255));
        m.put("Carnation", new Color(255, 111, 207));
        m.put("Licorice", new Color(0, 0, 0));
        m.put("Snow", new Color(255, 255, 255));
        m.put("Transparent", null);
        DEFAULT_COLORS = Collections.unmodifiableMap(m);
    }

    private ButtonFactory() {
    }

    public static Collection<Action> createDrawingActions(DrawingEditor editor) {
        LinkedList<Action> a = new LinkedList<Action>();
        a.add(new CutAction());
        a.add(new CopyAction());
        a.add(new PasteAction());
        a.add(new SelectAllAction());
        a.add(new SelectSameAction(editor));
        a.add(null);
        a.add(ConnectionRecommendationAction.getInstance(editor));
        a.add(new SelectAttributeTypeAction(editor));
        a.add(new IncludeSqlStatementAction(editor));
        return a;
    }

    public static Collection<Action> createSelectionActions(DrawingEditor editor) {
        LinkedList<Action> a = new LinkedList<Action>();
        a.add(new DuplicateAction());
        a.add(null);
        a.add(new GroupAction(editor));
        a.add(new UngroupAction(editor));
        a.add(null);
        a.add(new MoveToFrontAction(editor));
        a.add(new MoveToBackAction(editor));
        return a;
    }

    public static JToggleButton addSelectionToolTo(JToolBar tb, DrawingEditor editor) {
        return ButtonFactory.addSelectionToolTo(tb, editor, ButtonFactory.createDrawingActions(editor), ButtonFactory.createSelectionActions(editor));
    }

    public static JToggleButton addSelectionToolTo(JToolBar tb, DrawingEditor editor, Collection<Action> drawingActions, Collection<Action> selectionActions) {
        JToggleButton t;
        ButtonGroup group;
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        if (tb.getClientProperty("toolButtonGroup") instanceof ButtonGroup) {
            group = (ButtonGroup)tb.getClientProperty("toolButtonGroup");
        } else {
            group = new ButtonGroup();
            tb.putClientProperty("toolButtonGroup", group);
        }
        DelegationSelectionTool selectionTool = new DelegationSelectionTool(drawingActions, selectionActions);
        editor.setTool(selectionTool);
        JToggleButton defaultToolButton = t = new JToggleButton();
        if (tb.getClientProperty("toolHandler") instanceof ToolListener) {
            ToolListener toolHandler = (ToolListener)tb.getClientProperty("toolHandler");
        } else {
            ToolListener toolHandler = new ToolListener(){

                @Override
                public void toolStarted(ToolEvent event) {
                }

                @Override
                public void toolDone(ToolEvent event) {
                }

                @Override
                public void areaInvalidated(ToolEvent e) {
                }
            };
            tb.putClientProperty("toolHandler", toolHandler);
        }
        labels.configureToolBarButton(t, "selectionTool");
        t.setSelected(true);
        t.addItemListener(new ToolButtonListener(selectionTool, editor));
        t.setFocusable(false);
        group.add(t);
        tb.add(t);
        return t;
    }

    public static JToggleButton addToolTo(JToolBar tb, DrawingEditor editor, Tool tool, String labelKey, ResourceBundleUtil labels) {
        ButtonGroup group = (ButtonGroup)tb.getClientProperty("toolButtonGroup");
        ToolListener toolHandler = (ToolListener)tb.getClientProperty("toolHandler");
        JToggleButton t = new JToggleButton();
        labels.configureToolBarButton(t, labelKey);
        t.addItemListener(new ToolButtonListener(tool, editor));
        t.setFocusable(false);
        tool.addToolListener(toolHandler);
        group.add(t);
        tb.add(t);
        return t;
    }

    public static AbstractButton createZoomButton(DrawingView view) {
        return ButtonFactory.createZoomButton(view, new double[]{5.0, 4.0, 3.0, 2.0, 1.5, 1.25, 1.0, 0.75, 0.5, 0.25, 0.1});
    }

    public static AbstractButton createZoomButton(final DrawingView view, double[] factors) {
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        final JPopupButton zoomPopupButton = new JPopupButton();
        labels.configureToolBarButton(zoomPopupButton, "viewZoom");
        zoomPopupButton.setFocusable(false);
        zoomPopupButton.setText(String.valueOf((int)(view.getScaleFactor() * 100.0)) + " %");
        view.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == "scaleFactor") {
                    zoomPopupButton.setText(String.valueOf((int)(view.getScaleFactor() * 100.0)) + " %");
                }
            }
        });
        int i = 0;
        while (i < factors.length) {
            zoomPopupButton.add(new ZoomAction(view, factors[i], zoomPopupButton){

                @Override
                public void actionPerformed(ActionEvent e) {
                    super.actionPerformed(e);
                    zoomPopupButton.setText(String.valueOf((int)(view.getScaleFactor() * 100.0)) + " %");
                }
            });
            ++i;
        }
        zoomPopupButton.setFocusable(false);
        return zoomPopupButton;
    }

    public static void addAlignmentButtonsTo(JToolBar bar, DrawingEditor editor) {
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        bar.add(new AlignAction.West(editor)).setFocusable(false);
        bar.add(new AlignAction.East(editor)).setFocusable(false);
        bar.add(new AlignAction.Horizontal(editor)).setFocusable(false);
        bar.add(new AlignAction.North(editor)).setFocusable(false);
        bar.add(new AlignAction.South(editor)).setFocusable(false);
        bar.add(new AlignAction.Vertical(editor)).setFocusable(false);
        bar.addSeparator();
        bar.add(new MoveAction.West(editor)).setFocusable(false);
        bar.add(new MoveAction.East(editor)).setFocusable(false);
        bar.add(new MoveAction.North(editor)).setFocusable(false);
        bar.add(new MoveAction.South(editor)).setFocusable(false);
        bar.addSeparator();
        bar.add(new MoveToFrontAction(editor)).setFocusable(false);
        bar.add(new MoveToBackAction(editor)).setFocusable(false);
    }

    public static AbstractButton createToggleGridButton(final DrawingView view) {
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        final JToggleButton toggleButton = new JToggleButton();
        labels.configureToolBarButton(toggleButton, "alignGrid");
        toggleButton.setFocusable(false);
        toggleButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                GridConstrainer c = toggleButton.isSelected() ? new GridConstrainer(10.0, 10.0) : new GridConstrainer(1.0, 1.0);
                view.setConstrainer(c);
                view.getComponent().repaint();
            }
        });
        view.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == "gridConstrainer") {
                    Constrainer c = (Constrainer)evt.getNewValue();
                    toggleButton.setSelected(c.isVisible());
                }
            }
        });
        return toggleButton;
    }

    private static class ToolButtonListener
    implements ItemListener {
        private Tool tool;
        private DrawingEditor editor;

        public ToolButtonListener(Tool t, DrawingEditor editor) {
            this.tool = t;
            this.editor = editor;
        }

        @Override
        public void itemStateChanged(ItemEvent evt) {
            if (evt.getStateChange() == 1) {
                this.editor.setTool(this.tool);
                this.editor.getActiveView().clearSelection();
            }
        }
    }
}

