/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.CompositeFigure;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.GroupFigure;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.undo.CompositeEdit;

public class UngroupAction
extends AbstractSelectedAction {
    public static final String ID = "selectionUngroup";
    private CompositeFigure prototype;

    public UngroupAction(DrawingEditor editor) {
        this(editor, new GroupFigure());
    }

    public UngroupAction(DrawingEditor editor, CompositeFigure prototype) {
        super(editor);
        this.prototype = prototype;
        this.labels.configureAction(this, ID);
    }

    @Override
    protected void updateEnabledState() {
        if (this.getView() != null) {
            this.setEnabled(this.canUngroup());
        } else {
            this.setEnabled(false);
        }
    }

    protected boolean canUngroup() {
        return this.getView().getSelectionCount() == 1 && this.getView().getSelectedFigures().iterator().next().getClass().equals(this.prototype.getClass());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.canUngroup()) {
            final DrawingView view = this.getView();
            final CompositeFigure group = (CompositeFigure)this.getView().getSelectedFigures().iterator().next();
            final LinkedList<Figure> ungroupedFigures = new LinkedList<Figure>();
            CompositeEdit edit = new CompositeEdit(this.labels.getString(ID)){

                @Override
                public void redo() throws CannotRedoException {
                    super.redo();
                    UngroupAction.this.ungroupFigures(view, group);
                }

                @Override
                public void undo() throws CannotUndoException {
                    UngroupAction.this.groupFigures(view, group, ungroupedFigures);
                    super.undo();
                }
            };
            this.fireUndoableEditHappened(edit);
            ungroupedFigures.addAll(this.ungroupFigures(view, group));
            this.fireUndoableEditHappened(edit);
        }
    }

    public Collection<Figure> ungroupFigures(DrawingView view, CompositeFigure group) {
        LinkedList<Figure> figures = new LinkedList<Figure>(group.getChildren());
        view.clearSelection();
        group.basicRemoveAllChildren();
        Drawing drawing = view.getDrawing();
        drawing.basicAddAll(drawing.indexOf(group), figures);
        drawing.remove(group);
        view.addToSelection(figures);
        return figures;
    }

    public void groupFigures(DrawingView view, CompositeFigure group, Collection<Figure> figures) {
        List<Figure> sorted = view.getDrawing().sort(figures);
        view.getDrawing().basicRemoveAll(figures);
        view.clearSelection();
        view.getDrawing().add(group);
        group.willChange();
        for (Figure f : sorted) {
            group.basicAdd(f);
        }
        group.changed();
        view.addToSelection(group);
    }
}

