/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.geom;

import java.awt.geom.Rectangle2D;

public abstract class Insets2D
implements Cloneable {
    protected Insets2D() {
    }

    public abstract double getTop();

    public abstract double getLeft();

    public abstract double getBottom();

    public abstract double getRight();

    public abstract void set(double var1, double var3, double var5, double var7);

    public void set(Insets2D i) {
        this.set(i.getTop(), i.getLeft(), i.getBottom(), i.getRight());
    }

    public void add(double top, double left, double bottom, double right) {
        this.set(this.getTop() + top, this.getLeft() + left, this.getBottom() + bottom, this.getRight() + right);
    }

    public void add(Insets2D i) {
        this.set(this.getTop() + i.getTop(), this.getLeft() + i.getLeft(), this.getBottom() + i.getBottom(), this.getRight() + i.getRight());
    }

    public void addTo(Rectangle2D r) {
        r.setRect(r.getX() - this.getLeft(), r.getY() - this.getTop(), r.getWidth() + this.getLeft() + this.getRight(), r.getHeight() + this.getTop() + this.getBottom());
    }

    public void subtract(double top, double left, double bottom, double right) {
        this.set(this.getTop() - top, this.getLeft() - left, this.getBottom() - bottom, this.getRight() - right);
    }

    public void subtract(Insets2D i) {
        this.set(this.getTop() - i.getTop(), this.getLeft() - i.getLeft(), this.getBottom() - i.getBottom(), this.getRight() - i.getRight());
    }

    public void subtractTo(Rectangle2D r) {
        r.setRect(r.getX() + this.getLeft(), r.getY() + this.getTop(), r.getWidth() - this.getLeft() - this.getRight(), r.getHeight() - this.getTop() - this.getBottom());
    }

    public boolean equals(Object obj) {
        if (obj instanceof Insets2D) {
            Insets2D that = (Insets2D)obj;
            return this.getTop() == that.getTop() && this.getLeft() == that.getLeft() && this.getBottom() == that.getBottom() && this.getRight() == that.getRight();
        }
        return false;
    }

    public int hashCode() {
        double sum1 = this.getLeft() + this.getBottom();
        double sum2 = this.getRight() + this.getTop();
        double val1 = sum1 * (sum1 + 1.0) / 2.0 + this.getLeft();
        double val2 = sum2 * (sum2 + 1.0) / 2.0 + this.getTop();
        double sum3 = val1 + val2;
        return java.lang.Float.floatToIntBits((float)(sum3 * (sum3 + 1.0) / 2.0 + val2));
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public static class Double
    extends Insets2D {
        public double top;
        public double left;
        public double bottom;
        public double right;

        public Double() {
        }

        public Double(double top, double left, double bottom, double right) {
            this.top = top;
            this.left = left;
            this.bottom = bottom;
            this.right = right;
        }

        @Override
        public double getTop() {
            return this.top;
        }

        @Override
        public double getLeft() {
            return this.left;
        }

        @Override
        public double getBottom() {
            return this.bottom;
        }

        @Override
        public double getRight() {
            return this.right;
        }

        @Override
        public void set(double top, double left, double bottom, double right) {
            this.top = top;
            this.left = left;
            this.bottom = bottom;
            this.right = right;
        }
    }

    public static class Float
    extends Insets2D {
        public float top;
        public float left;
        public float bottom;
        public float right;

        public Float() {
        }

        public Float(float top, float left, float bottom, float right) {
            this.top = top;
            this.left = left;
            this.bottom = bottom;
            this.right = right;
        }

        @Override
        public double getTop() {
            return this.top;
        }

        @Override
        public double getLeft() {
            return this.left;
        }

        @Override
        public double getBottom() {
            return this.bottom;
        }

        @Override
        public double getRight() {
            return this.right;
        }

        @Override
        public void set(double top, double left, double bottom, double right) {
            this.top = (float)top;
            this.left = (float)left;
            this.bottom = (float)bottom;
            this.right = (float)right;
        }

        public void set(float top, float left, float bottom, float right) {
            this.top = top;
            this.left = left;
            this.bottom = bottom;
            this.right = right;
        }
    }
}

